/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.nir.serialization;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import scala.Byte$;
import scala.Char$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Short$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.scalanative.nir.serialization.NIRSectionWriter$;

public abstract class NIRSectionWriter {
    private final ByteArrayOutputStream baos;
    private final DataOutputStream output;

    public static int $lessinit$greater$default$1() {
        return NIRSectionWriter$.MODULE$.$lessinit$greater$default$1();
    }

    public NIRSectionWriter(int initialBufferSize) {
        this.baos = new ByteArrayOutputStream(initialBufferSize);
        this.output = new DataOutputStream(this.baos);
    }

    public final int position() {
        return this.output.size();
    }

    public final void put(byte[] values) {
        this.output.write(values);
    }

    public final void put(byte value) {
        this.output.write(Byte$.MODULE$.byte2int(value));
    }

    public final void putShort(short value) {
        this.output.writeShort(Short$.MODULE$.short2int(value));
    }

    public final void putInt(int value) {
        this.output.writeInt(value);
    }

    public final void putFloat(float value) {
        this.output.writeFloat(value);
    }

    public final void putDouble(double value) {
        this.output.writeDouble(value);
    }

    public final void putBool(boolean v) {
        this.put((byte)(v ? 1 : 0));
    }

    public final void putLebShort(short value) {
        this.putLebSignedInt(Short$.MODULE$.short2int(value));
    }

    public final void putLebChar(char value) {
        this.putLebUnsignedInt(Char$.MODULE$.char2int(value));
    }

    public final void putLebUnsignedInt(int v) {
        boolean hasMore;
        Predef$.MODULE$.require(v >= 0, () -> NIRSectionWriter.putLebUnsignedInt$$anonfun$1(v));
        int remaining = v;
        do {
            byte by = (byte)(remaining & 0x7F);
            hasMore = (remaining >>= 7) != 0;
            this.put(hasMore ? (byte)(by | 0x80) : by);
        } while (hasMore);
    }

    public final void putLebUnsignedLong(long v) {
        boolean hasMore;
        Predef$.MODULE$.require(v >= 0L, () -> NIRSectionWriter.putLebUnsignedLong$$anonfun$1(v));
        long remaining = v;
        do {
            byte by = (byte)(remaining & 0x7FL);
            hasMore = (remaining >>= 7) != 0L;
            this.put(hasMore ? (byte)(by | 0x80) : by);
        } while (hasMore);
    }

    public final void putLebSignedInt(int v) {
        int end;
        int value = v;
        int remaining = value >> 7;
        boolean hasMore = true;
        int n = end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            this.put((byte)(value & 0x7F | (hasMore ? 128 : 0)));
            value = remaining;
            remaining >>= 7;
        }
    }

    public final void putLebSignedLong(long v) {
        long end;
        long value = v;
        long remaining = value >> 7;
        boolean hasMore = true;
        long l = end = (value & Long.MIN_VALUE) == 0L ? 0L : -1L;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1L) != (value >> 6 & 1L);
            this.put((byte)(value & 0x7FL | (long)(hasMore ? 128 : 0)));
            value = remaining;
            remaining >>= 7;
        }
    }

    public final <T> void putSeq(Seq<T> seq, Function1<T, BoxedUnit> putT) {
        this.putLebUnsignedInt(seq.length());
        seq.foreach(putT);
    }

    public final <T> void putOpt(Option<T> opt, Function1<T, BoxedUnit> putT) {
        Option<T> option = opt;
        if (None$.MODULE$.equals(option)) {
            this.put((byte)0);
            return;
        }
        if (option instanceof Some) {
            Object t = ((Some)option).value();
            this.put((byte)1);
            putT.apply(t);
            return;
        }
        throw new MatchError(option);
    }

    public final void putTag(byte value) {
        this.put(value);
    }

    public final void commit(OutputStream output) {
        this.baos.writeTo(output);
        output.flush();
    }

    private static final Object putLebUnsignedInt$$anonfun$1(int v$1) {
        return new StringBuilder(31).append("Unsigned integer expected, got ").append(v$1).toString();
    }

    private static final Object putLebUnsignedLong$$anonfun$1(long v$2) {
        return new StringBuilder(31).append("Unsigned integer expected, got ").append(v$2).toString();
    }
}

