/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.io;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import scala.Function1;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.scalanative.io.VirtualDirectory$;
import scala.scalanative.io.package$;
import scala.scalanative.util.Scope;

public interface VirtualDirectory {
    public static VirtualDirectory empty() {
        return VirtualDirectory$.MODULE$.empty();
    }

    public static VirtualDirectory jar(Path path, Scope scope) {
        return VirtualDirectory$.MODULE$.jar(path, scope);
    }

    public static VirtualDirectory local(Path path) {
        return VirtualDirectory$.MODULE$.local(path);
    }

    public static VirtualDirectory real(Path path, Scope scope) {
        return VirtualDirectory$.MODULE$.real(path, scope);
    }

    public URI uri();

    public Path path();

    public static boolean contains$(VirtualDirectory $this, Path path) {
        return $this.contains(path);
    }

    default public boolean contains(Path path) {
        return this.files().contains((Object)path);
    }

    public ByteBuffer read(Path var1);

    public ByteBuffer read(Path var1, int var2);

    public void write(Path var1, ByteBuffer var2);

    public Path write(Path var1, Function1<Writer, BoxedUnit> var2);

    public Seq<Path> files();

    public Path merge(Seq<Path> var1, Path var2);

    public PathMatcher pathMatcher(String var1);

    public static final class JarDirectory
    implements VirtualDirectory,
    NioDirectory {
        private final Path path;
        private final FileSystem fileSystem;

        public JarDirectory(Path path, Scope in) {
            FileSystem fileSystem;
            this.path = path;
            scala.scalanative.util.package$ package$2 = scala.scalanative.util.package$.MODULE$;
            JarDirectory jarDirectory = this;
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("create", "false");
                fileSystem = FileSystems.newFileSystem(this.uri(), params);
            }
            catch (FileSystemAlreadyExistsException e) {
                fileSystem = FileSystems.getFileSystem(this.uri());
            }
            FileSystem fileSystem2 = fileSystem;
            JarDirectory jarDirectory2 = jarDirectory;
            jarDirectory = null;
            scala.scalanative.util.package$ package$3 = package$2;
            package$2 = null;
            FileSystem fileSystem3 = fileSystem2;
            fileSystem2 = null;
            jarDirectory2.fileSystem = package$3.acquire(fileSystem3, in);
        }

        @Override
        public Path path() {
            return this.path;
        }

        @Override
        public URI uri() {
            return URI.create(new StringBuilder(4).append("jar:").append(this.path().toUri()).toString());
        }

        @Override
        public PathMatcher pathMatcher(String pattern) {
            return this.fileSystem.getPathMatcher(pattern);
        }

        @Override
        public Seq<Path> files() {
            Seq<Path> roots = package$.MODULE$.jIteratorToSeq(this.fileSystem.getRootDirectories().iterator());
            return (Seq)roots.flatMap(VirtualDirectory$::scala$scalanative$io$VirtualDirectory$JarDirectory$$_$files$$anonfun$3);
        }
    }

    public static final class LocalDirectory
    implements VirtualDirectory,
    NioDirectory {
        private final Path path;

        public LocalDirectory(Path path) {
            this.path = path;
        }

        @Override
        public Path path() {
            return this.path;
        }

        @Override
        public URI uri() {
            return this.path().toUri();
        }

        @Override
        public Path resolve(Path path) {
            return this.path().resolve(path);
        }

        @Override
        public Seq<Path> files() {
            return (Seq)((IterableOps)package$.MODULE$.jIteratorToSeq(Files.walk(this.path(), Integer.MAX_VALUE, FileVisitOption.FOLLOW_LINKS).iterator()).filter(VirtualDirectory$::scala$scalanative$io$VirtualDirectory$LocalDirectory$$_$files$$anonfun$1)).map((Function1 & Serializable)fp -> this.path().relativize((Path)fp));
        }

        @Override
        public PathMatcher pathMatcher(String pattern) {
            return this.path().getFileSystem().getPathMatcher(pattern);
        }
    }

    public static interface NioDirectory
    extends VirtualDirectory {
        public static Path resolve$(NioDirectory $this, Path path) {
            return $this.resolve(path);
        }

        default public Path resolve(Path path) {
            return path;
        }

        public static FileChannel open$(NioDirectory $this, Path path) {
            return $this.open(path);
        }

        default public FileChannel open(Path path) {
            return FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }

        public static ByteBuffer read$(NioDirectory $this, Path path) {
            return $this.read(path);
        }

        @Override
        default public ByteBuffer read(Path path) {
            byte[] bytes = Files.readAllBytes(this.resolve(path));
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            return buffer;
        }

        public static ByteBuffer read$(NioDirectory $this, Path path, int len) {
            return $this.read(path, len);
        }

        @Override
        default public ByteBuffer read(Path path, int len) {
            ByteBuffer byteBuffer;
            try (InputStream stream = Files.newInputStream(this.resolve(path), new OpenOption[0]);){
                byte[] bytes = new byte[len];
                int read = stream.read(bytes);
                byteBuffer = ByteBuffer.wrap(bytes, 0, read);
            }
            return byteBuffer;
        }

        public static Path write$(NioDirectory $this, Path path, Function1 fn) {
            return $this.write(path, (Function1<Writer, BoxedUnit>)fn);
        }

        @Override
        default public Path write(Path path, Function1<Writer, BoxedUnit> fn) {
            Path fullPath = this.resolve(path);
            Files.createDirectories(fullPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(fullPath, new OpenOption[0]);){
                fn.apply((Object)writer);
            }
            return fullPath;
        }

        public static void write$(NioDirectory $this, Path path, ByteBuffer buffer) {
            $this.write(path, buffer);
        }

        @Override
        default public void write(Path path, ByteBuffer buffer) {
            Path fullPath = this.resolve(path);
            Files.createDirectories(fullPath.getParent(), new FileAttribute[0]);
            try (FileChannel channel = this.open(fullPath);){
                channel.write(buffer);
            }
        }

        public static Path merge$(NioDirectory $this, Seq sources, Path target) {
            return $this.merge((Seq<Path>)sources, target);
        }

        @Override
        default public Path merge(Seq<Path> sources, Path target) {
            Path outputPath = this.resolve(target);
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            try (FileChannel output = FileChannel.open(outputPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
                sources.foreach((Function1 & Serializable)path -> {
                    long l;
                    try (FileChannel input = FileChannel.open(this.resolve((Path)path), StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE);){
                        l = input.transferTo(0L, input.size(), output);
                    }
                    return l;
                });
            }
            return outputPath;
        }
    }
}

