#if defined(__unix__) || defined(__unix) || defined(unix) ||                   \
    (defined(__APPLE__) && defined(__MACH__))
#include <sys/types.h>
#include <sys/uio.h>

struct scalanative_iovec {
    void *iov_base; /** Base address of a memory region for input or output. */
    size_t iov_len; /** The size of the memory pointed to by iov_base. */
};

void iovec_to_scalanative_iovec(struct iovec *orig,
                                struct scalanative_iovec *buf) {
    buf->iov_base = orig->iov_base;
    buf->iov_len = orig->iov_len;
}

ssize_t scalanative_readv(int d, struct scalanative_iovec *buf, int iovcnt) {
    struct iovec copy;
    ssize_t result = readv(d, &copy, iovcnt);
    iovec_to_scalanative_iovec(&copy, buf);
    return result;
}

ssize_t scalanative_writev(int fildes, struct scalanative_iovec *buf,
                           int iovcnt) {
    struct iovec copy;
    ssize_t result = writev(fildes, &copy, iovcnt);
    iovec_to_scalanative_iovec(&copy, buf);
    return result;
}
#endif // Unix or Mac OS
