/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.scalanative.build.Platform$;
import scala.util.control.NonFatal$;

public final class IO$ {
    public static IO$ MODULE$;

    static {
        new IO$();
    }

    public Path RichPath(Path path) {
        return path;
    }

    public String RichString(String s) {
        return s;
    }

    public void write(Path file, byte[] bytes) {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.write(file, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    public void write(Path path, String content) {
        this.write(path, content.getBytes());
    }

    public Option<String> readFully(Path path) {
        Some some;
        if (!Files.exists(path, new LinkOption[0])) {
            return None$.MODULE$;
        }
        try (BufferedSource source = Source$.MODULE$.fromFile(path.toFile(), Codec$.MODULE$.fallbackSystemCodec());){
            try {
                some = new Some((Object)source.mkString());
            }
            catch (Exception exception) {
                some = None$.MODULE$;
            }
        }
        return some;
    }

    public Seq<Path> getAll(Path base, String pattern) {
        ArrayBuffer out = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(pattern);
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(matcher, out){
            private final PathMatcher matcher$1;
            private final ArrayBuffer out$1;

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                Object object = this.matcher$1.matches(file) ? this.out$1.$plus$eq((Object)file) : BoxedUnit.UNIT;
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
            {
                this.matcher$1 = matcher$1;
                this.out$1 = out$1;
            }
        };
        Files.walkFileTree(base, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
        return out.toSeq();
    }

    public boolean existsInDir(Path base, String pattern) {
        BooleanRef out = BooleanRef.create((boolean)false);
        PathMatcher matcher = base.getFileSystem().getPathMatcher(pattern);
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(matcher, out){
            private final PathMatcher matcher$2;
            private final BooleanRef out$2;

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                if (this.matcher$2.matches(file)) {
                    this.out$2.elem = true;
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
            {
                this.matcher$2 = matcher$2;
                this.out$2 = out$2;
            }
        };
        Files.walkFileTree(base, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
        return out.elem;
    }

    public boolean existsInJar(Path path, Function1<String, Object> matcher) {
        ZipFile zf = new ZipFile(path.toFile());
        Enumeration<? extends ZipEntry> it = zf.entries();
        while (it.hasMoreElements()) {
            if (!BoxesRunTime.unboxToBoolean((Object)matcher.apply((Object)it.nextElement().getName()))) continue;
            return true;
        }
        return false;
    }

    public void deleteRecursive(Path directory) {
        BooleanRef shouldRetry = BooleanRef.create((boolean)false);
        for (int remainingRetries = 3; Files.exists(directory, new LinkOption[0]) && remainingRetries > 0; --remainingRetries) {
            if (shouldRetry.elem) {
                Thread.sleep(50L);
            }
            shouldRetry.elem = false;
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(shouldRetry){
                private final BooleanRef shouldRetry$1;

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    IO$.scala$scalanative$build$IO$$tryDelete$1(file, IO$.scala$scalanative$build$IO$$tryDelete$default$2$1(), this.shouldRetry$1);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    IO$.scala$scalanative$build$IO$$tryDelete$1(dir, IO$.scala$scalanative$build$IO$$tryDelete$default$2$1(), this.shouldRetry$1);
                    return FileVisitResult.CONTINUE;
                }
                {
                    this.shouldRetry$1 = shouldRetry$1;
                }
            });
        }
    }

    public byte[] sha1(Path path, int bufSize) {
        byte[] byArray;
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        InputStream stream = Files.newInputStream(path, new OpenOption[0]);
        try (DigestInputStream digestStream = new DigestInputStream(stream, digest);){
            byte[] buf = new byte[bufSize];
            while (digestStream.read(buf, 0, bufSize) != -1) {
            }
            byArray = digest.digest();
        }
        return byArray;
    }

    public int sha1$default$2() {
        return 1024;
    }

    public byte[] sha1files(Seq<Path> files, int bufSize) {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        files.foreach((Function1 & java.io.Serializable & Serializable)file -> {
            IO$.$anonfun$sha1files$1(digest, bufSize, file);
            return BoxedUnit.UNIT;
        });
        return digest.digest();
    }

    public int sha1files$default$2() {
        return 1024;
    }

    public void unzip(Path archive, Path target) {
        Files.createDirectories(target, new FileAttribute[0]);
        try (FileSystem zipFS = FileSystems.newFileSystem(archive, null);){
            for (Path root : zipFS.getRootDirectories()) {
                this.copyRecursive(root, target);
            }
        }
    }

    public void copyDirectory(Path source, Path target) {
        Files.createDirectories(target, new FileAttribute[0]);
        this.copyRecursive(source, target);
    }

    private Path copyRecursive(Path source, Path target) {
        return Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(target, source){
            private final Path target$1;
            private final Path source$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Path dest = Paths.get(((Object)this.target$1).toString(), ((Object)this.source$1.relativize(file)).toString());
                Files.copy(file, dest, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Path dest = Paths.get(((Object)this.target$1).toString(), ((Object)this.source$1.relativize(dir)).toString());
                Files.createDirectories(dest, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }
            {
                this.target$1 = target$1;
                this.source$1 = source$1;
            }
        });
    }

    public static final void scala$scalanative$build$IO$$tryDelete$1(Path path, boolean isRetry, BooleanRef shouldRetry$1) {
        try {
            Files.deleteIfExists(path);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AccessDeniedException && Platform$.MODULE$.isWindows() && !isRetry) {
                BoxedUnit boxedUnit;
                if (Files.notExists(path, new LinkOption[0])) {
                }
                try {
                    DosFileAttributes attrs = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
                    Object object = attrs.isReadOnly() ? Files.setAttribute(path, "dos:readonly", BoxesRunTime.boxToBoolean((boolean)false), new LinkOption[0]) : BoxedUnit.UNIT;
                    IO$.scala$scalanative$build$IO$$tryDelete$1(path, true, shouldRetry$1);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    Option option = NonFatal$.MODULE$.unapply(throwable4);
                    if (option.isEmpty()) {
                        throw throwable3;
                    }
                    shouldRetry$1.elem = true;
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                shouldRetry$1.elem = true;
            }
            throw throwable;
        }
    }

    public static final boolean scala$scalanative$build$IO$$tryDelete$default$2$1() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$sha1files$1(MessageDigest digest$1, int bufSize$1, Path file) {
        InputStream stream = Files.newInputStream(file, new OpenOption[0]);
        byte[] buf = new byte[bufSize$1];
        try (DigestInputStream digestStream = new DigestInputStream(stream, digest$1);){
            while (digestStream.read(buf, 0, bufSize$1) != -1) {
            }
        }
    }

    private IO$() {
        MODULE$ = this;
    }
}

