/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import scala.scalanative.build.Build$;
import scala.scalanative.build.BuildException;
import scala.scalanative.build.Config;
import scala.scalanative.build.Descriptor;
import scala.scalanative.build.Descriptor$;
import scala.scalanative.build.IO$;
import scala.scalanative.build.IO$RichPath$;
import scala.scalanative.build.LLVM$;
import scala.scalanative.build.NativeConfig;
import scala.scalanative.build.NativeLib;
import scala.scalanative.build.Platform$;
import scala.scalanative.linker.ReachabilityAnalysis;
import scala.scalanative.nir.Attr;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class NativeLib$
implements Serializable {
    public static NativeLib$ MODULE$;
    private final String nativeCodeDir;
    private final String nativeProjectProps;
    private final String jarExt;
    private final String jarSrcRegex;
    private final Pattern jarPattern;

    static {
        new NativeLib$();
    }

    public String nativeCodeDir() {
        return this.nativeCodeDir;
    }

    private String nativeProjectProps() {
        return this.nativeProjectProps;
    }

    public Future<Seq<Path>> compileNativeLibrary(Config config, ReachabilityAnalysis.Result analysis, NativeLib nativeLib, ExecutionContext ec) {
        Path destPath = this.unpackNativeCode(nativeLib);
        Seq<Path> paths = this.findNativePaths(destPath);
        Config projConfig = this.configureNativeLibrary(config, analysis, destPath);
        return Future$.MODULE$.sequence((TraversableOnce)paths.map((Function1 & java.io.Serializable & Serializable)x$1 -> LLVM$.MODULE$.compile(projConfig, (Path)x$1, ec), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), ec);
    }

    private Config configureNativeLibrary(Config initialConfig, ReachabilityAnalysis.Result analysis, Path destPath) {
        Path nativeCodePath = destPath.resolve(this.nativeCodeDir());
        return (Config)((Function1 & java.io.Serializable & Serializable)(Function1 & java.io.Serializable & Serializable)config -> NativeLib$.withAnalysisInfo$1(config, analysis)).andThen((Function1 & java.io.Serializable & Serializable)config -> this.withProjectDescriptor$1((Config)config, nativeCodePath, analysis)).apply((Object)initialConfig);
    }

    private Seq<String> resolveDescriptorFlags(Descriptor desc, Config config, ReachabilityAnalysis.Result analysis, Path nativeCodePath) {
        Nil$ nil$;
        List linkDefines = (List)((List)desc.links().filter((Function1 & java.io.Serializable & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)NativeLib$.$anonfun$resolveDescriptorFlags$1(analysis, name)))).map((Function1 & java.io.Serializable & Serializable)name -> new StringBuilder(19).append("-DSCALANATIVE_LINK_").append(name.toUpperCase()).toString(), List$.MODULE$.canBuildFrom());
        List includePaths = (List)((List)desc.includes().map((Function1 & java.io.Serializable & Serializable)x$7 -> MODULE$.createPathString((String)x$7, nativeCodePath), List$.MODULE$.canBuildFrom())).map((Function1 & java.io.Serializable & Serializable)path -> new StringBuilder(2).append("-I").append((String)path).toString(), List$.MODULE$.canBuildFrom());
        List defines = (List)desc.defines().map((Function1 & java.io.Serializable & Serializable)define -> new StringBuilder(2).append("-D").append((String)define).toString(), List$.MODULE$.canBuildFrom());
        if (!desc.gcProject()) {
            nil$ = Nil$.MODULE$;
        } else {
            String gcName = config.compilerConfig().gc().toString().toUpperCase();
            nil$ = (Seq)new .colon.colon((Object)new Some((Object)new StringBuilder(17).append("-DSCALANATIVE_GC_").append(gcName).toString()), (List)new .colon.colon(!config.useTrapBasedGCYieldPoints() ? None$.MODULE$ : new Some((Object)"-DSCALANATIVE_GC_USE_YIELDPOINT_TRAPS"), (List)Nil$.MODULE$)).flatten((Function1 & java.io.Serializable & Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
        }
        Nil$ gcMaybeDefines = nil$;
        return (Seq)((List)((List)linkDefines.$plus$plus((GenTraversableOnce)defines, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)gcMaybeDefines, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)includePaths, List$.MODULE$.canBuildFrom());
    }

    private String createPathString(String unixPath, Path nativeCodePath) {
        String[] dirs = unixPath.split("/");
        return IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath((Path)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs)).foldLeft((Object)nativeCodePath, (Function2 & java.io.Serializable & Serializable)(path, dir) -> path.resolve((String)dir))));
    }

    private Option<Path> findDescriptor(Path nativeCodePath) {
        Path file = nativeCodePath.resolve(this.nativeProjectProps());
        if (Files.exists(file, new LinkOption[0])) {
            return new Some((Object)file);
        }
        return None$.MODULE$;
    }

    public Seq<NativeLib> findNativeLibs(Config config) {
        Seq extractPaths;
        block2: {
            Seq nativeLibPaths;
            Path workDir = config.workDir();
            Seq<Path> classpath = config.classPath();
            Path nativeCodeDir = workDir.resolve("dependencies");
            if (Build$.MODULE$.userConfigHasChanged(config)) {
                IO$.MODULE$.deleteRecursive(nativeCodeDir);
            }
            if ((extractPaths = (Seq)((TraversableLike)(nativeLibPaths = (Seq)classpath.flatMap((Function1 & java.io.Serializable & Serializable)path -> {
                if (MODULE$.isJar((Path)path)) {
                    return Option$.MODULE$.option2Iterable(MODULE$.readJar((Path)path));
                }
                return Option$.MODULE$.option2Iterable(MODULE$.readDir((Path)path));
            }, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & java.io.Serializable & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)NativeLib$.$anonfun$findNativeLibs$2(check$ifrefutable$1))).map((Function1 & java.io.Serializable & Serializable)x$8 -> {
                Tuple2 tuple2 = x$8;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    String name = new StringOps(Predef$.MODULE$.augmentString(((Object)path.getFileName()).toString())).stripSuffix(MODULE$.jarExt());
                    return new NativeLib(path, nativeCodeDir.resolve(new StringBuilder(1).append(name).append("-").append(index).toString()));
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).isEmpty()) {
                throw new BuildException(new StringBuilder(38).append("No Scala Native libraries were found: ").append(classpath).toString());
            }
            if (!Files.exists(nativeCodeDir, new LinkOption[0])) break block2;
            Set expectedPaths = ((TraversableOnce)extractPaths.map((Function1 & java.io.Serializable & Serializable)x$9 -> x$9.dest().toAbsolutePath(), Seq$.MODULE$.canBuildFrom())).toSet();
            Files.list(nativeCodeDir).filter(p -> !expectedPaths.contains((Object)p.toAbsolutePath())).forEach(x$10 -> IO$.MODULE$.deleteRecursive((Path)x$10));
        }
        return extractPaths;
    }

    private Seq<Path> findNativePaths(Path destPath) {
        String srcPatterns = this.destSrcPattern(destPath);
        return IO$.MODULE$.getAll(destPath, srcPatterns);
    }

    public Seq<Path> filterClasspath(Seq<Path> classpath) {
        return (Seq)classpath.filter((Function1 & java.io.Serializable & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)NativeLib$.$anonfun$filterClasspath$1(p)));
    }

    private Path unpackNativeCode(NativeLib nativelib) {
        if (this.isJar(nativelib)) {
            return this.unpackNativeJar(nativelib);
        }
        return this.copyNativeDir(nativelib);
    }

    private Path unpackNativeJar(NativeLib nativelib) {
        Path target = nativelib.dest();
        Path source = nativelib.src();
        NativeLib$.unpack$1(target, source);
        return target;
    }

    private Path copyNativeDir(NativeLib nativelib) {
        Path target = nativelib.dest();
        Path source = nativelib.src();
        NativeLib$.copy$1(target, source);
        return target;
    }

    private String jarExt() {
        return this.jarExt;
    }

    private boolean isJar(Path path) {
        return ((Object)path).toString().endsWith(this.jarExt());
    }

    private boolean isJar(NativeLib nativelib) {
        return this.isJar(nativelib.src());
    }

    private String jarSrcRegex() {
        return this.jarSrcRegex;
    }

    private Pattern jarPattern() {
        return this.jarPattern;
    }

    private boolean isNativeFile(String name) {
        return this.jarPattern().matcher(name).matches();
    }

    private Option<Path> readDir(Path path) {
        boolean bl = IO$.MODULE$.existsInDir(path, this.srcPatterns(path));
        if (bl) {
            return new Some((Object)path);
        }
        if (!bl) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private Option<Path> readJar(Path path) {
        boolean bl = IO$.MODULE$.existsInJar(path, (Function1<String, Object>)(Function1 & java.io.Serializable & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)NativeLib$.MODULE$.isNativeFile(name)));
        if (bl) {
            return new Some((Object)path);
        }
        if (!bl) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private String srcPatterns(Path path) {
        return LLVM$.MODULE$.srcExtensions().mkString(new StringBuilder(8).append("glob:").append(this.srcPathPattern(path)).append("**{").toString(), ",", "}");
    }

    private String srcPathPattern(Path path) {
        return this.makeDirPath(path, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.nativeCodeDir()}));
    }

    private String allFilesPattern(Path path) {
        return new StringBuilder(7).append("glob:").append(this.srcPathPattern(path)).append("**").toString();
    }

    private String destSrcPattern(Path destPath) {
        String dirPattern = new StringBuilder(2).append("{").append(destPath.getFileName()).append("}").toString();
        Path workDir = destPath.getParent();
        String pathPat = this.makeDirPath(workDir, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dirPattern, this.nativeCodeDir()}));
        return LLVM$.MODULE$.srcExtensions().mkString(new StringBuilder(8).append("glob:").append(pathPat).append("**{").toString(), ",", "}");
    }

    private String makeDirPath(Path path, Seq<String> elems) {
        String pathSep = Platform$.MODULE$.isWindows() ? "\\\\" : File.separator;
        String string = ((Object)path).toString().replace(File.separator, pathSep);
        return ((TraversableOnce)elems.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).mkString("", pathSep, pathSep);
    }

    public NativeLib apply(Path src, Path dest) {
        return new NativeLib(src, dest);
    }

    public Option<Tuple2<Path, Path>> unapply(NativeLib x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.src(), (Object)x$0.dest()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Config withAnalysisInfo$1(Config config, ReachabilityAnalysis.Result analysis$1) {
        Seq preprocessorFlags = (Seq)analysis$1.preprocessorDefinitions().map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Attr.Define define = x0$1;
            if (define != null) {
                String name = define.name();
                return new StringBuilder(2).append("-D").append(name).toString();
            }
            throw new MatchError((Object)define);
        }, Seq$.MODULE$.canBuildFrom());
        return config.withCompilerConfig((Function1<NativeConfig, NativeConfig>)(Function1 & java.io.Serializable & Serializable)x$2 -> x$2.withCompileOptions((Function1<Seq<String>, Seq<String>>)(Function1 & java.io.Serializable & Serializable)x$3 -> (Seq)x$3.$plus$plus((GenTraversableOnce)preprocessorFlags, Seq$.MODULE$.canBuildFrom())));
    }

    private final Config withProjectDescriptor$1(Config config, Path nativeCodePath$1, ReachabilityAnalysis.Result analysis$1) {
        return (Config)this.findDescriptor(nativeCodePath$1).fold((Function0 & java.io.Serializable & Serializable)() -> config, (Function1 & java.io.Serializable & Serializable)filepath -> {
            Try<Descriptor> try_ = Descriptor$.MODULE$.load((Path)filepath);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new BuildException(new StringBuilder(18).append("Problem reading ").append(MODULE$.nativeProjectProps()).append(": ").append(e.getMessage()).toString());
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            Descriptor v = (Descriptor)success.value();
            Descriptor descriptor = v;
            config.logger().debug(new StringBuilder(22).append("Compilation settings: ").append(descriptor.toString()).toString());
            Seq<String> projectSettings = MODULE$.resolveDescriptorFlags(descriptor, config, analysis$1, nativeCodePath$1);
            return config.withCompilerConfig((Function1<NativeConfig, NativeConfig>)(Function1 & java.io.Serializable & Serializable)x$4 -> x$4.withCompileOptions((Function1<Seq<String>, Seq<String>>)(Function1 & java.io.Serializable & Serializable)x$5 -> (Seq)x$5.$plus$plus((GenTraversableOnce)projectSettings, Seq$.MODULE$.canBuildFrom())));
        });
    }

    public static final /* synthetic */ boolean $anonfun$resolveDescriptorFlags$2(String name$1, Attr.Link x$6) {
        String string = x$6.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$resolveDescriptorFlags$1(ReachabilityAnalysis.Result analysis$2, String name) {
        return analysis$2.links().exists((Function1 & java.io.Serializable & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)NativeLib$.$anonfun$resolveDescriptorFlags$2(name, x$6)));
    }

    public static final /* synthetic */ boolean $anonfun$findNativeLibs$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$filterClasspath$1(Path p) {
        return Files.exists(p, new LinkOption[0]) && (MODULE$.isJar(p) || Files.isDirectory(p, new LinkOption[0]));
    }

    private static final void unpack$1(Path target$1, Path source$1) {
        IO$.MODULE$.deleteRecursive(target$1);
        IO$.MODULE$.unzip(source$1, target$1);
    }

    private static final void copy$1(Path target$2, Path source$2) {
        IO$.MODULE$.deleteRecursive(target$2);
        IO$.MODULE$.copyDirectory(source$2, target$2);
    }

    private NativeLib$() {
        MODULE$ = this;
        this.nativeCodeDir = "scala-native";
        this.nativeProjectProps = new StringBuilder(11).append(this.nativeCodeDir()).append(".properties").toString();
        this.jarExt = ".jar";
        String regexExtensions = LLVM$.MODULE$.srcExtensions().mkString("(\\", "|\\", ")");
        this.jarSrcRegex = new StringBuilder(7).append("^").append(this.nativeCodeDir()).append("/(.+)").append(regexExtensions).append("$").toString();
        this.jarPattern = Pattern.compile(this.jarSrcRegex());
    }
}

