/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.scalanative.build.IO$RichPath$;
import scala.scalanative.build.IO$RichString$;
import scala.scalanative.build.Platform$;
import scala.util.control.NonFatal$;

public final class IO$
implements Serializable {
    public static final IO$RichPath$ RichPath;
    public static final IO$RichString$ RichString;
    public static final IO$ MODULE$;

    private IO$() {
    }

    static {
        MODULE$ = new IO$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IO$.class);
    }

    public final Path RichPath(Path path) {
        return path;
    }

    public final String RichString(String s) {
        return s;
    }

    public void write(Path file, byte[] bytes) {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.write(file, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    public void write(Path path, String content) {
        this.write(path, content.getBytes());
    }

    public Option<String> readFully(Path path) {
        None$ none$;
        if (!Files.exists(path, new LinkOption[0])) {
            none$ = None$.MODULE$;
        } else {
            try (BufferedSource source = Source$.MODULE$.fromFile(path.toFile(), Codec$.MODULE$.fallbackSystemCodec());){
                try {
                    none$ = Some$.MODULE$.apply((Object)source.mkString());
                }
                catch (Exception exception) {
                    none$ = None$.MODULE$;
                }
            }
        }
        return none$;
    }

    public Seq<Path> getAll(Path base, String pattern) {
        ArrayBuffer out = ArrayBuffer$.MODULE$.empty();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(pattern);
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(out, matcher){
            private final ArrayBuffer out$1;
            private final PathMatcher matcher$1;
            {
                this.out$1 = out$3;
                this.matcher$1 = matcher$3;
            }

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                if (this.matcher$1.matches(file)) {
                    this.out$1.$plus$eq((Object)file);
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(base, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
        return out.toSeq();
    }

    public boolean existsInDir(Path base, String pattern) {
        BooleanRef out = BooleanRef.create((boolean)false);
        PathMatcher matcher = base.getFileSystem().getPathMatcher(pattern);
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(out, matcher){
            private final BooleanRef out$2;
            private final PathMatcher matcher$2;
            {
                this.out$2 = out$4;
                this.matcher$2 = matcher$4;
            }

            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path directory, IOException exception) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                FileVisitResult fileVisitResult;
                if (this.matcher$2.matches(file)) {
                    boolean bl;
                    this.out$2.elem = bl = true;
                    fileVisitResult = FileVisitResult.TERMINATE;
                } else {
                    fileVisitResult = FileVisitResult.CONTINUE;
                }
                return fileVisitResult;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exception) {
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(base, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
        return out.elem;
    }

    public boolean existsInJar(Path path, Function1<String, Object> matcher) {
        ZipFile zf = new ZipFile(path.toFile());
        Enumeration<? extends ZipEntry> it = zf.entries();
        while (it.hasMoreElements()) {
            if (!BoxesRunTime.unboxToBoolean((Object)matcher.apply((Object)it.nextElement().getName()))) continue;
            return true;
        }
        return false;
    }

    public void deleteRecursive(Path directory) {
        BooleanRef shouldRetry = BooleanRef.create((boolean)false);
        for (int remainingRetries = 3; Files.exists(directory, new LinkOption[0]) && remainingRetries > 0; --remainingRetries) {
            boolean bl;
            if (shouldRetry.elem) {
                Thread.sleep(50L);
            }
            shouldRetry.elem = bl = false;
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(shouldRetry){
                private final BooleanRef shouldRetry$2;
                {
                    this.shouldRetry$2 = shouldRetry$3;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    IO$.MODULE$.scala$scalanative$build$IO$$$_$tryDelete$1(this.shouldRetry$2, file, IO$.MODULE$.scala$scalanative$build$IO$$$_$tryDelete$default$2$1());
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    IO$.MODULE$.scala$scalanative$build$IO$$$_$tryDelete$1(this.shouldRetry$2, dir, IO$.MODULE$.scala$scalanative$build$IO$$$_$tryDelete$default$2$1());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public byte[] sha1(Path path, int bufSize) {
        byte[] byArray;
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        InputStream stream = Files.newInputStream(path, new OpenOption[0]);
        try (DigestInputStream digestStream = new DigestInputStream(stream, digest);){
            byte[] buf = new byte[bufSize];
            while (digestStream.read(buf, 0, bufSize) != -1) {
            }
            byArray = digest.digest();
        }
        return byArray;
    }

    public int sha1$default$2() {
        return 1024;
    }

    public byte[] sha1files(Seq<Path> files, int bufSize) {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        files.foreach((Function1)(JProcedure1 & Serializable)file -> {
            InputStream stream = Files.newInputStream(file, new OpenOption[0]);
            byte[] buf = new byte[bufSize];
            try (DigestInputStream digestStream = new DigestInputStream(stream, digest);){
                while (digestStream.read(buf, 0, bufSize) != -1) {
                }
            }
        });
        return digest.digest();
    }

    public int sha1files$default$2() {
        return 1024;
    }

    public void unzip(Path archive, Path target) {
        Files.createDirectories(target, new FileAttribute[0]);
        try (FileSystem zipFS = FileSystems.newFileSystem(archive, null);){
            for (Path root : zipFS.getRootDirectories()) {
                this.copyRecursive(root, target);
            }
        }
    }

    public void copyDirectory(Path source, Path target) {
        Files.createDirectories(target, new FileAttribute[0]);
        this.copyRecursive(source, target);
    }

    private Path copyRecursive(Path source, Path target) {
        return Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(source, target){
            private final Path source$1;
            private final Path target$1;
            {
                this.source$1 = source$2;
                this.target$1 = target$2;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Path dest = Paths.get(this.target$1.toString(), this.source$1.relativize(file).toString());
                Files.copy(file, dest, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Path dest = Paths.get(this.target$1.toString(), this.source$1.relativize(dir).toString());
                Files.createDirectories(dest, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public final void scala$scalanative$build$IO$$$_$tryDelete$1(BooleanRef shouldRetry$1, Path path, boolean isRetry) {
        block8: {
            try {
                Files.deleteIfExists(path);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof AccessDeniedException && Platform$.MODULE$.isWindows() && !isRetry) {
                    if (Files.notExists(path, new LinkOption[0])) break block8;
                    try {
                        DosFileAttributes attrs = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
                        if (attrs.isReadOnly()) {
                            Files.setAttribute(path, "dos:readonly", BoxesRunTime.boxToBoolean((boolean)false), new LinkOption[0]);
                        }
                        this.scala$scalanative$build$IO$$$_$tryDelete$1(shouldRetry$1, path, true);
                    }
                    catch (Throwable throwable3) {
                        Option option2;
                        Throwable throwable4 = throwable3;
                        if (throwable4 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                            boolean bl;
                            Throwable throwable5 = (Throwable)option2.get();
                            shouldRetry$1.elem = bl = true;
                            break block8;
                        }
                        throw throwable3;
                    }
                }
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    boolean bl;
                    Throwable throwable6 = (Throwable)option.get();
                    shouldRetry$1.elem = bl = true;
                }
                throw throwable;
            }
        }
    }

    public final boolean scala$scalanative$build$IO$$$_$tryDelete$default$2$1() {
        return false;
    }
}

