/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.scalanative.build.Build$;
import scala.scalanative.build.BuildException;
import scala.scalanative.build.Config;
import scala.scalanative.build.Descriptor;
import scala.scalanative.build.Descriptor$;
import scala.scalanative.build.IO$;
import scala.scalanative.build.IO$RichPath$;
import scala.scalanative.build.LLVM$;
import scala.scalanative.build.NativeConfig;
import scala.scalanative.build.NativeLib;
import scala.scalanative.build.Platform$;
import scala.scalanative.linker.ReachabilityAnalysis;
import scala.scalanative.nir.Attr;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class NativeLib$
implements Mirror.Product,
Serializable {
    private static final String nativeCodeDir;
    private static final String nativeProjectProps;
    private static final String jarExt;
    private static final Pattern jarPattern;
    public static final NativeLib$ MODULE$;

    private NativeLib$() {
    }

    static {
        MODULE$ = new NativeLib$();
        nativeCodeDir = "scala-native";
        nativeProjectProps = new StringBuilder(11).append(MODULE$.nativeCodeDir()).append(".properties").toString();
        jarExt = ".jar";
        String regexExtensions = LLVM$.MODULE$.srcExtensions().mkString("(\\", "|\\", ")");
        String jarSrcRegex = new StringBuilder(7).append("^").append(MODULE$.nativeCodeDir()).append("/(.+)").append(regexExtensions).append("$").toString();
        jarPattern = Pattern.compile(jarSrcRegex);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NativeLib$.class);
    }

    public NativeLib apply(Path src, Path dest) {
        return new NativeLib(src, dest);
    }

    public NativeLib unapply(NativeLib x$1) {
        return x$1;
    }

    public String toString() {
        return "NativeLib";
    }

    public String nativeCodeDir() {
        return nativeCodeDir;
    }

    public Future<Seq<Path>> compileNativeLibrary(Config config, ReachabilityAnalysis.Result analysis, NativeLib nativeLib, ExecutionContext ec) {
        Path destPath = this.unpackNativeCode(nativeLib);
        Seq<Path> paths = this.findNativePaths(destPath);
        Config projConfig = this.configureNativeLibrary(config, analysis, destPath);
        return Future$.MODULE$.sequence((IterableOnce)paths.map((Function1 & Serializable)_$1 -> LLVM$.MODULE$.compile(projConfig, (Path)_$1, ec)), BuildFrom$.MODULE$.buildFromIterableOps(), ec);
    }

    private Config configureNativeLibrary(Config initialConfig, ReachabilityAnalysis.Result analysis, Path destPath) {
        Path nativeCodePath = destPath.resolve(this.nativeCodeDir());
        return (Config)((Function1 & Serializable)(Function1 & Serializable)config -> this.withAnalysisInfo$1(analysis, (Config)config)).andThen((Function1 & Serializable)config -> this.withProjectDescriptor$1(analysis, nativeCodePath, (Config)config)).apply((Object)initialConfig);
    }

    private Seq<String> resolveDescriptorFlags(Descriptor desc, Config config, ReachabilityAnalysis.Result analysis, Path nativeCodePath) {
        Nil$ nil$;
        List linkDefines = desc.links().filter((Function1 & Serializable)name -> analysis.links().exists((Function1 & Serializable)_$6 -> {
            String string = _$6.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).map((Function1 & Serializable)name -> new StringBuilder(19).append("-DSCALANATIVE_LINK_").append(name.toUpperCase()).toString());
        List includePaths = desc.includes().map((Function1 & Serializable)_$7 -> this.createPathString((String)_$7, nativeCodePath)).map((Function1 & Serializable)path -> new StringBuilder(2).append("-I").append((String)path).toString());
        List defines = desc.defines().map((Function1 & Serializable)define -> new StringBuilder(2).append("-D").append((String)define).toString());
        if (!desc.gcProject()) {
            nil$ = package$.MODULE$.Nil();
        } else {
            String gcName = config.compilerConfig().gc().toString().toUpperCase();
            nil$ = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Some$.MODULE$.apply((Object)new StringBuilder(17).append("-DSCALANATIVE_GC_").append(gcName).toString()), !config.useTrapBasedGCYieldPoints() ? None$.MODULE$ : Some$.MODULE$.apply((Object)"-DSCALANATIVE_GC_USE_YIELDPOINT_TRAPS")})).flatten(Predef$.MODULE$.$conforms());
        }
        Nil$ gcMaybeDefines = nil$;
        return (Seq)((IterableOps)((IterableOps)linkDefines.$plus$plus((IterableOnce)defines)).$plus$plus((IterableOnce)gcMaybeDefines)).$plus$plus((IterableOnce)includePaths);
    }

    private String createPathString(String unixPath, Path nativeCodePath) {
        Object[] dirs = unixPath.split("/");
        Object object = Predef$.MODULE$.refArrayOps(dirs);
        return IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath((Path)ArrayOps$.MODULE$.foldLeft$extension(object, (Object)nativeCodePath, (Function2 & Serializable)(path, dir) -> path.resolve((String)dir))));
    }

    private Option<Path> findDescriptor(Path nativeCodePath) {
        Path file = nativeCodePath.resolve(nativeProjectProps);
        return Files.exists(file, new LinkOption[0]) ? Some$.MODULE$.apply((Object)file) : None$.MODULE$;
    }

    public Seq<NativeLib> findNativeLibs(Config config) {
        Seq nativeLibPaths;
        Seq extractPaths;
        Path workDir = config.workDir();
        Seq<Path> classpath = config.classPath();
        Path nativeCodeDir = workDir.resolve("dependencies");
        if (Build$.MODULE$.userConfigHasChanged(config)) {
            IO$.MODULE$.deleteRecursive(nativeCodeDir);
        }
        if ((extractPaths = (Seq)((IterableOps)(nativeLibPaths = (Seq)classpath.flatMap((Function1 & Serializable)path -> this.isJar((Path)path) ? this.readJar((Path)path) : this.readDir((Path)path))).zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
            String name = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(path.getFileName().toString()), jarExt);
            return this.apply(path, nativeCodeDir.resolve(new StringBuilder(1).append(name).append("-").append(index).toString()));
        })).isEmpty()) {
            throw new BuildException(new StringBuilder(38).append("No Scala Native libraries were found: ").append(classpath).toString());
        }
        if (Files.exists(nativeCodeDir, new LinkOption[0])) {
            Set expectedPaths = ((IterableOnceOps)extractPaths.map((Function1 & Serializable)_$8 -> _$8.dest().toAbsolutePath())).toSet();
            Files.list(nativeCodeDir).filter(p -> !expectedPaths.contains((Object)p.toAbsolutePath())).forEach(_$9 -> IO$.MODULE$.deleteRecursive((Path)_$9));
        }
        return extractPaths;
    }

    private Seq<Path> findNativePaths(Path destPath) {
        String srcPatterns = this.destSrcPattern(destPath);
        return IO$.MODULE$.getAll(destPath, srcPatterns);
    }

    public Seq<Path> filterClasspath(Seq<Path> classpath) {
        return (Seq)classpath.filter((Function1 & Serializable)p -> Files.exists(p, new LinkOption[0]) && (this.isJar((Path)p) || Files.isDirectory(p, new LinkOption[0])));
    }

    private Path unpackNativeCode(NativeLib nativelib) {
        return this.isJar(nativelib) ? this.unpackNativeJar(nativelib) : this.copyNativeDir(nativelib);
    }

    /*
     * WARNING - void declaration
     */
    private Path unpackNativeJar(NativeLib nativelib) {
        void var2_2;
        Path target = nativelib.dest();
        Path source = nativelib.src();
        this.unpack$1(target, source);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Path copyNativeDir(NativeLib nativelib) {
        void var2_2;
        Path target = nativelib.dest();
        Path source = nativelib.src();
        this.copy$1(target, source);
        return var2_2;
    }

    private boolean isJar(Path path) {
        return path.toString().endsWith(jarExt);
    }

    private boolean isJar(NativeLib nativelib) {
        return this.isJar(nativelib.src());
    }

    private boolean isNativeFile(String name) {
        return jarPattern.matcher(name).matches();
    }

    private Option<Path> readDir(Path path) {
        Some some;
        boolean bl = IO$.MODULE$.existsInDir(path, this.srcPatterns(path));
        if (bl) {
            some = Some$.MODULE$.apply((Object)path);
        } else if (!bl) {
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return some;
    }

    private Option<Path> readJar(Path path) {
        Some some;
        boolean bl = IO$.MODULE$.existsInJar(path, (Function1<String, Object>)(Function1 & Serializable)name -> this.isNativeFile((String)name));
        if (bl) {
            some = Some$.MODULE$.apply((Object)path);
        } else if (!bl) {
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return some;
    }

    private String srcPatterns(Path path) {
        return LLVM$.MODULE$.srcExtensions().mkString(new StringBuilder(8).append("glob:").append(this.srcPathPattern(path)).append("**{").toString(), ",", "}");
    }

    private String srcPathPattern(Path path) {
        return this.makeDirPath(path, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.nativeCodeDir()}));
    }

    private String allFilesPattern(Path path) {
        return new StringBuilder(7).append("glob:").append(this.srcPathPattern(path)).append("**").toString();
    }

    private String destSrcPattern(Path destPath) {
        String dirPattern = new StringBuilder(2).append("{").append(destPath.getFileName()).append("}").toString();
        Path workDir = destPath.getParent();
        String pathPat = this.makeDirPath(workDir, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dirPattern, this.nativeCodeDir()}));
        return LLVM$.MODULE$.srcExtensions().mkString(new StringBuilder(8).append("glob:").append(pathPat).append("**{").toString(), ",", "}");
    }

    private String makeDirPath(Path path, Seq<String> elems) {
        String pathSep = Platform$.MODULE$.isWindows() ? "\\\\" : File.separator;
        String string = path.toString().replace(File.separator, pathSep);
        return ((IterableOnceOps)elems.$plus$colon((Object)string)).mkString("", pathSep, pathSep);
    }

    public NativeLib fromProduct(Product x$0) {
        return new NativeLib((Path)x$0.productElement(0), (Path)x$0.productElement(1));
    }

    private final Config withAnalysisInfo$1(ReachabilityAnalysis.Result analysis$1, Config config) {
        Seq preprocessorFlags = (Seq)analysis$1.preprocessorDefinitions().map((Function1 & Serializable)x$1 -> {
            String string;
            Attr.Define define = x$1;
            if (define == null) {
                throw new MatchError((Object)define);
            }
            Attr.Define define2 = Attr.Define$.MODULE$.unapply(define);
            String name = string = define2._1();
            return new StringBuilder(2).append("-D").append(name).toString();
        });
        return config.withCompilerConfig((Function1<NativeConfig, NativeConfig>)(Function1 & Serializable)_$2 -> _$2.withCompileOptions((Function1<Seq<String>, Seq<String>>)(Function1 & Serializable)_$3 -> (Seq)_$3.$plus$plus((IterableOnce)preprocessorFlags)));
    }

    private final Config withProjectDescriptor$1$$anonfun$1(Config config$1) {
        return config$1;
    }

    private final Config withProjectDescriptor$1(ReachabilityAnalysis.Result analysis$2, Path nativeCodePath$1, Config config) {
        return (Config)this.findDescriptor(nativeCodePath$1).fold(() -> this.withProjectDescriptor$1$$anonfun$1(config), (Function1 & Serializable)filepath -> {
            Try<Descriptor> try_ = Descriptor$.MODULE$.load((Path)filepath);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Throwable e = ((Failure)try_).exception();
                    throw new BuildException(new StringBuilder(18).append("Problem reading ").append(nativeProjectProps).append(": ").append(e.getMessage()).toString());
                }
                throw new MatchError(try_);
            }
            Descriptor v = (Descriptor)((Success)try_).value();
            Descriptor descriptor = v;
            config.logger().debug(new StringBuilder(22).append("Compilation settings: ").append(descriptor.toString()).toString());
            Seq<String> projectSettings = this.resolveDescriptorFlags(descriptor, config, analysis$2, nativeCodePath$1);
            return config.withCompilerConfig((Function1<NativeConfig, NativeConfig>)(Function1 & Serializable)_$4 -> _$4.withCompileOptions((Function1<Seq<String>, Seq<String>>)(Function1 & Serializable)_$5 -> (Seq)_$5.$plus$plus((IterableOnce)projectSettings)));
        });
    }

    private final void unpack$1(Path target$1, Path source$1) {
        IO$.MODULE$.deleteRecursive(target$1);
        IO$.MODULE$.unzip(source$1, target$1);
    }

    private final void copy$1(Path target$2, Path source$2) {
        IO$.MODULE$.deleteRecursive(target$2);
        IO$.MODULE$.copyDirectory(source$2, target$2);
    }
}

