/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.Serializable;
import java.nio.file.Path;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.scalanative.build.SourceLevelDebuggingConfig$;
import scala.scalanative.build.SourceLevelDebuggingConfig$Impl$;

public interface SourceLevelDebuggingConfig {
    public static SourceLevelDebuggingConfig disabled() {
        return SourceLevelDebuggingConfig$.MODULE$.disabled();
    }

    public static int ordinal(SourceLevelDebuggingConfig sourceLevelDebuggingConfig) {
        return SourceLevelDebuggingConfig$.MODULE$.ordinal(sourceLevelDebuggingConfig);
    }

    public boolean enabled();

    public SourceLevelDebuggingConfig enabled(boolean var1);

    public SourceLevelDebuggingConfig enableAll();

    public SourceLevelDebuggingConfig disableAll();

    public boolean generateFunctionSourcePositions();

    public SourceLevelDebuggingConfig generateFunctionSourcePositions(boolean var1);

    public boolean generateLocalVariables();

    public SourceLevelDebuggingConfig generateLocalVariables(boolean var1);

    public Seq<Path> customSourceRoots();

    public SourceLevelDebuggingConfig withCustomSourceRoots(Seq<Path> var1);

    public String show(String var1);

    public static final class Impl
    implements SourceLevelDebuggingConfig,
    Product,
    Serializable {
        private final boolean enabled;
        private final boolean genFunctionSourcePositions;
        private final boolean genLocalVariables;
        private final Seq customSourceRoots;

        public static Impl apply(boolean bl, boolean bl2, boolean bl3, Seq<Path> seq) {
            return SourceLevelDebuggingConfig$Impl$.MODULE$.apply(bl, bl2, bl3, seq);
        }

        public static Impl fromProduct(Product product) {
            return SourceLevelDebuggingConfig$Impl$.MODULE$.fromProduct(product);
        }

        public static Impl unapply(Impl impl) {
            return SourceLevelDebuggingConfig$Impl$.MODULE$.unapply(impl);
        }

        public Impl(boolean enabled, boolean genFunctionSourcePositions, boolean genLocalVariables, Seq<Path> customSourceRoots) {
            this.enabled = enabled;
            this.genFunctionSourcePositions = genFunctionSourcePositions;
            this.genLocalVariables = genLocalVariables;
            this.customSourceRoots = customSourceRoots;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.genFunctionSourcePositions() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.genLocalVariables() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.customSourceRoots()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Impl)) return false;
            Impl impl = (Impl)object;
            if (this.enabled() != impl.enabled()) return false;
            if (this.genFunctionSourcePositions() != impl.genFunctionSourcePositions()) return false;
            if (this.genLocalVariables() != impl.genLocalVariables()) return false;
            Seq<Path> seq = this.customSourceRoots();
            Seq<Path> seq2 = impl.customSourceRoots();
            if (seq != null) {
                if (!seq.equals(seq2)) return false;
                return true;
            }
            if (seq2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Impl;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Impl";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._1());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._2());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._3());
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "enabled";
                    break;
                }
                case 1: {
                    string = "genFunctionSourcePositions";
                    break;
                }
                case 2: {
                    string = "genLocalVariables";
                    break;
                }
                case 3: {
                    string = "customSourceRoots";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public boolean enabled() {
            return this.enabled;
        }

        private boolean genFunctionSourcePositions() {
            return this.genFunctionSourcePositions;
        }

        private boolean genLocalVariables() {
            return this.genLocalVariables;
        }

        @Override
        public Seq<Path> customSourceRoots() {
            return this.customSourceRoots;
        }

        @Override
        public SourceLevelDebuggingConfig enabled(boolean state) {
            return this.copy(state, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        @Override
        public SourceLevelDebuggingConfig enableAll() {
            return this.copy(true, true, true, this.copy$default$4());
        }

        @Override
        public SourceLevelDebuggingConfig disableAll() {
            return this.copy(false, false, false, this.copy$default$4());
        }

        @Override
        public boolean generateFunctionSourcePositions() {
            return this.enabled() && this.genFunctionSourcePositions();
        }

        @Override
        public SourceLevelDebuggingConfig generateFunctionSourcePositions(boolean state) {
            return this.copy(this.copy$default$1(), state, this.copy$default$3(), this.copy$default$4());
        }

        @Override
        public boolean generateLocalVariables() {
            return this.enabled() && this.genLocalVariables();
        }

        @Override
        public SourceLevelDebuggingConfig generateLocalVariables(boolean state) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), state, this.copy$default$4());
        }

        @Override
        public SourceLevelDebuggingConfig withCustomSourceRoots(Seq<Path> paths) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), paths);
        }

        public String toString() {
            return this.show(" ");
        }

        @Override
        public String show(String indent) {
            String state = this.enabled() ? "Enabled" : "Disabled";
            String sourceRoots = this.customSourceRoots().mkString("[", ", ", "]");
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(158).append("SourceLevelDebuggingConfig[").append(state).append("]\n        |").append(indent).append("- customSourceRoots:       ").append(sourceRoots).append("\n        |").append(indent).append("- generateFunctionSourcePositions: ").append(this.generateFunctionSourcePositions()).append("\n        |").append(indent).append("- generateLocalVariables:  ").append(this.generateLocalVariables()).append("\n        |").append(indent).append(")").toString()));
        }

        public Impl copy(boolean enabled, boolean genFunctionSourcePositions, boolean genLocalVariables, Seq<Path> customSourceRoots) {
            return new Impl(enabled, genFunctionSourcePositions, genLocalVariables, customSourceRoots);
        }

        public boolean copy$default$1() {
            return this.enabled();
        }

        public boolean copy$default$2() {
            return this.genFunctionSourcePositions();
        }

        public boolean copy$default$3() {
            return this.genLocalVariables();
        }

        public Seq<Path> copy$default$4() {
            return this.customSourceRoots();
        }

        public boolean _1() {
            return this.enabled();
        }

        public boolean _2() {
            return this.genFunctionSourcePositions();
        }

        public boolean _3() {
            return this.genLocalVariables();
        }

        public Seq<Path> _4() {
            return this.customSourceRoots();
        }
    }
}

