/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.codegen;

import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.scalanative.build.Build$;
import scala.scalanative.build.Config;
import scala.scalanative.nir.Defn;

public class IncrementalCodeGenContext {
    private final Config config;
    private final TrieMap<String, Object> package2hash;
    private final TrieMap<String, Object> pack2hashPrev;
    private final TrieMap<String, Object> changed;
    private final Path dumpPackage2hash;

    public IncrementalCodeGenContext(Config config) {
        this.config = config;
        this.package2hash = (TrieMap)TrieMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.pack2hashPrev = (TrieMap)TrieMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.changed = (TrieMap)TrieMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.dumpPackage2hash = config.workDir().resolve("package2hash");
    }

    public void collectFromPreviousState() {
        if (Build$.MODULE$.userConfigHasChanged(this.config)) {
            Files.deleteIfExists(this.dumpPackage2hash);
        } else if (Files.exists(this.dumpPackage2hash, new LinkOption[0])) {
            Source$.MODULE$.fromFile(this.dumpPackage2hash.toUri(), Codec$.MODULE$.fallbackSystemCodec()).getLines().toList().foreach((Function1 & Serializable)vec -> {
                BoxedUnit boxedUnit;
                Object object;
                String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(vec), ',');
                if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                    String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                    String packageName = string;
                    String hashCodeString = string2;
                    boxedUnit = this.pack2hashPrev.put((Object)packageName, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(hashCodeString))));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }
    }

    public void addEntry(String packageName, Seq<Defn> defns) {
        long hash = BoxesRunTime.unboxToLong((Object)defns.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(_$1, _$2) -> IncrementalCodeGenContext.$anonfun$1(BoxesRunTime.unboxToLong((Object)_$1), (Defn)_$2)));
        Option prevHash = this.pack2hashPrev.get((Object)packageName);
        this.package2hash.put((Object)packageName, (Object)BoxesRunTime.boxToLong((long)hash));
        if (prevHash.forall((Function1)(JFunction1.mcZJ.sp & Serializable)_$3 -> _$3 != hash)) {
            this.changed.put((Object)packageName, (Object)BoxesRunTime.boxToLong((long)hash));
        }
    }

    public boolean shouldCompile(String packageName) {
        return this.changed.contains((Object)packageName);
    }

    public void dump() {
        try (PrintWriter pwHash = new PrintWriter(this.dumpPackage2hash.toFile());){
            this.package2hash.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String packageName = (String)tuple2._1();
                long hash = BoxesRunTime.unboxToLong((Object)tuple2._2());
                pwHash.write(packageName);
                pwHash.write(",");
                pwHash.println(hash);
            });
        }
    }

    public void clear() {
        this.package2hash.clear();
        this.pack2hashPrev.clear();
        this.changed.clear();
    }

    private static final /* synthetic */ long $anonfun$1(long _$1, Defn _$2) {
        return _$1 + (long)_$2.hashCode();
    }
}

