/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.SetOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.scalanative.build.Config;
import scala.scalanative.build.IO$;
import scala.scalanative.build.LLVM$;
import scala.scalanative.build.NativeConfig;
import scala.scalanative.build.NativeLib;
import scala.scalanative.build.NativeLib$;
import scala.scalanative.build.Platform$;
import scala.scalanative.build.ScalaNative$;
import scala.scalanative.build.Validator$;
import scala.scalanative.linker.Class;
import scala.scalanative.linker.Info;
import scala.scalanative.linker.ReachabilityAnalysis;
import scala.scalanative.nir.Global;
import scala.scalanative.util.Scope;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Build$
implements Serializable {
    public static final Build$ MODULE$ = new Build$();

    private Build$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Build$.class);
    }

    public Future<Path> buildCached(Config config, Scope scope, ExecutionContext ec) {
        Future future;
        Path checksumPath = config.workDir().resolve("build-checksum");
        if (Files.exists(config.artifactPath(), new LinkOption[0]) && IO$.MODULE$.readFully(checksumPath).contains((Object)BoxesRunTime.boxToInteger((int)this.scala$scalanative$build$Build$$$checkSum(config)).toString())) {
            config.logger().info("Build skipped: No changes detected in build configuration and class path contents since last build.");
            future = Future$.MODULE$.successful((Object)config.artifactPath());
        } else {
            future = this.build(config, scope, ec).andThen((PartialFunction)new Serializable(config, checksumPath){
                private final Config config$1;
                private final Path checksumPath$1;
                {
                    this.config$1 = config$17;
                    this.checksumPath$1 = checksumPath$2;
                }

                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    return try_ instanceof Success;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Object object;
                    Try try_ = x;
                    if (try_ instanceof Success) {
                        IO$.MODULE$.write(this.checksumPath$1, BoxesRunTime.boxToInteger((int)Build$.MODULE$.scala$scalanative$build$Build$$$checkSum(this.config$1)).toString());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            }, ec);
        }
        return future;
    }

    public Future<Path> build(Config config, Scope scope, ExecutionContext ec) {
        Config initialConfig = config;
        return config.logger().timeAsync("Total", () -> this.build$$anonfun$1(scope, ec, initialConfig), ec);
    }

    private Future<Seq<Path>> compile(Config config, ReachabilityAnalysis.Result analysis, Seq<Future<Path>> irGenerators, ExecutionContext ec) {
        return config.logger().timeAsync("Compiling to native code", () -> this.compile$$anonfun$1(config, analysis, irGenerators, ec), ec);
    }

    private Path link(Config config, ReachabilityAnalysis.Result analysis, Seq<Path> compiled) {
        return (Path)config.logger().time(new StringBuilder(31).append("Linking native code (").append(config.gc().name()).append(" gc, ").append(config.LTO().name()).append(" lto)").toString(), () -> this.link$$anonfun$1(config, analysis, compiled));
    }

    private Tuple2<Config, Object> postRechabilityAnalysisConfigUpdate(Config config, ReachabilityAnalysis.Result analysis) {
        BoxedUnit boxedUnit;
        Config currentConfig = config;
        boolean needsToReload = false;
        if (config.compilerConfig().multithreading().isEmpty()) {
            Global.Top jlThread = Global.Top$.MODULE$.apply("java.lang.Thread");
            Global.Top jlMainThread = Global.Top$.MODULE$.apply("java.lang.Thread$MainThread$");
            Global.Top jlVirtualThread = Global.Top$.MODULE$.apply("java.lang.VirtualThread");
            boolean usesSystemThreads = BoxesRunTime.unboxToBoolean((Object)analysis.infos().get((Object)jlThread).collect((PartialFunction)new Serializable(jlMainThread, jlVirtualThread){
                private final Global.Top jlMainThread$1;
                private final Global.Top jlVirtualThread$1;
                {
                    this.jlMainThread$1 = jlMainThread$2;
                    this.jlVirtualThread$1 = jlVirtualThread$2;
                }

                public final boolean isDefinedAt(Info x) {
                    boolean bl;
                    Info info = x;
                    if (info instanceof Class) {
                        Class cls = (Class)info;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(Info x, Function1 function1) {
                    Class cls;
                    Info info = x;
                    return info instanceof Class ? BoxesRunTime.boxToBoolean(((cls = (Class)info).subclasses().size() > 2 || ((SetOps)cls.subclasses().map(Build$::scala$scalanative$build$Build$$anon$3$$_$applyOrElse$$anonfun$1)).diff((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Global.Top[]{this.jlMainThread$1, this.jlVirtualThread$1}))).nonEmpty() || cls.allocations() > 4 ? 1 : 0) != 0) : function1.apply((Object)x);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{scala$scalanative$build$Build$$anon$3$$_$applyOrElse$$anonfun$1(scala.scalanative.linker.Class )}, serializedLambda);
                }
            }).getOrElse(this::$anonfun$2));
            if (!usesSystemThreads) {
                config.logger().info("Multithreading was not explicitly enabled - initial class loading has not detected any usage of system threads. Multithreading support will be disabled to improve performance.");
                currentConfig = currentConfig.withCompilerConfig((Function1<NativeConfig, NativeConfig>)(Function1 & Serializable)_$5 -> _$5.withMultithreading(false));
                needsToReload = true;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
        Config config2 = (Config)Predef$.MODULE$.ArrowAssoc((Object)currentConfig);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)config2, (Object)BoxesRunTime.boxToBoolean((boolean)needsToReload));
    }

    private Path postProcess(Config config, Path artifact) {
        return (Path)config.logger().time("Postprocessing", () -> this.postProcess$$anonfun$1(config, artifact));
    }

    public int scala$scalanative$build$Build$$$checkSum(Config config) {
        return Tuple3$.MODULE$.apply((Object)config, config.classPath().map((Function1 & Serializable)_$6 -> this.getLastModifiedChild((Path)_$6)), (Object)this.getLastModified(config.artifactPath())).hashCode();
    }

    public Future<Seq<Path>> findAndCompileNativeLibraries(Config config, ReachabilityAnalysis.Result analysis, ExecutionContext ec) {
        return Future$.MODULE$.traverse(NativeLib$.MODULE$.findNativeLibs(config), (Function1 & Serializable)_$7 -> NativeLib$.MODULE$.compileNativeLibrary(config, analysis, (NativeLib)_$7, ec), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)_$8 -> (Seq)_$8.flatten(Predef$.MODULE$.$conforms()), ec);
    }

    private void checkWorkdirExists(Config config) {
        Path workDir = config.workDir();
        if (Files.notExists(workDir, new LinkOption[0])) {
            Files.createDirectories(workDir, new FileAttribute[0]);
        }
    }

    private FileTime getLastModified(Path path) {
        return Files.exists(path, new LinkOption[0]) ? (FileTime)Try$.MODULE$.apply(() -> this.getLastModified$$anonfun$1(path)).getOrElse(this::getLastModified$$anonfun$2) : FileTime.fromMillis(0L);
    }

    private Optional<FileTime> getLastModifiedChild(Path path) {
        return Files.exists(path, new LinkOption[0]) ? Files.walk(path, FileVisitOption.FOLLOW_LINKS).map(_$9 -> this.getLastModified((Path)_$9)).max((_$10, _$11) -> _$10.compareTo((FileTime)_$11)) : Optional.empty();
    }

    public final String userConfigHashFile() {
        return "userConfigHash";
    }

    public boolean userConfigHasChanged(Config config) {
        return IO$.MODULE$.readFully(config.workDir().resolve("userConfigHash")).forall((Function1 & Serializable)_$12 -> {
            String string = _$12.trim();
            String string2 = BoxesRunTime.boxToInteger((int)Statics.anyHash((Object)config.compilerConfig())).toString();
            return string == null ? string2 != null : !string.equals(string2);
        });
    }

    public void dumpUserConfigHash(Config config) {
        IO$.MODULE$.write(config.workDir().resolve("userConfigHash"), BoxesRunTime.boxToInteger((int)Statics.anyHash((Object)config.compilerConfig())).toString());
    }

    private final Future linkNIRForEntries$1(Scope scope$2, ExecutionContext ec$2, ObjectRef config$2) {
        return ScalaNative$.MODULE$.link((Config)config$2.elem, ScalaNative$.MODULE$.entries((Config)config$2.elem), scope$2, ec$2);
    }

    private final Future build$$anonfun$1(Scope scope$1, ExecutionContext ec$1, Config initialConfig$1) {
        this.checkWorkdirExists(initialConfig$1);
        ObjectRef config = ObjectRef.create((Object)Validator$.MODULE$.validate(initialConfig$1));
        ((Config)config.elem).logger().debug(((Config)config.elem).toString());
        return this.linkNIRForEntries$1(scope$1, ec$1, config).flatMap((Function1 & Serializable)linkerResult -> {
            Tuple2<Config, Object> tuple2 = this.postRechabilityAnalysisConfigUpdate((Config)config$3.elem, (ReachabilityAnalysis.Result)linkerResult);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Config updatedConfig = (Config)tuple2._1();
            boolean needsToReload = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)updatedConfig, (Object)BoxesRunTime.boxToBoolean((boolean)needsToReload));
            Config updatedConfig2 = (Config)tuple22._1();
            boolean needsToReload2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
            Config config = updatedConfig2;
            config$3.elem = config;
            config = null;
            return needsToReload2 ? this.linkNIRForEntries$1(scope$1, ec$1, config) : Future$.MODULE$.successful(linkerResult);
        }, ec$1).flatMap((Function1 & Serializable)_$1 -> ScalaNative$.MODULE$.optimize((Config)config$4.elem, (ReachabilityAnalysis.Result)_$1, ec$1), ec$1).flatMap((Function1 & Serializable)linkerResult -> ScalaNative$.MODULE$.codegen((Config)config$5.elem, (ReachabilityAnalysis.Result)linkerResult, ec$1).flatMap((Function1 & Serializable)irGenerators -> this.compile((Config)config$6.elem, (ReachabilityAnalysis.Result)linkerResult, (Seq<Future<Path>>)irGenerators, ec$1), ec$1).map((Function1 & Serializable)objects -> this.link((Config)config$7.elem, (ReachabilityAnalysis.Result)linkerResult, (Seq<Path>)objects), ec$1).map((Function1 & Serializable)artifact -> this.postProcess((Config)config$8.elem, (Path)artifact), ec$1), ec$1).andThen((PartialFunction)new Serializable(config){
            private final ObjectRef config$9;
            {
                this.config$9 = config$18;
            }

            public final boolean isDefinedAt(Try x) {
                Try try_ = x;
                return try_ instanceof Success;
            }

            public final Object applyOrElse(Try x, Function1 function1) {
                Object object;
                Try try_ = x;
                if (try_ instanceof Success) {
                    Build$.MODULE$.dumpUserConfigHash((Config)this.config$9.elem);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        }, ec$1);
    }

    private final Future compile$$anonfun$1(Config config$10, ReachabilityAnalysis.Result analysis$1, Seq irGenerators$1, ExecutionContext ec$7) {
        Future compileGeneratedIR = Future$.MODULE$.sequence((IterableOnce)irGenerators$1.map((Function1 & Serializable)irGenerator -> irGenerator.flatMap((Function1 & Serializable)generatedIR -> LLVM$.MODULE$.compile(config$10, (Path)generatedIR, ec$7), ec$7)), BuildFrom$.MODULE$.buildFromIterableOps(), ec$7);
        Future<Seq<Path>> compileNativeLibs = this.findAndCompileNativeLibraries(config$10, analysis$1, ec$7);
        return Future$.MODULE$.reduceLeft((Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{compileGeneratedIR, compileNativeLibs})), (Function2 & Serializable)(_$2, _$3) -> (Seq)_$2.$plus$plus((IterableOnce)_$3), ec$7);
    }

    private final Path link$$anonfun$1(Config config$13, ReachabilityAnalysis.Result analysis$2, Seq compiled$1) {
        return LLVM$.MODULE$.link(config$13, analysis$2, (Seq<Path>)compiled$1);
    }

    public static final /* synthetic */ Global.Top scala$scalanative$build$Build$$anon$3$$_$applyOrElse$$anonfun$1(Class _$4) {
        return _$4.name();
    }

    private final boolean $anonfun$2() {
        return false;
    }

    private final Path postProcess$$anonfun$1(Config config$14, Path artifact$1) {
        if (Platform$.MODULE$.isMac() && config$14.compilerConfig().sourceLevelDebuggingConfig().generateFunctionSourcePositions()) {
            LLVM$.MODULE$.dsymutil(config$14, artifact$1);
        }
        return artifact$1;
    }

    private final FileTime getLastModified$$anonfun$1(Path path$1) {
        return Files.getLastModifiedTime(path$1, new LinkOption[0]);
    }

    private final FileTime getLastModified$$anonfun$2() {
        return FileTime.fromMillis(0L);
    }
}

