/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sbt.Highlight$;
import sbt.State;
import sbt.State$;
import sbt.State$StateOpsImpl$;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.Util$;
import sbt.internal.util.complete.DefaultParsers$;
import sbt.internal.util.complete.Parser;
import sbt.internal.util.complete.RichParser;
import sbt.io.FileFilter;
import sbt.io.FileFilter$;
import sbt.io.IO$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class CommandUtil$ {
    public static CommandUtil$ MODULE$;

    static {
        new CommandUtil$();
    }

    public Seq<String> readLines(Seq<File> files) {
        return (Seq)((TraversableLike)files.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> IO$.MODULE$.readLines(x$1, IO$.MODULE$.readLines$default$2()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)s -> Option$.MODULE$.option2Iterable(MODULE$.processLine((String)s)), Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> processLine(String s) {
        String s2 = s.trim();
        return this.ignoreLine(s2) ? None$.MODULE$ : new Some((Object)s2);
    }

    public boolean ignoreLine(String s) {
        return s.isEmpty() || s.startsWith("#");
    }

    private Function1<File, Object> canRead() {
        return (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.canRead());
    }

    public Seq<File> notReadable(Seq<File> files) {
        return (Seq)files.filterNot(this.canRead());
    }

    public Seq<File> readable(Seq<File> files) {
        return (Seq)files.filter(this.canRead());
    }

    public File bootDirectory(State state) {
        File file;
        try {
            file = state.configuration().provider().scalaProvider().launcher().bootDirectory();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            file = new File(".").getAbsoluteFile();
        }
        return file;
    }

    public Seq<String> aligned(String pre, String sep, Seq<Tuple2<String, String>> in) {
        Seq seq;
        if (in.isEmpty()) {
            seq = Util$.MODULE$.nilSeq();
        } else {
            int width = BoxesRunTime.unboxToInt((Object)in.iterator().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)CommandUtil$.$anonfun$aligned$1(x$3))).max((Ordering)Ordering.Int$.MODULE$));
            seq = (Seq)in.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CommandUtil$.$anonfun$aligned$2(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                Tuple2 tuple2 = x$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String a = (String)tuple2._1();
                String b = (String)tuple2._2();
                String string = new StringBuilder(0).append(pre).append(MODULE$.fill(a, width)).append(sep).append(b).toString();
                return string;
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public String fill(String s, int size) {
        return new StringBuilder(0).append(s).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(package$.MODULE$.max(size - s.length(), 0))).toString();
    }

    public <T> State withAttribute(State s, AttributeKey<T> key, String ifMissing, Function1<T, State> f) {
        State state;
        Option<T> option = State$StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(s), key);
        if (None$.MODULE$.equals(option)) {
            State$StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).error((Function0 & Serializable & scala.Serializable)() -> ifMissing);
            state = State$StateOpsImpl$.MODULE$.fail$extension(State$.MODULE$.StateOpsImpl(s));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Object nav = some.value();
            state = (State)f.apply(nav);
        } else {
            throw new MatchError(option);
        }
        return state;
    }

    public Parser<String> singleArgument(Set<String> exampleStrings) {
        Parser arg = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.NotSpaceClass()).$tilde(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.any()).$times())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            char ns = tuple2._1$mcC$sp();
            Seq s = (Seq)tuple2._2();
            char c = ns;
            String string = ((TraversableOnce)s.$plus$colon((Object)BoxesRunTime.boxToCharacter((char)c), Seq$.MODULE$.canBuildFrom())).mkString();
            return string;
        });
        RichParser qual$1 = DefaultParsers$.MODULE$.richParser(arg);
        Set<String> x$1 = exampleStrings;
        boolean x$2 = qual$1.examples$default$2();
        return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space())).$tilde$greater(DefaultParsers$.MODULE$.token(qual$1.examples(x$1, x$2)));
    }

    public String detail(String selected, Map<String, String> detailMap) {
        String string;
        Option option = detailMap.get((Object)selected);
        if (option instanceof Some) {
            String exactDetail;
            Some some = (Some)option;
            string = exactDetail = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String string2;
            try {
                Map<String, String> details = this.searchHelp(selected, detailMap);
                string2 = details.isEmpty() ? new StringBuilder(37).append("No matches for regular expression '").append(selected).append("'.").toString() : this.layoutDetails(details);
            }
            catch (PatternSyntaxException pse) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(53).append("Invalid regular expression (java.util.regex syntax).\n").append(pse.getMessage()).toString());
            }
            string = string2;
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public Map<String, String> searchHelp(String selected, Map<String, String> detailMap) {
        Pattern pattern = Pattern.compile(selected, 66);
        return (Map)detailMap.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Option<String> contentMatches = Highlight$.MODULE$.showMatches(pattern, v);
            Option<String> keyMatches = Highlight$.MODULE$.showMatches(pattern, k);
            String keyString = Highlight$.MODULE$.bold((String)keyMatches.getOrElse((Function0 & Serializable & scala.Serializable)() -> k));
            String contentString = (String)contentMatches.getOrElse((Function0 & Serializable & scala.Serializable)() -> v);
            Seq seq = keyMatches.isDefined() || contentMatches.isDefined() ? (Seq)new .colon.colon((Object)new Tuple2((Object)keyString, (Object)contentString), (List)Nil$.MODULE$) : Util$.MODULE$.nilSeq();
            return seq;
        }, Map$.MODULE$.canBuildFrom());
    }

    public String layoutDetails(Map<String, String> details) {
        return ((TraversableOnce)details.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(4).append(k).append("\n\n  ").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n", "\n\n", "\n");
    }

    public final int HelpPatternFlags() {
        return 66;
    }

    public boolean isSbtBuild(File baseDir) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(baseDir), "project").exists() || syntax$.MODULE$.singleFileFinder(baseDir).$times((FileFilter)FileFilter$.MODULE$.globFilter("*.sbt")).get().nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$aligned$1(Tuple2 x$3) {
        return ((String)x$3._1()).length();
    }

    public static final /* synthetic */ boolean $anonfun$aligned$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private CommandUtil$() {
        MODULE$ = this;
    }
}

