/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.DefaultPomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorBuilder;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.extendable.ExtendableItem;
import org.xml.sax.SAXException;

public final class PomModuleDescriptorParser
implements ModuleDescriptorParser {
    private static final PomModuleDescriptorParser INSTANCE = new PomModuleDescriptorParser();

    public static PomModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    private PomModuleDescriptorParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void toIvyFile(InputStream inputStream, Resource resource, File file, ModuleDescriptor moduleDescriptor) throws ParseException, IOException {
        try {
            XmlModuleDescriptorWriter.write(moduleDescriptor, file);
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    @Override
    public final boolean accept(Resource resource) {
        return resource.getName().endsWith(".pom") || resource.getName().endsWith("pom.xml") || resource.getName().endsWith("project.xml");
    }

    public final String toString() {
        return "pom parser";
    }

    @Override
    public final Artifact getMetadataArtifact(ModuleRevisionId moduleRevisionId, Resource resource) {
        return DefaultArtifact.newPomArtifact(moduleRevisionId, new Date(resource.getLastModified()));
    }

    @Override
    public final ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, boolean bl) throws ParseException, IOException {
        URLResource uRLResource = new URLResource(uRL);
        return this.parseDescriptor(parserSettings, uRL, uRLResource, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL object, Resource resource, boolean bl) throws ParseException, IOException {
        PomModuleDescriptorBuilder pomModuleDescriptorBuilder;
        block30: {
            pomModuleDescriptorBuilder = new PomModuleDescriptorBuilder(this, resource, parserSettings);
            try {
                Object object22;
                Object object3;
                object = new PomReader((URL)object, resource);
                ((PomReader)object).setProperty("parent.version", ((PomReader)object).getParentVersion());
                ((PomReader)object).setProperty("parent.groupId", ((PomReader)object).getParentGroupId());
                ((PomReader)object).setProperty("project.parent.version", ((PomReader)object).getParentVersion());
                ((PomReader)object).setProperty("project.parent.groupId", ((PomReader)object).getParentGroupId());
                Object object6 = ((PomReader)object).getPomProperties();
                for (Map.Entry object52 : object6.entrySet()) {
                    ((PomReader)object).setProperty((String)object52.getKey(), (String)object52.getValue());
                    pomModuleDescriptorBuilder.addProperty((String)object52.getKey(), (String)object52.getValue());
                }
                object6 = null;
                if (((PomReader)object).hasParent()) {
                    ModuleRevisionId i = ModuleRevisionId.newInstance(((PomReader)object).getParentGroupId(), ((PomReader)object).getParentArtifactId(), ((PomReader)object).getParentVersion());
                    object3 = this.parseOtherPom(parserSettings, i);
                    if (object3 == null) {
                        throw new IOException("Impossible to load parent for " + resource.getName() + ". Parent=" + i);
                    }
                    object6 = ((ResolvedModuleRevision)object3).getDescriptor();
                    if (object6 != null) {
                        object22 = PomModuleDescriptorBuilder.extractPomProperties(object6.getExtraInfo());
                        for (Map.Entry entry : object22.entrySet()) {
                            ((PomReader)object).setProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                String string = ((PomReader)object).getGroupId();
                object3 = ((PomReader)object).getArtifactId();
                object22 = ((PomReader)object).getVersion();
                pomModuleDescriptorBuilder.setModuleRevId(string, (String)object3, (String)object22);
                pomModuleDescriptorBuilder.setHomePage(((PomReader)object).getHomePage());
                pomModuleDescriptorBuilder.setDescription(((PomReader)object).getDescription());
                Object object42 = ((PomReader)object).getLicenses();
                if (object42 != null && ((License[])object42).length > 0) {
                    pomModuleDescriptorBuilder.setLicenses((License[])object42);
                } else if (object6 != null) {
                    pomModuleDescriptorBuilder.setLicenses(object6.getLicenses());
                }
                ModuleRevisionId moduleRevisionId = ((PomReader)object).getRelocation();
                if (moduleRevisionId != null) {
                    if (string != null && object3 != null && ((String)object3).equals(moduleRevisionId.getName()) && string.equals(moduleRevisionId.getOrganisation())) {
                        Message.error("Relocation to an other version number not supported in ivy : " + pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " relocated to " + moduleRevisionId + ". Please update your dependency to directly use the right version.");
                        Message.warn("Resolution will only pick dependencies of the relocated element.  Artefact and other metadata will be ignored.");
                        ResolvedModuleRevision resolvedModuleRevision = this.parseOtherPom(parserSettings, moduleRevisionId);
                        if (resolvedModuleRevision == null) {
                            throw new ParseException("impossible to load module " + moduleRevisionId + " to which " + pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " has been relocated", 0);
                        }
                        object22 = resolvedModuleRevision.getDescriptor().getDependencies();
                        for (int i = 0; i < ((ExtendableItem[])object22).length; ++i) {
                            pomModuleDescriptorBuilder.addDependency((DependencyDescriptor)object22[i]);
                        }
                    } else {
                        Message.info(pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " is relocated to " + moduleRevisionId + ". Please update your dependencies.");
                        Message.verbose("Relocated module will be considered as a dependency");
                        DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(pomModuleDescriptorBuilder.getModuleDescriptor(), moduleRevisionId, true, false, true);
                        object22 = PomModuleDescriptorBuilder.MAVEN2_CONFIGURATIONS;
                        for (int i = 0; i < ((Configuration[])object22).length; ++i) {
                            if (!Configuration.Visibility.PUBLIC.equals(object22[i].getVisibility())) continue;
                            defaultDependencyDescriptor.addDependencyConfiguration(((Configuration)object22[i]).getName(), ((Configuration)object22[i]).getName());
                        }
                        pomModuleDescriptorBuilder.addDependency(defaultDependencyDescriptor);
                    }
                    break block30;
                }
                ((PomReader)object).setProperty("project.groupId", string);
                ((PomReader)object).setProperty("pom.groupId", string);
                ((PomReader)object).setProperty("groupId", string);
                ((PomReader)object).setProperty("project.artifactId", (String)object3);
                ((PomReader)object).setProperty("pom.artifactId", (String)object3);
                ((PomReader)object).setProperty("artifactId", (String)object3);
                ((PomReader)object).setProperty("project.version", (String)object22);
                ((PomReader)object).setProperty("pom.version", (String)object22);
                ((PomReader)object).setProperty("version", (String)object22);
                if (object6 != null) {
                    pomModuleDescriptorBuilder.addExtraInfos(object6.getExtraInfo());
                    List list = PomModuleDescriptorBuilder.getDependencyManagements((ModuleDescriptor)object6);
                    for (Object object42 : list) {
                        if (object42 instanceof PomReader.PomDependencyMgtElement) {
                            Object object5 = object;
                            object5.getClass();
                            object42 = (PomReader)object5.new PomReader.PomDependencyMgtElement((PomReader.PomDependencyMgtElement)object42);
                        }
                        pomModuleDescriptorBuilder.addDependencyMgt((PomDependencyMgt)object42);
                    }
                    object22 = PomModuleDescriptorBuilder.getPlugins((ModuleDescriptor)object6);
                    object42 = object22.iterator();
                    while (object42.hasNext()) {
                        pomModuleDescriptorBuilder.addPlugin((PomDependencyMgt)object42.next());
                    }
                }
                for (Object object22 : ((PomReader)object).getDependencyMgt()) {
                    if ("import".equals(object22.getScope())) {
                        object42 = ModuleRevisionId.newInstance(object22.getGroupId(), object22.getArtifactId(), object22.getVersion());
                        if ((object22 = this.parseOtherPom(parserSettings, (ModuleRevisionId)object42)) != null) {
                            object22 = ((ResolvedModuleRevision)object22).getDescriptor();
                            object22 = PomModuleDescriptorBuilder.getDependencyManagements((ModuleDescriptor)object22);
                            object22 = object22.iterator();
                            while (object22.hasNext()) {
                                object42 = (PomDependencyMgt)object22.next();
                                pomModuleDescriptorBuilder.addDependencyMgt(new DefaultPomDependencyMgt(object42.getGroupId(), object42.getArtifactId(), object42.getVersion(), object42.getScope(), object42.getExcludedModules()));
                            }
                            continue;
                        }
                        throw new IOException("Impossible to import module for " + resource.getName() + ". Import=" + object42);
                    }
                    pomModuleDescriptorBuilder.addDependencyMgt((PomDependencyMgt)object22);
                }
                for (Object object22 : ((PomReader)object).getDependencies()) {
                    pomModuleDescriptorBuilder.addDependency(resource, (PomReader.PomDependencyData)object22);
                }
                if (object6 != null) {
                    void var6_19;
                    boolean bl2 = false;
                    while (var6_19 < object6.getDependencies().length) {
                        object22 = object6.getDependencies()[var6_19];
                        if (object22 instanceof PomModuleDescriptorBuilder.PomDependencyDescriptor) {
                            object42 = ((PomModuleDescriptorBuilder.PomDependencyDescriptor)object22).getPomDependencyData();
                            Object object7 = object;
                            object7.getClass();
                            object22 = (PomReader)object7.new PomReader.PomDependencyData((PomReader.PomDependencyData)object42);
                            pomModuleDescriptorBuilder.addDependency(resource, (PomReader.PomDependencyData)object22);
                        } else {
                            pomModuleDescriptorBuilder.addDependency((DependencyDescriptor)object22);
                        }
                        ++var6_19;
                    }
                }
                for (Object object22 : ((PomReader)object).getPlugins()) {
                    pomModuleDescriptorBuilder.addPlugin((PomDependencyMgt)object22);
                }
                pomModuleDescriptorBuilder.addMainArtifact((String)object3, ((PomReader)object).getPackaging());
                this.addSourcesAndJavadocArtifactsIfPresent(pomModuleDescriptorBuilder, parserSettings);
            }
            catch (SAXException sAXException) {
                throw this.newParserException(sAXException);
            }
        }
        return pomModuleDescriptorBuilder.getModuleDescriptor();
    }

    private void addSourcesAndJavadocArtifactsIfPresent(PomModuleDescriptorBuilder pomModuleDescriptorBuilder, ParserSettings object) {
        if (pomModuleDescriptorBuilder.getMainArtifact() == null) {
            return;
        }
        ExtendableItem extendableItem = pomModuleDescriptorBuilder.getModuleDescriptor();
        if ((object = object.getResolver((ModuleRevisionId)(extendableItem = extendableItem.getModuleRevisionId()))) == null) {
            Message.debug("no resolver found for " + extendableItem + ": no source or javadoc artifact lookup");
            return;
        }
        Object object2 = object.locate(pomModuleDescriptorBuilder.getMainArtifact());
        if (!ArtifactOrigin.isUnknown((ArtifactOrigin)object2)) {
            object2 = ((ArtifactOrigin)object2).getLocation();
            ArtifactOrigin artifactOrigin = object.locate(pomModuleDescriptorBuilder.getSourceArtifact());
            if (!ArtifactOrigin.isUnknown(artifactOrigin) && !artifactOrigin.getLocation().equals(object2)) {
                Message.debug("source artifact found for " + extendableItem);
                pomModuleDescriptorBuilder.addSourceArtifact();
            } else {
                artifactOrigin = object.locate(pomModuleDescriptorBuilder.getSrcArtifact());
                if (!ArtifactOrigin.isUnknown(artifactOrigin) && !artifactOrigin.getLocation().equals(object2)) {
                    Message.debug("source artifact found for " + extendableItem);
                    pomModuleDescriptorBuilder.addSrcArtifact();
                } else {
                    Message.debug("no source artifact found for " + extendableItem);
                }
            }
            artifactOrigin = object.locate(pomModuleDescriptorBuilder.getJavadocArtifact());
            if (!ArtifactOrigin.isUnknown(artifactOrigin) && !artifactOrigin.getLocation().equals(object2)) {
                Message.debug("javadoc artifact found for " + extendableItem);
                pomModuleDescriptorBuilder.addJavadocArtifact();
                return;
            }
            Message.debug("no javadoc artifact found for " + extendableItem);
        }
    }

    private ResolvedModuleRevision parseOtherPom(ParserSettings parserSettings, ModuleRevisionId moduleRevisionId) throws ParseException {
        Object object;
        DependencyDescriptor dependencyDescriptor = new DefaultDependencyDescriptor(moduleRevisionId, true);
        Object object2 = IvyContext.getContext().getResolveData();
        if (object2 == null) {
            object = IvyContext.getContext().getIvy().getResolveEngine();
            object2 = new ResolveOptions();
            ((ResolveOptions)object2).setDownload(false);
            object2 = new ResolveData((ResolveEngine)object, (ResolveOptions)object2);
        }
        if ((object = parserSettings.getResolver(moduleRevisionId)) == null) {
            return null;
        }
        dependencyDescriptor = NameSpaceHelper.toSystem(dependencyDescriptor, parserSettings.getContextNamespace());
        object2 = object.getDependency(dependencyDescriptor, (ResolveData)object2);
        return object2;
    }

    private ParseException newParserException(Exception exception) {
        Message.error(exception.getMessage());
        ParseException parseException = new ParseException(exception.getMessage(), 0);
        parseException.initCause(exception);
        return parseException;
    }
}

