/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.librarymanagement;

import java.net.URL;
import sbt.internal.librarymanagement.RepositoriesParser;
import sbt.internal.librarymanagement.RepositoriesParser$;
import sbt.internal.util.UnitSpec;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import xsbti.Predefined;
import xsbti.Repository;

@ScalaSignature(bytes="\u0006\u0001U1A!\u0001\u0002\u0001\u0013\ty\"+\u001a9pg&$xN]5fgB\u000b'o]3s'B,7-\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\r!\u0011!\u00057jEJ\f'/_7b]\u0006<W-\\3oi*\u0011QAB\u0001\tS:$XM\u001d8bY*\tq!A\u0002tER\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\u0011Q\u0002B\u0001\u0005kRLG.\u0003\u0002\u0010\u0019\tAQK\\5u'B,7\rC\u0003\u0012\u0001\u0011\u0005!#\u0001\u0004=S:LGO\u0010\u000b\u0002'A\u0011A\u0003A\u0007\u0002\u0005\u0001")
public class RepositoriesParserSpecification
extends UnitSpec {
    public RepositoriesParserSpecification() {
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapper("The RepositoriesParser").should("check that repositories file starts with [repositories]", this.shorthandTestRegistrationFunction())).in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("local\n                 |maven-central")).stripMargin();
                this.$outer.a(ManifestFactory$.MODULE$.classType(Exception.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final String file$1;

                    public final Seq<Repository> apply() {
                        return RepositoriesParser$.MODULE$.apply(this.file$1);
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.it().should("parse the local repository").in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("[repositories]\n                 |  local")).stripMargin();
                Seq repos = RepositoriesParser$.MODULE$.apply(file);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)repos.size())).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
                this.$outer.convertToAnyShouldWrapper(repos.apply(0)).shouldBe((Object)new RepositoriesParser.PredefinedRepository(Predefined.Local));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.it().should("parse the local maven repository").in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("[repositories]\n                 |  maven-local")).stripMargin();
                Seq repos = RepositoriesParser$.MODULE$.apply(file);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)repos.size())).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
                this.$outer.convertToAnyShouldWrapper(repos.apply(0)).shouldBe((Object)new RepositoriesParser.PredefinedRepository(Predefined.MavenLocal));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.it().should("parse Maven Central repository").in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("[repositories]\n                 |  maven-central")).stripMargin();
                Seq repos = RepositoriesParser$.MODULE$.apply(file);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)repos.size())).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
                this.$outer.convertToAnyShouldWrapper(repos.apply(0)).shouldBe((Object)new RepositoriesParser.PredefinedRepository(Predefined.MavenCentral));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.it().should("parse simple Maven repository").in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("[repositories]\n                 |  mavenRepo: https://repo1.maven.org")).stripMargin();
                Seq repos = RepositoriesParser$.MODULE$.apply(file);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)repos.size())).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
                this.$outer.convertToAnyShouldWrapper(repos.apply(0)).shouldBe((Object)new RepositoriesParser.MavenRepository("mavenRepo", new URL("https://repo1.maven.org")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.it().should("parse `bootOnly` option").in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("[repositories]\n                 |  ivyRepo: https://repo1.maven.org, [orgPath], bootOnly")).stripMargin();
                Seq repos = RepositoriesParser$.MODULE$.apply(file);
                RepositoriesParser.IvyRepository expected = new RepositoriesParser.IvyRepository("ivyRepo", new URL("https://repo1.maven.org"), "[orgPath]", "[orgPath]", false, false, false, true);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)repos.size())).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
                this.$outer.convertToAnyShouldWrapper(repos.apply(0)).shouldBe((Object)expected);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.it().should("parse `mavenCompatible` option").in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("[repositories]\n                 |  ivyRepo: https://repo1.maven.org, [orgPath], mavenCompatible")).stripMargin();
                Seq repos = RepositoriesParser$.MODULE$.apply(file);
                RepositoriesParser.IvyRepository expected = new RepositoriesParser.IvyRepository("ivyRepo", new URL("https://repo1.maven.org"), "[orgPath]", "[orgPath]", true, false, false, false);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)repos.size())).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
                this.$outer.convertToAnyShouldWrapper(repos.apply(0)).shouldBe((Object)expected);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.it().should("parse `skipConsistencyCheck` option").in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("[repositories]\n                 |  ivyRepo: https://repo1.maven.org, [orgPath], skipConsistencyCheck")).stripMargin();
                Seq repos = RepositoriesParser$.MODULE$.apply(file);
                RepositoriesParser.IvyRepository expected = new RepositoriesParser.IvyRepository("ivyRepo", new URL("https://repo1.maven.org"), "[orgPath]", "[orgPath]", false, true, false, false);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)repos.size())).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
                this.$outer.convertToAnyShouldWrapper(repos.apply(0)).shouldBe((Object)expected);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.it().should("parse `descriptorOptional` option").in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("[repositories]\n                 |  ivyRepo: https://repo1.maven.org, [orgPath], descriptorOptional")).stripMargin();
                Seq repos = RepositoriesParser$.MODULE$.apply(file);
                RepositoriesParser.IvyRepository expected = new RepositoriesParser.IvyRepository("ivyRepo", new URL("https://repo1.maven.org"), "[orgPath]", "[orgPath]", false, false, true, false);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)repos.size())).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
                this.$outer.convertToAnyShouldWrapper(repos.apply(0)).shouldBe((Object)expected);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.it().should("parse complex ivy repository definition").in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("[repositories]\n                 |  ivyRepo: https://repo1.maven.org, [orgPath], [artPath], descriptorOptional, skipConsistencyCheck")).stripMargin();
                Seq repos = RepositoriesParser$.MODULE$.apply(file);
                RepositoriesParser.IvyRepository expected = new RepositoriesParser.IvyRepository("ivyRepo", new URL("https://repo1.maven.org"), "[orgPath]", "[artPath]", false, true, true, false);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)repos.size())).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
                this.$outer.convertToAnyShouldWrapper(repos.apply(0)).shouldBe((Object)expected);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.it().should("parse multiple repositories defined together").in((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoriesParserSpecification $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String file = new StringOps(Predef$.MODULE$.augmentString("[repositories]\n                 |  local\n                 |  ivyRepo: https://repo1.maven.org, [orgPath], [artPath], descriptorOptional, skipConsistencyCheck\n                 |  mavenRepo: https://repo1.maven.org")).stripMargin();
                RepositoriesParser.PredefinedRepository expected0 = new RepositoriesParser.PredefinedRepository(Predefined.Local);
                RepositoriesParser.IvyRepository expected1 = new RepositoriesParser.IvyRepository("ivyRepo", new URL("https://repo1.maven.org"), "[orgPath]", "[artPath]", false, true, true, false);
                RepositoriesParser.MavenRepository expected2 = new RepositoriesParser.MavenRepository("mavenRepo", new URL("https://repo1.maven.org"));
                Seq repos = RepositoriesParser$.MODULE$.apply(file);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)repos.size())).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
                this.$outer.convertToAnyShouldWrapper(repos.apply(0)).shouldBe((Object)expected0);
                this.$outer.convertToAnyShouldWrapper(repos.apply(1)).shouldBe((Object)expected1);
                this.$outer.convertToAnyShouldWrapper(repos.apply(2)).shouldBe((Object)expected2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

