/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util.logic;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import sbt.internal.util.Dag;
import sbt.internal.util.Dag$;
import sbt.internal.util.Relation;
import sbt.internal.util.Relation$;
import sbt.internal.util.Util$;
import sbt.internal.util.logic.Atom;
import sbt.internal.util.logic.Atom$;
import sbt.internal.util.logic.Clause;
import sbt.internal.util.logic.Clause$;
import sbt.internal.util.logic.Clauses;
import sbt.internal.util.logic.Clauses$;
import sbt.internal.util.logic.Formula;
import sbt.internal.util.logic.Formula$And$;
import sbt.internal.util.logic.Formula$True$;
import sbt.internal.util.logic.Literal;
import sbt.internal.util.logic.Logic;
import sbt.internal.util.logic.Logic$Atoms$;
import sbt.internal.util.logic.Logic$Matched$;
import sbt.internal.util.logic.Negated;
import sbt.internal.util.logic.Negated$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Logic$
implements Serializable {
    public static final Logic$Matched$ Matched;
    public static final Logic$Atoms$ Atoms;
    public static final Logic$ MODULE$;

    private Logic$() {
    }

    static {
        MODULE$ = new Logic$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Logic$.class);
    }

    public Either<Logic.LogicException, Logic.Matched> reduceAll(List<Clause> clauses, Set<Literal> initialFacts) {
        return this.reduce(Clauses$.MODULE$.apply(clauses), initialFacts);
    }

    public Either<Logic.LogicException, Logic.Matched> reduce(Clauses clauses, Set<Literal> initialFacts) {
        Tuple2<Seq<Atom>, Seq<Atom>> tuple2 = this.separate((Seq<Literal>)initialFacts.toSeq());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq posSeq = (Seq)tuple2._1();
        Seq negSeq = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)posSeq, (Object)negSeq);
        Seq posSeq2 = (Seq)tuple22._1();
        Seq negSeq2 = (Seq)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)posSeq2.toSet(), (Object)negSeq2.toSet());
        Set pos = (Set)tuple23._1();
        Set neg = (Set)tuple23._2();
        Option problem = this.checkContradictions((Set<Atom>)pos, (Set<Atom>)neg).orElse(() -> this.$anonfun$1(clauses, pos));
        return problem.toLeft(() -> this.reduce$$anonfun$1(clauses, initialFacts));
    }

    private Option<Logic.InitialOverlap> checkOverlap(Clauses clauses, Set<Atom> initialFacts) {
        Logic.Atoms as = this.atoms(clauses);
        Set initialOverlap = (Set)initialFacts.filter(as.inHead());
        if (initialOverlap.nonEmpty()) {
            return Some$.MODULE$.apply((Object)new Logic.InitialOverlap((Set<Atom>)initialOverlap));
        }
        return None$.MODULE$;
    }

    private Option<Logic.InitialContradictions> checkContradictions(Set<Atom> pos, Set<Atom> neg) {
        Set contradictions = (Set)pos.intersect(neg);
        if (contradictions.nonEmpty()) {
            return Some$.MODULE$.apply((Object)new Logic.InitialContradictions((Set<Atom>)contradictions));
        }
        return None$.MODULE$;
    }

    private Option<Logic.CyclicNegation> checkAcyclic(Clauses clauses) {
        Map<Atom, Set<Literal>> deps = this.dependencyMap(clauses);
        List cycle = Dag$.MODULE$.findNegativeCycle(this.graph(deps));
        if (cycle.nonEmpty()) {
            return Some$.MODULE$.apply((Object)new Logic.CyclicNegation((List<Literal>)cycle));
        }
        return None$.MODULE$;
    }

    private Dag.DirectedSignedGraph graph(Map<Atom, Set<Literal>> deps) {
        return new Dag.DirectedSignedGraph<Atom>(deps, this){
            private final Map deps$1;
            {
                this.deps$1 = deps$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public List nodes() {
                return this.deps$1.keys().toList();
            }

            public List dependencies(Atom a) {
                return ((IterableOnceOps)this.deps$1.getOrElse((Object)a, Logic$::sbt$internal$util$logic$Logic$$anon$1$$_$dependencies$$anonfun$1)).toList();
            }

            public boolean isNegative(Literal b) {
                Literal literal = b;
                if (literal instanceof Negated) {
                    Negated negated = Negated$.MODULE$.unapply((Negated)literal);
                    Atom atom = negated._1();
                    return true;
                }
                if (literal instanceof Atom) {
                    Atom atom = Atom$.MODULE$.unapply((Atom)literal);
                    String string = atom._1();
                    return false;
                }
                throw new MatchError((Object)literal);
            }

            public Atom head(Literal b) {
                return b.atom();
            }

            public String toString() {
                return this.nodes().flatMap((Function1 & Serializable)n -> (IterableOnce)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Atom[]{n}))).$plus$plus((IterableOnce)this.dependencies((Atom)n).map(arg_0 -> Logic$.sbt$internal$util$logic$Logic$$anon$1$$_$toString$$anonfun$1$$anonfun$1(n, arg_0)))).mkString("{\n", "\n", "\n}");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{sbt$internal$util$logic$Logic$$anon$1$$_$dependencies$$anonfun$1(), toString$$anonfun$1(sbt.internal.util.logic.Atom ), sbt$internal$util$logic$Logic$$anon$1$$_$toString$$anonfun$1$$anonfun$1(sbt.internal.util.logic.Atom sbt.internal.util.logic.Literal )}, serializedLambda);
            }
        };
    }

    private Map<Atom, Set<Literal>> dependencyMap(Clauses clauses) {
        return (Map)clauses.clauses().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Clause clause = (Clause)tuple2._2();
                Map m = (Map)tuple2._1();
                if (clause != null) {
                    Clause clause2 = Clause$.MODULE$.unapply(clause);
                    Formula formula = clause2._1();
                    Set<Atom> set = clause2._2();
                    Formula formula2 = formula;
                    Set<Atom> heads = set;
                    Set<Literal> deps = this.literals(formula2);
                    return (Map)heads.foldLeft((Object)m, (Function2 & Serializable)(n, head) -> (Map)n.updated(head, (Object)((SetOps)n.getOrElse(head, this::dependencyMap$$anonfun$1$$anonfun$1$$anonfun$1)).$plus$plus((IterableOnce)deps)));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Tuple2<Seq<Atom>, Seq<Atom>> separate(Seq<Literal> lits) {
        return Util$.MODULE$.separate(lits, (Function1 & Serializable)x$1 -> {
            Literal literal = x$1;
            if (literal instanceof Atom) {
                Atom a = (Atom)literal;
                return package$.MODULE$.Left().apply((Object)a);
            }
            if (literal instanceof Negated) {
                Atom atom;
                Negated negated = Negated$.MODULE$.unapply((Negated)literal);
                Atom n = atom = negated._1();
                return package$.MODULE$.Right().apply((Object)n);
            }
            throw new MatchError((Object)literal);
        });
    }

    private Tuple2<Set<Atom>, List<Clause>> findProven(Clauses c) {
        Tuple2 tuple2 = c.clauses().partition((Function1 & Serializable)_$2 -> {
            Formula formula = _$2.body();
            Formula$True$ formula$True$ = Formula$True$.MODULE$;
            return !(formula != null ? !formula.equals(formula$True$) : formula$True$ != null);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List proven = (List)tuple2._1();
        List unproven = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)proven, (Object)unproven);
        List proven2 = (List)tuple22._1();
        List unproven2 = (List)tuple22._2();
        return Tuple2$.MODULE$.apply((Object)proven2.flatMap((Function1 & Serializable)_$3 -> _$3.head()).toSet(), (Object)unproven2);
    }

    private Set<Atom> keepPositive(Set<Literal> lits) {
        return ((IterableOnceOps)lits.collect((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Literal x) {
                Literal literal = x;
                if (literal instanceof Atom) {
                    Atom a = (Atom)literal;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Literal x, Function1 function1) {
                Literal literal = x;
                if (literal instanceof Atom) {
                    Atom a = (Atom)literal;
                    return a;
                }
                return function1.apply((Object)x);
            }
        })).toSet();
    }

    private Logic.Matched reduce0(Clauses clauses, Set<Literal> factsToProcess, Logic.Matched state) {
        Option<Clauses> option;
        while (true) {
            if (None$.MODULE$.equals(option = this.applyAll(clauses, factsToProcess))) {
                return state;
            }
            if (!(option instanceof Some)) break;
            Clauses applied = (Clauses)((Some)option).value();
            Tuple2<Set<Atom>, List<Clause>> tuple2 = this.findProven(applied);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Set proven = (Set)tuple2._1();
            List unprovenClauses = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)proven, (Object)unprovenClauses);
            Set proven2 = (Set)tuple22._1();
            List unprovenClauses2 = (List)tuple22._2();
            Logic.Matched processedFacts = state.add(this.keepPositive(factsToProcess));
            Set newlyProven = (Set)proven2.$minus$minus(processedFacts.provenSet());
            Logic.Matched newState = processedFacts.add((Set<Atom>)newlyProven);
            if (unprovenClauses2.isEmpty()) {
                return newState;
            }
            Clauses unproven = Clauses$.MODULE$.apply((List<Clause>)unprovenClauses2);
            Set<Literal> nextFacts = newlyProven.nonEmpty() ? newlyProven.toSet() : this.inferFailure(unproven);
            Clauses clauses2 = unproven;
            Set<Literal> set = nextFacts;
            Logic.Matched matched = newState;
            clauses = clauses2;
            factsToProcess = set;
            state = matched;
        }
        throw new MatchError(option);
    }

    private Set<Literal> inferFailure(Clauses clauses) {
        Logic.Atoms allAtoms = this.atoms(clauses);
        Set<Literal> newFacts = this.negated(allAtoms.triviallyFalse());
        if (newFacts.nonEmpty()) {
            return newFacts;
        }
        List<Atom> possiblyTrue = this.hasNegatedDependency((Seq<Clause>)clauses.clauses(), (Relation<Atom, Atom>)Relation$.MODULE$.empty(), (Relation<Atom, Atom>)Relation$.MODULE$.empty());
        Set<Literal> newlyFalse = this.negated((Set<Atom>)((Set)allAtoms.inHead().$minus$minus(possiblyTrue)));
        if (newlyFalse.nonEmpty()) {
            return newlyFalse;
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(40).append("No progress:\n\tclauses: ").append(clauses).append("\n\tpossibly true: ").append(possiblyTrue).toString());
    }

    private Set<Literal> negated(Set<Atom> atoms) {
        return (Set)atoms.map((Function1 & Serializable)a -> Negated$.MODULE$.apply((Atom)a));
    }

    public List<Atom> hasNegatedDependency(Seq<Clause> clauses, Relation<Atom, Atom> posDeps, Relation<Atom, Atom> negDeps) {
        Seq seq;
        while ((seq = clauses) != null) {
            Tuple2 tuple2;
            Clause clause;
            SeqOps seqOps = package$.MODULE$.Seq().unapplySeq(seq);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                return Dag$.MODULE$.topologicalSortUnchecked((Iterable)negDeps._1s(), (Function1 & Serializable)_2 -> posDeps.reverse(_2));
            }
            Option option = package$.MODULE$.$plus$colon().unapply(seq);
            if (option.isEmpty() || (clause = (Clause)(tuple2 = (Tuple2)option.get())._1()) == null) break;
            Clause clause2 = Clause$.MODULE$.unapply(clause);
            Formula formula = clause2._1();
            Set<Atom> set = clause2._2();
            Formula formula2 = formula;
            Set<Atom> head = set;
            Seq tail = (Seq)tuple2._2();
            Tuple2<Seq<Atom>, Seq<Atom>> tuple22 = this.directDeps(formula2);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            Seq pos = (Seq)tuple22._1();
            Seq neg = (Seq)tuple22._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)pos, (Object)neg);
            Seq pos2 = (Seq)tuple23._1();
            Seq neg2 = (Seq)tuple23._2();
            Tuple2 tuple24 = (Tuple2)head.foldLeft((Object)Tuple2$.MODULE$.apply(posDeps, negDeps), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Relation pdeps = (Relation)tuple2._1();
                    Relation ndeps = (Relation)tuple2._2();
                    Atom d = (Atom)tuple22._2();
                    return Tuple2$.MODULE$.apply((Object)pdeps.$plus((Object)d, (Iterable)pos2), (Object)ndeps.$plus((Object)d, (Iterable)neg2));
                }
                throw new MatchError((Object)tuple22);
            });
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Relation newPos = (Relation)tuple24._1();
            Relation newNeg = (Relation)tuple24._2();
            Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)newPos, (Object)newNeg);
            Relation newPos2 = (Relation)tuple25._1();
            Relation newNeg2 = (Relation)tuple25._2();
            Seq seq2 = tail;
            Relation relation = newPos2;
            Relation relation2 = newNeg2;
            clauses = seq2;
            posDeps = relation;
            negDeps = relation2;
        }
        throw new MatchError(seq);
    }

    private Tuple2<Seq<Atom>, Seq<Atom>> directDeps(Formula formula) {
        return Util$.MODULE$.separate(this.literals(formula).toSeq(), (Function1 & Serializable)x$1 -> {
            Literal literal = x$1;
            if (literal instanceof Negated) {
                Atom atom;
                Negated negated = Negated$.MODULE$.unapply((Negated)literal);
                Atom a = atom = negated._1();
                return package$.MODULE$.Right().apply((Object)a);
            }
            if (literal instanceof Atom) {
                Atom a = (Atom)literal;
                return package$.MODULE$.Left().apply((Object)a);
            }
            throw new MatchError((Object)literal);
        });
    }

    private Set<Literal> literals(Formula formula) {
        Formula formula2 = formula;
        if (formula2 instanceof Formula.And) {
            Set<Literal> set;
            Formula.And and = Formula$And$.MODULE$.unapply((Formula.And)formula2);
            Set<Literal> lits = set = and._1();
            return lits;
        }
        if (formula2 instanceof Literal) {
            Literal l = (Literal)formula2;
            return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{l}));
        }
        if (Formula$True$.MODULE$.equals(formula2)) {
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError((Object)formula2);
    }

    public Logic.Atoms atoms(Clauses cs) {
        return (Logic.Atoms)cs.clauses().map((Function1 & Serializable)c -> Logic$Atoms$.MODULE$.apply(c.head(), this.atoms(c.body()))).reduce((Function2 & Serializable)(_$4, _$5) -> _$4.$plus$plus((Logic.Atoms)_$5));
    }

    public Set<Atom> atoms(Formula formula) {
        Formula formula2 = formula;
        if (formula2 instanceof Formula.And) {
            Set<Literal> set;
            Formula.And and = Formula$And$.MODULE$.unapply((Formula.And)formula2);
            Set<Literal> lits = set = and._1();
            return (Set)lits.map((Function1 & Serializable)_$6 -> _$6.atom());
        }
        if (formula2 instanceof Negated) {
            Atom atom;
            Negated negated = Negated$.MODULE$.unapply((Negated)formula2);
            Atom lit = atom = negated._1();
            return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Atom[]{lit}));
        }
        if (formula2 instanceof Atom) {
            Atom a = (Atom)formula2;
            return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Atom[]{a}));
        }
        if (Formula$True$.MODULE$.equals(formula2)) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Atom[0]));
        }
        throw new MatchError((Object)formula2);
    }

    public Option<Clauses> applyAll(Clauses cs, Set<Literal> facts) {
        List newClauses;
        List list = newClauses = facts.isEmpty() ? cs.clauses().filter((Function1 & Serializable)_$7 -> _$7.head().nonEmpty()) : cs.clauses().map((Function1 & Serializable)c -> this.applyAll((Clause)c, facts)).flatMap((Function1 & Serializable)_$8 -> _$8.toList());
        if (newClauses.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)Clauses$.MODULE$.apply((List<Clause>)newClauses));
    }

    public Option<Clause> applyAll(Clause c, Set<Literal> facts) {
        Set atoms = (Set)facts.map((Function1 & Serializable)_$9 -> _$9.atom());
        Set newHead = (Set)c.head().$minus$minus((IterableOnce)atoms);
        if (newHead.isEmpty()) {
            return None$.MODULE$;
        }
        return this.substitute(c.body(), facts).map((Function1 & Serializable)f -> Clause$.MODULE$.apply((Formula)f, (Set<Atom>)newHead));
    }

    public Option<Formula> substitute(Formula formula, Set<Literal> facts) {
        Formula formula2;
        while (true) {
            if ((formula2 = formula) instanceof Formula.And) {
                Formula.And and = Formula$And$.MODULE$.unapply((Formula.And)formula2);
                Set<Literal> set = and._1();
                Set<Literal> lits = set;
                if (lits.exists((Function1)this.negated$1(facts))) {
                    return None$.MODULE$;
                }
                Set newLits = (Set)lits.$minus$minus(facts);
                Formula$True$ newF = newLits.isEmpty() ? Formula$True$.MODULE$ : Formula$And$.MODULE$.apply((Set<Literal>)newLits);
                return Some$.MODULE$.apply((Object)newF);
            }
            if (Formula$True$.MODULE$.equals(formula2)) {
                return Some$.MODULE$.apply((Object)Formula$True$.MODULE$);
            }
            if (!(formula2 instanceof Literal)) break;
            Literal lit = (Literal)formula2;
            formula = Formula$And$.MODULE$.apply((Set<Literal>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{lit}))));
        }
        throw new MatchError((Object)formula2);
    }

    private final Option $anonfun$1(Clauses clauses$1, Set pos$1) {
        return this.checkOverlap(clauses$1, (Set<Atom>)pos$1);
    }

    private final Logic.Matched reduce$$anonfun$1(Clauses clauses$2, Set initialFacts$1) {
        return this.reduce0(clauses$2, (Set<Literal>)initialFacts$1, Logic$Matched$.MODULE$.empty());
    }

    public static final Set sbt$internal$util$logic$Logic$$anon$1$$_$dependencies$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    public static final /* synthetic */ String sbt$internal$util$logic$Logic$$anon$1$$_$toString$$anonfun$1$$anonfun$1(Atom n$1, Literal d) {
        return new StringBuilder(4).append(n$1).append(" -> ").append(d).toString();
    }

    private final Set dependencyMap$$anonfun$1$$anonfun$1$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private final Set negated$1(Set lits) {
        return (Set)lits.map((Function1 & Serializable)a -> a.unary_$bang());
    }
}

