/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util.logic;

import java.io.Serializable;
import sbt.internal.util.Relation;
import sbt.internal.util.logic.Atom;
import sbt.internal.util.logic.Clause;
import sbt.internal.util.logic.Clauses;
import sbt.internal.util.logic.Formula;
import sbt.internal.util.logic.Literal;
import sbt.internal.util.logic.Logic$;
import sbt.internal.util.logic.Logic$Atoms$;
import sbt.internal.util.logic.Logic$Matched$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Logic {
    public static Option<Clause> applyAll(Clause clause, Set<Literal> set) {
        return Logic$.MODULE$.applyAll(clause, set);
    }

    public static Option<Clauses> applyAll(Clauses clauses, Set<Literal> set) {
        return Logic$.MODULE$.applyAll(clauses, set);
    }

    public static Atoms atoms(Clauses clauses) {
        return Logic$.MODULE$.atoms(clauses);
    }

    public static Set<Atom> atoms(Formula formula) {
        return Logic$.MODULE$.atoms(formula);
    }

    public static List<Atom> hasNegatedDependency(Seq<Clause> seq, Relation<Atom, Atom> relation, Relation<Atom, Atom> relation2) {
        return Logic$.MODULE$.hasNegatedDependency(seq, relation, relation2);
    }

    public static Either<LogicException, Matched> reduce(Clauses clauses, Set<Literal> set) {
        return Logic$.MODULE$.reduce(clauses, set);
    }

    public static Either<LogicException, Matched> reduceAll(List<Clause> list, Set<Literal> set) {
        return Logic$.MODULE$.reduceAll(list, set);
    }

    public static Option<Formula> substitute(Formula formula, Set<Literal> set) {
        return Logic$.MODULE$.substitute(formula, set);
    }

    public static final class Atoms
    implements Product,
    Serializable {
        private final Set inHead;
        private final Set inFormula;

        public static Atoms apply(Set<Atom> set, Set<Atom> set2) {
            return Logic$Atoms$.MODULE$.apply(set, set2);
        }

        public static Atoms fromProduct(Product product) {
            return Logic$Atoms$.MODULE$.fromProduct(product);
        }

        public static Atoms unapply(Atoms atoms) {
            return Logic$Atoms$.MODULE$.unapply(atoms);
        }

        public Atoms(Set<Atom> inHead, Set<Atom> inFormula) {
            this.inHead = inHead;
            this.inFormula = inFormula;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Atoms)) return false;
            Atoms atoms = (Atoms)object;
            Set<Atom> set = this.inHead();
            Set<Atom> set2 = atoms.inHead();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<Atom> set3 = this.inFormula();
            Set<Atom> set4 = atoms.inFormula();
            if (set3 == null) {
                if (set4 == null) return true;
                return false;
            } else {
                if (!set3.equals(set4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Atoms;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Atoms";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "inHead";
            }
            if (1 == n2) {
                return "inFormula";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<Atom> inHead() {
            return this.inHead;
        }

        public Set<Atom> inFormula() {
            return this.inFormula;
        }

        public Atoms $plus$plus(Atoms as) {
            return Logic$Atoms$.MODULE$.apply((Set<Atom>)((Set)this.inHead().$plus$plus(as.inHead())), (Set<Atom>)((Set)this.inFormula().$plus$plus(as.inFormula())));
        }

        public Set<Atom> triviallyFalse() {
            return (Set)this.inFormula().$minus$minus(this.inHead());
        }

        public Atoms copy(Set<Atom> inHead, Set<Atom> inFormula) {
            return new Atoms(inHead, inFormula);
        }

        public Set<Atom> copy$default$1() {
            return this.inHead();
        }

        public Set<Atom> copy$default$2() {
            return this.inFormula();
        }

        public Set<Atom> _1() {
            return this.inHead();
        }

        public Set<Atom> _2() {
            return this.inFormula();
        }
    }

    public static final class CyclicNegation
    extends LogicException {
        private final List cycle;

        public CyclicNegation(List<Literal> cycle) {
            this.cycle = cycle;
            super(new StringBuilder(42).append("Negation may not be involved in a cycle:\n\t").append(cycle.mkString("\n\t")).toString());
        }

        public List<Literal> cycle() {
            return this.cycle;
        }
    }

    public static final class InitialContradictions
    extends LogicException {
        private final Set literals;

        public InitialContradictions(Set<Atom> literals) {
            this.literals = literals;
            super(new StringBuilder(46).append("Initial facts cannot be both true and false:\n\t").append(literals.mkString("\n\t")).toString());
        }

        public Set<Atom> literals() {
            return this.literals;
        }
    }

    public static final class InitialOverlap
    extends LogicException {
        private final Set literals;

        public InitialOverlap(Set<Atom> literals) {
            this.literals = literals;
            super(new StringBuilder(58).append("Initial positive facts cannot be implied by any clauses:\n\t").append(literals.mkString("\n\t")).toString());
        }

        public Set<Atom> literals() {
            return this.literals;
        }
    }

    public static abstract class LogicException {
        private final String toString;

        public LogicException(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }

    public static final class Matched {
        private final Set provenSet;
        private final List<Atom> reverseOrdered;

        public static Matched empty() {
            return Logic$Matched$.MODULE$.empty();
        }

        public Matched(Set<Atom> provenSet, List<Atom> reverseOrdered) {
            this.provenSet = provenSet;
            this.reverseOrdered = reverseOrdered;
        }

        public Set<Atom> provenSet() {
            return this.provenSet;
        }

        public Matched add(Set<Atom> atoms) {
            return this.add((List<Atom>)atoms.toList());
        }

        public Matched add(List<Atom> atoms) {
            List newOnly = atoms.filterNot(this.provenSet());
            return new Matched((Set<Atom>)((Set)this.provenSet().$plus$plus((IterableOnce)newOnly.toSet())), (List<Atom>)this.reverseOrdered.$colon$colon$colon(newOnly));
        }

        public List<Atom> ordered() {
            return this.reverseOrdered.reverse();
        }

        public String toString() {
            return this.ordered().map((Function1 & Serializable)_$1 -> _$1.label()).mkString("Matched(", ",", ")");
        }
    }
}

