/*
 * Decompiled with CFR 0.152.
 */
package sbt.protocol;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import sbt.internal.protocol.JsonRpcMessage;
import sbt.internal.protocol.JsonRpcNotificationMessage;
import sbt.internal.protocol.JsonRpcRequestMessage;
import sbt.internal.protocol.JsonRpcResponseMessage;
import sbt.internal.protocol.codec.JsonRPCProtocol$;
import sbt.internal.util.StringEvent;
import sbt.protocol.Attach;
import sbt.protocol.CommandMessage;
import sbt.protocol.EventMessage;
import sbt.protocol.ExecCommand;
import sbt.protocol.InitCommand;
import sbt.protocol.SettingQuery;
import sbt.protocol.codec.JsonProtocol$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import sjsonnew.BasicJsonProtocol$;
import sjsonnew.JsonFormat;
import sjsonnew.JsonReader;
import sjsonnew.JsonWriter;
import sjsonnew.shaded.scalajson.ast.unsafe.JField;
import sjsonnew.shaded.scalajson.ast.unsafe.JObject;
import sjsonnew.shaded.scalajson.ast.unsafe.JString;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;
import sjsonnew.support.scalajson.unsafe.Converter$;
import sjsonnew.support.scalajson.unsafe.Parser$;

public final class Serialization$ {
    public static Serialization$ MODULE$;
    private final String VsCode;
    private final String readSystemIn;
    private final String cancelReadSystemIn;
    private final String systemIn;
    private final String systemOut;
    private final String systemErr;
    private final String systemOutFlush;
    private final String systemErrFlush;
    private final String terminalPropertiesQuery;
    private final String terminalPropertiesResponse;
    private final String terminalCapabilities;
    private final String terminalCapabilitiesResponse;
    private final String attach;
    private final String attachResponse;
    private final String cancelRequest;
    private final String promptChannel;
    private final String setTerminalAttributes;
    private final String getTerminalAttributes;
    private final String terminalGetSize;
    private final String terminalSetSize;
    private final String terminalSetEcho;
    private final String terminalSetRawMode;
    private final String CancelAll;

    static {
        new Serialization$();
    }

    public String VsCode() {
        return this.VsCode;
    }

    public String readSystemIn() {
        return this.readSystemIn;
    }

    public String cancelReadSystemIn() {
        return this.cancelReadSystemIn;
    }

    public String systemIn() {
        return this.systemIn;
    }

    public String systemOut() {
        return this.systemOut;
    }

    public String systemErr() {
        return this.systemErr;
    }

    public String systemOutFlush() {
        return this.systemOutFlush;
    }

    public String systemErrFlush() {
        return this.systemErrFlush;
    }

    public String terminalPropertiesQuery() {
        return this.terminalPropertiesQuery;
    }

    public String terminalPropertiesResponse() {
        return this.terminalPropertiesResponse;
    }

    public String terminalCapabilities() {
        return this.terminalCapabilities;
    }

    public String terminalCapabilitiesResponse() {
        return this.terminalCapabilitiesResponse;
    }

    public String attach() {
        return this.attach;
    }

    public String attachResponse() {
        return this.attachResponse;
    }

    public String cancelRequest() {
        return this.cancelRequest;
    }

    public String promptChannel() {
        return this.promptChannel;
    }

    public String setTerminalAttributes() {
        return this.setTerminalAttributes;
    }

    public String getTerminalAttributes() {
        return this.getTerminalAttributes;
    }

    public String terminalGetSize() {
        return this.terminalGetSize;
    }

    public String terminalSetSize() {
        return this.terminalSetSize;
    }

    public String terminalSetEcho() {
        return this.terminalSetEcho;
    }

    public String terminalSetRawMode() {
        return this.terminalSetRawMode;
    }

    public String CancelAll() {
        return this.CancelAll;
    }

    public <A> byte[] serializeEvent(A event, JsonFormat<A> evidence$1) {
        JValue json = (JValue)Converter$.MODULE$.toJson(event, evidence$1).get();
        return CompactPrinter$.MODULE$.apply(json).getBytes("UTF-8");
    }

    public byte[] serializeCommand(CommandMessage command) {
        JValue json = (JValue)Converter$.MODULE$.toJson((Object)command, JsonProtocol$.MODULE$.CommandMessageFormat()).get();
        return CompactPrinter$.MODULE$.apply(json).getBytes("UTF-8");
    }

    public String serializeCommandAsJsonMessage(CommandMessage command) {
        String string;
        CommandMessage commandMessage = command;
        if (commandMessage instanceof InitCommand) {
            String string2;
            InitCommand initCommand = (InitCommand)commandMessage;
            String execId = (String)initCommand.execId().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString());
            String analysis = new StringBuilder(17).append("\"skipAnalysis\" : ").append(initCommand.skipAnalysis().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)).toString();
            Option<String> option = initCommand.token();
            if (option instanceof Some) {
                Some some = (Some)option;
                String t = (String)some.value();
                JValue json = (JValue)Converter$.MODULE$.toJson((Object)t, (JsonWriter)BasicJsonProtocol$.MODULE$.StringJsonFormat()).get();
                String v = CompactPrinter$.MODULE$.apply(json);
                string2 = new StringBuilder(15).append("{ \"token\": ").append(v).append(", ").append(analysis).append(" }").toString();
            } else if (None$.MODULE$.equals(option)) {
                string2 = new StringBuilder(4).append("{ ").append(analysis).append(" }").toString();
            } else {
                throw new MatchError(option);
            }
            String opt = string2;
            string = new StringBuilder(95).append("{ \"jsonrpc\": \"2.0\", \"id\": \"").append(execId).append("\", \"method\": \"initialize\", \"params\": { \"initializationOptions\": ").append(opt).append(" } }").toString();
        } else if (commandMessage instanceof ExecCommand) {
            ExecCommand execCommand = (ExecCommand)commandMessage;
            String execId = (String)execCommand.execId().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString());
            JValue json = (JValue)Converter$.MODULE$.toJson((Object)execCommand.commandLine(), (JsonWriter)BasicJsonProtocol$.MODULE$.StringJsonFormat()).get();
            String v = CompactPrinter$.MODULE$.apply(json);
            string = new StringBuilder(83).append("{ \"jsonrpc\": \"2.0\", \"id\": \"").append(execId).append("\", \"method\": \"sbt/exec\", \"params\": { \"commandLine\": ").append(v).append(" } }").toString();
        } else if (commandMessage instanceof SettingQuery) {
            SettingQuery settingQuery = (SettingQuery)commandMessage;
            String execId = UUID.randomUUID().toString();
            JValue json = (JValue)Converter$.MODULE$.toJson((Object)settingQuery.setting(), (JsonWriter)BasicJsonProtocol$.MODULE$.StringJsonFormat()).get();
            String v = CompactPrinter$.MODULE$.apply(json);
            string = new StringBuilder(82).append("{ \"jsonrpc\": \"2.0\", \"id\": \"").append(execId).append("\", \"method\": \"sbt/setting\", \"params\": { \"setting\": ").append(v).append(" } }").toString();
        } else if (commandMessage instanceof Attach) {
            Attach attach = (Attach)commandMessage;
            String execId = UUID.randomUUID().toString();
            JValue json = (JValue)Converter$.MODULE$.toJson((Object)BoxesRunTime.boxToBoolean((boolean)attach.interactive()), (JsonWriter)BasicJsonProtocol$.MODULE$.BooleanJsonFormat()).get();
            String v = CompactPrinter$.MODULE$.apply(json);
            string = new StringBuilder(75).append("{ \"jsonrpc\": \"2.0\", \"id\": \"").append(execId).append("\", \"method\": \"").append(this.attach()).append("\", \"params\": { \"interactive\": ").append(v).append(" } }").toString();
        } else {
            throw new MatchError((Object)commandMessage);
        }
        return string;
    }

    public byte[] serializeEventMessage(EventMessage event) {
        JValue json = (JValue)Converter$.MODULE$.toJson((Object)event, JsonProtocol$.MODULE$.EventMessageFormat()).get();
        return CompactPrinter$.MODULE$.apply(json).getBytes("UTF-8");
    }

    public byte[] serializeResponseMessage(JsonRpcResponseMessage message) {
        return this.serializeResponse((Object)message, (JsonWriter)JsonRPCProtocol$.MODULE$.JsonRpcResponseMessageFormat());
    }

    public byte[] serializeRequestMessage(JsonRpcRequestMessage message) {
        return this.serializeResponse((Object)message, (JsonWriter)JsonRPCProtocol$.MODULE$.JsonRpcRequestMessageFormat());
    }

    public byte[] serializeNotificationMessage(JsonRpcNotificationMessage message) {
        return this.serializeResponse((Object)message, (JsonWriter)JsonRPCProtocol$.MODULE$.JsonRpcNotificationMessageFormat());
    }

    public <A> byte[] serializeResponse(A message, JsonWriter<A> evidence$2) {
        JValue json = (JValue)Converter$.MODULE$.toJson(message, evidence$2).get();
        String body = CompactPrinter$.MODULE$.apply(json);
        int bodyLength = body.getBytes("UTF-8").length;
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append("Content-Length: ").append(bodyLength).toString(), new StringBuilder(14).append("Content-Type: ").append(this.VsCode()).toString(), "", body})).mkString("\r\n").getBytes("UTF-8");
    }

    public Either<String, CommandMessage> deserializeCommand(Seq<Object> bytes) {
        Left left;
        ByteBuffer buffer = ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()));
        Try try_ = Parser$.MODULE$.parseFromByteBuffer(buffer);
        if (try_ instanceof Success) {
            Right right;
            Success success = (Success)try_;
            JValue json = (JValue)success.value();
            Try try_2 = Converter$.MODULE$.fromJson((Object)json, JsonProtocol$.MODULE$.CommandMessageFormat());
            if (try_2 instanceof Success) {
                Success success2 = (Success)try_2;
                CommandMessage command = (CommandMessage)success2.value();
                right = package$.MODULE$.Right().apply((Object)command);
            } else if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable e = failure.exception();
                right = package$.MODULE$.Left().apply((Object)e.getMessage());
            } else {
                throw new MatchError((Object)try_2);
            }
            left = right;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(13).append("Parse error: ").append(e.getMessage()).toString());
        } else {
            throw new MatchError((Object)try_);
        }
        return left;
    }

    public Either<String, Object> deserializeEvent(Seq<Object> bytes) {
        Left left;
        ByteBuffer buffer = ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()));
        Try try_ = Parser$.MODULE$.parseFromByteBuffer(buffer);
        if (try_ instanceof Success) {
            Right right;
            Some some;
            String string;
            Success success = (Success)try_;
            JValue json = (JValue)success.value();
            Option<String> option = this.detectType(json);
            if (option instanceof Some && "StringEvent".equals(string = (String)(some = (Some)option).value())) {
                Right right2;
                Try try_2 = Converter$.MODULE$.fromJson((Object)json, (JsonReader)sbt.internal.util.codec.JsonProtocol$.MODULE$.StringEventFormat());
                if (try_2 instanceof Success) {
                    Success success2 = (Success)try_2;
                    StringEvent event = (StringEvent)success2.value();
                    right2 = package$.MODULE$.Right().apply((Object)event);
                } else if (try_2 instanceof Failure) {
                    Failure failure = (Failure)try_2;
                    Throwable e = failure.exception();
                    right2 = package$.MODULE$.Left().apply((Object)e.getMessage());
                } else {
                    throw new MatchError((Object)try_2);
                }
                right = right2;
            } else {
                Right right3;
                Try try_3 = Converter$.MODULE$.fromJson((Object)json, JsonProtocol$.MODULE$.EventMessageFormat());
                if (try_3 instanceof Success) {
                    Success success3 = (Success)try_3;
                    EventMessage event = (EventMessage)success3.value();
                    right3 = package$.MODULE$.Right().apply((Object)event);
                } else if (try_3 instanceof Failure) {
                    Failure failure = (Failure)try_3;
                    Throwable e = failure.exception();
                    right3 = package$.MODULE$.Left().apply((Object)e.getMessage());
                } else {
                    throw new MatchError((Object)try_3);
                }
                right = right3;
            }
            left = right;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(13).append("Parse error: ").append(e.getMessage()).toString());
        } else {
            throw new MatchError((Object)try_);
        }
        return left;
    }

    public Option<String> detectType(JValue json) {
        None$ none$;
        JValue jValue = json;
        if (jValue instanceof JObject) {
            None$ none$2;
            Some some;
            JValue jValue2;
            JObject jObject = (JObject)jValue;
            JField[] fields = jObject.value();
            Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization$.$anonfun$detectType$1(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value());
            if (option instanceof Some && (jValue2 = (JValue)(some = (Some)option).value()) instanceof JString) {
                JString jString = (JString)jValue2;
                String value = jString.value();
                none$2 = new Some((Object)value);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Either<String, EventMessage> deserializeEventMessage(Seq<Object> bytes) {
        Left left;
        ByteBuffer buffer = ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()));
        Try try_ = Parser$.MODULE$.parseFromByteBuffer(buffer);
        if (try_ instanceof Success) {
            Right right;
            Success success = (Success)try_;
            JValue json = (JValue)success.value();
            Try try_2 = Converter$.MODULE$.fromJson((Object)json, JsonProtocol$.MODULE$.EventMessageFormat());
            if (try_2 instanceof Success) {
                Success success2 = (Success)try_2;
                EventMessage event = (EventMessage)success2.value();
                right = package$.MODULE$.Right().apply((Object)event);
            } else if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable e = failure.exception();
                right = package$.MODULE$.Left().apply((Object)e.getMessage());
            } else {
                throw new MatchError((Object)try_2);
            }
            left = right;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(13).append("Parse error: ").append(e.getMessage()).toString());
        } else {
            throw new MatchError((Object)try_);
        }
        return left;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, JsonRpcMessage> deserializeJsonMessage(Seq<Object> bytes) {
        ByteBuffer buffer = ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()));
        boolean bl = false;
        Success success = null;
        Try try_ = Parser$.MODULE$.parseFromByteBuffer(buffer);
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            JValue json = (JValue)success.value();
            if (json instanceof JObject) {
                Left left;
                JObject jObject = (JObject)json;
                JField[] fields = jObject.value();
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Serialization$.$anonfun$deserializeJsonMessage$1(x$3))).isDefined()) {
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization$.$anonfun$deserializeJsonMessage$2(x$4))).isDefined()) {
                        Right right;
                        Try try_2 = Converter$.MODULE$.fromJson((Object)jObject, JsonRPCProtocol$.MODULE$.JsonRpcRequestMessageFormat());
                        if (try_2 instanceof Success) {
                            Success success2 = (Success)try_2;
                            JsonRpcRequestMessage request = (JsonRpcRequestMessage)success2.value();
                            right = package$.MODULE$.Right().apply((Object)request);
                        } else {
                            if (!(try_2 instanceof Failure)) throw new MatchError((Object)try_2);
                            Failure failure = (Failure)try_2;
                            Throwable e = failure.exception();
                            right = package$.MODULE$.Left().apply((Object)new StringBuilder(18).append("conversion error: ").append(e.getMessage()).toString());
                        }
                        left = right;
                        return left;
                    } else {
                        Right right;
                        Try try_3 = Converter$.MODULE$.fromJson((Object)jObject, JsonRPCProtocol$.MODULE$.JsonRpcNotificationMessageFormat());
                        if (try_3 instanceof Success) {
                            Success success3 = (Success)try_3;
                            JsonRpcNotificationMessage notification = (JsonRpcNotificationMessage)success3.value();
                            right = package$.MODULE$.Right().apply((Object)notification);
                        } else {
                            if (!(try_3 instanceof Failure)) throw new MatchError((Object)try_3);
                            Failure failure = (Failure)try_3;
                            Throwable e = failure.exception();
                            right = package$.MODULE$.Left().apply((Object)new StringBuilder(18).append("conversion error: ").append(e.getMessage()).toString());
                        }
                        left = right;
                    }
                    return left;
                } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Serialization$.$anonfun$deserializeJsonMessage$3(x$5))).isDefined()) {
                    Right right;
                    Try try_4 = Converter$.MODULE$.fromJson((Object)jObject, JsonRPCProtocol$.MODULE$.JsonRpcResponseMessageFormat());
                    if (try_4 instanceof Success) {
                        Success success4 = (Success)try_4;
                        JsonRpcResponseMessage res = (JsonRpcResponseMessage)success4.value();
                        right = package$.MODULE$.Right().apply((Object)res);
                    } else {
                        if (!(try_4 instanceof Failure)) throw new MatchError((Object)try_4);
                        Failure failure = (Failure)try_4;
                        Throwable e = failure.exception();
                        right = package$.MODULE$.Left().apply((Object)new StringBuilder(18).append("conversion error: ").append(e.getMessage()).toString());
                    }
                    left = right;
                    return left;
                } else {
                    left = package$.MODULE$.Left().apply((Object)new StringBuilder(35).append("expected JSON-RPC object but found ").append(new String((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()), "UTF-8")).toString());
                }
                return left;
            }
        }
        if (bl) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(31).append("expected JSON object but found ").append(new String((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()), "UTF-8")).toString());
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable e = failure.exception();
        return package$.MODULE$.Left().apply((Object)new StringBuilder(13).append("parse error: ").append(e.getMessage()).toString());
    }

    public String compactPrintJsonOpt(Option<JValue> jsonOpt) {
        String string;
        Option<JValue> option = jsonOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            JValue x = (JValue)some.value();
            string = CompactPrinter$.MODULE$.apply(x);
        } else {
            string = "";
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$detectType$1(JField x$1) {
        String string = x$1.field();
        String string2 = "type";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deserializeJsonMessage$1(JField x$3) {
        String string = x$3.field();
        String string2 = "method";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deserializeJsonMessage$2(JField x$4) {
        String string = x$4.field();
        String string2 = "id";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deserializeJsonMessage$3(JField x$5) {
        String string = x$5.field();
        String string2 = "id";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Serialization$() {
        MODULE$ = this;
        this.VsCode = "application/vscode-jsonrpc; charset=utf-8";
        this.readSystemIn = "sbt/readSystemIn";
        this.cancelReadSystemIn = "sbt/cancelReadSystemIn";
        this.systemIn = "sbt/systemIn";
        this.systemOut = "sbt/systemOut";
        this.systemErr = "sbt/systemErr";
        this.systemOutFlush = "sbt/systemOutFlush";
        this.systemErrFlush = "sbt/systemErrFlush";
        this.terminalPropertiesQuery = "sbt/terminalPropertiesQuery";
        this.terminalPropertiesResponse = "sbt/terminalPropertiesResponse";
        this.terminalCapabilities = "sbt/terminalCapabilities";
        this.terminalCapabilitiesResponse = "sbt/terminalCapabilitiesResponse";
        this.attach = "sbt/attach";
        this.attachResponse = "sbt/attachResponse";
        this.cancelRequest = "sbt/cancelRequest";
        this.promptChannel = "sbt/promptChannel";
        this.setTerminalAttributes = "sbt/setTerminalAttributes";
        this.getTerminalAttributes = "sbt/getTerminalAttributes";
        this.terminalGetSize = "sbt/terminalGetSize";
        this.terminalSetSize = "sbt/terminalSetSize";
        this.terminalSetEcho = "sbt/terminalSetEcho";
        this.terminalSetRawMode = "sbt/terminalSetRawMode";
        this.CancelAll = "__CancelAll";
    }
}

