/*
 * Decompiled with CFR 0.152.
 */
package sbt.scriptedtest;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import sbt.internal.scripted.ScriptRunner;
import sbt.internal.scripted.Statement;
import sbt.internal.scripted.StatementHandler;
import sbt.internal.scripted.TestException;
import sbt.internal.scripted.TestFailed;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005=qA\u0002\b\u0010\u0011\u0003\t2C\u0002\u0004\u0016\u001f!\u0005\u0011C\u0006\u0005\u0006;\u0005!\taH\u0003\u0005A\u0005\u0001\u0011EB\u0003\u0016\u001f\u0001\tB\u0007C\u0003\u001e\t\u0011\u0005\u0001\t\u0003\u0004C\t\u0001\u0006Ia\u0011\u0005\u0006\u0017\u0012!\t\u0001\u0014\u0005\u0006Q\u0012!\t!\u001b\u0005\u0006a\u0012!\t!\u001d\u0005\bi\u0012\u0011\r\u0011\"\u0003v\u0011\u0019iH\u0001)A\u0005m\")a\u0010\u0002C\u0001\u007f\"9\u00111\u0002\u0003\u0005B\u00055\u0011!\u0005\"bi\u000eD7k\u0019:jaR\u0014VO\u001c8fe*\u0011\u0001#E\u0001\rg\u000e\u0014\u0018\u000e\u001d;fIR,7\u000f\u001e\u0006\u0002%\u0005\u00191O\u0019;\u0011\u0005Q\tQ\"A\b\u0003#\t\u000bGo\u00195TGJL\u0007\u000f\u001e*v]:,'o\u0005\u0002\u0002/A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002'\t11\u000b^1uKN\u0004BAI\u0014*c5\t1E\u0003\u0002%K\u00059Q.\u001e;bE2,'B\u0001\u0014\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Q\r\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002+_5\t1F\u0003\u0002-[\u0005A1o\u0019:jaR,GM\u0003\u0002/#\u0005A\u0011N\u001c;fe:\fG.\u0003\u00021W\t\u00012\u000b^1uK6,g\u000e\u001e%b]\u0012dWM\u001d\t\u0003SIJ!aM\u0018\u0003\u000bM#\u0018\r^3\u0014\u0007\u0011)\u0004\b\u0005\u0002+m%\u0011qg\u000b\u0002\r'\u000e\u0014\u0018\u000e\u001d;Sk:tWM\u001d\t\u0003syj\u0011A\u000f\u0006\u0003wq\nA\u0001\\1oO*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u00055\tU\u000f^8DY>\u001cX-\u00192mKR\t\u0011\t\u0005\u0002\u0015\t\u000591/\u001a:wS\u000e,\u0007C\u0001#J\u001b\u0005)%B\u0001$H\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0011r\nA!\u001e;jY&\u0011!*\u0012\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006)\u0011\r\u001d9msR\u0019Q\n\u00153\u0011\u0005aq\u0015BA(\u001a\u0005\u0011)f.\u001b;\t\u000bE;\u0001\u0019\u0001*\u0002\u0015M$\u0018\r^3nK:$8\u000fE\u0002T7zs!\u0001V-\u000f\u0005UCV\"\u0001,\u000b\u0005]s\u0012A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tQ\u0016$A\u0004qC\u000e\\\u0017mZ3\n\u0005qk&\u0001\u0002'jgRT!AW\r\u0011\tay\u0016&Y\u0005\u0003Af\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0016c\u0013\t\u00197FA\u0005Ti\u0006$X-\\3oi\")Qm\u0002a\u0001M\u000611\u000f^1uKN\u0004\"aZ\u0002\u000f\u0005Q\u0001\u0011AC5oSR\u001cF/\u0019;fgR\u0019QJ[6\t\u000b\u0015D\u0001\u0019\u00014\t\u000b1D\u0001\u0019A7\u0002\u0011!\fg\u000e\u001a7feN\u00042a\u00158*\u0013\tyWLA\u0002TKF\fqb\u00197fC:,\u0006\u000fS1oI2,'o\u001d\u000b\u0004\u001bJ\u001c\b\"\u00027\n\u0001\u0004i\u0007\"B3\n\u0001\u00041\u0017a\u0002;j[\u0016|W\u000f^\u000b\u0002mB\u0011qo_\u0007\u0002q*\u0011\u0011P_\u0001\tIV\u0014\u0018\r^5p]*\u0011a)G\u0005\u0003yb\u0014aBR5oSR,G)\u001e:bi&|g.\u0001\u0005uS6,w.\u001e;!\u0003A\u0001(o\\2fgN\u001cF/\u0019;f[\u0016tG\u000fF\u0004N\u0003\u0003\t)!!\u0003\t\r\u0005\rA\u00021\u0001*\u0003\u001dA\u0017M\u001c3mKJDa!a\u0002\r\u0001\u0004\t\u0017!C:uCR,W.\u001a8u\u0011\u0015)G\u00021\u0001g\u0003\u0015\u0019Gn\\:f)\u0005i\u0005")
public class BatchScriptRunner
extends ScriptRunner
implements AutoCloseable {
    private final ExecutorService service = Executors.newCachedThreadPool();
    private final FiniteDuration timeout = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).minutes();

    public void apply(List<Tuple2<StatementHandler, Statement>> statements, HashMap<StatementHandler, Object> states) {
        if (states.isEmpty()) {
            super.apply(statements);
        } else {
            statements.foreach((Function1 & Serializable & scala.Serializable)st -> {
                this.processStatement((StatementHandler)st._1(), (Statement)st._2(), (HashMap<StatementHandler, Object>)states);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void initStates(HashMap<StatementHandler, Object> states, Seq<StatementHandler> handlers) {
        handlers.foreach((Function1 & Serializable & scala.Serializable)handler -> {
            states.update((Object)handler, handler.initialState());
            return BoxedUnit.UNIT;
        });
    }

    public void cleanUpHandlers(Seq<StatementHandler> handlers, HashMap<StatementHandler, Object> states) {
        handlers.foreach((Function1 & Serializable & scala.Serializable)handler -> {
            BatchScriptRunner.$anonfun$cleanUpHandlers$1(states, handler);
            return BoxedUnit.UNIT;
        });
    }

    private FiniteDuration timeout() {
        return this.timeout;
    }

    public void processStatement(StatementHandler handler, Statement statement, HashMap<StatementHandler, Object> states) {
        block7: {
            Object state = states.apply((Object)handler);
            Future<Either> nextStateFuture = this.service.submit(() -> {
                Left left;
                try {
                    left = package$.MODULE$.Right().apply(handler.apply(statement.command(), statement.arguments(), state));
                }
                catch (Exception e) {
                    left = package$.MODULE$.Left().apply((Object)e);
                }
                return left;
            });
            try {
                Either either = nextStateFuture.get(this.timeout().toMillis(), TimeUnit.MILLISECONDS);
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Exception err = (Exception)left.value();
                    if (statement.successExpected()) {
                        Exception exception = err;
                        if (exception instanceof TestFailed) {
                            TestFailed testFailed = (TestFailed)exception;
                            throw new TestException(statement, new StringBuilder(16).append("Command failed: ").append(testFailed.getMessage()).toString(), null);
                        }
                        throw new TestException(statement, "Command failed", (Throwable)err);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Object s = right.value();
                    if (!statement.successExpected()) {
                        throw new TestException(statement, "Command succeeded but failure was expected", null);
                    }
                    states.update((Object)handler, s);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                throw new MatchError((Object)either);
            }
            catch (TimeoutException e) {
                throw new TestException(statement, "Command timed out", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.service.shutdown();
    }

    public static final /* synthetic */ void $anonfun$cleanUpHandlers$2(StatementHandler handler$1, Object state) {
        try {
            handler$1.finish(state);
        }
        catch (Exception exception) {}
    }

    public static final /* synthetic */ void $anonfun$cleanUpHandlers$1(HashMap states$3, StatementHandler handler) {
        states$3.get((Object)handler).foreach((Function1 & Serializable & scala.Serializable)state -> {
            BatchScriptRunner.$anonfun$cleanUpHandlers$2(handler, state);
            return BoxedUnit.UNIT;
        });
    }
}

