/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import sbt.internal.util.InputStreamWrapper;
import sbt.internal.util.Signals$;
import sbt.internal.util.SimpleReader;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;

public final class JLine$ {
    public static final JLine$ MODULE$;
    private final String TerminalProperty;
    private final FileInputStream originalIn;
    private final int MaxHistorySize;
    private final boolean HandleCONT;

    static {
        new JLine$();
    }

    public void fixTerminalProperty() {
        String string2 = System.getProperty(this.TerminalProperty);
        String string3 = "jline.UnixTerminal".equals(string2) ? "unix" : (string2 == null && System.getProperty("sbt.cygwin") != null ? "unix" : ("jline.WindowsTerminal".equals(string2) ? "windows" : ("jline.AnsiWindowsTerminal".equals(string2) ? "windows" : ("jline.UnsupportedTerminal".equals(string2) ? "none" : string2))));
        String newValue = string3;
        Object object = newValue == null ? BoxedUnit.UNIT : System.setProperty(this.TerminalProperty, newValue);
    }

    public FileInputStream originalIn() {
        return this.originalIn;
    }

    public InputStream makeInputStream(boolean injectThreadSleep) {
        return injectThreadSleep ? new InputStreamWrapper(this.originalIn(), Duration$.MODULE$.apply("50 ms")) : this.originalIn();
    }

    public Terminal sbt$internal$util$JLine$$terminal() {
        return TerminalFactory.get();
    }

    private synchronized <T> T withTerminal(Function1<Terminal, T> f) {
        Terminal t;
        Terminal terminal = t = this.sbt$internal$util$JLine$$terminal();
        synchronized (terminal) {
            Object object = f.apply((Object)t);
            return (T)object;
        }
    }

    public <T> T usingTerminal(Function1<Terminal, T> f) {
        return this.withTerminal((Function1<Terminal, T>)new Serializable(f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;

            public final T apply(Terminal t) {
                t.restore();
                return (T)this.f$1.apply((Object)t);
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public ConsoleReader createReader() {
        return this.createReader((Option<File>)None$.MODULE$, this.makeInputStream(true));
    }

    public ConsoleReader createReader(Option<File> historyPath, InputStream in) {
        return (ConsoleReader)this.usingTerminal((Function1)new Serializable(historyPath, in){
            public static final long serialVersionUID = 0L;
            private final Option historyPath$1;
            private final InputStream in$1;

            /*
             * WARNING - void declaration
             */
            public final ConsoleReader apply(Terminal t) {
                Option option;
                block4: {
                    void var2_2;
                    MemoryHistory memoryHistory;
                    ConsoleReader cr;
                    block3: {
                        block2: {
                            cr = new ConsoleReader(this.in$1, (OutputStream)System.out);
                            cr.setExpandEvents(false);
                            cr.setBellEnabled(false);
                            option = this.historyPath$1;
                            if (!None$.MODULE$.equals(option)) break block2;
                            memoryHistory = new MemoryHistory();
                            break block3;
                        }
                        if (!(option instanceof Some)) break block4;
                        Some some2 = (Some)option;
                        File file = (File)some2.x();
                        memoryHistory = new FileHistory(file);
                    }
                    MemoryHistory h = memoryHistory;
                    h.setMaxSize(JLine$.MODULE$.MaxHistorySize());
                    cr.setHistory((History)h);
                    return var2_2;
                }
                throw new MatchError((Object)option);
            }
            {
                this.historyPath$1 = historyPath$1;
                this.in$1 = in$1;
            }
        });
    }

    public <T> T withJLine(Function0<T> action) {
        return this.withTerminal((Function1<Terminal, T>)new Serializable(action){
            public static final long serialVersionUID = 0L;
            private final Function0 action$1;

            public final T apply(Terminal t) {
                t.init();
                try {
                    return (T)this.action$1.apply();
                }
                finally {
                    t.restore();
                }
            }
            {
                this.action$1 = action$1;
            }
        });
    }

    public SimpleReader simple(Option<File> historyPath, boolean handleCONT, boolean injectThreadSleep) {
        return new SimpleReader(historyPath, handleCONT, injectThreadSleep);
    }

    public boolean simple$default$2() {
        return this.HandleCONT();
    }

    public boolean simple$default$3() {
        return false;
    }

    public int MaxHistorySize() {
        return this.MaxHistorySize;
    }

    public boolean HandleCONT() {
        return this.HandleCONT;
    }

    private JLine$() {
        MODULE$ = this;
        this.TerminalProperty = "jline.terminal";
        this.fixTerminalProperty();
        this.originalIn = new FileInputStream(FileDescriptor.in);
        this.MaxHistorySize = 500;
        this.HandleCONT = !Boolean.getBoolean("sbt.disable.cont") && Signals$.MODULE$.supported(Signals$.MODULE$.CONT());
    }
}

