/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;
import jline.Terminal;
import jline.TerminalFactory;
import sbt.internal.util.ConsoleLogger;
import sbt.internal.util.ConsoleOut;
import sbt.internal.util.ConsoleOut$;
import sbt.internal.util.SuppressedTraceContext;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class ConsoleLogger$ {
    public static final ConsoleLogger$ MODULE$;
    private final char ESC;
    private final boolean formatEnabled;
    private final Function1<SuppressedTraceContext, None$> noSuppressedMessage;
    private final Regex EscapeSequence;

    static {
        new ConsoleLogger$();
    }

    public final char ESC() {
        return '\u001b';
    }

    public boolean isEscapeTerminator(char c) {
        return c >= '@' && c <= '~';
    }

    private boolean isCSI(char c) {
        return c == '[';
    }

    private boolean isAnsiTwoCharacterTerminator(char c) {
        return c >= '@' && c <= '_';
    }

    public boolean hasEscapeSequence(String s) {
        return s.indexOf(27) >= 0;
    }

    public String removeEscapeSequences(String s) {
        String string;
        if (!s.isEmpty() && this.hasEscapeSequence(s)) {
            StringBuilder sb = new StringBuilder();
            this.nextESC(s, 0, sb);
            string = sb.toString();
        } else {
            string = s;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private void nextESC(String s, int start, StringBuilder sb) {
        while (true) {
            int next;
            void var5_4;
            int escIndex;
            if ((escIndex = s.indexOf(27, start)) < 0) {
                sb.append(s, start, s.length());
                return;
            }
            sb.append(s, start, (int)var5_4);
            start = next = this.isCSI(s.charAt((int)(var5_4 + true))) ? this.skipESC(s, (int)(var5_4 + 2)) : (this.isAnsiTwoCharacterTerminator(s.charAt((int)(var5_4 + true))) ? var5_4 + 2 : this.skipESC(s, (int)(var5_4 + true)));
        }
    }

    private int skipESC(String s, int i) {
        while (true) {
            block5: {
                int n;
                block4: {
                    block3: {
                        if (i < s.length()) break block3;
                        n = i;
                        break block4;
                    }
                    if (!this.isEscapeTerminator(s.charAt(i))) break block5;
                    n = i + 1;
                }
                return n;
            }
            ++i;
        }
    }

    public boolean formatEnabled() {
        return this.formatEnabled;
    }

    private String jline1to2CompatMsg() {
        return "Found class jline.Terminal, but interface was expected";
    }

    private boolean ansiSupported() {
        Throwable throwable;
        Throwable throwable22;
        block4: {
            boolean bl;
            try {
                Terminal terminal = TerminalFactory.get();
                terminal.restore();
                bl = terminal.isAnsiSupported();
            }
            catch (Throwable throwable22) {
                boolean bl2;
                throwable = throwable22;
                if (!(throwable instanceof Exception)) break block4;
                bl = bl2 = !this.isWindows();
            }
            return bl;
        }
        if (throwable instanceof IncompatibleClassChangeError) {
            IncompatibleClassChangeError incompatibleClassChangeError = (IncompatibleClassChangeError)throwable;
            String string = incompatibleClassChangeError.getMessage();
            String string2 = this.jline1to2CompatMsg();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new IncompatibleClassChangeError("JLine incompatibility detected.  Check that the sbt launcher is version 0.13.x or later.");
            }
        }
        throw throwable22;
    }

    public Function1<SuppressedTraceContext, None$> noSuppressedMessage() {
        return this.noSuppressedMessage;
    }

    private String os() {
        return System.getProperty("os.name");
    }

    private boolean isWindows() {
        return this.os().toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
    }

    public ConsoleLogger apply(PrintStream out) {
        return this.apply(ConsoleOut$.MODULE$.printStreamOut(out), this.apply$default$2(), this.apply$default$3(), this.apply$default$4());
    }

    public ConsoleLogger apply(PrintWriter out) {
        return this.apply(ConsoleOut$.MODULE$.printWriterOut(out), this.apply$default$2(), this.apply$default$3(), this.apply$default$4());
    }

    public ConsoleLogger apply(ConsoleOut out, boolean ansiCodesSupported, boolean useColor, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        return new ConsoleLogger(out, ansiCodesSupported, useColor, suppressedMessage);
    }

    public ConsoleOut apply$default$1() {
        return ConsoleOut$.MODULE$.systemOut();
    }

    public boolean apply$default$2() {
        return this.formatEnabled();
    }

    public boolean apply$default$3() {
        return this.formatEnabled();
    }

    public Function1<SuppressedTraceContext, Option<String>> apply$default$4() {
        return this.noSuppressedMessage();
    }

    public String stripEscapeSequences(String s) {
        return this.EscapeSequence.pattern().matcher(s).replaceAll("");
    }

    private ConsoleLogger$() {
        MODULE$ = this;
        String value = System.getProperty("sbt.log.format");
        this.formatEnabled = value == null ? this.ansiSupported() && !Boolean.getBoolean("sbt.log.noformat") : Boolean.parseBoolean(value);
        this.noSuppressedMessage = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final None$ apply(SuppressedTraceContext x$1) {
                return None$.MODULE$;
            }
        };
        this.EscapeSequence = new StringOps(Predef$.MODULE$.augmentString(new scala.collection.mutable.StringBuilder().append((char)27).append((Object)"[^@-~]*[@-~]").toString())).r();
    }
}

