/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import sbt.internal.util.ConsoleAppender$;
import sbt.internal.util.EscHelpers$;
import sbt.internal.util.Prompt;
import sbt.internal.util.Terminal;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f!B\u0011#\u0005\u0019B\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011A\u0019\t\u0011E\u0003!\u0011!Q\u0001\nIB\u0001B\u0015\u0001\u0003\u0006\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0011)A\u0005)\"A\u0001\f\u0001BC\u0002\u0013\u0005\u0011\f\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003[\u0011!q\u0006A!b\u0001\n\u0003y\u0006\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u00115\u0004!Q1A\u0005\u0002eC\u0001B\u001c\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006_\u0002!\t\u0001\u001f\u0005\u0006_\u0002!\ta\u001f\u0005\u0006{\u0002!\tA \u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011!\ty\u0001\u0001Q\u0001\n\u0005E\u0001\u0002CA\r\u0001\u0011\u0005!%a\u0007\t\u0011\u0005u\u0001\u0001)C\u0005\u0003?A\u0001\"!\n\u0001\t\u0003\u0011\u0013q\u0001\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002*!A\u0011q\u0006\u0001\u0005\u0002\t\n\t\u0004\u0003\u0005\u0002D\u0001!\tAIA#\u0011!\tI\u0005\u0001C\u0001E\u0005-\u0003\u0002CA6\u0001\u0011\u0005!%!\u001c\b\u0011\u0005U$\u0005#\u0001'\u0003o2q!\t\u0012\t\u0002\u0019\nI\b\u0003\u0004p5\u0011\u0005\u00111\u0010\u0005\n\u0003{R\"\u0019!C\u0005\u0003\u007fB\u0001\"a#\u001bA\u0003%\u0011\u0011\u0011\u0005\t\u0003\u001bS\"\u0019!C\u00053\"9\u0011q\u0012\u000e!\u0002\u0013Q\u0006\u0002CAI5\u0011\u0005a%a%\u0003\u001bA\u0013xn\u001a:fgN\u001cF/\u0019;f\u0015\t\u0019C%\u0001\u0003vi&d'BA\u0013'\u0003!Ig\u000e^3s]\u0006d'\"A\u0014\u0002\u0007M\u0014Go\u0005\u0002\u0001SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\fQ\u0002\u001d:pOJ,7o\u001d'j]\u0016\u001c8\u0001A\u000b\u0002eA\u00191gO\u001f\u000e\u0003QR!!\u000e\u001c\u0002\r\u0005$x.\\5d\u0015\t9\u0004(\u0001\u0006d_:\u001cWO\u001d:f]RT!aI\u001d\u000b\u0003i\nAA[1wC&\u0011A\b\u000e\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u0019aHR%\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"1\u0003\u0019a$o\\8u}%\tA&\u0003\u0002FW\u00059\u0001/Y2lC\u001e,\u0017BA$I\u0005\r\u0019V-\u001d\u0006\u0003\u000b.\u0002\"A\u0013(\u000f\u0005-c\u0005C\u0001!,\u0013\ti5&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA',\u00039\u0001(o\\4sKN\u001cH*\u001b8fg\u0002\nq\u0001]1eI&tw-F\u0001U!\t\u0019T+\u0003\u0002Wi\ti\u0011\t^8nS\u000eLe\u000e^3hKJ\f\u0001\u0002]1eI&tw\rI\u0001\nE2\fgn\u001b.p]\u0016,\u0012A\u0017\t\u0003UmK!\u0001X\u0016\u0003\u0007%sG/\u0001\u0006cY\u0006t7NW8oK\u0002\n\u0001cY;se\u0016tG\u000fT5oK\nKH/Z:\u0016\u0003\u0001\u00042aM\u001eb!\r\u0011w-[\u0007\u0002G*\u0011A-Z\u0001\b[V$\u0018M\u00197f\u0015\t17&\u0001\u0006d_2dWm\u0019;j_:L!\u0001[2\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003U)L!a[\u0016\u0003\t\tKH/Z\u0001\u0012GV\u0014(/\u001a8u\u0019&tWMQ=uKN\u0004\u0013\u0001C7bq&#X-\\:\u0002\u00135\f\u00070\u0013;f[N\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004rgR,ho\u001e\t\u0003e\u0002i\u0011A\t\u0005\u0006_-\u0001\rA\r\u0005\u0006%.\u0001\r\u0001\u0016\u0005\u00061.\u0001\rA\u0017\u0005\u0006=.\u0001\r\u0001\u0019\u0005\u0006[.\u0001\rA\u0017\u000b\u0004cfT\b\"\u0002-\r\u0001\u0004Q\u0006\"B7\r\u0001\u0004QFCA9}\u0011\u0015AV\u00021\u0001[\u0003-\u0019WO\u001d:f]Rd\u0015N\\3\u0016\u0003}\u0004BAKA\u0001\u0013&\u0019\u00111A\u0016\u0003\r=\u0003H/[8o\u0003\u0015\u0011Xm]3u)\t\tI\u0001E\u0002+\u0003\u0017I1!!\u0004,\u0005\u0011)f.\u001b;\u0002\u00151Lg.\u001a\"vM\u001a,'\u000fE\u0003\u0002\u0014\u0005U\u0011*D\u00017\u0013\r\t9B\u000e\u0002\u0013\u0003J\u0014\u0018-\u001f\"m_\u000e\\\u0017N\\4Rk\u0016,X-\u0001\u0005hKRd\u0015N\\3t+\u0005i\u0014AC1qa\u0016tG\rT5oKR!\u0011\u0011BA\u0011\u0011\u0019\t\u0019C\u0005a\u0001\u0013\u0006!A.\u001b8f\u0003)\u0019G.Z1s\u0005f$Xm]\u0001\u0013Y&tWmU3qCJ\fGo\u001c:CsR,7\u000f\u0005\u0003+\u0003WI\u0017bAA\u0017W\t)\u0011I\u001d:bs\u0006A\u0011\r\u001a3CsR,7\u000f\u0006\u0004\u0002\n\u0005M\u0012Q\b\u0005\b\u0003k)\u0002\u0019AA\u001c\u0003!!XM]7j]\u0006d\u0007c\u0001:\u0002:%\u0019\u00111\b\u0012\u0003\u0011Q+'/\\5oC2Dq!a\u0010\u0016\u0001\u0004\t\t%A\u0003csR,7\u000fE\u0002?\r&\f\u0011bZ3u!J|W\u000e\u001d;\u0015\t\u0005%\u0012q\t\u0005\b\u0003k1\u0002\u0019AA\u001c\u0003\u00159(/\u001b;f))\tI!!\u0014\u0002P\u0005E\u0013\u0011\r\u0005\b\u0003k9\u0002\u0019AA\u001c\u0011\u001d\tyd\u0006a\u0001\u0003SAq!a\u0015\u0018\u0001\u0004\t)&A\u0006qe&tGo\u0015;sK\u0006l\u0007\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005m\u0013(\u0001\u0002j_&!\u0011qLA-\u0005-\u0001&/\u001b8u'R\u0014X-Y7\t\u000f\u0005\rt\u00031\u0001\u0002f\u0005Y\u0001.Y:Qe><'/Z:t!\rQ\u0013qM\u0005\u0004\u0003SZ#a\u0002\"p_2,\u0017M\\\u0001\u000eaJLg\u000e\u001e)s_\u001e\u0014Xm]:\u0015\u000b%\u000by'!\u001d\t\u000f\u0005U\u0002\u00041\u0001\u00028!1\u00111\u000f\rA\u0002%\u000b\u0001\u0002\\1ti2Kg.Z\u0001\u000e!J|wM]3tgN#\u0018\r^3\u0011\u0005IT2C\u0001\u000e*)\t\t9(A\tT\u000bJ3VIU0J'~\u0013VK\u0014(J\u001d\u001e+\"!!!\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\":\u0003\u0011a\u0017M\\4\n\u0007=\u000b))\u0001\nT\u000bJ3VIU0J'~\u0013VK\u0014(J\u001d\u001e\u0003\u0013\u0001G*F%Z+%kX%T?J+fJT%O\u000f~cUIT$U\u0011\u0006I2+\u0012*W\u000bJ{\u0016jU0S+:s\u0015JT$`\u0019\u0016su\t\u0016%!\u0003M)\b\u000fZ1uKB\u0013xn\u001a:fgN\u001cF/\u0019;f)\u0019\tI!!&\u0002 \"9\u0011q\u0013\u0011A\u0002\u0005e\u0015A\u00019f!\r\u0011\u00181T\u0005\u0004\u0003;\u0013#!\u0004)s_\u001e\u0014Xm]:Fm\u0016tG\u000fC\u0004\u00026\u0001\u0002\r!a\u000e")
public final class ProgressState {
    private final AtomicReference<Seq<String>> progressLines;
    private final AtomicInteger padding;
    private final int blankZone;
    private final AtomicReference<ArrayBuffer<Object>> currentLineBytes;
    private final int maxItems;
    private final ArrayBlockingQueue<String> lineBuffer;
    private final byte[] lineSeparatorBytes;

    public AtomicReference<Seq<String>> progressLines() {
        return this.progressLines;
    }

    public AtomicInteger padding() {
        return this.padding;
    }

    public int blankZone() {
        return this.blankZone;
    }

    public AtomicReference<ArrayBuffer<Object>> currentLineBytes() {
        return this.currentLineBytes;
    }

    public int maxItems() {
        return this.maxItems;
    }

    public Option<String> currentLine() {
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(new String((byte[])((IterableOnceOps)this.currentLineBytes().get()).toArray((ClassTag)ClassTag$.MODULE$.Byte()), "UTF-8"))).toSeq().lastOption().map((Function1 & Serializable)s -> EscHelpers$.MODULE$.stripColorsAndMoves((String)s)).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1))));
    }

    public void reset() {
        this.progressLines().set((Seq<String>)Nil$.MODULE$);
        this.padding().set(0);
        this.currentLineBytes().set((ArrayBuffer<Object>)new ArrayBuffer());
    }

    public Seq<String> getLines() {
        return ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.lineBuffer).asScala()).toVector();
    }

    private void appendLine(String line) {
        while (!this.lineBuffer.offer(line)) {
            this.lineBuffer.poll();
        }
    }

    public void clearBytes() {
        int pad = this.padding().get();
        Object object = ((SeqOps)this.currentLineBytes().get()).isEmpty() && pad > 0 ? BoxesRunTime.boxToInteger((int)this.padding().decrementAndGet()) : BoxedUnit.UNIT;
        this.currentLineBytes().set((ArrayBuffer<Object>)new ArrayBuffer());
    }

    public void addBytes(Terminal terminal, Seq<Object> bytes) {
        block1: {
            String lines;
            block2: {
                ArrayBuffer<Object> previous = this.currentLineBytes().get();
                int padding = this.padding().get();
                int prevLineCount = padding > 0 ? terminal.lineCount(new String((byte[])previous.toArray((ClassTag)ClassTag$.MODULE$.Byte()))) : 0;
                previous.$plus$plus$eq(bytes);
                if (padding > 0) {
                    int newLineCount = terminal.lineCount(new String((byte[])previous.toArray((ClassTag)ClassTag$.MODULE$.Byte())));
                    int diff = newLineCount - prevLineCount;
                    this.padding().set(package$.MODULE$.max(padding - diff, 0));
                }
                if (!(lines = new String((byte[])previous.toArray((ClassTag)ClassTag$.MODULE$.Byte()), "UTF-8")).contains(System.lineSeparator())) break block1;
                this.currentLineBytes().set((ArrayBuffer<Object>)new ArrayBuffer());
                if (lines.endsWith(System.lineSeparator())) break block2;
                String[] allLines = lines.split(System.lineSeparator());
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])allLines), 1)), (Function1 & Serializable)line -> {
                    this.appendLine(line);
                    return BoxedUnit.UNIT;
                });
                ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.refArrayOps((Object[])allLines)).foreach((Function1 & Serializable)x$2 -> (ArrayBuffer)((Growable)this.currentLineBytes().get()).$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray(x$2.getBytes("UTF-8"))));
                break block1;
            }
            if (!lines.contains(System.lineSeparator())) break block1;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])lines.split(System.lineSeparator())), (Function1 & Serializable)line -> {
                this.appendLine(line);
                return BoxedUnit.UNIT;
            });
        }
    }

    public byte[] getPrompt(Terminal terminal) {
        byte[] byArray;
        if (terminal.prompt() instanceof Prompt.AskUser) {
            String prefix = terminal.isAnsiSupported() ? new StringBuilder(4).append("\u001b[2K").append(ConsoleAppender$.MODULE$.CursorLeft1000()).toString() : "";
            byArray = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(prefix.getBytes()), (Object)terminal.prompt().render().getBytes("UTF-8"), (ClassTag)ClassTag$.MODULE$.Byte());
        } else {
            byArray = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
        }
        return byArray;
    }

    public void write(Terminal terminal, byte[] bytes, PrintStream printStream, boolean hasProgress) {
        if (hasProgress) {
            BoxedUnit boxedUnit;
            Prompt.AskUser askUser;
            boolean canClearPrompt = ((SeqOps)this.currentLineBytes().get()).isEmpty();
            this.addBytes(terminal, (Seq<Object>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)bytes));
            ArrayBuffer toWrite = new ArrayBuffer();
            Prompt prompt = terminal.prompt();
            Object object = prompt instanceof Prompt.AskUser && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((askUser = (Prompt.AskUser)prompt).render())) && canClearPrompt ? toWrite.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray(new StringBuilder(4).append("\u001b[2K").append(ConsoleAppender$.MODULE$.ClearScreenAfterCursor()).append(ConsoleAppender$.MODULE$.CursorLeft1000()).toString().getBytes("UTF-8"))) : BoxedUnit.UNIT;
            toWrite.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray(bytes));
            toWrite.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray(ConsoleAppender$.MODULE$.ClearScreenAfterCursor().getBytes("UTF-8")));
            if (ArrayOps$.MODULE$.endsWith$extension(Predef$.MODULE$.byteArrayOps(bytes), (Object)this.lineSeparatorBytes)) {
                BoxedUnit boxedUnit2;
                if (((IterableOnceOps)this.progressLines().get()).nonEmpty()) {
                    String string;
                    Prompt prompt2 = terminal.prompt();
                    if (prompt2 instanceof Prompt.AskUser) {
                        Prompt.AskUser askUser2 = (Prompt.AskUser)prompt2;
                        string = askUser2.render();
                    } else {
                        string = (String)this.currentLine().getOrElse((Function0 & Serializable)() -> "");
                    }
                    String lastLine = string;
                    String lines = this.printProgress(terminal, lastLine);
                    boxedUnit2 = toWrite.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray(new StringBuilder(0).append(ConsoleAppender$.MODULE$.ClearScreenAfterCursor()).append(lines).toString().getBytes("UTF-8")));
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = toWrite.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray(this.getPrompt(terminal)));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            printStream.write((byte[])toWrite.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
            printStream.flush();
        } else {
            printStream.write(bytes);
        }
    }

    public String printProgress(Terminal terminal, String lastLine) {
        String string;
        Seq<String> previousLines = this.progressLines().get();
        if (previousLines.nonEmpty()) {
            int currentLength = BoxesRunTime.unboxToInt((Object)previousLines.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToInteger((int)ProgressState.$anonfun$printProgress$1(terminal, BoxesRunTime.unboxToInt((Object)x$3), x$4))));
            Tuple2<Object, Object> tuple2 = terminal.getLineHeightAndWidth(lastLine);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int height = tuple2._1$mcI$sp();
            int width = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(height, width);
            Tuple2.mcII.sp sp3 = sp2;
            int height2 = sp3._1$mcI$sp();
            int width2 = sp3._2$mcI$sp();
            boolean offset = width2 > 0;
            int pad = package$.MODULE$.max(this.padding().get() - height2, 0);
            String start = offset ? new StringBuilder(1).append("\n").append(ConsoleAppender$.MODULE$.CursorLeft1000()).toString() : "";
            int totalSize = currentLength + this.blankZone() + pad;
            String blank = new StringBuilder(0).append(ConsoleAppender$.MODULE$.CursorLeft1000()).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(new StringBuilder(5).append("\n").append("\u001b[2K").toString()), totalSize - currentLength)).toString();
            String lines = previousLines.mkString("\u001b[2K", new StringBuilder(5).append("\n").append("\u001b[2K").toString(), new StringBuilder(5).append("\n").append("\u001b[2K").toString());
            String resetCursorUp = ConsoleAppender$.MODULE$.cursorUp(totalSize + (offset ? 1 : 0));
            String resetCursor = new StringBuilder(0).append(resetCursorUp).append(ConsoleAppender$.MODULE$.CursorLeft1000()).append(lastLine).toString();
            string = new StringBuilder(0).append(start).append(blank).append(lines).append(resetCursor).toString();
        } else {
            string = ConsoleAppender$.MODULE$.ClearScreenAfterCursor();
        }
        return string;
    }

    public static final /* synthetic */ int $anonfun$printProgress$1(Terminal terminal$1, int x$3, String x$4) {
        return x$3 + terminal$1.lineCount(x$4);
    }

    public ProgressState(AtomicReference<Seq<String>> progressLines, AtomicInteger padding, int blankZone, AtomicReference<ArrayBuffer<Object>> currentLineBytes, int maxItems) {
        this.progressLines = progressLines;
        this.padding = padding;
        this.blankZone = blankZone;
        this.currentLineBytes = currentLineBytes;
        this.maxItems = maxItems;
        this.lineBuffer = new ArrayBlockingQueue(300);
        this.lineSeparatorBytes = System.lineSeparator().getBytes("UTF-8");
    }

    public ProgressState(int blankZone, int maxItems) {
        this(new AtomicReference<Nil$>(Nil$.MODULE$), new AtomicInteger(0), blankZone, new AtomicReference<ArrayBuffer<Object>>(new ArrayBuffer()), maxItems);
    }

    public ProgressState(int blankZone) {
        this(blankZone, 8);
    }
}

