/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.PrintStream;
import sbt.BasicLogger;
import sbt.ConsoleLogger$;
import sbt.Level$;
import sbt.LogEvent;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.Seq;
import scala.runtime.BoxedObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleLogger
extends BasicLogger
implements ScalaObject {
    @Override
    public void control(Enumeration.Value event, Function0<String> message) {
        this.log(this.labelColor(Level$.MODULE$.Info()), Level$.MODULE$.Info().toString(), "\u001b[34m", (String)message.apply());
    }

    @Override
    public void logAll(Seq<LogEvent> events) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            events.foreach((Function1)new $anonfun$logAll$2(this));
            return;
        }
    }

    private void log(String labelColor$1, String label$1, String messageColor$1, String message) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            new BoxedObjectArray((Object[])message.split("\\n")).foreach((Function1)new $anonfun$log$5(this, labelColor$1, label$1, messageColor$1));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void sbt$ConsoleLogger$$setColor(String color) {
        if (!ConsoleLogger$.MODULE$.sbt$ConsoleLogger$$formatEnabled()) return;
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.print(color);
            return;
        }
    }

    @Override
    public void log(Enumeration.Value level, Function0<String> message) {
        if (this.atLevel(level)) {
            this.log(this.labelColor(level), level.toString(), this.messageColor(level), (String)message.apply());
        }
    }

    @Override
    public void trace(Function0<Throwable> t) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            if (this.traceEnabled()) {
                ((Throwable)t.apply()).printStackTrace();
            }
            return;
        }
    }

    @Override
    public void success(Function0<String> message) {
        if (this.atLevel(Level$.MODULE$.Info())) {
            this.log(this.successLabelColor(), Level$.MODULE$.SuccessLabel(), this.successMessageColor(), (String)message.apply());
        }
    }

    public String successMessageColor() {
        return "\u001b[0m";
    }

    public String successLabelColor() {
        return "\u001b[32m";
    }

    public String labelColor(Enumeration.Value level) {
        String string;
        Enumeration.Value value;
        Enumeration.Value value2 = value = level;
        Enumeration.Value value3 = Level$.MODULE$.Error();
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = "\u001b[31m";
        } else {
            Enumeration.Value value4 = value;
            Enumeration.Value value5 = Level$.MODULE$.Warn();
            string = !(value4 != null ? !value4.equals(value5) : value5 != null) ? "\u001b[33m" : "\u001b[0m";
        }
        return string;
    }

    public String messageColor(Enumeration.Value level) {
        return "\u001b[0m";
    }
}

