/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.security.CodeSource;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.AllPassFilter$;
import sbt.Control$;
import sbt.FileUtilities$;
import sbt.FileUtilities$$anonfun$sbt$FileUtilities$;
import sbt.Level$;
import sbt.Logger;
import sbt.NameFilter;
import sbt.OpenResource$;
import sbt.Path;
import sbt.Path$;
import sbt.PathFinder;
import sbt.Preserved;
import scala.;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Iterable;
import scala.Iterator;
import scala.Left;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Right;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.Manifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxedObjectArray;
import scala.tools.nsc.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtilities$
implements ScalaObject {
    public static final FileUtilities$ MODULE$;
    public volatile int bitmap$0;
    private final String Appending;
    private final String Writing;
    private final String Reading;
    private final Random random;
    private File scalaCompilerJar;
    private File scalaLibraryJar;
    private File sbtJar;
    private final File temporaryDirectory;
    private final int MaximumTries;
    private final Pattern PathSeparatorPattern;
    private final String Newline;
    private final int sbt$FileUtilities$$BufferSize;

    static {
        new FileUtilities$();
    }

    public FileUtilities$() {
        this.sbt$FileUtilities$$BufferSize = 8192;
        MODULE$ = this;
        this.Newline = System.getProperty("line.separator");
        this.PathSeparatorPattern = Pattern.compile(File.pathSeparator);
        this.MaximumTries = 10;
        this.temporaryDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.random = new Random();
        this.Reading = "reading";
        this.Writing = "writing";
        this.Appending = "appending";
    }

    private final void readNext$2(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) {
        int read2;
        while ((read2 = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, read2);
        }
    }

    private final void readNext$1(Reader reader, StringBuilder stringBuilder, char[] cArray) {
        int read2;
        while ((read2 = reader.read(cArray, 0, cArray.length)) >= 0) {
            stringBuilder.append(cArray, 0, read2);
        }
    }

    public final void logMessage$1(Function0 message, boolean bl, Logger logger) {
        logger.log(bl ? Level$.MODULE$.Debug() : Level$.MODULE$.Info(), (Function0<String>)message);
    }

    public final Option copyContents$1(File sourceDir, File targetDir$2, Logger logger) {
        return (Option)new BoxedObjectArray((Object[])sourceDir.listFiles()).foldLeft((Object)None$.MODULE$, (Function2)new anonfun.copyContents.1.1(logger, targetDir$2));
    }

    public final Option copyDirectory$1(File sourceDir$1, File targetDir$1, Logger logger) {
        return this.createDirectory(targetDir$1, logger).orElse((Function0)new anonfun.copyDirectory.1.1(logger, sourceDir$1, targetDir$1));
    }

    public final Option copyAll$1(List sources, Path path, Logger logger, HashSet hashSet) {
        List list;
        block6: {
            None$ none$;
            block5: {
                while ((list = sources) instanceof .colon.colon) {
                    File file2;
                    .colon.colon colon2 = (.colon.colon)list;
                    File head = file2 = (File)colon2.hd$1();
                    Option option = this.copy$1(head, path, logger, hashSet);
                    None$ none$2 = None$.MODULE$;
                    Option option2 = option;
                    if (!(none$2 != null ? !none$2.equals(option2) : option2 != null)) {
                        sources = colon2.tl$1();
                        continue;
                    }
                    none$ = option;
                    break block5;
                }
                Nil$ nil$ = Nil$.MODULE$;
                List list2 = list;
                if (nil$ != null ? !nil$.equals(list2) : list2 != null) break block6;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)list);
    }

    private final Option copy$1(File source$4, Path path, Logger logger, HashSet hashSet) {
        Option<String> option;
        if (source$4.isDirectory()) {
            option = this.copyAll$1(new BoxedObjectArray((Object[])source$4.listFiles()).toList(), path, logger, hashSet);
        } else if (source$4.exists()) {
            PathFinder targetPath$1 = path.$div(source$4.getName());
            hashSet.$plus$eq((Object)targetPath$1);
            if (((Path)targetPath$1).exists() && source$4.lastModified() <= ((Path)targetPath$1).lastModified()) {
                option = None$.MODULE$;
            } else {
                logger.debug(new anonfun.copy.1.1(source$4, (Path)targetPath$1));
                option = this.copyFile(source$4, ((Path)targetPath$1).asFile(), logger);
            }
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public final Option copy$2(List sources, Function1 function1) {
        List list;
        block6: {
            None$ none$;
            block5: {
                while ((list = sources) instanceof .colon.colon) {
                    Path path;
                    .colon.colon colon2 = (.colon.colon)list;
                    Path src = path = (Path)colon2.hd$1();
                    Option option = (Option)function1.apply((Object)src);
                    None$ none$2 = None$.MODULE$;
                    Option option2 = option;
                    if (!(none$2 != null ? !none$2.equals(option2) : option2 != null)) {
                        sources = colon2.tl$1();
                        continue;
                    }
                    none$ = option;
                    break block5;
                }
                Nil$ nil$ = Nil$.MODULE$;
                List list2 = list;
                if (nil$ != null ? !nil$.equals(list2) : list2 != null) break block6;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)list);
    }

    public final Either doInDirectory$1(File dir$2, Logger logger, Function1 function1) {
        return Control$.MODULE$.trapAndFinally(new anonfun.doInDirectory.1.1(), logger, new anonfun.doInDirectory.1.2(function1, dir$2), new anonfun.doInDirectory.1.3(logger, dir$2));
    }

    private final Either create$1(int tries, Logger logger) {
        while (true) {
            block5: {
                Left left;
                block4: {
                    block3: {
                        if (tries <= this.MaximumTries()) break block3;
                        left = new Left((Object)"Could not create temporary directory.");
                        break block4;
                    }
                    String randomName = new StringBuilder().append((Object)"sbt_").append((Object)Integer.toHexString(this.random().nextInt())).toString();
                    File f = new File(this.temporaryDirectory(), randomName);
                    if (!this.createDirectory(f, logger).isEmpty()) break block5;
                    left = new Right((Object)f);
                }
                return left;
            }
            ++tries;
        }
    }

    private final Option next$1(ZipInputStream zipInputStream, Path path, NameFilter nameFilter, Logger logger, HashSet hashSet) {
        None$ none$;
        block6: {
            Option<String> option;
            Option<String> option2;
            None$ none$2;
            do {
                Option<String> option3;
                ZipEntry entry;
                ZipEntry zipEntry;
                if ((zipEntry = (entry = zipInputStream.getNextEntry())) == null || zipEntry.equals(null)) {
                    none$ = None$.MODULE$;
                    break block6;
                }
                String name$1 = entry.getName();
                if (nameFilter.accept(name$1)) {
                    Option<String> result;
                    Option<String> option4;
                    Path target$1 = Path$.MODULE$.fromString(path, name$1);
                    logger.debug(new anonfun.4(name$1, target$1));
                    if (entry.isDirectory()) {
                        option4 = this.createDirectory(target$1, logger);
                    } else {
                        hashSet.$plus$eq((Object)target$1);
                        option4 = this.writeStream(target$1.asFile(), logger, new anonfun.5(zipInputStream, logger));
                    }
                    option3 = result = option4;
                } else {
                    logger.debug(new anonfun.6(name$1));
                    option3 = None$.MODULE$;
                }
                Option<String> result = option3;
                zipInputStream.closeEntry();
                option = result;
                none$2 = None$.MODULE$;
                option2 = option;
            } while (!(none$2 == null ? option2 != null : !none$2.equals(option2)));
            none$ = option;
        }
        return none$;
    }

    public final void add$1(Path source$2, ZipOutputStream zipOutputStream, boolean bl, Logger logger, Function1 function1) {
        File sourceFile2 = source$2.asFile();
        if (sourceFile2.isDirectory()) {
            if (bl) {
                new BoxedObjectArray((Object[])this.wrapNull(sourceFile2.listFiles())).foreach((Function1)new anonfun.add.1.1(zipOutputStream, bl, logger, function1, source$2));
            }
        } else if (sourceFile2.exists()) {
            String relativePath$1 = source$2.relativePathString("/");
            logger.debug(new anonfun.add.1.2(source$2, relativePath$1));
            ZipEntry nextEntry = (ZipEntry)function1.apply((Object)relativePath$1);
            nextEntry.setTime(sourceFile2.lastModified());
            zipOutputStream.putNextEntry(nextEntry);
            this.transferAndClose(new FileInputStream(sourceFile2), zipOutputStream, logger);
        } else {
            logger.warn(new anonfun.add.1.3(source$2));
        }
    }

    private String Appending() {
        return this.Appending;
    }

    private String Writing() {
        return this.Writing;
    }

    private String Reading() {
        return this.Reading;
    }

    private Random random() {
        return this.random;
    }

    public Iterable<File> scalaJars() {
        return List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new File[]{this.scalaLibraryJar(), this.scalaCompilerJar()}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File scalaCompilerJar() {
        if ((this.bitmap$0 & 0x10) != 0) return this.scalaCompilerJar;
        FileUtilities$ fileUtilities$ = this;
        synchronized (fileUtilities$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.scalaCompilerJar = this.classLocationFile(Manifest$.MODULE$.classType(Settings.class));
                this.bitmap$0 |= 0x10;
            }
            return this.scalaCompilerJar;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File scalaLibraryJar() {
        if ((this.bitmap$0 & 4) != 0) return this.scalaLibraryJar;
        FileUtilities$ fileUtilities$ = this;
        synchronized (fileUtilities$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.scalaLibraryJar = this.classLocationFile(Manifest$.MODULE$.classType(ScalaObject.class));
                this.bitmap$0 |= 4;
            }
            return this.scalaLibraryJar;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File sbtJar() {
        if ((this.bitmap$0 & 1) != 0) return this.sbtJar;
        FileUtilities$ fileUtilities$ = this;
        synchronized (fileUtilities$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sbtJar = this.classLocationFile(this.getClass());
                this.bitmap$0 |= 1;
            }
            return this.sbtJar;
        }
    }

    public <T> File classLocationFile(Manifest<T> mf) {
        return this.classLocationFile(mf.erasure());
    }

    public <T> URL classLocation(Manifest<T> mf) {
        return this.classLocation(mf.erasure());
    }

    public File classLocationFile(Class<?> cl) {
        return this.toFile(this.classLocation(cl));
    }

    public URL classLocation(Class<?> cl) {
        CodeSource codeSource = cl.getProtectionDomain().getCodeSource();
        CodeSource codeSource2 = codeSource;
        if (codeSource2 == null || ((Object)codeSource2).equals(null)) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"No class location for ").append(cl).toString());
        }
        return codeSource.getLocation();
    }

    public File temporaryDirectory() {
        return this.temporaryDirectory;
    }

    /*
     * WARNING - void declaration
     */
    public File toFile(URL url) {
        void var2_2;
        File exceptionResult2 = null;
        try {
            exceptionResult2 = new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            exceptionResult2 = new File(url.getPath());
        }
        return var2_2;
    }

    public void writeLine(Writer writer, String line) {
        writer.write(line);
        writer.write(this.Newline());
    }

    public File[] wrapNull(File[] a) {
        return a == null ? new File[]{} : a;
    }

    public <R> Either<String, R> readChannelValue(File file2, Logger log2, Function1<FileChannel, Either<String, R>> f) {
        return OpenResource$.MODULE$.fileInputChannel().io(file2, this.Reading(), log2, f);
    }

    public Option<String> readChannel(File file2, Logger log2, Function1<FileChannel, Option<String>> f) {
        return OpenResource$.MODULE$.fileInputChannel().ioOption(file2, this.Reading(), log2, f);
    }

    public Option<String> writeChannel(File file2, Logger log2, Function1<FileChannel, Option<String>> f) {
        return OpenResource$.MODULE$.fileOutputChannel().ioOption(file2, this.Writing(), log2, f);
    }

    public <R> Either<String, R> readStreamValue(URL url, Logger log2, Function1<InputStream, Either<String, R>> f) {
        return OpenResource$.MODULE$.urlInputStream().io(url, this.Reading(), log2, f);
    }

    public Option<String> readStream(URL url, Logger log2, Function1<InputStream, Option<String>> f) {
        return OpenResource$.MODULE$.urlInputStream().ioOption(url, this.Reading(), log2, f);
    }

    public <R> Either<String, R> readStreamValue(File file2, Logger log2, Function1<InputStream, Either<String, R>> f) {
        return OpenResource$.MODULE$.fileInputStream().io(file2, this.Reading(), log2, f);
    }

    public Option<String> readStream(File file2, Logger log2, Function1<InputStream, Option<String>> f) {
        return OpenResource$.MODULE$.fileInputStream().ioOption(file2, this.Reading(), log2, f);
    }

    private Option<String> writeStream(File file2, boolean append, Logger log2, Function1<OutputStream, Option<String>> f) {
        return append ? this.appendStream(file2, log2, f) : this.writeStream(file2, log2, f);
    }

    public Option<String> writeStream(File file2, Logger log2, Function1<OutputStream, Option<String>> f) {
        return OpenResource$.MODULE$.fileOutputStream(false).ioOption(file2, this.Writing(), log2, f);
    }

    public Option<String> appendStream(File file2, Logger log2, Function1<OutputStream, Option<String>> f) {
        return OpenResource$.MODULE$.fileOutputStream(true).ioOption(file2, this.Appending(), log2, f);
    }

    public final Either sbt$FileUtilities$$readBytes(InputStream in$5) {
        ByteArrayOutputStream out$4 = new ByteArrayOutputStream();
        byte[] buffer$3 = new byte[this.sbt$FileUtilities$$BufferSize()];
        this.readNext$2(in$5, out$4, buffer$3);
        return new Right((Object)out$4.toByteArray());
    }

    public Either<String, byte[]> readBytes(InputStream in$6, Logger log2) {
        return Control$.MODULE$.trapAndFinally(new anonfun.readBytes.2(), log2, new anonfun.readBytes.3(in$6), new anonfun.readBytes.4(in$6));
    }

    public Either<String, byte[]> readBytes(File file2, Logger log2) {
        return this.readStreamValue(file2, log2, new anonfun.readBytes.1());
    }

    private Option<String> writeBytes(File file2, byte[] bytes$1, boolean append, Logger log2) {
        return this.writeStream(file2, append, log2, new anonfun.writeBytes.1(bytes$1));
    }

    public Option<String> write(File file2, byte[] bytes, Logger log2) {
        return this.writeBytes(file2, bytes, false, log2);
    }

    public Option<String> append(File file2, byte[] bytes, Logger log2) {
        return this.writeBytes(file2, bytes, true, log2);
    }

    public final Either sbt$FileUtilities$$readString(Reader in$3) {
        StringBuilder builder$1 = new StringBuilder();
        char[] buffer$2 = new char[this.sbt$FileUtilities$$BufferSize()];
        this.readNext$1(in$3, builder$1, buffer$2);
        return new Right((Object)builder$1.toString());
    }

    public Either<String, String> readString(Reader in$4, Logger log2) {
        return Control$.MODULE$.trapAndFinally(new anonfun.readString.3(), log2, new anonfun.readString.4(in$4), new anonfun.readString.5(in$4));
    }

    public Either<String, String> readString(InputStream in, Charset charset, Logger log2) {
        return OpenResource$.MODULE$.streamReader().io((Tuple2<InputStream, Charset>)new Tuple2((Object)in, (Object)charset), this.Reading(), log2, new anonfun.readString.2());
    }

    public Either<String, String> readString(InputStream in, Logger log2) {
        return this.readString(in, Charset.defaultCharset(), log2);
    }

    public Either<String, String> readString(File file2, Charset charset, Logger log2) {
        return this.readValue(file2, charset, log2, new anonfun.readString.1());
    }

    public Either<String, String> readString(File file2, Logger log2) {
        return this.readString(file2, Charset.defaultCharset(), log2);
    }

    public <R> Either<String, R> readValue(File file2, Charset charset, Logger log2, Function1<Reader, Either<String, R>> f) {
        return OpenResource$.MODULE$.fileReader(charset).io(file2, this.Reading(), log2, f);
    }

    public <R> Either<String, R> readValue(File file2, Logger log2, Function1<Reader, Either<String, R>> f) {
        return this.readValue(file2, Charset.defaultCharset(), log2, f);
    }

    public Option<String> read(File file2, Charset charset, Logger log2, Function1<Reader, Option<String>> f) {
        return OpenResource$.MODULE$.fileReader(charset).ioOption(file2, this.Reading(), log2, f);
    }

    public Option<String> read(File file2, Logger log2, Function1<Reader, Option<String>> f) {
        return this.read(file2, Charset.defaultCharset(), log2, f);
    }

    private Option<String> write(File file2, Charset charset, boolean append, Logger log2, Function1<Writer, Option<String>> f) {
        return OpenResource$.MODULE$.fileWriter(charset, append).ioOption(file2, this.Writing(), log2, f);
    }

    public Option<String> write(File file2, Charset charset, Logger log2, Function1<Writer, Option<String>> f) {
        return this.write(file2, charset, false, log2, f);
    }

    public Option<String> write(File file2, Logger log2, Function1<Writer, Option<String>> f) {
        return this.write(file2, Charset.defaultCharset(), log2, f);
    }

    private Option<String> write(File file2, String content$1, Charset charset, boolean append, Logger log2) {
        return charset.newEncoder().canEncode(content$1) ? this.write(file2, charset, append, log2, new anonfun.write.1(content$1)) : new Some((Object)new StringBuilder().append((Object)"String cannot be encoded by charset ").append((Object)charset.name()).toString());
    }

    public Option<String> write(File file2, String content, Charset charset, Logger log2) {
        return this.write(file2, content, charset, false, log2);
    }

    public Option<String> write(File file2, String content, Logger log2) {
        return this.write(file2, content, Charset.defaultCharset(), log2);
    }

    public Option<String> append(File file2, String content, Charset charset, Logger log2) {
        return this.write(file2, content, charset, true, log2);
    }

    public Option<String> append(File file2, String content, Logger log2) {
        return this.append(file2, content, Charset.defaultCharset(), log2);
    }

    public final Option sbt$FileUtilities$$delete(File file$2, boolean quiet$1, Logger log$27) {
        return Control$.MODULE$.trapUnit(new anonfun$sbt$FileUtilities$$delete$1(file$2), log$27, new anonfun$sbt$FileUtilities$$delete$2(file$2, quiet$1, log$27));
    }

    public final Option sbt$FileUtilities$$deleteFiles(Iterable files, boolean quiet$2, Logger log$31) {
        None$ none$ = None$.MODULE$;
        return (Option)files.$div$colon((Object)none$, (Function2)new anonfun$sbt$FileUtilities$$deleteFiles$1(quiet$2, log$31));
    }

    public Option<String> clean(Iterable<Path> files, boolean quiet, Logger log2) {
        return this.sbt$FileUtilities$$deleteFiles(files.map((Function1)new anonfun.clean.1()), quiet, log2);
    }

    public Option<String> clean(Iterable<Path> files, Logger log2) {
        return this.clean(files, false, log2);
    }

    public Option<String> clean(Path file2, Logger log2) {
        Path path = file2;
        return this.clean((Iterable<Path>)Nil$.MODULE$.$colon$colon((Object)path), log2);
    }

    public Option<String> copyDirectory(File source, File target, Logger log$1) {
        Predef$.MODULE$.require(source.isDirectory(), (Object)new StringBuilder().append((Object)"Source '").append((Object)source.getAbsolutePath()).append((Object)"' is not a directory.").toString());
        Predef$.MODULE$.require(!target.exists(), (Object)new StringBuilder().append((Object)"Target '").append((Object)target.getAbsolutePath()).append((Object)"' already exists.").toString());
        return this.copyDirectory$1(source, target, log$1);
    }

    public Option<String> copyDirectory(Path source, Path target, Logger log2) {
        return this.copyDirectory(source.asFile(), target.asFile(), log2);
    }

    public Option<String> prune(Path directory, Iterable<Path> keepOnly, Logger log$30) {
        Set<Path> existing = directory.$hash$hash().$times$times(AllPassFilter$.MODULE$).get();
        scala.collection.mutable.Set toRemove = HashSet$.MODULE$.apply(existing.toSeq());
        toRemove.$minus$minus$eq(keepOnly);
        if (log$30.atLevel(Level$.MODULE$.Debug())) {
            toRemove.foreach((Function1)new anonfun.prune.1(log$30));
        }
        return this.clean((Iterable<Path>)toRemove, true, log$30);
    }

    public Option<String> sync(Path sourceDirectory, Path targetDirectory$1, Logger log$6) {
        return this.copy((Iterable<Path>)sourceDirectory.$hash$hash().$times$times(AllPassFilter$.MODULE$).get(), targetDirectory$1, log$6).right().flatMap((Function1)new anonfun.sync.1(targetDirectory$1, log$6)).left().toOption();
    }

    public Option<String> copyFile(File sourceFile$1, File targetFile$1, Logger log$5) {
        Predef$.MODULE$.require(sourceFile$1.exists(), (Object)new StringBuilder().append((Object)"Source file '").append((Object)sourceFile$1.getAbsolutePath()).append((Object)"' does not exist.").toString());
        Predef$.MODULE$.require(!sourceFile$1.isDirectory(), (Object)new StringBuilder().append((Object)"Source file '").append((Object)sourceFile$1.getAbsolutePath()).append((Object)"' is a directory.").toString());
        return this.readChannel(sourceFile$1, log$5, new anonfun.copyFile.1(sourceFile$1, targetFile$1, log$5));
    }

    public Option<String> copyFile(Path sourceFile2, Path targetFile, Logger log2) {
        return this.copyFile(sourceFile2.asFile(), targetFile.asFile(), log2);
    }

    public Either<String, Set<Path>> copyFilesFlat(Iterable<File> sources, Path targetDirectory$2, Logger log$14) {
        Predef$.MODULE$.require(targetDirectory$2.asFile().isDirectory(), (Object)new StringBuilder().append((Object)"Target '").append((Object)targetDirectory$2).append((Object)"' is not a directory.").toString());
        HashMap byName$1 = new HashMap();
        sources.foreach((Function1)new anonfun.copyFilesFlat.1(byName$1));
        Iterator uniquelyNamedSources$1 = byName$1.values();
        HashSet targetSet$3 = new HashSet();
        return Control$.MODULE$.trap(new anonfun.copyFilesFlat.2(), log$14, new anonfun.copyFilesFlat.3(targetDirectory$2, log$14, uniquelyNamedSources$1, targetSet$3));
    }

    public Either<String, Set<Path>> copy(Iterable<Path> sources, Path destinationDirectory$1, Logger log$7) {
        HashSet targetSet$1 = new HashSet();
        return this.copyImpl(sources, destinationDirectory$1, log$7, new anonfun.copy.1(destinationDirectory$1, log$7, targetSet$1)).toLeft((Function0)new anonfun.copy.2(targetSet$1));
    }

    public Option<String> download(URL url, File to$1, Logger log$29) {
        return this.readStream(url, log$29, (Function1<InputStream, Option<String>>)new anonfun.download.1(to$1, log$29));
    }

    private Option<String> copyImpl(Iterable<Path> sources$1, Path destinationDirectory, Logger log$8, Function1<Path, Option<String>> doCopy$1) {
        File target = destinationDirectory.asFile();
        Option<String> creationError = target.isDirectory() ? None$.MODULE$ : this.createDirectory(target, log$8);
        return creationError.orElse((Function0)new anonfun.copyImpl.1(sources$1, log$8, doCopy$1));
    }

    public Either<String, Set<Path>> copyFlat(Iterable<Path> sources, Path destinationDirectory$2, Logger log$13) {
        HashSet targetSet$2 = new HashSet();
        return this.copyImpl(sources, destinationDirectory$2, log$13, new anonfun.copyFlat.1(destinationDirectory$2, log$13, targetSet$2)).toLeft((Function0)new anonfun.copyFlat.2(targetSet$2));
    }

    public <T> Either<String, T> withTemporaryFile(Logger log$28, String prefix$1, String postfix$1, Function1<File, Either<String, T>> action$3) {
        return Control$.MODULE$.trap(new anonfun.withTemporaryFile.1(), log$28, new anonfun.withTemporaryFile.2(log$28, prefix$1, postfix$1, action$3));
    }

    public <T> Either<String, T> doInTemporaryDirectory(Logger log$2, Function1<File, Either<String, T>> action$1) {
        return this.createTemporaryDirectory(log$2).right().flatMap((Function1)new anonfun.doInTemporaryDirectory.1(log$2, action$1));
    }

    public Option<String> withTemporaryDirectory(Logger log2, Function1<File, Option<String>> action$2) {
        return this.doInTemporaryDirectory(log2, new anonfun.withTemporaryDirectory.1(action$2)).left().toOption();
    }

    public Either<String, File> createTemporaryDirectory(Logger log$15) {
        return this.create$1(0, log$15);
    }

    private int MaximumTries() {
        return this.MaximumTries;
    }

    public Option<String> createDirectories(List<File> d, Logger log$26) {
        List<File> list;
        block4: {
            None$ none$;
            block3: {
                List list2;
                block2: {
                    list = d;
                    Nil$ nil$ = Nil$.MODULE$;
                    List<File> list3 = list;
                    if (nil$ != null ? !nil$.equals(list3) : list3 != null) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (!(list instanceof .colon.colon)) break block4;
                .colon.colon colon2 = (.colon.colon)list;
                List tail$1 = list2 = colon2.tl$1();
                none$ = this.createDirectory((File)colon2.hd$1(), log$26).orElse((Function0)new anonfun.createDirectories.2(log$26, tail$1));
            }
            return none$;
        }
        throw new MatchError(list);
    }

    public Option<String> createDirectories(Seq<Path> d, Logger log2) {
        return this.createDirectories((List<File>)d.toList().map((Function1)new anonfun.createDirectories.1()), log2);
    }

    public Option<String> createDirectory(File dir$1, Logger log$9) {
        return Control$.MODULE$.trapUnit(new anonfun.createDirectory.1(dir$1), log$9, new anonfun.createDirectory.2(dir$1, log$9));
    }

    public Option<String> createDirectory(Path dir, Logger log2) {
        return this.createDirectory(dir.asFile(), log2);
    }

    public Option<String> touch(File file$1, Logger log$25) {
        return Control$.MODULE$.trapUnit(new anonfun.touch.1(file$1), log$25, new anonfun.touch.2(file$1, log$25));
    }

    public Option<String> touch(Path path, Logger log2) {
        return this.touch(path.asFile(), log2);
    }

    private Option<String> transferImpl(InputStream in$1, OutputStream out$3, boolean close$1, Logger log2) {
        return Control$.MODULE$.trapUnitAndFinally(new anonfun.transferImpl.1(), log2, new anonfun.transferImpl.2(in$1, out$3), new anonfun.transferImpl.3(in$1, close$1));
    }

    public Option<String> transferAndClose(InputStream in, OutputStream out, Logger log2) {
        return this.transferImpl(in, out, true, log2);
    }

    public Option<String> transfer(InputStream in, OutputStream out, Logger log2) {
        return this.transferImpl(in, out, false, log2);
    }

    public final Either sbt$FileUtilities$$extract(ZipInputStream from$1, Path toDirectory$4, NameFilter filter$4, Logger log$24) {
        HashSet set$1 = new HashSet();
        return this.next$1(from$1, toDirectory$4, filter$4, log$24, set$1).toLeft((Function0)new anonfun$sbt$FileUtilities$$extract$1(set$1));
    }

    public Either<String, Set<Path>> unzip(InputStream from, Path toDirectory$1, NameFilter filter$1, Logger log$21) {
        Option<String> option;
        block4: {
            Either either;
            block3: {
                block2: {
                    option = this.createDirectory(toDirectory$1, log$21);
                    if (!(option instanceof Some)) break block2;
                    either = new Either(((Some)option).x());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                either = OpenResource$.MODULE$.zipInputStream().io(from, "unzipping", log$21, new anonfun.unzip.3(toDirectory$1, filter$1, log$21));
            }
            return either;
        }
        throw new MatchError(option);
    }

    public Either<String, Set<Path>> unzip(URL from, Path toDirectory$2, NameFilter filter$2, Logger log$22) {
        return this.readStreamValue(from, log$22, new anonfun.unzip.2(toDirectory$2, filter$2, log$22));
    }

    public Either<String, Set<Path>> unzip(File from, Path toDirectory$3, NameFilter filter$3, Logger log$23) {
        return this.readStreamValue(from, log$23, new anonfun.unzip.1(toDirectory$3, filter$3, log$23));
    }

    public Either<String, Set<Path>> unzip(Path from, Path toDirectory, NameFilter filter, Logger log2) {
        return this.unzip(from.asFile(), toDirectory, filter, log2);
    }

    public Either<String, Set<Path>> unzip(URL from, Path toDirectory, Logger log2) {
        return this.unzip(from, toDirectory, (NameFilter)AllPassFilter$.MODULE$, log2);
    }

    public Either<String, Set<Path>> unzip(InputStream from, Path toDirectory, Logger log2) {
        return this.unzip(from, toDirectory, (NameFilter)AllPassFilter$.MODULE$, log2);
    }

    public Either<String, Set<Path>> unzip(File from, Path toDirectory, Logger log2) {
        return this.unzip(from, toDirectory, (NameFilter)AllPassFilter$.MODULE$, log2);
    }

    public Either<String, Set<Path>> unzip(Path from, Path toDirectory, Logger log2) {
        return this.unzip(from, toDirectory, (NameFilter)AllPassFilter$.MODULE$, log2);
    }

    public final Option sbt$FileUtilities$$withZipOutput(File file2, Option manifest$2, Logger log$11, Function1 f$1) {
        return this.writeStream(file2, log$11, new anonfun$sbt$FileUtilities$$withZipOutput$1(manifest$2, log$11, f$1));
    }

    public final None$ sbt$FileUtilities$$writeZip(Iterable sources, ZipOutputStream output$1, boolean recursive$2, Logger log$12, Function1 createEntry$1) {
        sources.foreach((Function1)new anonfun$sbt$FileUtilities$$writeZip$1(output$1, recursive$2, log$12, createEntry$1));
        output$1.closeEntry();
        return None$.MODULE$;
    }

    private Option<String> archive(Iterable<Path> sources$2, Path outputPath$1, Option<java.util.jar.Manifest> manifest$1, boolean recursive$1, Logger log$10) {
        Some some;
        log$10.info(new anonfun.archive.1(outputPath$1));
        File outputFile$1 = outputPath$1.asFile();
        if (outputFile$1.isDirectory()) {
            some = new Some((Object)new StringBuilder().append((Object)"Specified output file ").append((Object)outputFile$1).append((Object)" is a directory.").toString());
        } else {
            File outputDir = outputFile$1.getParentFile();
            Option result = this.createDirectory(outputDir, log$10).orElse((Function0)new anonfun.1(sources$2, manifest$1, recursive$1, log$10, outputFile$1));
            if (result.isEmpty()) {
                log$10.info(new anonfun.archive.2());
            }
            some = result;
        }
        return some;
    }

    public Option<String> zip(Iterable<Path> sources, Path outputZip, boolean recursive, Logger log2) {
        return this.archive(sources, outputZip, (Option<java.util.jar.Manifest>)None$.MODULE$, recursive, log2);
    }

    public Option<String> pack(Iterable<Path> sources, Path outputJar, java.util.jar.Manifest manifest, boolean recursive, Logger log2) {
        return this.jar(sources, outputJar, manifest, recursive, log2);
    }

    public Option<String> jar(Iterable<Path> sources, Path outputJar, java.util.jar.Manifest manifest, boolean recursive, Logger log2) {
        return this.archive(sources, outputJar, (Option<java.util.jar.Manifest>)new Some((Object)manifest), recursive, log2);
    }

    public Option<String> gunzip(Path in, Path out$2, Logger log$20) {
        Path path = in;
        Path path2 = out$2;
        Predef$.MODULE$.require(path != null ? !((Object)path).equals(path2) : path2 != null, (Object)"Input file cannot be the same as the output file.");
        return this.readStream(in.asFile(), log$20, (Function1<InputStream, Option<String>>)new anonfun.gunzip.2(out$2, log$20));
    }

    public Option<String> gunzip(InputStream input2, OutputStream output$2, Logger log$19) {
        return OpenResource$.MODULE$.gzipInputStream().ioOption(input2, "gunzipping", log$19, new anonfun.gunzip.1(output$2, log$19));
    }

    public Option<String> gzip(InputStream input$1, OutputStream output2, Logger log$17) {
        return OpenResource$.MODULE$.gzipOutputStream().ioOption(output2, "gzipping", log$17, new anonfun.gzip.2(input$1, log$17));
    }

    public Option<String> gzip(Path in, Path out$1, Logger log$16) {
        Path path = in;
        Path path2 = out$1;
        Predef$.MODULE$.require(path != null ? !((Object)path).equals(path2) : path2 != null, (Object)"Input file cannot be the same as the output file.");
        return this.readStream(in.asFile(), log$16, (Function1<InputStream, Option<String>>)new anonfun.gzip.1(out$1, log$16));
    }

    public Either<String, Preserved> preserve(Iterable<Path> paths$1, Logger log$3) {
        return this.createTemporaryDirectory(log$3).right().map((Function1)new anonfun.preserve.1(paths$1, log$3));
    }

    public String[] pathSplit(String s) {
        return this.PathSeparatorPattern().split(s);
    }

    private Pattern PathSeparatorPattern() {
        return this.PathSeparatorPattern;
    }

    private String Newline() {
        return this.Newline;
    }

    public final int sbt$FileUtilities$$BufferSize() {
        return this.sbt$FileUtilities$$BufferSize;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

