/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import sbt.Level$;
import sbt.Logger;
import sbt.LoggerReporter$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.FakePos;
import scala.tools.nsc.util.Position;
import scala.tools.nsc.util.SourceFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerReporter
extends Reporter
implements ScalaObject {
    private final HashMap<Position, Reporter.Severity> positions;
    public final Logger sbt$LoggerReporter$$log;
    private final int maximumErrors;

    public LoggerReporter(int maximumErrors2, Logger log2) {
        this.maximumErrors = maximumErrors2;
        this.sbt$LoggerReporter$$log = log2;
        this.positions = new HashMap();
    }

    public final String message$1(String string, Position position) {
        Position position2 = position;
        String sourcePrefix = position2 instanceof FakePos ? new StringBuilder().append((Object)((FakePos)position2).msg()).append((Object)" ").toString() : (String)position.source().map((Function1)new $anonfun$9(this)).getOrElse((Function0)new $anonfun$10(this));
        String lineNumberString = new StringBuilder().append((Object)((String)position.line().map((Function1)new $anonfun$11(this)).getOrElse((Function0)new $anonfun$12(this)))).append((Object)" ").toString();
        return new StringBuilder().append((Object)sourcePrefix).append((Object)lineNumberString).append((Object)string).toString();
    }

    private boolean testAndLog(Position pos, Reporter.Severity severity$1) {
        boolean bl;
        Position position = pos;
        if (position == null || position.equals(null) || pos.offset().isEmpty()) {
            bl = false;
        } else if (BoxesRunTime.unboxToBoolean((Object)this.positions().get((Object)pos).map((Function1)new $anonfun$testAndLog$1(this, severity$1)).getOrElse((Function0)new $anonfun$testAndLog$2(this)))) {
            bl = true;
        } else {
            this.positions().update((Object)pos, (Object)severity$1);
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void info0(Position pos, String msg, Reporter.Severity severity, boolean force) {
        block3: {
            block2: {
                Reporter.Severity severity2;
                Reporter.Severity severity3 = severity2 = severity;
                Reporter.Severity severity4 = this.WARNING();
                if (!(severity3 == null ? severity4 != null : !severity3.equals(severity4))) break block2;
                Reporter.Severity severity5 = severity2;
                Reporter.Severity severity6 = this.ERROR();
                if (severity5 != null ? !severity5.equals(severity6) : severity6 != null) break block3;
            }
            if (this.testAndLog(pos, severity)) return;
            this.display(pos, msg, severity);
            return;
        }
        this.display(pos, msg, severity);
    }

    public void reset() {
        super.reset();
        this.positions().clear();
    }

    private void print(Enumeration.Value level$1, Position posIn, String msg$1) {
        Position position = posIn;
        if (position == null || position.equals(null)) {
            this.sbt$LoggerReporter$$log.log(level$1, new $anonfun$print$1(this, msg$1));
        } else {
            Position pos$1 = posIn.inUltimateSource((SourceFile)posIn.source().getOrElse((Function0)new $anonfun$8(this)));
            this.sbt$LoggerReporter$$log.log(level$1, new $anonfun$print$2(this, msg$1, pos$1));
            if (!pos$1.line().isEmpty()) {
                this.sbt$LoggerReporter$$log.log(level$1, new $anonfun$print$3(this, pos$1));
                pos$1.column().filter((Function1)new $anonfun$print$4(this)).foreach((Function1)new $anonfun$print$5(this, level$1));
            }
        }
    }

    private Enumeration.Value severityToLevel(Reporter.Severity severity) {
        Reporter.Severity severity2;
        block5: {
            Enumeration.Value value;
            block3: {
                block4: {
                    block2: {
                        Reporter.Severity severity3 = severity2 = severity;
                        Reporter.Severity severity4 = this.ERROR();
                        if (severity3 != null ? !severity3.equals(severity4) : severity4 != null) break block2;
                        value = Level$.MODULE$.Error();
                        break block3;
                    }
                    Reporter.Severity severity5 = severity2;
                    Reporter.Severity severity6 = this.WARNING();
                    if (severity5 != null ? !severity5.equals(severity6) : severity6 != null) break block4;
                    value = Level$.MODULE$.Warn();
                    break block3;
                }
                Reporter.Severity severity7 = severity2;
                Reporter.Severity severity8 = this.INFO();
                if (severity7 != null ? !severity7.equals(severity8) : severity8 != null) break block5;
                value = Level$.MODULE$.Info();
            }
            return value;
        }
        throw new MatchError((Object)severity2);
    }

    public void display(Position pos, String msg, Reporter.Severity severity) {
        block3: {
            block2: {
                severity.count_$eq(severity.count() + 1);
                Reporter.Severity severity2 = severity;
                Reporter.Severity severity3 = this.ERROR();
                if (severity2 != null ? !severity2.equals(severity3) : severity3 != null) break block2;
                if (this.maximumErrors >= 0 && severity.count() > this.maximumErrors) break block3;
            }
            this.print(this.severityToLevel(severity), pos, msg);
        }
    }

    public void printSummary() {
        if (this.WARNING().count() > 0) {
            this.sbt$LoggerReporter$$log.warn(new $anonfun$printSummary$1(this));
        }
        if (this.ERROR().count() > 0) {
            this.sbt$LoggerReporter$$log.error(new $anonfun$printSummary$2(this));
        }
    }

    public void error(String msg) {
        this.error((Position)new FakePos("scalac"), msg);
    }

    private HashMap<Position, Reporter.Severity> positions() {
        return this.positions;
    }
}

