/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import sbt.AlreadySetup$;
import sbt.BuilderProject;
import sbt.ClasspathUtilities$;
import sbt.ConsoleLogger;
import sbt.Level$;
import sbt.LoadError;
import sbt.LoadResult;
import sbt.LoadSetupDeclined$;
import sbt.LoadSetupError;
import sbt.LoadSuccess;
import sbt.Logger;
import sbt.Path;
import sbt.PathFinder;
import sbt.Project;
import sbt.Project$;
import sbt.Project$$anonfun$sbt$Project$;
import sbt.ProjectInfo;
import sbt.ProjectInfo$;
import sbt.SetupDeclined$;
import sbt.SetupError;
import sbt.SetupInfo;
import sbt.SetupResult;
import scala.Either;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Iterable;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Right;
import scala.ScalaObject;
import scala.Some;
import scala.StringBuilder;
import scala.collection.mutable.HashMap;
import scala.reflect.Manifest;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Project$
implements ScalaObject {
    public static final Project$ MODULE$;
    private final String ProjectClassName;
    private final String PluginProjectDirectoryName;
    private final String BuilderProjectDirectoryName;
    private final Class<? extends Project> DefaultBuilderClass;
    private final String DefaultBuilderClassName;
    private final String DefaultEnvBackingName;
    private final String DefaultOutputDirectoryName;
    private final String BootDirectoryName;

    static {
        new Project$();
    }

    public Project$() {
        this.BootDirectoryName = "boot";
        this.DefaultOutputDirectoryName = "target";
        this.DefaultEnvBackingName = "build.properties";
        this.DefaultBuilderClassName = "sbt.DefaultProject";
        MODULE$ = this;
        this.DefaultBuilderClass = Class.forName(this.DefaultBuilderClassName()).asSubclass(Project.class);
        this.BuilderProjectDirectoryName = "build";
        this.PluginProjectDirectoryName = "plugins";
        this.ProjectClassName = Project.class.getName();
    }

    public Project rootProject(Project p) {
        Option<Project> option;
        while ((option = p.info().parent()) instanceof Some) {
            p = (Project)((Some)option).x();
        }
        None$ none$ = None$.MODULE$;
        Option<Project> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            return p;
        }
        throw new MatchError(option);
    }

    public void showProjectHeader(Project project2) {
        String projectHeader$1 = new StringBuilder().append((Object)"Project ").append((Object)project2.name()).toString();
        project2.log().info(new anonfun.showProjectHeader.1());
        project2.log().info(new anonfun.showProjectHeader.2(projectHeader$1));
        project2.log().info(new anonfun.showProjectHeader.3(projectHeader$1));
    }

    public <P extends Project> Class<P> getProjectClass(String name2, PathFinder classpath, ClassLoader additional, Manifest<P> mf) {
        ClassLoader loader = ClasspathUtilities$.MODULE$.toLoader(classpath, additional);
        Class<?> builderClass = Class.forName(name2, false, loader);
        Class projectClass = mf.erasure();
        Predef$.MODULE$.require(projectClass.isAssignableFrom(builderClass), (Object)new StringBuilder().append((Object)"Builder class '").append(builderClass).append((Object)"' does not extend ").append((Object)projectClass.getName()).append((Object)".").toString());
        return builderClass.asSubclass(projectClass);
    }

    private LoadResult checkOutputDirectoriesImpl(Project project2) {
        ScalaObject scalaObject;
        List projects = project2.topologicalSort();
        HashMap outputDirectories$1 = new HashMap();
        projects.foreach((Function1)new anonfun.checkOutputDirectoriesImpl.1(outputDirectories$1));
        Iterable shared = outputDirectories$1.filter((Function1)new anonfun.11());
        if (shared.isEmpty()) {
            scalaObject = new LoadSuccess(project2);
        } else {
            Iterable s = shared.map((Function1)new anonfun.12());
            String sharedString = s.mkString("\n\t");
            scalaObject = new LoadError(new StringBuilder().append((Object)"The same directory is used for output for multiple projects:\n\t").append((Object)sharedString).append((Object)"\n  (If this is intentional, use 'override def shouldCheckOutputDirectories = false' in your project definition.)").toString());
        }
        return scalaObject;
    }

    private LoadResult checkOutputDirectories(LoadResult result) {
        LoadSuccess loadSuccess;
        LoadSuccess success;
        LoadResult loadResult = result;
        return loadResult instanceof LoadSuccess ? ((success = (loadSuccess = (LoadSuccess)loadResult)).project().shouldCheckOutputDirectories() ? this.checkOutputDirectoriesImpl(success.project()) : success) : loadResult;
    }

    private void checkDependencies(String forProject$1, Iterable<Project> deps, Logger log$3) {
        deps.find((Function1)new anonfun.checkDependencies.1()).foreach((Function1)new anonfun.checkDependencies.2(forProject$1, log$3));
    }

    private Either<String, Class<? extends Project>> getProjectDefinition(ProjectInfo info2, ClassLoader additional$1, Logger buildLog) {
        Right right;
        PathFinder builderProjectPath = info2.builderPath().$div(this.BuilderProjectDirectoryName());
        if (((Path)builderProjectPath).asFile().isDirectory()) {
            PathFinder pluginProjectPath = info2.builderPath().$div(this.PluginProjectDirectoryName());
            ClassLoader classLoader = additional$1;
            Nil$ additionalPaths = classLoader instanceof URLClassLoader ? new BoxedObjectArray((Object[])((URLClassLoader)classLoader).getURLs()).map((Function1)new anonfun.10()) : Nil$.MODULE$;
            BuilderProject builderProject$1 = new BuilderProject(new ProjectInfo(((Path)builderProjectPath).asFile(), (Iterable<Project>)Nil$.MODULE$, (Option<Project>)None$.MODULE$), (Path)pluginProjectPath, (Iterable<Path>)additionalPaths, buildLog);
            right = builderProject$1.compile().run().toLeft((Function0)new anonfun.getProjectDefinition.1()).right().flatMap((Function1)new anonfun.getProjectDefinition.2(additional$1, builderProject$1));
        } else {
            right = new Right(this.DefaultBuilderClass());
        }
        return right;
    }

    public final Project sbt$Project$$initialize(Project p$2, Option setupInfo, Logger log$2) {
        Option option;
        block9: {
            block8: {
                block7: {
                    SetupInfo setupInfo2;
                    option = setupInfo;
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    SetupInfo setup = setupInfo2 = (SetupInfo)some.x();
                    p$2.projectName().update(setup.name());
                    setup.version().foreach((Function1)new anonfun$sbt$Project$$initialize$1(p$2));
                    setup.organization().foreach((Function1)new anonfun$sbt$Project$$initialize$2(p$2));
                    if (!setup.initializeDirectories()) {
                        p$2.setEnvironmentModified(false);
                    }
                    p$2.saveEnvironment().foreach((Function1)new anonfun$sbt$Project$$initialize$3(log$2));
                    if (setup.initializeDirectories()) {
                        p$2.initializeDirectories();
                    }
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                if (BoxesRunTime.unboxToBoolean((Object)p$2.projectInitialize().value())) {
                    p$2.initializeDirectories();
                    p$2.projectInitialize().update(BoxesRunTime.boxToBoolean((boolean)false));
                    p$2.saveEnvironment().foreach((Function1)new anonfun$sbt$Project$$initialize$4(log$2));
                }
            }
            String useName = (String)p$2.projectName().get().getOrElse((Function0)new anonfun.9(p$2));
            this.checkDependencies(useName, p$2.info().dependencies(), log$2);
            return p$2;
        }
        throw new MatchError((Object)option);
    }

    public <P extends Project> P constructProject(ProjectInfo info2, Class<P> builderClass) {
        return (P)((Project)builderClass.getConstructor(ProjectInfo.class).newInstance(info2));
    }

    private LoadError errorLoadingProject(Throwable e$1, Logger log2) {
        log2.trace(new anonfun.errorLoadingProject.1(e$1));
        return new LoadError(new StringBuilder().append((Object)"Error loading project: ").append((Object)e$1.toString()).toString());
    }

    private LoadResult loadProject(ProjectInfo info$1, Option<SetupInfo> setupInfo$1, ClassLoader additional, Logger log$1) {
        LoadResult exceptionResult1 = null;
        try {
            Enumeration.Value oldLevel = log$1.getLevel();
            log$1.setLevel(Level$.MODULE$.Warn());
            Either result = this.getProjectDefinition(info$1, additional, log$1).right().map((Function1)new anonfun.8(info$1, setupInfo$1, log$1));
            log$1.setLevel(oldLevel);
            exceptionResult1 = (LoadResult)result.fold((Function1)new anonfun.loadProject.1(), (Function1)new anonfun.loadProject.2());
        }
        catch (Exception exception) {
            exceptionResult1 = this.errorLoadingProject(exception, log$1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exceptionResult1 = new LoadError("Constructor with one argument of type sbt.ProjectInfo required for project definition.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            InvocationTargetException cause = throwable == null || throwable.equals(null) ? invocationTargetException : invocationTargetException.getCause();
            exceptionResult1 = this.errorLoadingProject(cause, log$1);
        }
        return exceptionResult1;
    }

    public LoadResult loadProject(File projectDirectory, Iterable<Project> deps, Option<Project> parent, ClassLoader additional, Logger log2) {
        SetupResult setupResult;
        block6: {
            LoadResult loadResult;
            block3: {
                ProjectInfo info2;
                block5: {
                    block4: {
                        block2: {
                            info2 = new ProjectInfo(projectDirectory, deps, parent);
                            setupResult = ProjectInfo$.MODULE$.setup(info2, log2);
                            if (!(setupResult instanceof SetupError)) break block2;
                            loadResult = new LoadSetupError(((SetupError)setupResult).message());
                            break block3;
                        }
                        SetupDeclined$ setupDeclined$ = SetupDeclined$.MODULE$;
                        SetupResult setupResult2 = setupResult;
                        if (setupDeclined$ != null ? !setupDeclined$.equals(setupResult2) : setupResult2 != null) break block4;
                        loadResult = LoadSetupDeclined$.MODULE$;
                        break block3;
                    }
                    AlreadySetup$ alreadySetup$ = AlreadySetup$.MODULE$;
                    SetupResult setupResult3 = setupResult;
                    if (alreadySetup$ != null ? !alreadySetup$.equals(setupResult3) : setupResult3 != null) break block5;
                    loadResult = this.loadProject(info2, (Option<SetupInfo>)None$.MODULE$, additional, log2);
                    break block3;
                }
                if (!(setupResult instanceof SetupInfo)) break block6;
                loadResult = this.loadProject(info2, (Option<SetupInfo>)new Some((Object)((SetupInfo)setupResult)), additional, log2);
            }
            return loadResult;
        }
        throw new MatchError((Object)setupResult);
    }

    public LoadResult loadProject(File projectDirectory, Iterable<Project> deps, Option<Project> parent, Logger log2) {
        return this.loadProject(projectDirectory, deps, parent, this.getClass().getClassLoader(), log2);
    }

    public LoadResult loadProject(Path path, Iterable<Project> deps, Option<Project> parent, Logger log2) {
        return this.loadProject(path.asFile(), deps, parent, log2);
    }

    public LoadResult loadProject(Logger log2) {
        return this.checkOutputDirectories(this.loadProject(new File("."), (Iterable<Project>)Nil$.MODULE$, (Option<Project>)None$.MODULE$, log2));
    }

    public LoadResult loadProject() {
        return this.loadProject(this.bootLogger());
    }

    public boolean booted() {
        return Boolean.getBoolean("sbt.boot");
    }

    /*
     * WARNING - void declaration
     */
    public ConsoleLogger bootLogger() {
        void var1_1;
        ConsoleLogger log2 = new ConsoleLogger();
        log2.setLevel(Level$.MODULE$.Debug());
        log2.enableTrace(true);
        return var1_1;
    }

    public String ProjectClassName() {
        return this.ProjectClassName;
    }

    public String PluginProjectDirectoryName() {
        return this.PluginProjectDirectoryName;
    }

    public String BuilderProjectDirectoryName() {
        return this.BuilderProjectDirectoryName;
    }

    public Class<? extends Project> DefaultBuilderClass() {
        return this.DefaultBuilderClass;
    }

    public String DefaultBuilderClassName() {
        return this.DefaultBuilderClassName;
    }

    public String DefaultEnvBackingName() {
        return this.DefaultEnvBackingName;
    }

    public String DefaultOutputDirectoryName() {
        return this.DefaultOutputDirectoryName;
    }

    public String BootDirectoryName() {
        return this.BootDirectoryName;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

