/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import sbt.BufferedLogger;
import sbt.ConsoleLogger;
import sbt.Described;
import sbt.FileFilter;
import sbt.GlobFilter$;
import sbt.HiddenFileFilter$;
import sbt.LoadError;
import sbt.LoadResult;
import sbt.LoadSetupDeclined$;
import sbt.LoadSetupError;
import sbt.LoadSuccess;
import sbt.Logger;
import sbt.NameFilter;
import sbt.Path;
import sbt.Path$;
import sbt.PathFinder;
import sbt.Project;
import sbt.Project$;
import sbt.ProjectInfo;
import sbt.ScalaVersion$;
import sbt.SetupInfo;
import sbt.StringUtilities$;
import sbt.TaskManager;
import sbt.Version;
import sbt.WorkFailure;
import sbt.impl.RunTask$;
import scala.Function0;
import scala.Function1;
import scala.Iterable;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.collection.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.mutable.HashSet;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Project$class {
    public static void $init$(Project $this) {
        $this.log_$eq($this.logImpl());
        $this.projectVersion_$eq($this.property(Manifest$.MODULE$.classType(Version.class), $this.VersionFormat()));
        $this.projectName_$eq($this.propertyLocalF($this.NonEmptyStringFormat(), Manifest$.MODULE$.classType(String.class)));
        $this.projectOrganization_$eq($this.propertyOptional(new Project$.anonfun.3($this), true, Manifest$.MODULE$.classType(String.class), $this.StringFormat()));
        $this.scalaVersion_$eq($this.propertyOptional(new Project$.anonfun.4($this), Manifest$.MODULE$.classType(String.class), $this.StringFormat()));
        $this.sbtVersion_$eq($this.propertyOptional(new Project$.anonfun.5($this), Manifest$.MODULE$.classType(String.class), $this.StringFormat()));
        $this.projectInitialize_$eq($this.propertyOptional(new Project$.anonfun.6($this), Manifest$.MODULE$.classType(Boolean.TYPE), $this.BooleanFormat()));
        $this.projectScratch_$eq($this.propertyOptional(new Project$.anonfun.7($this), Manifest$.MODULE$.classType(Boolean.TYPE), $this.BooleanFormat()));
    }

    private static final TaskManager.Task virtualTask$1(Project $this, String name2, List list) {
        return new TaskManager.Task($this, (Option<String>)None$.MODULE$, (List<TaskManager.Task>)list.filter((Function1)new Project$.anonfun.virtualTask.1.2($this)), false, new Project$.anonfun.virtualTask.1.1($this));
    }

    public static String normalizedName(Project $this) {
        return StringUtilities$.MODULE$.normalize($this.name());
    }

    public static String toString(Project $this) {
        return new StringBuilder().append((Object)"Project ").append($this.projectName().get().getOrElse((Function0)new Project$.anonfun.toString.1($this))).toString();
    }

    public static PathFinder descendents(Project $this, PathFinder parent, FileFilter include) {
        return parent.descendentsExcept(include, $this.defaultExcludes());
    }

    public static FileFilter defaultExcludes(Project $this) {
        return $this.filter(".*").$minus($this.filter(".")).$bar$bar(HiddenFileFilter$.MODULE$);
    }

    public static final Option parentEnvironment(Project $this) {
        return $this.info().parent();
    }

    public static PathFinder watchPaths(Project $this) {
        return Path$.MODULE$.emptyPathFinder();
    }

    public static Set crossScalaVersions(Project $this) {
        Option<Project> option;
        block4: {
            Set set2;
            block3: {
                block2: {
                    option = $this.info().parent();
                    if (!(option instanceof Some)) break block2;
                    set2 = ((Project)((Some)option).x()).crossScalaVersions();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Project> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                set2 = Set$.MODULE$.empty();
            }
            return set2;
        }
        throw new MatchError(option);
    }

    public static boolean disableCrossPaths(Project $this) {
        return $this.crossScalaVersions().isEmpty();
    }

    public static String crossScalaVersionString(Project $this) {
        return $this.disableCrossPaths() ? "" : ScalaVersion$.MODULE$.currentString();
    }

    public static Path crossPath(Project $this, Path base$1) {
        return (Path)ScalaVersion$.MODULE$.withCross($this.disableCrossPaths(), new Project$.anonfun.crossPath.2($this, base$1), new Project$.anonfun.crossPath.1($this, base$1));
    }

    private static Project getProject(Project $this, LoadResult result, Path path) {
        LoadResult loadResult = result;
        LoadSetupDeclined$ loadSetupDeclined$ = LoadSetupDeclined$.MODULE$;
        LoadResult loadResult2 = loadResult;
        if (!(loadSetupDeclined$ != null ? !loadSetupDeclined$.equals(loadResult2) : loadResult2 != null)) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"No project exists at path ").append((Object)path).toString());
        }
        if (loadResult instanceof LoadSetupError) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Error setting up new project at path ").append((Object)Path$.MODULE$).append((Object)" : ").append((Object)((LoadSetupError)loadResult).message()).toString());
        }
        if (loadResult instanceof LoadError) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Error loading project at path ").append((Object)path).append((Object)" : ").append((Object)((LoadError)loadResult).message()).toString());
        }
        if (loadResult instanceof LoadSuccess) {
            return ((LoadSuccess)loadResult).project();
        }
        throw new MatchError((Object)loadResult);
    }

    public static String outputDirectoryName(Project $this) {
        return Project$.MODULE$.DefaultOutputDirectoryName();
    }

    public static String outputRootPath(Project $this) {
        return $this.outputDirectoryName();
    }

    public static Path outputPath(Project $this) {
        return $this.crossPath($this.path($this.outputRootPath()));
    }

    public static Option historyPath(Project $this) {
        return new Some((Object)$this.path($this.outputRootPath()).$div(".history"));
    }

    public static final Path envBackingPath(Project $this) {
        return $this.info().builderPath().$div(Project$.MODULE$.DefaultEnvBackingName());
    }

    public static Project rootProject(Project $this) {
        return Project$.MODULE$.rootProject($this);
    }

    public static Iterable outputDirectories(Project $this) {
        String string = $this.outputRootPath();
        return Nil$.MODULE$.$colon$colon((Object)$this.path(string));
    }

    public static boolean shouldCheckOutputDirectories(Project $this) {
        return true;
    }

    public static boolean parallelExecution(Project $this) {
        Option<Project> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = $this.info().parent();
                    if (!(option instanceof Some)) break block2;
                    bl = ((Project)((Some)option).x()).parallelExecution();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Project> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public static void initializeDirectories(Project $this) {
    }

    public static Project project(Project $this, Path path, String name2, Function1 construct, Seq deps) {
        return Project$.MODULE$.sbt$Project$$initialize((Project)construct.apply((Object)new ProjectInfo(path.asFile(), (Iterable<Project>)deps, (Option<Project>)new Some((Object)$this))), (Option)new Some((Object)new SetupInfo(name2, (Option<Version>)None$.MODULE$, (Option<String>)None$.MODULE$, false)), $this.log());
    }

    public static Project project(Project $this, Path path, String name2, Class builderClass$1, Seq deps) {
        Class clazz = builderClass$1;
        Class<?> clazz2 = $this.getClass();
        Predef$.MODULE$.require(clazz != null ? !clazz.equals(clazz2) : clazz2 != null, (Object)new StringBuilder().append((Object)"Cannot recursively construct projects of same type: ").append((Object)builderClass$1.getName()).toString());
        return $this.project(path, name2, new Project$.anonfun.project.1($this, builderClass$1), (Seq<Project>)deps);
    }

    public static Project project(Project $this, Path path, String name2, Seq deps) {
        return $this.project(path, name2, Project$.MODULE$.DefaultBuilderClass(), (Seq<Project>)deps);
    }

    public static Project project(Project $this, Path path, Seq deps) {
        return Project$class.getProject($this, Project$.MODULE$.loadProject(path, (Iterable<Project>)deps, (Option<Project>)new Some((Object)$this), $this.log()), path);
    }

    public static NameFilter filter(Project $this, String simplePattern) {
        return GlobFilter$.MODULE$.apply(simplePattern);
    }

    public static Path path(Project $this, String component) {
        return $this.info().projectPath().$div(component);
    }

    private static void showBuildOrder(Project $this, Iterable<Project> order) {
        $this.log().debug(new Project$.anonfun.showBuildOrder.1($this));
        order.foreach((Function1)new Project$.anonfun.showBuildOrder.2($this));
        $this.log().debug(new Project$.anonfun.showBuildOrder.3($this));
    }

    public static Option act(Project $this, String name$1) {
        Option option;
        block6: {
            Some some;
            block4: {
                block5: {
                    List definedTasks$1;
                    block3: {
                        List ordered = $this.topologicalSort();
                        definedTasks$1 = ordered.flatMap((Function1)new Project$.anonfun.2($this, name$1));
                        if (!definedTasks$1.isEmpty()) break block3;
                        some = new Some((Object)new StringBuilder().append((Object)"Action '").append((Object)name$1).append((Object)"' does not exist.").toString());
                        break block4;
                    }
                    option = $this.tasks().get((Object)name$1);
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                    TaskManager.Task virtual = Project$class.virtualTask$1($this, name$1, definedTasks$1);
                    some = virtual.dependencies().size() == definedTasks$1.size() ? Project$class.run($this, virtual, name$1) : new Some((Object)new StringBuilder().append((Object)"Cannot run interactive action '").append((Object)name$1).append((Object)"' defined on multiple subprojects (change to the desired project with 'project <name>').").toString());
                    break block4;
                }
                if (!(option instanceof Some)) break block6;
                some = Project$class.run($this, (TaskManager.Task)((Some)option).x(), name$1);
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    private static Option<String> run(Project $this, TaskManager.Task task2, String taskName2) {
        List<WorkFailure<TaskManager.Task>> list = RunTask$.MODULE$.apply(task2, taskName2, $this.parallelExecution());
        Nil$ nil$ = Nil$.MODULE$;
        List<WorkFailure<TaskManager.Task>> list2 = list;
        return !(nil$ != null ? !nil$.equals(list2) : list2 != null) ? None$.MODULE$ : new Some((Object)Predef$.MODULE$.Set().apply(list).mkString("\n"));
    }

    public static Option call(Project $this, String name2, String[] parameters) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = $this.methods().get((Object)name2);
                    if (!(option instanceof Some)) break block2;
                    some = Project$class.run($this, ((TaskManager.MethodTask)((Some)option).x()).apply(parameters), name2);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                some = new Some((Object)new StringBuilder().append((Object)"Method '").append((Object)name2).append((Object)"' does not exist.").toString());
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    public static Iterable projectNames(Project $this) {
        HashSet names$1 = new HashSet();
        names$1.$plus$plus$eq($this.subProjects().keys());
        $this.topologicalSort().foreach((Function1)new Project$.anonfun.projectNames.1($this, names$1));
        return names$1.toList();
    }

    public static Map subProjects(Project $this) {
        return Map$.MODULE$.empty();
    }

    private static <T> Map<String, T> deep(Project $this, Function1<Project, Map<String, T>> p$1) {
        ObjectRef tasks$1 = new ObjectRef((Object)new TreeMap((Function1)new Project$.anonfun.1($this)));
        $this.topologicalSort().foreach((Function1)new Project$.anonfun.deep.1($this, p$1, tasks$1));
        return (SortedMap)tasks$1.elem;
    }

    public static Map deepTasks(Project $this) {
        return Project$class.deep($this, new Project$.anonfun.deepTasks.1($this));
    }

    public static Map deepMethods(Project $this) {
        return Project$class.deep($this, new Project$.anonfun.deepMethods.1($this));
    }

    private static String descriptionList(Project $this, Map<String, Described> described) {
        StringBuilder buffer$1 = new StringBuilder();
        described.foreach((Function1)new Project$.anonfun.descriptionList.1($this, buffer$1));
        return buffer$1.toString();
    }

    public static final Map tasksAndMethods(Project $this) {
        return TreeMap$.MODULE$.empty((Function1)new Project$.anonfun.tasksAndMethods.1($this)).$plus$plus($this.methods()).$plus$plus($this.tasks());
    }

    public static String taskAndMethodList(Project $this) {
        return Project$class.descriptionList($this, $this.tasksAndMethods());
    }

    public static final Option taskName(Project $this, TaskManager.Task task$1) {
        return $this.tasks().find((Function1)new Project$.anonfun.taskName.1($this, task$1)).map((Function1)new Project$.anonfun.taskName.2($this));
    }

    public static String taskList(Project $this) {
        return Project$class.descriptionList($this, $this.deepTasks());
    }

    public static String methodList(Project $this) {
        return Project$class.descriptionList($this, $this.methods());
    }

    public static Iterable methodNames(Project $this) {
        return $this.methods().keys().toList();
    }

    public static Iterable taskNames(Project $this) {
        return $this.deepTasks().keys().toList();
    }

    public static boolean scratch(Project $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.projectScratch().value());
    }

    public static final String organization(Project $this) {
        return $this.projectOrganization().value();
    }

    public static final Version version(Project $this) {
        return $this.projectVersion().value();
    }

    public static final String name(Project $this) {
        return $this.projectName().value();
    }

    public static Logger logImpl(Project $this) {
        return new BufferedLogger(new ConsoleLogger());
    }
}

