/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import sbt.LogEvent;
import sbt.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.ScalaObject;
import scala.Seq;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchronizedLogger
extends Logger
implements ScalaObject {
    private final Logger delegate;

    public SynchronizedLogger(Logger delegate) {
        this.delegate = delegate;
    }

    @Override
    public void logAll(Seq<LogEvent> events) {
        SynchronizedLogger synchronizedLogger = this;
        synchronized (synchronizedLogger) {
            this.delegate.logAll(events);
            return;
        }
    }

    @Override
    public void control(Enumeration.Value event, Function0<String> message) {
        SynchronizedLogger synchronizedLogger = this;
        synchronized (synchronizedLogger) {
            this.delegate.control(event, message);
            return;
        }
    }

    @Override
    public void success(Function0<String> message) {
        SynchronizedLogger synchronizedLogger = this;
        synchronized (synchronizedLogger) {
            this.delegate.success(message);
            return;
        }
    }

    @Override
    public void log(Enumeration.Value level, Function0<String> message) {
        SynchronizedLogger synchronizedLogger = this;
        synchronized (synchronizedLogger) {
            this.delegate.log(level, message);
            return;
        }
    }

    @Override
    public void trace(Function0<Throwable> t) {
        SynchronizedLogger synchronizedLogger = this;
        synchronized (synchronizedLogger) {
            this.delegate.trace(t);
            return;
        }
    }

    @Override
    public boolean traceEnabled() {
        SynchronizedLogger synchronizedLogger = this;
        synchronized (synchronizedLogger) {
            return BoxesRunTime.unboxToBoolean((Object)BoxesRunTime.boxToBoolean((boolean)this.delegate.traceEnabled()));
        }
    }

    @Override
    public void enableTrace(boolean enabled) {
        SynchronizedLogger synchronizedLogger = this;
        synchronized (synchronizedLogger) {
            this.delegate.enableTrace(enabled);
            return;
        }
    }

    @Override
    public void setLevel(Enumeration.Value newLevel) {
        SynchronizedLogger synchronizedLogger = this;
        synchronized (synchronizedLogger) {
            this.delegate.setLevel(newLevel);
            return;
        }
    }

    @Override
    public Enumeration.Value getLevel() {
        SynchronizedLogger synchronizedLogger = this;
        synchronized (synchronizedLogger) {
            return this.delegate.getLevel();
        }
    }
}

