/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.rmi.RemoteException;
import sbt.FileTasks$;
import sbt.FileUtilities$;
import sbt.Hash$;
import sbt.Logger;
import sbt.Pack$;
import sbt.Path;
import sbt.Path$;
import sbt.PathFinder;
import sbt.RelativePath;
import sbt.SignConfiguration;
import sbt.SignJar;
import sbt.SignJar$;
import sbt.WebstartJarResource;
import sbt.WebstartOptions;
import sbt.WebstartScalaProject$;
import sbt.WebstartScalaProject$$anonfun$sbt$WebstartScalaProject$;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.Iterable;
import scala.Left;
import scala.List;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.Utility$;

public final class WebstartScalaProject$
implements ScalaObject {
    public static final WebstartScalaProject$ MODULE$;

    static {
        new WebstartScalaProject$();
    }

    public WebstartScalaProject$() {
        MODULE$ = this;
    }

    public final void sbt$WebstartScalaProject$$verifyOptions(WebstartOptions options$2) {
        Predef$.MODULE$.require(this.sbt$WebstartScalaProject$$isInDirectory(options$2.webstartOutputDirectory(), options$2.webstartLibDirectory()), (Object)new StringBuilder().append((Object)"Webstart dependency directory (").append((Object)options$2.webstartLibDirectory()).append((Object)") must be a subdirectory of webstart output directory (").append((Object)options$2.webstartOutputDirectory()).append((Object)").").toString());
        Predef$.MODULE$.require(this.sbt$WebstartScalaProject$$isInDirectory(options$2.webstartOutputDirectory(), options$2.jnlpFile()), (Object)new StringBuilder().append((Object)"Webstart JNLP file output location (").append((Object)options$2.jnlpFile()).append((Object)") must be in the webstart output directory (").append((Object)options$2.webstartOutputDirectory()).append((Object)").").toString());
        options$2.webstartZip().foreach((Function1)new anonfun$sbt$WebstartScalaProject$$verifyOptions$1(options$2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean sbt$WebstartScalaProject$$isInDirectory(Path directory, Path check) {
        if (!Path$.MODULE$.relativize(directory, check).isDefined()) return false;
        Path path = directory;
        Path path2 = check;
        if (path == null) {
            if (path2 == null) return false;
            return true;
        } else if (((Object)path).equals(path2)) return false;
        return true;
    }

    public final Seq sbt$WebstartScalaProject$$jarResources(Iterable mainJars, Iterable libraries2) {
        List list = mainJars.map((Function1)new anonfun.7()).toList();
        return libraries2.map((Function1)new anonfun$sbt$WebstartScalaProject$$jarResources$1()).toList().$colon$colon$colon(list);
    }

    public final WebstartJarResource sbt$WebstartScalaProject$$jarResource(boolean isMain2, Path jar) {
        return new WebstartJarResource(jar.asFile().getName(), jar.relativePathString("/"), isMain2);
    }

    public final Option sbt$WebstartScalaProject$$writeXML(Elem xml, Path outputPath$1, Logger log$8) {
        Option option;
        String xmlString$1 = Utility$.MODULE$.toXML((Node)xml, false);
        if (outputPath$1.exists()) {
            Either result = Hash$.MODULE$.apply(xmlString$1, log$8).right().flatMap((Function1)new anonfun.6(outputPath$1, log$8, xmlString$1));
            option = (Option)result.fold((Function1)new anonfun$sbt$WebstartScalaProject$$writeXML$2(), (Function1)new anonfun$sbt$WebstartScalaProject$$writeXML$3());
        } else {
            log$8.debug(new anonfun$sbt$WebstartScalaProject$$writeXML$1(outputPath$1));
            option = this.sbt$WebstartScalaProject$$writeXML(xmlString$1, outputPath$1, log$8);
        }
        return option;
    }

    public final Option sbt$WebstartScalaProject$$writeXML(String xmlString, Path outputPath, Logger log2) {
        return FileUtilities$.MODULE$.write(outputPath.asFile(), xmlString, log2);
    }

    public final Either sbt$WebstartScalaProject$$copyJar(Path jar$6, Path targetDirectory, Logger log$6) {
        PathFinder targetJar$2 = targetDirectory.$div(jar$6.asFile().getName());
        return FileTasks$.MODULE$.runOption("copy jar", FileTasks$.MODULE$.wrapProduct(new anonfun$sbt$WebstartScalaProject$$copyJar$1((Path)targetJar$2)).from(jar$6), log$6, new anonfun$sbt$WebstartScalaProject$$copyJar$2(jar$6, log$6, (Path)targetJar$2)).toLeft((Function0)new anonfun$sbt$WebstartScalaProject$$copyJar$3((Path)targetJar$2));
    }

    public final Either sbt$WebstartScalaProject$$pack200Only(Path jar$5, Path targetDirectory, Logger log$5) {
        Option<String> option;
        block4: {
            Left left;
            block3: {
                Path packedJar$2;
                block2: {
                    PathFinder targetJar = targetDirectory.$div(jar$5.asFile().getName());
                    packedJar$2 = this.packPath((Path)targetJar);
                    Option<String> packResult = FileTasks$.MODULE$.runOption("pack200", FileTasks$.MODULE$.wrapProduct(new anonfun.4(packedJar$2)).from(jar$5), log$5, new anonfun.5(jar$5, log$5, packedJar$2));
                    option = packResult;
                    if (!(option instanceof Some)) break block2;
                    left = new Left(((Some)option).x());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                left = this.sbt$WebstartScalaProject$$copyJar(jar$5, targetDirectory, log$5).right().map((Function1)new anonfun$sbt$WebstartScalaProject$$pack200Only$1(packedJar$2));
            }
            return left;
        }
        throw new MatchError(option);
    }

    public final Option sbt$WebstartScalaProject$$signAndPack(Path jarPath, Path signedPath$1, Path out$1, String alias$1, Seq options$3, Logger log$2) {
        return Pack$.MODULE$.pack(jarPath, out$1, log$2).orElse((Function0)new anonfun$sbt$WebstartScalaProject$$signAndPack$1(signedPath$1, out$1, log$2)).orElse((Function0)new anonfun$sbt$WebstartScalaProject$$signAndPack$2(signedPath$1, alias$1, options$3, log$2)).orElse((Function0)new anonfun$sbt$WebstartScalaProject$$signAndPack$3(signedPath$1, out$1, log$2)).orElse((Function0)new anonfun$sbt$WebstartScalaProject$$signAndPack$4(signedPath$1, out$1, log$2)).orElse((Function0)new anonfun$sbt$WebstartScalaProject$$signAndPack$5(signedPath$1, options$3, log$2));
    }

    public final Either sbt$WebstartScalaProject$$signAndPack200(Path jar$2, SignConfiguration signConfiguration$1, Path targetDirectory, Logger log$1) {
        PathFinder signedJar$1 = targetDirectory.$div(jar$2.asFile().getName());
        Path packedJar$1 = this.packPath((Path)signedJar$1);
        return FileTasks$.MODULE$.runOption("sign and pack200", FileTasks$.MODULE$.wrapProducts(new anonfun$sbt$WebstartScalaProject$$signAndPack200$1((Path)signedJar$1, packedJar$1)).from(jar$2), log$1, new anonfun$sbt$WebstartScalaProject$$signAndPack200$2(jar$2, signConfiguration$1, log$1, (Path)signedJar$1, packedJar$1)).toLeft((Function0)new anonfun$sbt$WebstartScalaProject$$signAndPack200$3((Path)signedJar$1, packedJar$1));
    }

    public final Either sbt$WebstartScalaProject$$gzipJar(Path jar$7, boolean deleteOriginal$2, Logger log$7) {
        Path gzipJar$1 = this.gzipJarPath(jar$7);
        return FileTasks$.MODULE$.runOption("gzip", FileTasks$.MODULE$.wrapProduct(new anonfun$sbt$WebstartScalaProject$$gzipJar$1(gzipJar$1)).from(jar$7), log$7, new anonfun$sbt$WebstartScalaProject$$gzipJar$2(jar$7, deleteOriginal$2, log$7, gzipJar$1)).toLeft((Function0)new anonfun$sbt$WebstartScalaProject$$gzipJar$3(gzipJar$1));
    }

    public final Option sbt$WebstartScalaProject$$signAndVerify(Path jar$3, SignConfiguration signConfiguration$2, Path targetJar, Logger log$3) {
        SignJar.SignOption signOption = SignJar$.MODULE$.signedJar(targetJar);
        return SignJar$.MODULE$.sign(jar$3, signConfiguration$2.alias(), (Seq<SignJar.SignOption>)signConfiguration$2.options().toList().$colon$colon((Object)signOption), log$3).orElse((Function0)new anonfun$sbt$WebstartScalaProject$$signAndVerify$1(jar$3, signConfiguration$2, log$3));
    }

    public final Either sbt$WebstartScalaProject$$signOnly(Path jar$4, SignConfiguration signConfiguration$3, Path targetDirectory, Logger log$4) {
        PathFinder targetJar$1 = targetDirectory.$div(jar$4.asFile().getName());
        return FileTasks$.MODULE$.runOption("sign", FileTasks$.MODULE$.wrapProduct(new anonfun$sbt$WebstartScalaProject$$signOnly$1((Path)targetJar$1)).from(jar$4), log$4, new anonfun$sbt$WebstartScalaProject$$signOnly$2(jar$4, signConfiguration$3, log$4, (Path)targetJar$1)).toLeft((Function0)new anonfun$sbt$WebstartScalaProject$$signOnly$3((Path)targetJar$1));
    }

    private Path packPath(Path jar) {
        return this.appendExtension(jar, ".pack");
    }

    private Path gzipJarPath(Path jar) {
        return this.appendExtension(jar, ".gz");
    }

    private Path appendExtension(Path jar, String newExtension) {
        PathFinder pathFinder2;
        Path path = jar;
        if (path instanceof RelativePath) {
            RelativePath relativePath;
            RelativePath rp = relativePath = (RelativePath)path;
            pathFinder2 = rp.parentPath().$div(new StringBuilder().append((Object)rp.component()).append((Object)newExtension).toString());
        } else {
            pathFinder2 = path;
        }
        return pathFinder2;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

