/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.DefaultPomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;

public class PomModuleDescriptorBuilder {
    private static final int DEPENDENCY_MANAGEMENT_KEY_PARTS_COUNT = 4;
    public static final Configuration[] MAVEN2_CONFIGURATIONS = new Configuration[]{new Configuration("default", Configuration.Visibility.PUBLIC, "runtime dependencies and master artifact can be used with this conf", new String[]{"runtime", "master"}, true, null), new Configuration("master", Configuration.Visibility.PUBLIC, "contains only the artifact published by this module itself, with no transitive dependencies", new String[0], true, null), new Configuration("compile", Configuration.Visibility.PUBLIC, "this is the default scope, used if none is specified. Compile dependencies are available in all classpaths.", new String[0], true, null), new Configuration("provided", Configuration.Visibility.PUBLIC, "this is much like compile, but indicates you expect the JDK or a container to provide it. It is only available on the compilation classpath, and is not transitive.", new String[0], true, null), new Configuration("runtime", Configuration.Visibility.PUBLIC, "this scope indicates that the dependency is not required for compilation, but is for execution. It is in the runtime and test classpaths, but not the compile classpath.", new String[]{"compile"}, true, null), new Configuration("test", Configuration.Visibility.PRIVATE, "this scope indicates that the dependency is not required for normal use of the application, and is only available for the test compilation and execution phases.", new String[]{"runtime"}, true, null), new Configuration("system", Configuration.Visibility.PUBLIC, "this scope is similar to provided except that you have to provide the JAR which contains it explicitly. The artifact is always available and is not looked up in a repository.", new String[0], true, null), new Configuration("sources", Configuration.Visibility.PUBLIC, "this configuration contains the source artifact of this module, if any.", new String[0], true, null), new Configuration("javadoc", Configuration.Visibility.PUBLIC, "this configuration contains the javadoc artifact of this module, if any.", new String[0], true, null), new Configuration("optional", Configuration.Visibility.PUBLIC, "contains all optional dependencies", new String[0], true, null)};
    static final Map MAVEN2_CONF_MAPPING = new HashMap();
    private static final String DEPENDENCY_MANAGEMENT = "m:dependency.management";
    private static final String PROPERTIES = "m:properties";
    private static final String EXTRA_INFO_DELIMITER = "__";
    private static final Collection JAR_PACKAGINGS = Arrays.asList("ejb", "bundle", "maven-plugin");
    private final DefaultModuleDescriptor ivyModuleDescriptor;
    private ModuleRevisionId mrid;
    private DefaultArtifact mainArtifact;
    private ParserSettings parserSettings;

    public PomModuleDescriptorBuilder(ModuleDescriptorParser parser, Resource res, ParserSettings ivySettings) {
        this.ivyModuleDescriptor = new DefaultModuleDescriptor(parser, res);
        this.ivyModuleDescriptor.setResolvedPublicationDate(new Date(res.getLastModified()));
        for (int i = 0; i < MAVEN2_CONFIGURATIONS.length; ++i) {
            this.ivyModuleDescriptor.addConfiguration(MAVEN2_CONFIGURATIONS[i]);
        }
        this.ivyModuleDescriptor.setMappingOverride(true);
        this.ivyModuleDescriptor.addExtraAttributeNamespace("m", Ivy.getIvyHomeURL() + "maven");
        this.parserSettings = ivySettings;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.ivyModuleDescriptor;
    }

    public void setModuleRevId(String groupId, String artifactId, String version) {
        this.mrid = ModuleRevisionId.newInstance(groupId, artifactId, version);
        this.ivyModuleDescriptor.setModuleRevisionId(this.mrid);
        if (version == null || version.endsWith("SNAPSHOT")) {
            this.ivyModuleDescriptor.setStatus("integration");
        } else {
            this.ivyModuleDescriptor.setStatus("release");
        }
    }

    public void setHomePage(String homePage) {
        this.ivyModuleDescriptor.setHomePage(homePage);
    }

    public void setDescription(String description) {
        this.ivyModuleDescriptor.setDescription(description);
    }

    public void setLicenses(License[] licenses) {
        for (int i = 0; i < licenses.length; ++i) {
            this.ivyModuleDescriptor.addLicense(licenses[i]);
        }
    }

    public void addMainArtifact(String artifactId, String packaging) {
        if ("pom".equals(packaging)) {
            DefaultArtifact artifact;
            ArtifactOrigin artifactOrigin;
            DependencyResolver resolver = this.parserSettings.getResolver(this.mrid);
            if (resolver != null && !ArtifactOrigin.isUnknown(artifactOrigin = resolver.locate(artifact = new DefaultArtifact(this.mrid, new Date(), artifactId, "jar", "jar")))) {
                this.mainArtifact = artifact;
                this.ivyModuleDescriptor.addArtifact("master", this.mainArtifact);
            }
            return;
        }
        String ext = JAR_PACKAGINGS.contains(packaging) ? "jar" : packaging;
        this.mainArtifact = new DefaultArtifact(this.mrid, new Date(), artifactId, packaging, ext);
        this.ivyModuleDescriptor.addArtifact("master", this.mainArtifact);
    }

    public void addDependency(Resource res, PomReader.PomDependencyData dep) {
        String version;
        String scope = dep.getScope();
        if (scope != null && scope.length() > 0 && !MAVEN2_CONF_MAPPING.containsKey(scope)) {
            scope = "compile";
        }
        version = (version = dep.getVersion()) == null || version.length() == 0 ? this.getDefaultVersion(dep) : version;
        ModuleRevisionId moduleRevId = ModuleRevisionId.newInstance(dep.getGroupId(), dep.getArtifactId(), version);
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(this.ivyModuleDescriptor, moduleRevId, true, false, true);
        scope = scope == null || scope.length() == 0 ? this.getDefaultScope(dep) : scope;
        ConfMapper mapping = (ConfMapper)MAVEN2_CONF_MAPPING.get(scope);
        mapping.addMappingConfs(dd, dep.isOptional());
        HashMap<String, String> extraAtt = new HashMap<String, String>();
        if (dep.getClassifier() != null || dep.getType() != null) {
            String type = "jar";
            if (dep.getType() != null) {
                type = dep.getType();
            }
            if (dep.getClassifier() != null) {
                extraAtt.put("m:classifier", dep.getClassifier());
            }
            DefaultDependencyArtifactDescriptor depArtifact = new DefaultDependencyArtifactDescriptor(dd, dd.getDependencyId().getName(), type, type, null, extraAtt);
            String optionalizedScope = dep.isOptional() ? "optional" : scope;
            dd.addDependencyArtifact(optionalizedScope, depArtifact);
        }
        Iterator itExcl = dep.getExcludedModules().iterator();
        while (itExcl.hasNext()) {
            ModuleId excludedModule = (ModuleId)itExcl.next();
            String[] confs = dd.getModuleConfigurations();
            for (int k = 0; k < confs.length; ++k) {
                dd.addExcludeRule(confs[k], new DefaultExcludeRule(new ArtifactId(excludedModule, "*", "*", "*"), ExactPatternMatcher.INSTANCE, null));
            }
        }
        this.ivyModuleDescriptor.addDependency(dd);
    }

    public void addDependency(DependencyDescriptor descriptor) {
        this.ivyModuleDescriptor.addDependency(descriptor);
    }

    public void addDependencyMgt(PomDependencyMgt dep) {
        String key = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForVersion(dep.getGroupId(), dep.getArtifactId());
        this.ivyModuleDescriptor.addExtraInfo(key, dep.getVersion());
        if (dep.getScope() != null) {
            String scopeKey = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForScope(dep.getGroupId(), dep.getArtifactId());
            this.ivyModuleDescriptor.addExtraInfo(scopeKey, dep.getScope());
        }
        this.ivyModuleDescriptor.addDependencyDescriptorMediator(ModuleId.newInstance(dep.getGroupId(), dep.getArtifactId()), ExactPatternMatcher.INSTANCE, new OverrideDependencyDescriptorMediator(null, dep.getVersion()));
    }

    public void addPlugin(PomDependencyMgt plugin) {
        String pluginValue = plugin.getGroupId() + EXTRA_INFO_DELIMITER + plugin.getArtifactId() + EXTRA_INFO_DELIMITER + plugin.getVersion();
        String pluginExtraInfo = (String)this.ivyModuleDescriptor.getExtraInfo().get("m:maven.plugins");
        pluginExtraInfo = pluginExtraInfo == null ? pluginValue : pluginExtraInfo + "|" + pluginValue;
        this.ivyModuleDescriptor.getExtraInfo().put("m:maven.plugins", pluginExtraInfo);
    }

    public static List getPlugins(ModuleDescriptor md) {
        ArrayList<PomPluginElement> result = new ArrayList<PomPluginElement>();
        String plugins = (String)md.getExtraInfo().get("m:maven.plugins");
        if (plugins == null) {
            return new ArrayList();
        }
        String[] pluginsArray = plugins.split("\\|");
        for (int i = 0; i < pluginsArray.length; ++i) {
            String[] parts = pluginsArray[i].split(EXTRA_INFO_DELIMITER);
            result.add(new PomPluginElement(parts[0], parts[1], parts[2]));
        }
        return result;
    }

    private String getDefaultVersion(PomReader.PomDependencyData dep) {
        String key = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForVersion(dep.getGroupId(), dep.getArtifactId());
        return (String)this.ivyModuleDescriptor.getExtraInfo().get(key);
    }

    private String getDefaultScope(PomReader.PomDependencyData dep) {
        String key = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForScope(dep.getGroupId(), dep.getArtifactId());
        String result = (String)this.ivyModuleDescriptor.getExtraInfo().get(key);
        if (result == null || !MAVEN2_CONF_MAPPING.containsKey(result)) {
            result = "compile";
        }
        return result;
    }

    private static String getDependencyMgtExtraInfoKeyForVersion(String groupId, String artifaceId) {
        return "m:dependency.management__" + groupId + EXTRA_INFO_DELIMITER + artifaceId + EXTRA_INFO_DELIMITER + "version";
    }

    private static String getDependencyMgtExtraInfoKeyForScope(String groupId, String artifaceId) {
        return "m:dependency.management__" + groupId + EXTRA_INFO_DELIMITER + artifaceId + EXTRA_INFO_DELIMITER + "scope";
    }

    private static String getPropertyExtraInfoKey(String propertyName) {
        return "m:properties__" + propertyName;
    }

    public static Map getDependencyManagementMap(ModuleDescriptor md) {
        LinkedHashMap ret = new LinkedHashMap();
        Iterator iterator = md.getExtraInfo().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(DEPENDENCY_MANAGEMENT)) continue;
            String[] parts = key.split(EXTRA_INFO_DELIMITER);
            if (parts.length != 4) {
                Message.warn("what seem to be a dependency management extra info doesn't match expected pattern: " + key);
                continue;
            }
            ret.put(ModuleId.newInstance(parts[1], parts[2]), entry.getValue());
        }
        return ret;
    }

    public static List getDependencyManagements(ModuleDescriptor md) {
        ArrayList<DefaultPomDependencyMgt> result = new ArrayList<DefaultPomDependencyMgt>();
        Iterator iterator = md.getExtraInfo().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(DEPENDENCY_MANAGEMENT)) continue;
            String[] parts = key.split(EXTRA_INFO_DELIMITER);
            if (parts.length != 4) {
                Message.warn("what seem to be a dependency management extra info doesn't match expected pattern: " + key);
                continue;
            }
            String versionKey = "m:dependency.management__" + parts[1] + EXTRA_INFO_DELIMITER + parts[2] + EXTRA_INFO_DELIMITER + "version";
            String scopeKey = "m:dependency.management__" + parts[1] + EXTRA_INFO_DELIMITER + parts[2] + EXTRA_INFO_DELIMITER + "scope";
            String version = (String)md.getExtraInfo().get(versionKey);
            String scope = (String)md.getExtraInfo().get(scopeKey);
            result.add(new DefaultPomDependencyMgt(parts[1], parts[2], version, scope));
        }
        return result;
    }

    public void addExtraInfos(Map extraAttributes) {
        Iterator it = extraAttributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.addExtraInfo(key, value);
        }
    }

    private void addExtraInfo(String key, String value) {
        if (!this.ivyModuleDescriptor.getExtraInfo().containsKey(key)) {
            this.ivyModuleDescriptor.addExtraInfo(key, value);
        }
    }

    public static Map extractPomProperties(Map extraInfo) {
        HashMap r = new HashMap();
        Iterator it = extraInfo.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry extraInfoEntry = it.next();
            if (!((String)extraInfoEntry.getKey()).startsWith(PROPERTIES)) continue;
            String prop = ((String)extraInfoEntry.getKey()).substring(PROPERTIES.length() + EXTRA_INFO_DELIMITER.length());
            r.put(prop, extraInfoEntry.getValue());
        }
        return r;
    }

    public void addProperty(String propertyName, String value) {
        this.addExtraInfo(PomModuleDescriptorBuilder.getPropertyExtraInfoKey(propertyName), value);
    }

    public Artifact getMainArtifact() {
        return this.mainArtifact;
    }

    public Artifact getSourceArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "source", "jar", null, Collections.singletonMap("m:classifier", "sources"));
    }

    public Artifact getJavadocArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "javadoc", "jar", null, Collections.singletonMap("m:classifier", "javadoc"));
    }

    public void addSourceArtifact() {
        this.ivyModuleDescriptor.addArtifact("sources", this.getSourceArtifact());
    }

    public void addJavadocArtifact() {
        this.ivyModuleDescriptor.addArtifact("javadoc", this.getJavadocArtifact());
    }

    static {
        MAVEN2_CONF_MAPPING.put("compile", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("compile", "compile(*)");
                    dd.addDependencyConfiguration("compile", "master(*)");
                    dd.addDependencyConfiguration("runtime", "runtime(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("provided", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "provided(*)");
                    dd.addDependencyConfiguration("optional", "runtime(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("provided", "compile(*)");
                    dd.addDependencyConfiguration("provided", "provided(*)");
                    dd.addDependencyConfiguration("provided", "runtime(*)");
                    dd.addDependencyConfiguration("provided", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("runtime", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "provided(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("runtime", "compile(*)");
                    dd.addDependencyConfiguration("runtime", "runtime(*)");
                    dd.addDependencyConfiguration("runtime", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("test", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                dd.addDependencyConfiguration("test", "runtime(*)");
                dd.addDependencyConfiguration("test", "master(*)");
            }
        });
        MAVEN2_CONF_MAPPING.put("system", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                dd.addDependencyConfiguration("system", "master(*)");
            }
        });
    }

    private static class PomPluginElement
    implements PomDependencyMgt {
        private String groupId;
        private String artifactId;
        private String version;

        public PomPluginElement(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getScope() {
            return null;
        }
    }

    static interface ConfMapper {
        public void addMappingConfs(DefaultDependencyDescriptor var1, boolean var2);
    }
}

