/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.settings.IvyPattern;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.util.MDResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public abstract class AbstractPatternsBasedResolver
extends BasicResolver {
    private static final Map IVY_ARTIFACT_ATTRIBUTES = new HashMap();
    private List ivyPatterns = new ArrayList();
    private List artifactPatterns = new ArrayList();
    private boolean m2compatible = false;

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this.ivyPatterns, DefaultArtifact.newIvyArtifact(mrid, data.getDate()), this.getRMDParser(dd, data), data.getDate());
    }

    protected ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this.artifactPatterns, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    protected ResolvedResource findResourceUsingPatterns(ModuleRevisionId moduleRevision, List patternList, Artifact artifact, ResourceMDParser rmdparser, Date date) {
        ArrayList<ResolvedResource> resolvedResources = new ArrayList<ResolvedResource>();
        HashSet<String> foundRevisions = new HashSet<String>();
        boolean dynamic = this.getSettings().getVersionMatcher().isDynamic(moduleRevision);
        boolean stop = false;
        Iterator iter = patternList.iterator();
        while (iter.hasNext() && !stop) {
            String pattern = (String)iter.next();
            ResolvedResource rres = this.findResourceUsingPattern(moduleRevision, pattern, artifact, rmdparser, date);
            if (rres == null || foundRevisions.contains(rres.getRevision())) continue;
            foundRevisions.add(rres.getRevision());
            resolvedResources.add(rres);
            stop = !dynamic;
        }
        if (resolvedResources.size() > 1) {
            ResolvedResource[] rress = resolvedResources.toArray(new ResolvedResource[resolvedResources.size()]);
            return this.findResource(rress, rmdparser, moduleRevision, date);
        }
        if (resolvedResources.size() == 1) {
            return (ResolvedResource)resolvedResources.get(0);
        }
        return null;
    }

    protected abstract ResolvedResource findResourceUsingPattern(ModuleRevisionId var1, String var2, Artifact var3, ResourceMDParser var4, Date var5);

    public ResolvedResource findResource(ResolvedResource[] rress, ResourceMDParser rmdparser, ModuleRevisionId mrid, Date date) {
        String name = this.getName();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        ResolvedResource found = null;
        List sorted = this.getLatestStrategy().sort(rress);
        ArrayList<String> rejected = new ArrayList<String>();
        ArrayList<ModuleRevisionId> foundBlacklisted = new ArrayList<ModuleRevisionId>();
        IvyContext context = IvyContext.getContext();
        ListIterator iter = sorted.listIterator(sorted.size());
        while (iter.hasPrevious()) {
            ResolvedResource rres = (ResolvedResource)iter.previous();
            if (this.filterNames(new ArrayList<String>(Collections.singleton(rres.getRevision()))).isEmpty()) {
                Message.debug("\t" + name + ": filtered by name: " + rres);
                continue;
            }
            if (date != null && rres.getLastModified() > date.getTime()) {
                Message.verbose("\t" + name + ": too young: " + rres);
                rejected.add(rres.getRevision() + " (" + rres.getLastModified() + ")");
                continue;
            }
            ModuleRevisionId foundMrid = ModuleRevisionId.newInstance(mrid, rres.getRevision());
            ResolveData data = context.getResolveData();
            if (data != null && data.getReport() != null && data.isBlacklisted(data.getReport().getConfiguration(), foundMrid)) {
                Message.debug("\t" + name + ": blacklisted: " + rres);
                rejected.add(rres.getRevision() + " (blacklisted)");
                foundBlacklisted.add(foundMrid);
                continue;
            }
            if (!versionMatcher.accept(mrid, foundMrid)) {
                Message.debug("\t" + name + ": rejected by version matcher: " + rres);
                rejected.add(rres.getRevision());
                continue;
            }
            if (versionMatcher.needModuleDescriptor(mrid, foundMrid)) {
                MDResolvedResource r = rmdparser.parse(rres.getResource(), rres.getRevision());
                if (r == null) {
                    Message.debug("\t" + name + ": impossible to get module descriptor resource: " + rres);
                    rejected.add(rres.getRevision() + " (no or bad MD)");
                    continue;
                }
                ModuleDescriptor md = r.getResolvedModuleRevision().getDescriptor();
                if (md.isDefault()) {
                    Message.debug("\t" + name + ": default md rejected by version matcher" + "requiring module descriptor: " + rres);
                    rejected.add(rres.getRevision() + " (MD)");
                    continue;
                }
                if (!versionMatcher.accept(mrid, md)) {
                    Message.debug("\t" + name + ": md rejected by version matcher: " + rres);
                    rejected.add(rres.getRevision() + " (MD)");
                    continue;
                }
                found = r;
            } else {
                found = rres;
            }
            if (found == null) continue;
            if (found.getResource().exists()) break;
            Message.debug("\t" + name + ": resource not reachable for " + mrid + ": res=" + found.getResource());
            this.logAttempt(found.getResource().toString());
        }
        if (found == null && !rejected.isEmpty()) {
            this.logAttempt(((Object)rejected).toString());
        }
        if (found == null && !foundBlacklisted.isEmpty()) {
            DependencyDescriptor dd = context.getDependencyDescriptor();
            IvyNode parentNode = context.getResolveData().getNode(dd.getParentRevisionId());
            ConflictManager cm = parentNode.getConflictManager(mrid.getModuleId());
            cm.handleAllBlacklistedRevisions(dd, foundBlacklisted);
        }
        return found;
    }

    protected Collection findNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        names.addAll(this.findIvyNames(tokenValues, token));
        if (this.isAllownomd()) {
            names.addAll(this.findArtifactNames(tokenValues, token));
        }
        return names;
    }

    protected Collection findIvyNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        tokenValues = new HashMap<String, String>(tokenValues);
        tokenValues.put("artifact", "ivy");
        tokenValues.put("type", "ivy");
        tokenValues.put("ext", "xml");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(tokenValues);
        }
        this.findTokenValues(names, this.getIvyPatterns(), tokenValues, token);
        this.filterNames(names);
        return names;
    }

    protected Collection findArtifactNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        tokenValues = new HashMap(tokenValues);
        tokenValues.put("artifact", tokenValues.get("module"));
        tokenValues.put("type", "jar");
        tokenValues.put("ext", "jar");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(tokenValues);
        }
        this.findTokenValues(names, this.getArtifactPatterns(), tokenValues, token);
        this.filterNames(names);
        return names;
    }

    public Map[] listTokenValues(String[] tokens, Map criteria) {
        LinkedHashSet result = new LinkedHashSet();
        List ivyPatterns = this.getIvyPatterns();
        HashMap<String, String> tokenValues = new HashMap<String, String>(criteria);
        tokenValues.put("type", "ivy");
        tokenValues.put("ext", "xml");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(tokenValues);
        }
        Iterator it = ivyPatterns.iterator();
        while (it.hasNext()) {
            String ivyPattern = (String)it.next();
            result.addAll(this.resolveTokenValues(tokens, ivyPattern, tokenValues, false));
        }
        if (this.isAllownomd()) {
            List artifactPatterns = this.getArtifactPatterns();
            tokenValues = new HashMap(criteria);
            tokenValues.put("type", "jar");
            tokenValues.put("ext", "jar");
            if (this.isM2compatible()) {
                this.convertM2TokenValuesForResourceSearch(tokenValues);
            }
            Iterator it2 = artifactPatterns.iterator();
            while (it2.hasNext()) {
                String artifactPattern = (String)it2.next();
                result.addAll(this.resolveTokenValues(tokens, artifactPattern, tokenValues, true));
            }
        }
        return result.toArray(new Map[result.size()]);
    }

    private Set resolveTokenValues(String[] tokens, String pattern, Map criteria, boolean noMd) {
        String[] values;
        LinkedHashSet result = new LinkedHashSet();
        HashSet<String> tokenSet = new HashSet<String>(Arrays.asList(tokens));
        HashMap tokenValues = new HashMap();
        Iterator it = criteria.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            tokenValues.put(key, value);
        }
        if (tokenSet.isEmpty()) {
            result.add(tokenValues);
            return result;
        }
        String partiallyResolvedPattern = IvyPatternHelper.substituteTokens(pattern, tokenValues);
        String token = IvyPatternHelper.getFirstToken(partiallyResolvedPattern);
        if (token == null && this.exist(partiallyResolvedPattern)) {
            result.add(tokenValues);
            return result;
        }
        tokenSet.remove(token);
        Matcher matcher = null;
        Object criteriaForToken = criteria.get(token);
        if (criteriaForToken instanceof Matcher) {
            matcher = (Matcher)criteriaForToken;
        }
        if ((values = this.listTokenValues(partiallyResolvedPattern, token)) == null) {
            return result;
        }
        ArrayList<String> vals = new ArrayList<String>(Arrays.asList(values));
        this.filterNames(vals);
        Iterator it2 = vals.iterator();
        while (it2.hasNext()) {
            String value = (String)it2.next();
            if (matcher != null && !matcher.matches(value)) continue;
            tokenValues.put(token, value);
            String moreResolvedPattern = IvyPatternHelper.substituteTokens(partiallyResolvedPattern, tokenValues);
            HashMap<String, String> newCriteria = new HashMap<String, String>(criteria);
            newCriteria.put(token, value);
            if (noMd && "artifact".equals(token)) {
                newCriteria.put("module", value);
            } else if (noMd && "module".equals(token)) {
                newCriteria.put("artifact", value);
            }
            result.addAll(this.resolveTokenValues(tokenSet.toArray(new String[tokenSet.size()]), moreResolvedPattern, newCriteria, noMd));
        }
        return result;
    }

    protected abstract String[] listTokenValues(String var1, String var2);

    protected abstract boolean exist(String var1);

    protected Collection filterNames(Collection names) {
        this.getSettings().filterIgnore(names);
        return names;
    }

    protected void findTokenValues(Collection names, List patterns, Map tokenValues, String token) {
    }

    public void addIvyPattern(String pattern) {
        this.ivyPatterns.add(pattern);
    }

    public void addArtifactPattern(String pattern) {
        this.artifactPatterns.add(pattern);
    }

    public List getIvyPatterns() {
        return Collections.unmodifiableList(this.ivyPatterns);
    }

    public List getArtifactPatterns() {
        return Collections.unmodifiableList(this.artifactPatterns);
    }

    protected void setIvyPatterns(List patterns) {
        this.ivyPatterns = patterns;
    }

    protected void setArtifactPatterns(List patterns) {
        this.artifactPatterns = patterns;
    }

    public void addConfiguredIvy(IvyPattern p) {
        this.ivyPatterns.add(p.getPattern());
    }

    public void addConfiguredArtifact(IvyPattern p) {
        this.artifactPatterns.add(p.getPattern());
    }

    public void dumpSettings() {
        String p;
        super.dumpSettings();
        Message.debug("\t\tm2compatible: " + this.isM2compatible());
        Message.debug("\t\tivy patterns:");
        ListIterator iter = this.getIvyPatterns().listIterator();
        while (iter.hasNext()) {
            p = (String)iter.next();
            Message.debug("\t\t\t" + p);
        }
        Message.debug("\t\tartifact patterns:");
        iter = this.getArtifactPatterns().listIterator();
        while (iter.hasNext()) {
            p = (String)iter.next();
            Message.debug("\t\t\t" + p);
        }
    }

    public boolean isM2compatible() {
        return this.m2compatible;
    }

    public void setM2compatible(boolean compatible) {
        this.m2compatible = compatible;
    }

    protected ModuleRevisionId convertM2IdForResourceSearch(ModuleRevisionId mrid) {
        if (mrid.getOrganisation() == null || mrid.getOrganisation().indexOf(46) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('.', '/'), mrid.getName(), mrid.getBranch(), mrid.getRevision(), mrid.getQualifiedExtraAttributes());
    }

    protected String convertM2OrganizationForResourceSearch(String org) {
        return org.replace('.', '/');
    }

    protected void convertM2TokenValuesForResourceSearch(Map tokenValues) {
        if (tokenValues.get("organisation") instanceof String) {
            tokenValues.put("organisation", this.convertM2OrganizationForResourceSearch((String)tokenValues.get("organisation")));
        }
    }

    static {
        IVY_ARTIFACT_ATTRIBUTES.put("artifact", "ivy");
        IVY_ARTIFACT_ATTRIBUTES.put("type", "ivy");
        IVY_ARTIFACT_ATTRIBUTES.put("ext", "xml");
    }
}

