/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.HasLatestStrategy;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;

public class ChainResolver
extends AbstractResolver {
    private boolean returnFirst = false;
    private List chain = new ArrayList();
    private boolean dual;
    private Boolean checkmodified = null;

    public void add(DependencyResolver resolver) {
        this.chain.add(resolver);
    }

    public boolean isCheckmodified() {
        if (this.checkmodified == null) {
            if (this.getSettings() != null) {
                String check = this.getSettings().getVariable("ivy.resolver.default.check.modified");
                return check != null ? Boolean.valueOf(check) : false;
            }
            return false;
        }
        return this.checkmodified;
    }

    public void setCheckmodified(boolean check) {
        this.checkmodified = check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        data = new ResolveData(data, this.doValidate(data));
        ArrayList<Exception> errors = new ArrayList<Exception>();
        ResolvedModuleRevision resolved = data.getCurrentResolvedModuleRevision();
        ResolvedModuleRevision mr = resolved;
        if (mr == null) {
            Message.verbose(this.getName() + ": Checking cache for: " + dd);
            mr = this.findModuleInCache(dd, data, true);
            if (mr != null) {
                Message.verbose(this.getName() + ": module revision found in cache: " + mr.getId());
                if (!this.isCheckmodified()) {
                    mr = this.forcedRevision(mr);
                }
            }
        }
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            LatestStrategy oldLatest = this.setLatestIfRequired(resolver, this.getLatestStrategy());
            try {
                ResolvedModuleRevision previouslyResolved = mr;
                data.setCurrentResolvedModuleRevision(previouslyResolved);
                mr = resolver.getDependency(dd, data);
                if (mr != previouslyResolved && this.isReturnFirst()) {
                    mr = this.forcedRevision(mr);
                }
            }
            catch (Exception ex) {
                Message.verbose("problem occured while resolving " + dd + " with " + resolver + ": " + StringUtils.getStackTrace(ex));
                errors.add(ex);
            }
            finally {
                if (oldLatest != null) {
                    ChainResolver.setLatest(resolver, oldLatest);
                }
            }
            this.checkInterrupted();
        }
        if (mr == null && !errors.isEmpty()) {
            if (errors.size() == 1) {
                Exception ex = (Exception)errors.get(0);
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof ParseException) {
                    throw (ParseException)ex;
                }
                throw new RuntimeException(ex.toString(), ex);
            }
            StringBuffer err = new StringBuffer();
            Iterator iter2 = errors.iterator();
            while (iter2.hasNext()) {
                Exception ex = (Exception)iter2.next();
                err.append("\t").append(StringUtils.getErrorMessage(ex)).append("\n");
            }
            err.setLength(err.length() - 1);
            throw new RuntimeException("several problems occured while resolving " + dd + ":\n" + err);
        }
        if (resolved == mr) {
            return resolved;
        }
        return this.resolvedRevision(mr);
    }

    private ResolvedModuleRevision resolvedRevision(ResolvedModuleRevision mr) {
        if (this.isDual() && mr != null) {
            return new ResolvedModuleRevision(mr.getResolver(), this, mr.getDescriptor(), mr.getReport(), mr.isForce());
        }
        return mr;
    }

    private ResolvedModuleRevision forcedRevision(ResolvedModuleRevision rmr) {
        if (rmr == null) {
            return null;
        }
        return new ResolvedModuleRevision(rmr.getResolver(), rmr.getArtifactResolver(), rmr.getDescriptor(), rmr.getReport(), true);
    }

    private LatestStrategy setLatestIfRequired(DependencyResolver resolver, LatestStrategy latestStrategy) {
        String latestName = ChainResolver.getLatestStrategyName(resolver);
        if (latestName != null && !"default".equals(latestName)) {
            LatestStrategy oldLatest = ChainResolver.getLatest(resolver);
            ChainResolver.setLatest(resolver, latestStrategy);
            return oldLatest;
        }
        return null;
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            ResolvedResource result = resolver.findIvyFileRef(dd, data);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void reportFailure() {
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            resolver.reportFailure();
        }
    }

    public void reportFailure(Artifact art) {
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            resolver.reportFailure(art);
        }
    }

    public DownloadReport download(Artifact[] artifacts, DownloadOptions options) {
        ArrayList<Artifact> artifactsToDownload = new ArrayList<Artifact>(Arrays.asList(artifacts));
        DownloadReport report = new DownloadReport();
        Iterator iter = this.chain.iterator();
        while (iter.hasNext() && !artifactsToDownload.isEmpty()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            DownloadReport r = resolver.download(artifactsToDownload.toArray(new Artifact[artifactsToDownload.size()]), options);
            ArtifactDownloadReport[] adr = r.getArtifactsReports();
            for (int i = 0; i < adr.length; ++i) {
                if (adr[i].getDownloadStatus() == DownloadStatus.FAILED) continue;
                artifactsToDownload.remove(adr[i].getArtifact());
                report.addArtifactReport(adr[i]);
            }
        }
        iter = artifactsToDownload.iterator();
        while (iter.hasNext()) {
            Artifact art = (Artifact)iter.next();
            ArtifactDownloadReport adr = new ArtifactDownloadReport(art);
            adr.setDownloadStatus(DownloadStatus.FAILED);
            report.addArtifactReport(adr);
        }
        return report;
    }

    public List getResolvers() {
        return this.chain;
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        this.getFirstResolver().publish(artifact, src, overwrite);
    }

    public void abortPublishTransaction() throws IOException {
        this.getFirstResolver().abortPublishTransaction();
    }

    public void beginPublishTransaction(ModuleRevisionId module, boolean overwrite) throws IOException {
        this.getFirstResolver().beginPublishTransaction(module, overwrite);
    }

    public void commitPublishTransaction() throws IOException {
        this.getFirstResolver().commitPublishTransaction();
    }

    private DependencyResolver getFirstResolver() {
        if (this.chain.isEmpty()) {
            throw new IllegalStateException("invalid chain resolver with no sub resolver");
        }
        return (DependencyResolver)this.chain.get(0);
    }

    public boolean isReturnFirst() {
        return this.returnFirst;
    }

    public void setReturnFirst(boolean returnFirst) {
        this.returnFirst = returnFirst;
    }

    public void dumpSettings() {
        Message.verbose("\t" + this.getName() + " [chain] " + this.chain);
        Message.debug("\t\treturn first: " + this.isReturnFirst());
        Message.debug("\t\tdual: " + this.isDual());
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver r = (DependencyResolver)iter.next();
            Message.debug("\t\t-> " + r.getName());
        }
    }

    public boolean exists(Artifact artifact) {
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            if (!resolver.exists(artifact)) continue;
            return true;
        }
        return false;
    }

    public ArtifactOrigin locate(Artifact artifact) {
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            ArtifactOrigin origin = resolver.locate(artifact);
            if (ArtifactOrigin.isUnknown(origin)) continue;
            return origin;
        }
        return ArtifactOrigin.unkwnown(artifact);
    }

    public ArtifactDownloadReport download(ArtifactOrigin artifact, DownloadOptions options) {
        Iterator iter = this.chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            ArtifactDownloadReport adr = resolver.download(artifact, options);
            if (adr.getDownloadStatus() == DownloadStatus.FAILED) continue;
            return adr;
        }
        ArtifactDownloadReport adr = new ArtifactDownloadReport(artifact.getArtifact());
        adr.setDownloadStatus(DownloadStatus.FAILED);
        return adr;
    }

    private static void setLatest(DependencyResolver resolver, LatestStrategy latest) {
        if (resolver instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver);
            r.setLatestStrategy(latest);
        }
    }

    private static LatestStrategy getLatest(DependencyResolver resolver) {
        if (resolver instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver);
            return r.getLatestStrategy();
        }
        return null;
    }

    private static String getLatestStrategyName(DependencyResolver resolver) {
        if (resolver instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver);
            return r.getLatest();
        }
        return null;
    }

    public void setDual(boolean b) {
        this.dual = b;
    }

    public boolean isDual() {
        return this.dual;
    }

    public static class ResolvedModuleRevisionArtifactInfo
    implements ArtifactInfo {
        private ResolvedModuleRevision rmr;

        public ResolvedModuleRevisionArtifactInfo(ResolvedModuleRevision rmr) {
            this.rmr = rmr;
        }

        public String getRevision() {
            return this.rmr.getId().getRevision();
        }

        public long getLastModified() {
            return this.rmr.getPublicationDate().getTime();
        }
    }
}

