/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.rmi.RemoteException;
import sbt.AnalysisCallback;
import sbt.BasicAnalysis;
import sbt.BasicCompileAnalysis;
import sbt.Path;
import scala.Iterable;
import scala.ScalaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicAnalysisCallback<A extends BasicCompileAnalysis>
implements AnalysisCallback,
ScalaObject {
    private final A analysis;
    private final Iterable<String> superclassNames;
    private final Path basePath;

    public BasicAnalysisCallback(Path basePath, Iterable<String> superclassNames, A analysis) {
        this.basePath = basePath;
        this.superclassNames = superclassNames;
        this.analysis = analysis;
    }

    @Override
    public void endSource(Path sourcePath) {
        ((BasicAnalysis)this.analysis()).removeSelfDependency(sourcePath);
    }

    @Override
    public void generatedClass(Path sourcePath, Path modulePath) {
        ((BasicAnalysis)this.analysis()).addProduct(sourcePath, modulePath);
    }

    @Override
    public void productDependency(Path classFile, Path sourcePath) {
        ((BasicAnalysis)this.analysis()).addProductDependency(classFile, sourcePath);
    }

    @Override
    public void classDependency(File classFile, Path sourcePath) {
        ((BasicAnalysis)this.analysis()).addExternalDependency(classFile, sourcePath);
    }

    @Override
    public void jarDependency(File jarFile, Path sourcePath) {
        ((BasicAnalysis)this.analysis()).addExternalDependency(jarFile, sourcePath);
    }

    @Override
    public void sourceDependency(Path dependsOnPath, Path sourcePath) {
        ((BasicAnalysis)this.analysis()).addSourceDependency(dependsOnPath, sourcePath);
    }

    @Override
    public void beginSource(Path sourcePath) {
        ((BasicAnalysis)this.analysis()).addSource(sourcePath);
    }

    @Override
    public void superclassNotFound(String superclassName) {
    }

    public A analysis() {
        return this.analysis;
    }

    @Override
    public Iterable<String> superclassNames() {
        return this.superclassNames;
    }

    @Override
    public Path basePath() {
        return this.basePath;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

