/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import sbt.BufferedLogger$;
import sbt.ControlEvent;
import sbt.Level$;
import sbt.Log;
import sbt.LogEvent;
import sbt.Logger;
import sbt.SetLevel;
import sbt.SetTrace;
import sbt.Success;
import sbt.Trace;
import sbt.wrap.MutableMapWrapper;
import sbt.wrap.Wrappers$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BufferedLogger
extends Logger
implements ScalaObject {
    public final Thread sbt$BufferedLogger$$mainThread;
    private int recordingDepth;
    private final MutableMapWrapper<Thread, Buffer<LogEvent>> buffers;
    public final Logger sbt$BufferedLogger$$delegate;

    public BufferedLogger(Logger delegate) {
        this.sbt$BufferedLogger$$delegate = delegate;
        this.buffers = Wrappers$.MODULE$.weakMap();
        this.recordingDepth = 0;
        this.sbt$BufferedLogger$$mainThread = Thread.currentThread();
    }

    @Override
    public void control(Enumeration.Value event, Function0<String> message) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            if (this.atLevel(Level$.MODULE$.Info())) {
                if (this.recording()) {
                    this.buffer().$plus$eq((Object)new ControlEvent(event, (String)message.apply()));
                } else {
                    this.sbt$BufferedLogger$$delegate.control(event, message);
                }
            }
            return;
        }
    }

    @Override
    public void logAll(Seq<LogEvent> events) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            BoxedUnit boxedUnit;
            if (this.recording()) {
                this.buffer().$plus$plus$eq(events);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.sbt$BufferedLogger$$delegate.logAll(events);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public void log(Enumeration.Value level, Function0<String> message) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            if (this.atLevel(level)) {
                if (this.recording()) {
                    this.buffer().$plus$eq((Object)new Log(level, (String)message.apply()));
                } else {
                    this.sbt$BufferedLogger$$delegate.log(level, message);
                }
            }
            return;
        }
    }

    @Override
    public void success(Function0<String> message) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            if (this.atLevel(Level$.MODULE$.Info())) {
                if (this.recording()) {
                    this.buffer().$plus$eq((Object)new Success((String)message.apply()));
                } else {
                    this.sbt$BufferedLogger$$delegate.success(message);
                }
            }
            return;
        }
    }

    @Override
    public void trace(Function0<Throwable> t) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            if (this.traceEnabled()) {
                if (this.recording()) {
                    this.buffer().$plus$eq((Object)new Trace((Throwable)t.apply()));
                } else {
                    this.sbt$BufferedLogger$$delegate.trace(t);
                }
            }
            return;
        }
    }

    @Override
    public void enableTrace(boolean flag) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            if (this.recording()) {
                this.buffer().$plus$eq((Object)new SetTrace(flag));
            }
            this.sbt$BufferedLogger$$delegate.enableTrace(flag);
            return;
        }
    }

    @Override
    public boolean traceEnabled() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            return BoxesRunTime.unboxToBoolean((Object)BoxesRunTime.boxToBoolean((boolean)this.sbt$BufferedLogger$$delegate.traceEnabled()));
        }
    }

    @Override
    public Enumeration.Value getLevel() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            return this.sbt$BufferedLogger$$delegate.getLevel();
        }
    }

    @Override
    public void setLevel(Enumeration.Value newLevel) {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            if (this.recording()) {
                this.buffer().$plus$eq((Object)new SetLevel(newLevel));
            }
            this.sbt$BufferedLogger$$delegate.setLevel(newLevel);
            return;
        }
    }

    public <T> T runAndFlush(Function0<T> f) {
        Object exceptionResult1 = null;
        try {
            exceptionResult1 = f.apply();
            this.play();
            this.clear();
        }
        catch (Throwable throwable) {
            this.play();
            this.clear();
            throw throwable;
        }
        return (T)exceptionResult1;
    }

    public void clearAll() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            BoxedUnit boxedUnit;
            if (this.recordingDepth <= 1) {
                this.buffers.clear();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Buffer serial = this.sbt$BufferedLogger$$serialBuffer();
                this.buffers.clear();
                this.buffers.update(this.sbt$BufferedLogger$$mainThread, (Buffer<LogEvent>)serial);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void stop() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            this.clearAll();
            if (this.recordingDepth > 0) {
                --this.recordingDepth;
            }
            return;
        }
    }

    public void clear() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            if (this.recordingDepth == 1 || this.inWorker()) {
                this.buffers.$minus$eq(this.key());
            }
            return;
        }
    }

    public void playAll() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            BoxedUnit boxedUnit;
            if (this.recordingDepth == 1) {
                this.buffers.values().foreach((Function1)new $anonfun$playAll$1(this));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (this.recordingDepth > 1) {
                    this.buffers.toList().filter((Function1)new $anonfun$playAll$2(this)).foreach((Function1)new $anonfun$playAll$3(this));
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void play() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            BoxedUnit boxedUnit;
            if (this.recordingDepth == 1) {
                this.sbt$BufferedLogger$$delegate.logAll(Wrappers$.MODULE$.readOnly(this.buffer()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (this.recordingDepth > 1 && this.inWorker()) {
                    this.sbt$BufferedLogger$$serialBuffer().$plus$plus$eq(this.buffer());
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void startRecording() {
        BufferedLogger bufferedLogger = this;
        synchronized (bufferedLogger) {
            ++this.recordingDepth;
            return;
        }
    }

    private boolean inWorker() {
        return Thread.currentThread() != this.sbt$BufferedLogger$$mainThread;
    }

    public final Buffer sbt$BufferedLogger$$serialBuffer() {
        return this.getBuffer(this.sbt$BufferedLogger$$mainThread);
    }

    private Thread key() {
        return Thread.currentThread();
    }

    private Buffer<LogEvent> buffer() {
        return this.getBuffer(this.key());
    }

    private Buffer<LogEvent> getBuffer(Thread key) {
        return this.buffers.getOrElseUpdate(key, new $anonfun$getBuffer$1(this));
    }

    private boolean recording() {
        return this.recordingDepth > 0;
    }
}

