/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import sbt.ExitHook;
import sbt.ExitHooks$;
import sbt.FileUtilities$;
import sbt.JettyRun;
import sbt.JettyRun$;
import sbt.JettyRunConfiguration;
import sbt.LazyFrameworkLoader;
import sbt.Logger;
import sbt.ModuleUtilities$;
import sbt.Path;
import sbt.Stoppable;
import scala.Array$;
import scala.Function1;
import scala.Iterable;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.ScalaRunTime$;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JettyRun$
implements ExitHook,
ScalaObject {
    public static final JettyRun$ MODULE$;
    private final String implClassName;
    private Option<Stoppable> running;
    private final int DefaultPort;

    static {
        new JettyRun$();
    }

    public JettyRun$() {
        this.DefaultPort = 8080;
        MODULE$ = this;
        ExitHooks$.MODULE$.register(this);
        this.running = None$.MODULE$;
        this.implClassName = "sbt.LazyJettyRun";
    }

    private final Option liftedTree1$1(String string, JettyRunConfiguration jettyRunConfiguration, Logger logger) {
        Some<String> exceptionResult1 = null;
        try {
            this.started(this.runJetty$1(jettyRunConfiguration, logger));
            exceptionResult1 = None$.MODULE$;
        }
        catch (Throwable throwable) {
            exceptionResult1 = this.runError(throwable, "Error running Jetty: ", logger);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            exceptionResult1 = this.runError(noClassDefFoundError, new StringBuilder().append((Object)"Jetty and its dependencies must be on the ").append((Object)string).append((Object)" classpath: ").toString(), logger);
        }
        return exceptionResult1;
    }

    private final Stoppable runJetty$1(JettyRunConfiguration jettyRunConfiguration, Logger logger) {
        ClassLoader baseLoader = this.getClass().getClassLoader();
        Object object = ScalaRunTime$.MODULE$.arrayValue(jettyRunConfiguration.classpathURLs().toArray(), URL.class);
        URLClassLoader loader = new URLClassLoader((URL[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, URL.class) : object), baseLoader);
        Object object2 = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new URL[]{FileUtilities$.MODULE$.sbtJar().toURI().toURL()})), URL.class);
        LazyFrameworkLoader lazyLoader = new LazyFrameworkLoader(this.implClassName(), (URL[])(object2 instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object2, URL.class) : object2), (ClassLoader)loader, baseLoader);
        JettyRun runner = (JettyRun)ModuleUtilities$.MODULE$.getObject(this.implClassName(), lazyLoader);
        return runner.apply(jettyRunConfiguration, logger);
    }

    private Some<String> runError(Throwable e$1, String messageBase, Logger log2) {
        log2.trace(new anonfun.runError.1(e$1));
        return new Some((Object)new StringBuilder().append((Object)messageBase).append((Object)e$1.toString()).toString());
    }

    private String implClassName() {
        return this.implClassName;
    }

    private Option<String> run(String classpathName$1, JettyRunConfiguration configuration$1, Logger log$1) {
        JettyRun$ jettyRun$ = this;
        synchronized (jettyRun$) {
            return (Option)(this.running().isDefined() ? new Some((Object)"Jetty is already running.") : this.liftedTree1$1(classpathName$1, configuration$1, log$1));
        }
    }

    private Seq<URL> toURLs(Iterable<Path> paths) {
        return paths.map((Function1)new anonfun.toURLs.1()).toSeq();
    }

    public Option<String> apply(Iterable<Path> classpath, String classpathName, Path war, String defaultContextPath, int port, Seq<File> scanDirectories, int scanPeriod, Logger log2) {
        return this.run(classpathName, new JettyRunConfiguration(war, defaultContextPath, port, NodeSeq$.MODULE$.Empty(), (Seq<File>)Nil$.MODULE$, scanDirectories, scanPeriod, this.toURLs(classpath)), log2);
    }

    public Option<String> apply(Iterable<Path> classpath, String classpathName, Path war, String defaultContextPath, NodeSeq jettyConfigurationXML, Seq<File> jettyConfigurationFiles, Logger log2) {
        return this.run(classpathName, new JettyRunConfiguration(war, defaultContextPath, this.DefaultPort(), jettyConfigurationXML, jettyConfigurationFiles, (Seq<File>)Nil$.MODULE$, 0, this.toURLs(classpath)), log2);
    }

    public void stop() {
        JettyRun$ jettyRun$ = this;
        synchronized (jettyRun$) {
            this.running().foreach((Function1)new anonfun.stop.1());
            this.running_$eq((Option<Stoppable>)None$.MODULE$);
            return;
        }
    }

    private void started(Stoppable s) {
        this.running_$eq((Option<Stoppable>)new Some((Object)s));
    }

    private void running_$eq(Option<Stoppable> x$1) {
        this.running = x$1;
    }

    private Option<Stoppable> running() {
        return this.running;
    }

    @Override
    public void runBeforeExiting() {
        this.stop();
    }

    @Override
    public String name() {
        return "jetty-shutdown";
    }

    public int DefaultPort() {
        return this.DefaultPort;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

