/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.rmi.RemoteException;
import sbt.BaseDirectory;
import sbt.FilePath;
import sbt.FileUtilities$;
import sbt.Path;
import sbt.Path$;
import sbt.PathFinder;
import sbt.ProjectDirectory;
import sbt.RelativePath;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Iterable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.StringBuilder;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Path$
implements ScalaObject {
    public static final Path$ MODULE$;
    private final char sep;

    static {
        new Path$();
    }

    public Path$() {
        MODULE$ = this;
        this.sep = File.separatorChar;
    }

    public Path fromFile(File file2) {
        return new FilePath(file2);
    }

    public Path fromFile(String file2) {
        return this.fromFile(new File(file2));
    }

    private Option<String> baseFileString(File baseFile) {
        None$ none$;
        if (baseFile.isDirectory()) {
            String cp = baseFile.getAbsolutePath();
            Predef$.MODULE$.assert(cp.length() > 0);
            none$ = cp.charAt(cp.length() - 1) == File.separatorChar ? new Some((Object)cp) : new Some((Object)new StringBuilder().append((Object)cp).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).toString());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<String> basePathString(Path basePath) {
        return this.baseFileString(basePath.asFile());
    }

    public Option<String> relativize(File baseFile, File file2) {
        String pathString$1 = file2.getAbsolutePath();
        return this.baseFileString(baseFile).flatMap((Function1)new anonfun.relativize.2(pathString$1));
    }

    public Option<Path> relativize(Path basePath, String basePathString, File file2) {
        String pathString = file2.getAbsolutePath();
        return pathString.startsWith(basePathString) ? new Some((Object)this.fromString(basePath, pathString.substring(basePathString.length()))) : None$.MODULE$;
    }

    public Option<Path> relativize(Path basePath$1, File file$1) {
        return this.basePathString(basePath$1).flatMap((Function1)new anonfun.relativize.1(basePath$1, file$1));
    }

    public Option<Path> relativize(Path basePath, Path path) {
        return this.relativize(basePath, path.asFile());
    }

    public Option<Path> baseAncestor(Path path) {
        Path path2;
        block7: {
            None$ none$;
            block6: {
                while (true) {
                    if ((path2 = path) instanceof ProjectDirectory) {
                        none$ = None$.MODULE$;
                        break block6;
                    }
                    if (path2 instanceof FilePath) {
                        none$ = None$.MODULE$;
                        break block6;
                    }
                    if (!(path2 instanceof RelativePath)) break;
                    path = ((RelativePath)path2).parentPath();
                }
                if (!(path2 instanceof BaseDirectory)) break block7;
                none$ = new Some((Object)((BaseDirectory)path2).path());
            }
            return none$;
        }
        throw new MatchError((Object)path2);
    }

    public Path fromString(Path basePath, String value) {
        Path path;
        if (Predef$.MODULE$.stringWrapper(value).isEmpty()) {
            path = basePath;
        } else {
            String[] components = value.split("[/\\\\]");
            Path path2 = basePath;
            path = (Path)new BoxedObjectArray((Object[])components).$div$colon((Object)path2, (Function2)new anonfun.fromString.1());
        }
        return path;
    }

    public String checkComponent(String c) {
        Predef$.MODULE$.require(c.length() > 0, (Object)"Path component must not be empty");
        Predef$.MODULE$.require(c.indexOf(47) == -1, (Object)new StringBuilder().append((Object)"Path component '").append((Object)c).append((Object)"' must not have forward slashes in it").toString());
        Predef$.MODULE$.require(c.indexOf(92) == -1, (Object)new StringBuilder().append((Object)"Path component '").append((Object)c).append((Object)"' must not have backslashes in it").toString());
        String string = c;
        String string2 = "..";
        Predef$.MODULE$.require(string != null ? !string.equals(string2) : string2 != null, (Object)"Path component cannot be '..'");
        String string3 = c;
        String string4 = ".";
        Predef$.MODULE$.require(string3 != null ? !string3.equals(string4) : string4 != null, (Object)"Path component cannot be '.'");
        return c;
    }

    public char sep() {
        return this.sep;
    }

    public PathFinder lazyPathFinder(Function0<Iterable<Path>> paths$1) {
        return new anon.2(paths$1);
    }

    public PathFinder emptyPathFinder() {
        return new anon.1();
    }

    public Iterable<Path> splitString(Path projectPath$1, String value) {
        return new BoxedObjectArray((Object[])FileUtilities$.MODULE$.pathSplit(value)).filter((Function1)new anonfun.splitString.1()).map((Function1)new anonfun.splitString.2(projectPath$1));
    }

    public String makeRelativeString(Iterable<Path> paths, String separator$1) {
        return paths.map((Function1)new anonfun.makeRelativeString.1(separator$1)).mkString(File.pathSeparator);
    }

    public String makeRelativeString(Iterable<Path> paths) {
        return this.makeRelativeString(paths, ((Object)BoxesRunTime.boxToCharacter((char)this.sep())).toString());
    }

    public String makeString(Iterable<Path> paths) {
        return paths.map((Function1)new anonfun.makeString.1()).mkString(File.pathSeparator);
    }

    public File absolute(File file2) {
        return new File(file2.toURI().normalize()).getAbsoluteFile();
    }

    public Path userHome() {
        return this.fileProperty("user.home");
    }

    public Path fileProperty(String name2) {
        return this.fromFile(System.getProperty(name2));
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

