/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.rmi.RemoteException;
import sbt.AlreadySetup$;
import sbt.Logger;
import sbt.Project;
import sbt.ProjectInfo;
import sbt.ProjectInfo$;
import sbt.SetupDeclined$;
import sbt.SetupError;
import sbt.SetupInfo;
import sbt.SetupResult;
import sbt.SimpleReader$;
import sbt.Version;
import sbt.Version$;
import scala.Either;
import scala.Function0;
import scala.Iterable;
import scala.Left;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Right;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.Tuple3;
import scala.runtime.BoxedObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectInfo$
implements ScalaObject {
    public static final ProjectInfo$ MODULE$;
    private final String DefaultOrganization;
    private final String MetadataDirectoryName;

    static {
        new ProjectInfo$();
    }

    public ProjectInfo$() {
        this.MetadataDirectoryName = "project";
        this.DefaultOrganization = "empty";
        MODULE$ = this;
    }

    public /* synthetic */ ProjectInfo apply(File projectDirectory, Iterable dependencies2, Option parent) {
        return new ProjectInfo(projectDirectory, (Iterable<Project>)dependencies2, (Option<Project>)parent);
    }

    public /* synthetic */ Some unapply(ProjectInfo x$0) {
        return new Some((Object)new Tuple3((Object)x$0.projectDirectory(), x$0.dependencies(), x$0.parent()));
    }

    private String trim(Option<String> s) {
        return (String)s.getOrElse((Function0)new anonfun.trim.1());
    }

    private Option<Version> readVersion(File projectDirectory, Logger log2) {
        Either<String, Version> either;
        block6: {
            None$ none$;
            block5: {
                while (true) {
                    String string;
                    String version;
                    if (Predef$.MODULE$.stringWrapper(version = this.trim(SimpleReader$.MODULE$.readLine("Version: "))).isEmpty()) {
                        none$ = None$.MODULE$;
                        break block5;
                    }
                    either = Version$.MODULE$.fromString(version);
                    if (!(either instanceof Left)) break;
                    Left left = (Left)either;
                    String errorMessage$1 = string = (String)left.a();
                    log2.error(new anonfun.readVersion.1(errorMessage$1));
                }
                if (!(either instanceof Right)) break block6;
                none$ = new Some(((Right)either).b());
            }
            return none$;
        }
        throw new MatchError(either);
    }

    private boolean confirmPrompt(String question, boolean defaultYes) {
        String choices = defaultYes ? " (Y/n) " : " (y/N) ";
        String answer = this.trim(SimpleReader$.MODULE$.readLine(new StringBuilder().append((Object)question).append((Object)choices).toString()));
        String string = "y";
        String string2 = "yes";
        List yes = (defaultYes ? List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{""})) : Nil$.MODULE$).$colon$colon((Object)string2).$colon$colon((Object)string);
        return yes.contains((Object)answer.toLowerCase());
    }

    private boolean verifyCreateProject(String name2, Version version, String organization) {
        return this.confirmPrompt(new StringBuilder().append((Object)"Create new project ").append((Object)name2).append((Object)" ").append((Object)version).append((Object)" with organization ").append((Object)organization).append((Object)" ?").toString(), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SetupResult setupProject(File projectDirectory, Logger log2) {
        SetupResult setupResult;
        if (this.confirmPrompt("No project found. Create new project?", false)) {
            String name2 = this.trim(SimpleReader$.MODULE$.readLine("Project Name: "));
            if (Predef$.MODULE$.stringWrapper(name2).isEmpty()) {
                setupResult = new SetupError("Project not created: no name specified.");
                return setupResult;
            } else {
                String org = this.trim(SimpleReader$.MODULE$.readLine(new StringBuilder().append((Object)"Organization [").append((Object)this.DefaultOrganization()).append((Object)"]: ").toString()));
                String organization = Predef$.MODULE$.stringWrapper(org).isEmpty() ? this.DefaultOrganization() : org;
                Option<Version> option = this.readVersion(projectDirectory, log2);
                None$ none$ = None$.MODULE$;
                Option<Version> option2 = option;
                if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                    setupResult = new SetupError("Project not created: no version specified.");
                    return setupResult;
                } else {
                    if (!(option instanceof Some)) throw new MatchError(option);
                    Some some = (Some)option;
                    Version version = (Version)some.x();
                    Version version2 = version;
                    setupResult = this.verifyCreateProject(name2, version2, organization) ? new SetupInfo(name2, (Option<Version>)new Some((Object)version2), (Option<String>)new Some((Object)organization), true) : SetupDeclined$.MODULE$;
                }
            }
            return setupResult;
        } else {
            setupResult = SetupDeclined$.MODULE$;
        }
        return setupResult;
    }

    public SetupResult setup(ProjectInfo info2, Logger log2) {
        File builderDirectory = info2.builderPath().asFile();
        return builderDirectory.exists() ? (builderDirectory.isDirectory() ? AlreadySetup$.MODULE$ : new SetupError(new StringBuilder().append((Object)"'").append((Object)builderDirectory.getAbsolutePath()).append((Object)"' is not a directory.").toString())) : this.setupProject(info2.projectDirectory(), log2);
    }

    private String DefaultOrganization() {
        return this.DefaultOrganization;
    }

    public String MetadataDirectoryName() {
        return this.MetadataDirectoryName;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

