/*
 * Decompiled with CFR 0.152.
 */
package org.scalactic;

import java.io.Serializable;
import org.scalactic.CanEqual;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalactic.Equivalence;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport$Spread$;
import org.scalactic.TripleEqualsSupport$TripleEqualsInvocation$;
import org.scalactic.TripleEqualsSupport$TripleEqualsInvocationOnSpread$;
import scala.;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface TripleEqualsSupport {
    public static Equality defaultEquality$(TripleEqualsSupport $this) {
        return $this.defaultEquality();
    }

    default public <A> Equality<A> defaultEquality() {
        return Equality$.MODULE$.default();
    }

    public <T> Equalizer<T> convertToEqualizer(T var1);

    public <T> CheckingEqualizer<T> convertToCheckingEqualizer(T var1);

    public <A, B> CanEqual<A, B> unconstrainedEquality(Equality<A> var1);

    public <A, B> CanEqual<A, B> lowPriorityTypeCheckedConstraint(Equivalence<B> var1, .less.colon.less<A, B> var2);

    public <A, B> CanEqual<A, B> convertEquivalenceToAToBConstraint(Equivalence<B> var1, .less.colon.less<A, B> var2);

    public <A, B> CanEqual<A, B> typeCheckedConstraint(Equivalence<A> var1, .less.colon.less<B, A> var2);

    public <A, B> CanEqual<A, B> convertEquivalenceToBToAConstraint(Equivalence<A> var1, .less.colon.less<B, A> var2);

    public <A, B> CanEqual<A, B> lowPriorityConversionCheckedConstraint(Equivalence<B> var1, Function1<A, B> var2);

    public <A, B> CanEqual<A, B> convertEquivalenceToAToBConversionConstraint(Equivalence<B> var1, Function1<A, B> var2);

    public <A, B> CanEqual<A, B> conversionCheckedConstraint(Equivalence<A> var1, Function1<B, A> var2);

    public <A, B> CanEqual<A, B> convertEquivalenceToBToAConversionConstraint(Equivalence<A> var1, Function1<B, A> var2);

    public static TripleEqualsInvocation $eq$eq$eq$(TripleEqualsSupport $this, Object right) {
        return $this.$eq$eq$eq(right);
    }

    default public <T> TripleEqualsInvocation<T> $eq$eq$eq(T right) {
        return new TripleEqualsInvocation<T>(right, true);
    }

    public static TripleEqualsInvocation $bang$eq$eq$(TripleEqualsSupport $this, Object right) {
        return $this.$bang$eq$eq(right);
    }

    default public <T> TripleEqualsInvocation<T> $bang$eq$eq(T right) {
        return new TripleEqualsInvocation<T>(right, false);
    }

    public static TripleEqualsInvocation $eq$eq$eq$(TripleEqualsSupport $this, Null$ right) {
        return $this.$eq$eq$eq(right);
    }

    default public TripleEqualsInvocation<Null$> $eq$eq$eq(Null$ right) {
        return new TripleEqualsInvocation<Object>(null, true);
    }

    public static TripleEqualsInvocation $bang$eq$eq$(TripleEqualsSupport $this, Null$ right) {
        return $this.$bang$eq$eq(right);
    }

    default public TripleEqualsInvocation<Null$> $bang$eq$eq(Null$ right) {
        return new TripleEqualsInvocation<Object>(null, false);
    }

    public static TripleEqualsInvocationOnSpread $eq$eq$eq$(TripleEqualsSupport $this, Spread right) {
        return $this.$eq$eq$eq(right);
    }

    default public <T> TripleEqualsInvocationOnSpread<T> $eq$eq$eq(Spread<T> right) {
        return new TripleEqualsInvocationOnSpread<T>(right, true);
    }

    public static TripleEqualsInvocationOnSpread $bang$eq$eq$(TripleEqualsSupport $this, Spread right) {
        return $this.$bang$eq$eq(right);
    }

    default public <T> TripleEqualsInvocationOnSpread<T> $bang$eq$eq(Spread<T> right) {
        return new TripleEqualsInvocationOnSpread<T>(right, false);
    }

    public static final class AToBEquivalenceConstraint<A, B>
    extends CanEqual<A, B> {
        private final Equivalence<B> equivalenceOfB;
        private final Function1<A, B> cnv;

        public AToBEquivalenceConstraint(Equivalence<B> equivalenceOfB, Function1<A, B> cnv) {
            this.equivalenceOfB = equivalenceOfB;
            this.cnv = cnv;
        }

        @Override
        public boolean areEqual(A a, B b) {
            return this.equivalenceOfB.areEquivalent(this.cnv.apply(a), b);
        }
    }

    public static final class BToAEquivalenceConstraint<A, B>
    extends CanEqual<A, B> {
        private final Equivalence<A> equivalenceOfA;
        private final Function1<B, A> cnv;

        public BToAEquivalenceConstraint(Equivalence<A> equivalenceOfA, Function1<B, A> cnv) {
            this.equivalenceOfA = equivalenceOfA;
            this.cnv = cnv;
        }

        @Override
        public boolean areEqual(A a, B b) {
            return this.equivalenceOfA.areEquivalent(a, this.cnv.apply(b));
        }
    }

    public class CheckingEqualizer<L> {
        private final Object leftSide;
        private final TripleEqualsSupport $outer;

        public CheckingEqualizer(TripleEqualsSupport $outer, L leftSide) {
            this.leftSide = leftSide;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public L leftSide() {
            return (L)this.leftSide;
        }

        public <R> boolean $eq$eq$eq(R rightSide, CanEqual<L, R> constraint) {
            return constraint.areEqual(this.leftSide(), rightSide);
        }

        public <R> boolean $bang$eq$eq(R rightSide, CanEqual<L, R> constraint) {
            return !constraint.areEqual(this.leftSide(), rightSide);
        }

        public boolean $eq$eq$eq(Spread<L> spread) {
            boolean bl;
            if (spread != null) {
                bl = spread.isWithin(this.leftSide());
            } else {
                L l = this.leftSide();
                Spread<L> spread2 = spread;
                bl = !(l != null ? !l.equals(spread2) : spread2 != null);
            }
            return bl;
        }

        public boolean $bang$eq$eq(Spread<L> spread) {
            boolean bl;
            if (spread != null) {
                bl = !spread.isWithin(this.leftSide());
            } else {
                L l = this.leftSide();
                Spread<L> spread2 = spread;
                bl = l == null ? spread2 != null : !l.equals(spread2);
            }
            return bl;
        }

        public final TripleEqualsSupport org$scalactic$TripleEqualsSupport$CheckingEqualizer$$$outer() {
            return this.$outer;
        }
    }

    public static final class EqualityConstraint<A, B>
    extends CanEqual<A, B> {
        private final Equality<A> equalityOfA;

        public EqualityConstraint(Equality<A> equalityOfA) {
            this.equalityOfA = equalityOfA;
        }

        @Override
        public boolean areEqual(A a, B b) {
            return this.equalityOfA.areEqual(a, b);
        }
    }

    public class Equalizer<L> {
        private final Object leftSide;
        private final TripleEqualsSupport $outer;

        public Equalizer(TripleEqualsSupport $outer, L leftSide) {
            this.leftSide = leftSide;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public L leftSide() {
            return (L)this.leftSide;
        }

        public boolean $eq$eq$eq(Object rightSide, Equality<L> equality) {
            return equality.areEqual(this.leftSide(), rightSide);
        }

        public boolean $bang$eq$eq(Object rightSide, Equality<L> equality) {
            return !equality.areEqual(this.leftSide(), rightSide);
        }

        public boolean $eq$eq$eq(Spread<L> spread) {
            boolean bl;
            if (spread != null) {
                bl = spread.isWithin(this.leftSide());
            } else {
                L l = this.leftSide();
                Spread<L> spread2 = spread;
                bl = !(l != null ? !l.equals(spread2) : spread2 != null);
            }
            return bl;
        }

        public boolean $bang$eq$eq(Spread<L> spread) {
            boolean bl;
            if (spread != null) {
                bl = !spread.isWithin(this.leftSide());
            } else {
                L l = this.leftSide();
                Spread<L> spread2 = spread;
                bl = l == null ? spread2 != null : !l.equals(spread2);
            }
            return bl;
        }

        public boolean $eq$eq$eq(Null$ literalNull) {
            return this.leftSide() == null;
        }

        public boolean $bang$eq$eq(Null$ literalNull) {
            return this.leftSide() != null;
        }

        public final TripleEqualsSupport org$scalactic$TripleEqualsSupport$Equalizer$$$outer() {
            return this.$outer;
        }
    }

    public static final class Spread<T>
    implements Product,
    Serializable {
        private final Object pivot;
        private final Object tolerance;
        private final Numeric<T> numeric;
        private final T max;
        private final T min;

        public static <T> Spread<T> apply(T t, T t2, Numeric<T> numeric) {
            return TripleEqualsSupport$Spread$.MODULE$.apply(t, t2, numeric);
        }

        public static <T> Spread<T> unapply(Spread<T> spread) {
            return TripleEqualsSupport$Spread$.MODULE$.unapply(spread);
        }

        public Spread(T pivot, T tolerance, Numeric<T> evidence$1) {
            this.pivot = pivot;
            this.tolerance = tolerance;
            this.numeric = (Numeric)Predef$.MODULE$.implicitly(evidence$1);
            Predef$.MODULE$.require(this.numeric.signum(tolerance) >= 0, () -> this.$init$$$anonfun$1(tolerance));
            this.max = this.numeric.plus(pivot, tolerance);
            this.min = this.numeric.minus(pivot, tolerance);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Spread)) return false;
            Spread spread = (Spread)object;
            if (!BoxesRunTime.equals(this.pivot(), spread.pivot())) return false;
            if (!BoxesRunTime.equals(this.tolerance(), spread.tolerance())) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Spread;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Spread";
        }

        public Object productElement(int n) {
            T t;
            int n2 = n;
            if (0 == n2) {
                t = this._1();
            } else if (1 == n2) {
                t = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return t;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "pivot";
            } else if (1 == n2) {
                string = "tolerance";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public T pivot() {
            return (T)this.pivot;
        }

        public T tolerance() {
            return (T)this.tolerance;
        }

        public boolean isWithin(T n) {
            return this.numeric.gteq(n, this.min) && this.numeric.lteq(n, this.max);
        }

        public boolean $eq$eq$eq(T n) {
            return this.isWithin(n);
        }

        public boolean $bang$eq$eq(T n) {
            return !this.isWithin(n);
        }

        public String toString() {
            return Prettifier$.MODULE$.default().apply(this.pivot()) + " +- " + Prettifier$.MODULE$.default().apply(this.tolerance());
        }

        public <T> Spread<T> copy(T pivot, T tolerance, Numeric<T> evidence$1) {
            return new Spread<T>(pivot, tolerance, evidence$1);
        }

        public <T> T copy$default$1() {
            return this.pivot();
        }

        public <T> T copy$default$2() {
            return this.tolerance();
        }

        public T _1() {
            return this.pivot();
        }

        public T _2() {
            return this.tolerance();
        }

        private final String $init$$$anonfun$1(Object tolerance$1) {
            return "tolerance must be zero or greater, but was " + tolerance$1;
        }
    }

    public static final class TripleEqualsInvocation<T>
    implements Product,
    Serializable {
        private final Object right;
        private final boolean expectingEqual;

        public static <T> TripleEqualsInvocation<T> apply(T t, boolean bl) {
            return TripleEqualsSupport$TripleEqualsInvocation$.MODULE$.apply(t, bl);
        }

        public static TripleEqualsInvocation fromProduct(Product product) {
            return TripleEqualsSupport$TripleEqualsInvocation$.MODULE$.fromProduct(product);
        }

        public static <T> TripleEqualsInvocation<T> unapply(TripleEqualsInvocation<T> tripleEqualsInvocation) {
            return TripleEqualsSupport$TripleEqualsInvocation$.MODULE$.unapply(tripleEqualsInvocation);
        }

        public TripleEqualsInvocation(T right, boolean expectingEqual) {
            this.right = right;
            this.expectingEqual = expectingEqual;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.right()));
            n = Statics.mix((int)n, (int)(this.expectingEqual() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TripleEqualsInvocation)) return false;
            TripleEqualsInvocation tripleEqualsInvocation = (TripleEqualsInvocation)object;
            if (this.expectingEqual() != tripleEqualsInvocation.expectingEqual()) return false;
            if (!BoxesRunTime.equals(this.right(), tripleEqualsInvocation.right())) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof TripleEqualsInvocation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "TripleEqualsInvocation";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = BoxesRunTime.boxToBoolean((boolean)this._2());
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "right";
            } else if (1 == n2) {
                string = "expectingEqual";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public T right() {
            return (T)this.right;
        }

        public boolean expectingEqual() {
            return this.expectingEqual;
        }

        public String toString() {
            return (this.expectingEqual() ? "===" : "!==") + " " + Prettifier$.MODULE$.default().apply(this.right());
        }

        public <T> TripleEqualsInvocation<T> copy(T right, boolean expectingEqual) {
            return new TripleEqualsInvocation<T>(right, expectingEqual);
        }

        public <T> T copy$default$1() {
            return this.right();
        }

        public boolean copy$default$2() {
            return this.expectingEqual();
        }

        public T _1() {
            return this.right();
        }

        public boolean _2() {
            return this.expectingEqual();
        }
    }

    public static final class TripleEqualsInvocationOnSpread<T>
    implements Product,
    Serializable {
        private final Spread spread;
        private final boolean expectingEqual;

        public static <T> TripleEqualsInvocationOnSpread<T> apply(Spread<T> spread, boolean bl) {
            return TripleEqualsSupport$TripleEqualsInvocationOnSpread$.MODULE$.apply(spread, bl);
        }

        public static TripleEqualsInvocationOnSpread fromProduct(Product product) {
            return TripleEqualsSupport$TripleEqualsInvocationOnSpread$.MODULE$.fromProduct(product);
        }

        public static <T> TripleEqualsInvocationOnSpread<T> unapply(TripleEqualsInvocationOnSpread<T> tripleEqualsInvocationOnSpread) {
            return TripleEqualsSupport$TripleEqualsInvocationOnSpread$.MODULE$.unapply(tripleEqualsInvocationOnSpread);
        }

        public TripleEqualsInvocationOnSpread(Spread<T> spread, boolean expectingEqual) {
            this.spread = spread;
            this.expectingEqual = expectingEqual;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.spread()));
            n = Statics.mix((int)n, (int)(this.expectingEqual() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TripleEqualsInvocationOnSpread)) return false;
            TripleEqualsInvocationOnSpread tripleEqualsInvocationOnSpread = (TripleEqualsInvocationOnSpread)object;
            if (this.expectingEqual() != tripleEqualsInvocationOnSpread.expectingEqual()) return false;
            Spread<T> spread = this.spread();
            Spread<T> spread2 = tripleEqualsInvocationOnSpread.spread();
            if (spread != null) {
                if (!((Object)spread).equals(spread2)) return false;
                return true;
            }
            if (spread2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TripleEqualsInvocationOnSpread;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "TripleEqualsInvocationOnSpread";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            if (0 == n2) {
                serializable = this._1();
            } else if (1 == n2) {
                serializable = BoxesRunTime.boxToBoolean((boolean)this._2());
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "spread";
            } else if (1 == n2) {
                string = "expectingEqual";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Spread<T> spread() {
            return this.spread;
        }

        public boolean expectingEqual() {
            return this.expectingEqual;
        }

        public <T> TripleEqualsInvocationOnSpread<T> copy(Spread<T> spread, boolean expectingEqual) {
            return new TripleEqualsInvocationOnSpread<T>(spread, expectingEqual);
        }

        public <T> Spread<T> copy$default$1() {
            return this.spread();
        }

        public boolean copy$default$2() {
            return this.expectingEqual();
        }

        public Spread<T> _1() {
            return this.spread();
        }

        public boolean _2() {
            return this.expectingEqual();
        }
    }
}

