/*
 * Decompiled with CFR 0.152.
 */
package scalaj.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalaj.http.Base64;
import scalaj.http.HttpConstants$;
import scalaj.http.HttpOptions$;
import scalaj.http.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpConstants$
implements ScalaObject {
    public static final HttpConstants$ MODULE$;
    private final Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode;
    private final String utf8;

    static {
        new HttpConstants$();
    }

    public Seq<Function1<HttpURLConnection, BoxedUnit>> defaultOptions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{HttpOptions$.MODULE$.connTimeout(1000), HttpOptions$.MODULE$.readTimeout(5000), HttpOptions$.MODULE$.followRedirects(false)}));
    }

    public Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode() {
        return this.setFixedLengthStreamingMode;
    }

    public String urlEncode(String name, String charset) {
        return URLEncoder.encode(name, charset);
    }

    public String urlDecode(String name, String charset) {
        return URLDecoder.decode(name, charset);
    }

    public String base64(byte[] bytes) {
        return new String(Base64.encode(bytes));
    }

    public String base64(String in) {
        return this.base64(in.getBytes(this.utf8()));
    }

    public String toQs(Seq<Tuple2<String, String>> params, String charset$2) {
        return ((TraversableOnce)params.map((Function1)new Serializable(charset$2){
            public static final long serialVersionUID;
            private final String charset$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Tuple2<String, String> p) {
                return new StringBuilder().append((Object)HttpConstants$.MODULE$.urlEncode((String)p._1(), this.charset$2)).append((Object)"=").append((Object)HttpConstants$.MODULE$.urlEncode((String)p._2(), this.charset$2)).toString();
            }
            {
                this.charset$2 = string;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("&");
    }

    public String appendQs(String url, Seq<Tuple2<String, String>> params, String charset) {
        return new StringBuilder().append((Object)url).append((Object)(params.isEmpty() ? "" : new StringBuilder().append((Object)(url.contains("?") ? "&" : "?")).append((Object)this.toQs(params, charset)).toString())).toString();
    }

    public String readString(InputStream is) {
        return this.readString(is, this.utf8());
    }

    public String readString(InputStream is, String charset) {
        String string;
        if (is == null) {
            string = "";
        } else {
            InputStreamReader in$2 = new InputStreamReader(is, charset);
            StringBuilder bos$1 = new StringBuilder();
            char[] ba$1 = new char[4096];
            this.readOnce$2(in$2, bos$1, ba$1);
            string = bos$1.toString();
        }
        return string;
    }

    public byte[] readBytes(InputStream in$1) {
        byte[] byArray;
        if (in$1 == null) {
            byArray = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, (ClassManifest)Manifest$.MODULE$.Byte());
        } else {
            ByteArrayOutputStream bos$2 = new ByteArrayOutputStream();
            byte[] ba$2 = new byte[4096];
            this.readOnce$3(in$1, bos$2, ba$2);
            byArray = bos$2.toByteArray();
        }
        return byArray;
    }

    public Seq<Tuple2<String, String>> readParams(InputStream in, String charset$3) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.readString(in, charset$3).split("&")).flatMap((Function1)new Serializable(charset$3){
            public static final long serialVersionUID;
            private final String charset$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Iterable<Tuple2<String, String>> apply(String string) {
                IndexedSeq indexedSeq;
                String[] stringArray = string.split("=");
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                return !option.isEmpty() && ((indexedSeq = (IndexedSeq)option.get()) == null ? false : indexedSeq.lengthCompare(2) == 0) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)HttpConstants$.MODULE$.urlDecode((String)indexedSeq.apply(0), this.charset$3), (Object)HttpConstants$.MODULE$.urlDecode((String)indexedSeq.apply(1), this.charset$3)))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            {
                this.charset$3 = string;
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(String.class)}))))).toList();
    }

    public String readParams$default$2() {
        return this.utf8();
    }

    public Map<String, String> readParamMap(InputStream in, String charset) {
        return (Map)Predef$.MODULE$.Map().apply(this.readParams(in, charset));
    }

    public String readParamMap$default$2() {
        return this.utf8();
    }

    public Token readToken(InputStream in) {
        Map<String, String> params = this.readParamMap(in, this.readParamMap$default$2());
        return new Token((String)params.apply((Object)"oauth_token"), (String)params.apply((Object)"oauth_token_secret"));
    }

    public Proxy proxy(String host, int port, Proxy.Type proxyType) {
        return new Proxy(proxyType, new InetSocketAddress(host, port));
    }

    public Proxy.Type proxy$default$3() {
        return Proxy.Type.HTTP;
    }

    public String utf8() {
        return this.utf8;
    }

    /*
     * WARNING - void declaration
     */
    private final Tuple2 liftedTree1$1(Class clazz) {
        void var2_2;
        Tuple2 exceptionResult2 = null;
        try {
            exceptionResult2 = Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)true)).$minus$greater((Object)clazz.getDeclaredMethod("setFixedLengthStreamingMode", Long.TYPE));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exceptionResult2 = Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)false)).$minus$greater((Object)clazz.getDeclaredMethod("setFixedLengthStreamingMode", Integer.TYPE));
        }
        return var2_2;
    }

    private final void readOnce$2(InputStreamReader inputStreamReader, StringBuilder stringBuilder, char[] cArray) {
        int len;
        do {
            Object object = (len = inputStreamReader.read(cArray)) > 0 ? stringBuilder.appendAll(cArray, 0, len) : BoxedUnit.UNIT;
        } while (len >= 0);
    }

    private final void readOnce$3(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) {
        int len;
        do {
            if ((len = inputStream.read(byArray)) <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, len);
        } while (len >= 0);
    }

    private HttpConstants$() {
        MODULE$ = this;
        Class<HttpURLConnection> connClass$1 = HttpURLConnection.class;
        Tuple2 tuple2 = this.liftedTree1$1(connClass$1);
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            boolean isLong$1 = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
            Method theMethod$1 = (Method)tuple22._2();
            this.setFixedLengthStreamingMode = new anonfun.11(isLong$1, theMethod$1);
            this.utf8 = "UTF-8";
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

