/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import munit.internal.junitinterface.AbstractEvent;
import munit.internal.junitinterface.Ansi;
import munit.internal.junitinterface.OutputCapture;
import munit.internal.junitinterface.RichLogger;
import munit.internal.junitinterface.RunSettings;
import munit.internal.junitinterface.RunStatistics;
import munit.internal.junitinterface.Settings;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Status;

final class EventDispatcher
extends RunListener {
    private final RichLogger logger;
    private final Set<Description> reported = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> reportedSuites = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentHashMap<String, Long> startTimes = new ConcurrentHashMap();
    private final EventHandler handler;
    private final RunSettings settings;
    private final Fingerprint fingerprint;
    private final String taskInfo;
    private final RunStatistics runStatistics;
    private OutputCapture capture;

    EventDispatcher(RichLogger richLogger, EventHandler eventHandler, RunSettings runSettings, Fingerprint fingerprint, Description description, RunStatistics runStatistics) {
        this.logger = richLogger;
        this.handler = eventHandler;
        this.settings = runSettings;
        this.fingerprint = fingerprint;
        this.taskInfo = runSettings.buildPlainName(description);
        this.runStatistics = runStatistics;
    }

    public void testAssumptionFailure(final Failure failure) {
        this.uncapture(true);
        this.postIfFirst(failure.getDescription(), new ErrorEvent(failure, Status.Skipped){

            @Override
            void logTo(RichLogger richLogger) {
                if (((EventDispatcher)EventDispatcher.this).settings.verbose) {
                    richLogger.info(Ansi.c("==> i " + failure.getDescription().getMethodName(), "\u001b[93m"));
                }
            }
        });
    }

    public void testFailure(Failure failure) {
        if (failure.getDescription() != null && failure.getDescription().getClassName() != null) {
            try {
                EventDispatcher.trimStackTrace(failure.getException(), "java.lang.Thread", failure.getDescription().getClassName(), this.settings);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.uncapture(true);
        this.postIfFirst(failure.getDescription(), new ErrorEvent(failure, Status.Failure){

            @Override
            void logTo(RichLogger richLogger) {
                richLogger.error(EventDispatcher.this.settings.buildTestResult(Status.Failure) + this.ansiName + " " + this.durationSuffix() + " " + this.ansiMsg, this.error);
            }
        });
    }

    public void testFinished(final Description description) {
        this.uncapture(false);
        this.postIfFirst(description, new InfoEvent(description, Status.Success){

            @Override
            void logTo(RichLogger richLogger) {
                richLogger.info(EventDispatcher.this.settings.buildTestResult(Status.Success) + Ansi.c(description.getMethodName(), "\u001b[32m") + this.durationSuffix());
            }
        });
        this.logger.popCurrentTestClassName();
    }

    public void testIgnored(Description description) {
        this.postIfFirst(description, new InfoEvent(description, Status.Skipped){

            @Override
            void logTo(RichLogger richLogger) {
                richLogger.warn(EventDispatcher.this.settings.buildTestResult(Status.Ignored) + this.ansiName + " ignored" + this.durationSuffix());
            }
        });
    }

    public void testSuiteStarted(Description description) {
        if (description == null || description.getClassName() == null || description.getClassName().equals("null")) {
            return;
        }
        this.reportedSuites.add(description.getClassName());
        this.logger.info(Ansi.c(description.getClassName() + ":", "\u001b[32m"));
    }

    public void testStarted(Description description) {
        this.recordStartTime(description);
        if (this.reportedSuites.add(description.getClassName())) {
            this.testSuiteStarted(description);
        }
        this.logger.pushCurrentTestClassName(description.getClassName());
        if (this.settings.verbose) {
            this.logger.info(this.settings.buildPlainName(description) + " started");
        }
        this.capture();
    }

    private void recordStartTime(Description description) {
        this.startTimes.putIfAbsent(this.settings.buildPlainName(description), System.currentTimeMillis());
    }

    private Long elapsedTime(Description description) {
        Long l = this.startTimes.get(this.settings.buildPlainName(description));
        if (l == null) {
            return 0L;
        }
        return System.currentTimeMillis() - l;
    }

    public void testRunFinished(Result result) {
        if (this.settings.verbose) {
            this.logger.info("Test run " + this.taskInfo + " finished: " + result.getFailureCount() + " failed, " + result.getIgnoreCount() + " ignored, " + result.getRunCount() + " total, " + (double)result.getRunTime() / 1000.0 + "s");
        }
        this.runStatistics.addTime(result.getRunTime());
    }

    public void testRunStarted(Description description) {
        if (this.settings.verbose) {
            this.logger.info(this.taskInfo + " started");
        }
    }

    void testExecutionFailed(String string, Throwable throwable) {
        this.post(new Event(Ansi.c(string, "\u001b[91m"), this.settings.buildErrorMessage(throwable), Status.Error, (Long)0L, throwable){

            @Override
            void logTo(RichLogger richLogger) {
                richLogger.error(this.ansiName + " failed: " + this.ansiMsg, this.error);
            }
        });
    }

    private void postIfFirst(Description description, AbstractEvent abstractEvent) {
        if (this.reported.add(description)) {
            abstractEvent.logTo(this.logger);
            this.runStatistics.captureStats(abstractEvent);
            this.handler.handle((sbt.testing.Event)abstractEvent);
        }
    }

    void post(AbstractEvent abstractEvent) {
        abstractEvent.logTo(this.logger);
        this.runStatistics.captureStats(abstractEvent);
        this.handler.handle((sbt.testing.Event)abstractEvent);
    }

    private void capture() {
        if (this.settings.quiet && this.capture == null) {
            this.capture = OutputCapture.start();
        }
    }

    void uncapture(boolean bl) {
        if (this.settings.quiet && this.capture != null) {
            this.capture.stop();
            if (bl) {
                try {
                    this.capture.replay();
                }
                catch (IOException iOException) {
                    this.logger.error("Error replaying captured stdio", iOException);
                }
            }
            this.capture = null;
        }
    }

    private static void trimStackTrace(Throwable throwable, String string, String string2, Settings settings) {
        if (!settings.trimStackTraces()) {
            return;
        }
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            StackTraceElement stackTraceElement;
            int n;
            StackTraceElement stackTraceElement2;
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            if (stackTraceElementArray == null || stackTraceElementArray.length <= 0 || (stackTraceElement2 = stackTraceElementArray[n = stackTraceElementArray.length - 1]).getClassName() == null || !stackTraceElement2.getClassName().equals(string)) continue;
            boolean bl = false;
            while (n >= 0 && !(stackTraceElement = stackTraceElementArray[n]).getClassName().equals(string2)) {
                --n;
            }
            StackTraceElement[] stackTraceElementArray2 = Arrays.copyOfRange(stackTraceElementArray, 0, n + 1);
            throwable2.setStackTrace(stackTraceElementArray2);
        }
    }

    private abstract class InfoEvent
    extends Event {
        InfoEvent(Description description, Status status) {
            super(EventDispatcher.this.settings.buildInfoName(description, status), null, status, EventDispatcher.this.elapsedTime(description), null);
        }
    }

    private abstract class ErrorEvent
    extends Event {
        ErrorEvent(Failure failure, Status status) {
            super(EventDispatcher.this.settings.buildErrorName(failure.getDescription(), status), EventDispatcher.this.settings.buildErrorMessage(failure.getException()), status, EventDispatcher.this.elapsedTime(failure.getDescription()), failure.getException());
        }
    }

    private abstract class Event
    extends AbstractEvent {
        Event(String string, String string2, Status status, Long l, Throwable throwable) {
            super(string, string2, status, EventDispatcher.this.fingerprint, l, throwable);
        }

        String durationSuffix() {
            return " " + this.durationToString();
        }
    }
}

