/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import munit.internal.junitinterface.EventDispatcher;
import munit.internal.junitinterface.GlobFilter;
import munit.internal.junitinterface.JUnitComputer;
import munit.internal.junitinterface.JUnitFingerprint;
import munit.internal.junitinterface.JUnitRunner;
import munit.internal.junitinterface.RichLogger;
import munit.internal.junitinterface.RunSettings;
import munit.internal.junitinterface.SilentFilterRequest;
import munit.internal.junitinterface.TagFilter;
import munit.internal.junitinterface.TestFilter;
import org.junit.experimental.categories.Categories;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Logger;
import sbt.testing.Task;
import sbt.testing.TaskDef;

final class JUnitTask
implements Task {
    private static final Fingerprint JUNIT_FP = new JUnitFingerprint();
    private final JUnitRunner runner;
    private final RunSettings settings;
    private final TaskDef taskDef;
    private final JUnitComputer computer;
    private static final PrintStream EMPTY_PRINTSTREAM = new PrintStream(new OutputStream(){

        @Override
        public void write(int n) {
        }
    });

    public JUnitTask(JUnitRunner jUnitRunner, RunSettings runSettings, TaskDef taskDef, JUnitComputer jUnitComputer) {
        this.runner = jUnitRunner;
        this.settings = runSettings;
        this.taskDef = taskDef;
        this.computer = jUnitComputer;
    }

    public String[] tags() {
        return new String[0];
    }

    public TaskDef taskDef() {
        return this.taskDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task[] execute(EventHandler eventHandler, Logger[] loggerArray) {
        Fingerprint fingerprint = this.taskDef.fingerprint();
        String string = this.taskDef.fullyQualifiedName();
        Description description = Description.createSuiteDescription((String)string, (Annotation[])new Annotation[0]);
        RichLogger richLogger = new RichLogger(loggerArray, this.settings, string, this.runner);
        EventDispatcher eventDispatcher = new EventDispatcher(richLogger, eventHandler, this.settings, fingerprint, description, this.runner.runStatistics);
        JUnitCore jUnitCore = new JUnitCore();
        jUnitCore.addListener((RunListener)eventDispatcher);
        if (this.runner.runListener != null) {
            jUnitCore.addListener(this.runner.runListener);
        }
        Map<String, Object> map = this.settings.overrideSystemProperties();
        PrintStream printStream = System.err;
        try {
            this.suppressSystemError();
            try {
                Class<?> clazz = this.runner.testClassLoader.loadClass(string);
                boolean bl = this.shouldRun(fingerprint, clazz, this.settings);
                if (bl) {
                    Request request = Request.classes((Computer)this.computer, (Class[])new Class[]{clazz});
                    if (this.settings.globPatterns.size() > 0) {
                        request = new SilentFilterRequest(request, new GlobFilter(this.settings, this.settings.globPatterns));
                    }
                    if (this.settings.testFilter.length() > 0) {
                        request = new SilentFilterRequest(request, new TestFilter(this.settings.testFilter, eventDispatcher));
                    }
                    if (!this.settings.includeCategories.isEmpty() || !this.settings.excludeCategories.isEmpty()) {
                        request = new SilentFilterRequest(request, (Filter)Categories.CategoryFilter.categoryFilter((boolean)true, JUnitTask.loadClasses(this.runner.testClassLoader, this.settings.includeCategories), (boolean)true, JUnitTask.loadClasses(this.runner.testClassLoader, this.settings.excludeCategories)));
                    }
                    if (!this.settings.includeTags.isEmpty() || !this.settings.excludeTags.isEmpty()) {
                        request = new SilentFilterRequest(request, new TagFilter(this.settings.includeTags, this.settings.excludeTags));
                    }
                    jUnitCore.run(request);
                }
            }
            catch (Exception exception) {
                eventDispatcher.testExecutionFailed(string, exception);
            }
        }
        finally {
            this.settings.restoreSystemProperties(map);
            System.setErr(printStream);
        }
        return new Task[0];
    }

    private void suppressSystemError() {
        if (this.settings.suppressSystemError) {
            System.setErr(EMPTY_PRINTSTREAM);
        }
    }

    private boolean shouldRun(Fingerprint fingerprint, Class<?> clazz, RunSettings runSettings) {
        if (JUNIT_FP.equals(fingerprint)) {
            if (TestCase.class.isAssignableFrom(clazz)) {
                return false;
            }
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(RunWith.class)) continue;
                return false;
            }
            return true;
        }
        RunWith runWith = clazz.getAnnotation(RunWith.class);
        if (runWith != null) {
            return !runSettings.ignoreRunner(runWith.value().getName());
        }
        return true;
    }

    private static Set<Class<?>> loadClasses(ClassLoader classLoader, Set<String> set) throws ClassNotFoundException {
        HashSet hashSet = new HashSet();
        for (String string : set) {
            hashSet.add(classLoader.loadClass(string));
        }
        return hashSet;
    }
}

