/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import munit.internal.junitinterface.Ansi;
import munit.internal.junitinterface.JUnitRunner;
import munit.internal.junitinterface.RunSettings;
import sbt.testing.Logger;

final class RichLogger {
    private final Logger[] loggers;
    private final RunSettings settings;
    private final JUnitRunner runner;
    private final Stack<String> currentTestClassName = new Stack();
    private final Map<String, Boolean> highlightedCache = new HashMap<String, Boolean>();

    RichLogger(Logger[] loggerArray, RunSettings runSettings, String string, JUnitRunner jUnitRunner) {
        this.loggers = loggerArray;
        this.settings = runSettings;
        this.runner = jUnitRunner;
        this.currentTestClassName.push(string);
    }

    void pushCurrentTestClassName(String string) {
        this.currentTestClassName.push(string);
    }

    void popCurrentTestClassName() {
        if (this.currentTestClassName.size() > 1) {
            this.currentTestClassName.pop();
        }
    }

    void debug(String string) {
        if (this.settings.useSbtLoggers) {
            for (Logger logger : this.loggers) {
                if (this.settings.color && logger.ansiCodesSupported()) {
                    logger.debug(string);
                    continue;
                }
                logger.debug(Ansi.filterAnsi(string));
            }
        }
    }

    void error(String string) {
        if (this.settings.useSbtLoggers) {
            for (Logger logger : this.loggers) {
                if (this.settings.color && logger.ansiCodesSupported()) {
                    logger.error(string);
                    continue;
                }
                logger.error(Ansi.filterAnsi(string));
            }
        } else {
            System.out.println(string);
        }
    }

    void error(String string, Throwable throwable) {
        this.error(string);
        if (throwable != null && (this.settings.logAssert || !(throwable instanceof AssertionError))) {
            this.logStackTrace(throwable);
        }
    }

    void info(String string) {
        if (this.settings.useSbtLoggers) {
            for (Logger logger : this.loggers) {
                if (this.settings.color && logger.ansiCodesSupported()) {
                    logger.info(string);
                    continue;
                }
                logger.info(Ansi.filterAnsi(string));
            }
        } else {
            System.out.println(string);
        }
    }

    void warn(String string) {
        if (this.settings.useSbtLoggers) {
            for (Logger logger : this.loggers) {
                if (this.settings.color && logger.ansiCodesSupported()) {
                    logger.warn(string);
                    continue;
                }
                logger.warn(Ansi.filterAnsi(string));
            }
        } else {
            System.out.println(string);
        }
    }

    void warn(String string, Throwable throwable) {
        this.warn(string);
        if (throwable != null && (this.settings.logAssert || !(throwable instanceof AssertionError))) {
            this.logStackTrace(throwable);
        }
    }

    private void logStackTrace(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string = this.currentTestClassName.peek();
        String string2 = this.settings.color ? this.findTestFileName(stackTraceElementArray, string) : null;
        this.logStackTracePart(stackTraceElementArray, stackTraceElementArray.length - 1, 0, throwable, string, string2);
    }

    private void logStackTracePart(StackTraceElement[] stackTraceElementArray, int n, int n2, Throwable throwable, String string, String string2) {
        int n3;
        int n4;
        int n5 = n;
        for (n4 = n3 = 0; n4 <= n; ++n4) {
            String string3;
            if (!stackTraceElementArray[n4].toString().startsWith("org.junit.") && !stackTraceElementArray[n4].toString().startsWith("org.hamcrest.") && !stackTraceElementArray[n4].toString().startsWith("org.scalatest.")) continue;
            if (n4 == n3) {
                ++n3;
                continue;
            }
            for (n = n4 - 1; n > n3 && ((string3 = stackTraceElementArray[n].toString()).startsWith("java.lang.reflect.") || string3.startsWith("sun.reflect.")); --n) {
            }
            break;
        }
        for (n4 = n3; n4 <= n; ++n4) {
            if (stackTraceElementArray[n4].getClassName().startsWith("scala.runtime.")) continue;
            this.error(this.stackTraceElementToString(stackTraceElementArray[n4], string, string2));
        }
        if (n5 != n) {
            this.error("    ...");
        } else if (n2 != 0) {
            this.error("    ... " + n2 + " more");
        }
        this.logStackTraceAsCause(stackTraceElementArray, throwable.getCause(), string, string2);
    }

    private void logStackTraceAsCause(StackTraceElement[] stackTraceElementArray, Throwable throwable, String string, String string2) {
        if (throwable == null) {
            return;
        }
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        this.error("Caused by: " + throwable);
        this.logStackTracePart(stackTraceElementArray2, n, stackTraceElementArray2.length - 1 - n, throwable, string, string2);
    }

    private String findTestFileName(StackTraceElement[] stackTraceElementArray, String string) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string2 = stackTraceElement.getClassName();
            if (!string.equals(string2)) continue;
            return stackTraceElement.getFileName();
        }
        return null;
    }

    private boolean isHighlightedCached(String string2) {
        return this.highlightedCache.computeIfAbsent(string2, string -> this.isHighlighted((String)string));
    }

    private boolean isHighlighted(String string) {
        try {
            int n = string.lastIndexOf(46);
            String string2 = string.substring(0, n + 1).replace('.', '/');
            URL uRL = this.runner.testClassLoader.getResource(string2);
            return uRL.getProtocol().equals("file");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String stackTraceElementToString(StackTraceElement stackTraceElement, String string, String string2) {
        boolean bl = this.settings.color && (string.equals(stackTraceElement.getClassName()) || string2 != null && string2.equals(stackTraceElement.getFileName()) || this.isHighlightedCached(stackTraceElement.getClassName()));
        String string3 = bl ? "\u001b[1m" : "\u001b[90m";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Ansi.c("    at ", string3));
        stringBuilder.append(Ansi.c(this.settings.decodeName(stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName()), string3));
        stringBuilder.append(Ansi.c("(", string3));
        if (stackTraceElement.isNativeMethod()) {
            stringBuilder.append(Ansi.c("Native Method", string3));
        } else if (stackTraceElement.getFileName() == null) {
            stringBuilder.append(Ansi.c("Unknown Source", string3));
        } else {
            stringBuilder.append(Ansi.c(stackTraceElement.getFileName(), string3));
            if (stackTraceElement.getLineNumber() >= 0) {
                stringBuilder.append(':').append(Ansi.c(String.valueOf(stackTraceElement.getLineNumber()), string3));
            }
        }
        return stringBuilder.append(Ansi.c(")", string3)).toString();
    }
}

