/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import mdoc.internal.cli.Settings;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.internal.inputs.package$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.util.Try$;

public interface CliEnrichments {
    public static XtensionInputMdoc XtensionInputMdoc$(CliEnrichments $this, Input input) {
        return $this.XtensionInputMdoc(input);
    }

    default public XtensionInputMdoc XtensionInputMdoc(Input input) {
        return new XtensionInputMdoc(this, input);
    }

    public static XtensionPrintStream XtensionPrintStream$(CliEnrichments $this, PrintStream sb) {
        return $this.XtensionPrintStream(sb);
    }

    default public XtensionPrintStream XtensionPrintStream(PrintStream sb) {
        return new XtensionPrintStream(this, sb);
    }

    public static XtensionPositionMdoc XtensionPositionMdoc$(CliEnrichments $this, Position pos) {
        return $this.XtensionPositionMdoc(pos);
    }

    default public XtensionPositionMdoc XtensionPositionMdoc(Position pos) {
        return new XtensionPositionMdoc(this, pos);
    }

    public static XtensionThrowable XtensionThrowable$(CliEnrichments $this, Throwable e) {
        return $this.XtensionThrowable(e);
    }

    default public XtensionThrowable XtensionThrowable(Throwable e) {
        return new XtensionThrowable(this, e);
    }

    public static XtensionAbsolutePathLink XtensionAbsolutePathLink$(CliEnrichments $this, AbsolutePath path) {
        return $this.XtensionAbsolutePathLink(path);
    }

    default public XtensionAbsolutePathLink XtensionAbsolutePathLink(AbsolutePath path) {
        return new XtensionAbsolutePathLink(this, path);
    }

    public static String mdoc$internal$cli$CliEnrichments$XtensionInputMdoc$$_$filename$$anonfun$1(Input.VirtualFile v$2) {
        return v$2.path();
    }

    public class XtensionAbsolutePathLink {
        private final AbsolutePath path;
        private final CliEnrichments $outer;

        public XtensionAbsolutePathLink(CliEnrichments $outer, AbsolutePath path) {
            this.path = path;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String filename() {
            return this.path.toNIO().getFileName().toString();
        }

        public String extension() {
            return PathIO$.MODULE$.extension(this.path.toNIO());
        }

        public String readText() {
            return FileIO$.MODULE$.slurp(this.path, StandardCharsets.UTF_8);
        }

        public void copyTo(AbsolutePath out) {
            Files.createDirectories(this.path.toNIO().getParent(), new FileAttribute[0]);
            Files.copy(this.path.toNIO(), out.toNIO(), StandardCopyOption.REPLACE_EXISTING);
        }

        public void write(String text) {
            Files.createDirectories(this.path.toNIO().getParent(), new FileAttribute[0]);
            Files.write(this.path.toNIO(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }

        public String toRelativeLinkFrom(AbsolutePath other, String prefix) {
            return new StringBuilder(0).append(prefix).append(this.path.toRelative(this.$outer.XtensionAbsolutePathLink(other).parent()).toURI(false).toString()).toString();
        }

        public AbsolutePath parent() {
            return AbsolutePath$.MODULE$.apply(this.path.toNIO().getParent(), AbsolutePath$.MODULE$.workingDirectory());
        }

        public final CliEnrichments mdoc$internal$cli$CliEnrichments$XtensionAbsolutePathLink$$$outer() {
            return this.$outer;
        }
    }

    public class XtensionInputMdoc {
        private final Input input;
        private final CliEnrichments $outer;

        public XtensionInputMdoc(CliEnrichments $outer, Input input) {
            this.input = input;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String filename() {
            String string;
            Input input = this.input;
            if (input instanceof Input.Slice) {
                Input.Slice s = (Input.Slice)input;
                string = this.$outer.XtensionInputMdoc(s.input()).filename();
            } else if (input instanceof Input.File) {
                Input.File f = (Input.File)input;
                string = this.$outer.XtensionAbsolutePathLink(f.path()).filename();
            } else if (input instanceof Input.VirtualFile) {
                Input.VirtualFile v = (Input.VirtualFile)input;
                string = (String)Try$.MODULE$.apply(() -> this.filename$$anonfun$1(v)).getOrElse(() -> CliEnrichments.mdoc$internal$cli$CliEnrichments$XtensionInputMdoc$$_$filename$$anonfun$1(v));
            } else {
                string = package$.MODULE$.XtensionInputSyntaxStructure(this.input).syntax();
            }
            return string;
        }

        public RelativePath relativeFilename(AbsolutePath sourceroot) {
            RelativePath relativePath;
            Input input = this.input;
            if (input instanceof Input.Slice) {
                Input.Slice s = (Input.Slice)input;
                relativePath = this.$outer.XtensionInputMdoc(s.input()).relativeFilename(sourceroot);
            } else {
                relativePath = AbsolutePath$.MODULE$.apply(package$.MODULE$.XtensionInputSyntaxStructure(this.input).syntax(), AbsolutePath$.MODULE$.workingDirectory()).toRelative(sourceroot);
            }
            return relativePath;
        }

        public String toFilename(Settings settings) {
            return settings.reportRelativePaths() ? Paths.get(this.$outer.XtensionInputMdoc(this.input).filename(), new String[0]).getFileName().toString() : this.filename();
        }

        public Position.Range toPosition() {
            return scala.meta.package$.MODULE$.Position().Range().apply(this.input, 0, this.input.chars().length);
        }

        public Position toOffset(int line, int column) {
            return scala.meta.package$.MODULE$.Position().Range().apply(this.input, line, column, line, column);
        }

        public final CliEnrichments mdoc$internal$cli$CliEnrichments$XtensionInputMdoc$$$outer() {
            return this.$outer;
        }

        private final String filename$$anonfun$1(Input.VirtualFile v$1) {
            return this.$outer.XtensionAbsolutePathLink(AbsolutePath$.MODULE$.apply(Paths.get(v$1.path(), new String[0]), AbsolutePath$.MODULE$.workingDirectory())).filename();
        }
    }

    public class XtensionPositionMdoc {
        private final Position pos;
        private final CliEnrichments $outer;

        public XtensionPositionMdoc(CliEnrichments $outer, Position pos) {
            this.pos = pos;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Position addStart(int offset) {
            Position position;
            Position position2 = this.pos;
            if (position2 instanceof Position.Range) {
                Position.Range range = (Position.Range)position2;
                Input i = range.input();
                int start = range.start();
                int end = range.end();
                position = scala.meta.package$.MODULE$.Position().Range().apply(i, start + offset, end);
            } else {
                position = this.pos;
            }
            return position;
        }

        public Position toUnslicedPosition() {
            Position position;
            Input input = this.pos.input();
            if (input instanceof Input.Slice) {
                Input.Slice slice = (Input.Slice)input;
                Input underlying = slice.input();
                int a = slice.start();
                position = this.$outer.XtensionPositionMdoc((Position)scala.meta.package$.MODULE$.Position().Range().apply(underlying, a + this.pos.start(), a + this.pos.end())).toUnslicedPosition();
            } else {
                position = this.pos;
            }
            return position;
        }

        public final CliEnrichments mdoc$internal$cli$CliEnrichments$XtensionPositionMdoc$$$outer() {
            return this.$outer;
        }
    }

    public class XtensionPrintStream {
        private final PrintStream sb;
        private final CliEnrichments $outer;

        public XtensionPrintStream(CliEnrichments $outer, PrintStream sb) {
            this.sb = sb;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public void appendMultiline(String string) {
            this.appendMultiline(string, string.length());
        }

        public void appendMultiline(String string, int N) {
            for (int i = 0; i < N; ++i) {
                PrintStream printStream;
                char c = string.charAt(i);
                if ('\n' == c) {
                    printStream = this.sb.append("\n// ");
                    continue;
                }
                char ch = c;
                printStream = this.sb.append(ch);
            }
        }

        public final CliEnrichments mdoc$internal$cli$CliEnrichments$XtensionPrintStream$$$outer() {
            return this.$outer;
        }
    }

    public class XtensionThrowable {
        private final Throwable e;
        private final CliEnrichments $outer;

        public XtensionThrowable(CliEnrichments $outer, Throwable e) {
            this.e = e;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String message() {
            return this.e.getMessage() != null ? this.e.getMessage() : (this.e.getCause() != null ? this.$outer.XtensionThrowable(this.e.getCause()).message() : "null");
        }

        public final CliEnrichments mdoc$internal$cli$CliEnrichments$XtensionThrowable$$$outer() {
            return this.$outer;
        }
    }
}

