/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import mdoc.internal.cli.Section;
import metaconfig.Conf;
import metaconfig.ConfEncoder;
import metaconfig.ConfEncoder$;
import metaconfig.annotation.Hidden;
import metaconfig.annotation.Inline;
import metaconfig.generic.Setting;
import metaconfig.generic.Settings;
import metaconfig.generic.Settings$;
import metaconfig.generic.Surface;
import metaconfig.internal.Case$;
import org.typelevel.paiges.Doc;
import org.typelevel.paiges.Doc$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.annotation.StaticAnnotation;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class HelpMessage<T> {
    private final T default;
    private final String version;
    private final String usage;
    private final Doc description;
    private final Surface<T> evidence$1;
    private final ConfEncoder<T> evidence$2;

    public HelpMessage(T t, String version, String usage, Doc description, Surface<T> evidence$1, ConfEncoder<T> evidence$2) {
        this.default = t;
        this.version = version;
        this.usage = usage;
        this.description = description;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }

    private Doc markdownish(String text) {
        ListBuffer buf = ListBuffer$.MODULE$.empty();
        ListBuffer paragraphs = ListBuffer$.MODULE$.empty();
        BooleanRef insideCodeFence = BooleanRef.create((boolean)false);
        StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(text)).foreach((Function1 & Serializable)line -> {
            if (line.startsWith("```")) {
                boolean bl;
                HelpMessage.flush$1(buf, paragraphs, insideCodeFence);
                insideCodeFence$2.elem = bl = !insideCodeFence$2.elem;
            }
            return (ListBuffer)buf.$plus$eq(line);
        });
        HelpMessage.flush$1(buf, paragraphs, insideCodeFence);
        return Doc$.MODULE$.intercalate(Doc$.MODULE$.line(), (Iterable)paragraphs);
    }

    public String options(int width) {
        Settings settings = Settings$.MODULE$.apply(this.evidence$1);
        Conf.Obj obj = ConfEncoder$.MODULE$.apply(this.evidence$2).writeObj(this.default);
        StringBuilder sb = new StringBuilder();
        ((List)settings.settings().zip((IterableOnce)obj.values())).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            Setting setting = (Setting)tuple2._1();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            Conf value = (Conf)tuple22._2();
            if (setting.annotations().exists((Function1 & Serializable)_$2 -> _$2 instanceof Inline)) {
                setting.underlying().toList().foreach((Function1)(JProcedure1 & Serializable)underlying -> ((IterableOps)underlying.settings().zip((IterableOnce)((Conf.Obj)value).values())).withFilter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) return false;
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Setting field = (Setting)tuple2._1();
                    if (tuple22 == null) return false;
                    Conf fieldDefault = (Conf)tuple22._2();
                    return true;
                }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Setting field;
                    Tuple2 tuple2;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = x$1;
                            if (tuple22 == null) break block2;
                            tuple2 = (Tuple2)tuple22._2();
                            field = (Setting)tuple22._1();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    Conf fieldDefault = (Conf)tuple2._2();
                    this.printOption$5(width, sb, field, fieldDefault);
                }));
                return;
            } else {
                this.printOption$5(width, sb, setting, value);
            }
        });
        return sb.toString();
    }

    public void helpMessage(PrintStream out, int width) {
        out.println(this.version);
        out.println(this.usage);
        out.println(this.description.render(width));
        out.println(this.options(width));
    }

    public String helpMessage(int width) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.helpMessage(new PrintStream(baos), width);
        return baos.toString(StandardCharsets.UTF_8.name());
    }

    private static final void flush$1(ListBuffer buf$1, ListBuffer paragraphs$1, BooleanRef insideCodeFence$1) {
        ListBuffer listBuffer = insideCodeFence$1.elem ? (ListBuffer)paragraphs$1.$plus$eq((Object)Doc$.MODULE$.intercalate(Doc$.MODULE$.line(), (Iterable)buf$1.map((Function1 & Serializable)str -> Doc$.MODULE$.text(str)))) : (ListBuffer)paragraphs$1.$plus$eq((Object)Doc$.MODULE$.paragraph(buf$1.mkString("\n")));
        buf$1.clear();
    }

    private final void printOption$5(int width$1, StringBuilder sb$1, Setting setting, Conf value) {
        if (setting.annotations().exists((Function1 & Serializable)_$1 -> _$1 instanceof Hidden)) {
            return;
        }
        setting.annotations().foreach((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit;
            StaticAnnotation staticAnnotation = x$1;
            if (staticAnnotation instanceof Section) {
                Section section = (Section)staticAnnotation;
                boxedUnit = sb$1.append("\n").append(section.name()).append(":\n");
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        String name2 = Case$.MODULE$.camelToKebab(setting.name());
        sb$1.append("\n").append("  --").append(name2);
        setting.extraNames().foreach((Function1)(JProcedure1 & Serializable)name -> {
            if (name.length() == 1) {
                sb$1.append(" | -").append(Case$.MODULE$.camelToKebab(name));
            }
        });
        if (!setting.isBoolean()) {
            sb$1.append(" ").append(setting.tpe()).append(" (default: ").append(value.toString()).append(")");
        }
        sb$1.append("\n");
        setting.description().foreach((Function1 & Serializable)description -> sb$1.append("    ").append(this.markdownish((String)description).nested(4).render(width$1)).append('\n'));
    }
}

