/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import mdoc.Variable;
import pprint.PPrinter;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class ReplVariablePrinter
implements Function1<Variable, String> {
    private final boolean leadingNewline;
    private final int width;
    private final int height;

    public ReplVariablePrinter(boolean leadingNewline, int width, int height, int indent) {
        this.leadingNewline = leadingNewline;
        this.width = width;
        this.height = height;
    }

    public String apply(Variable binder) {
        String string;
        if (binder.isUnit()) {
            string = "";
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream sb = new PrintStream(baos);
            if (this.leadingNewline) {
                sb.append('\n');
            }
            sb.append("// ").append(binder.name()).append(": ").append(binder.staticType()).append(" = ");
            if (binder.isToString()) {
                this.appendMultiline(sb, binder.runtimeValue().toString());
            } else {
                Option<Object> heightOverride = binder.mods().heightOverride();
                Option<Object> widthOverride = binder.mods().widthOverride();
                Iterator lines = PPrinter.BlackWhite$.MODULE$.tokenize(binder.runtimeValue(), BoxesRunTime.unboxToInt((Object)widthOverride.getOrElse(this::$anonfun$1)), BoxesRunTime.unboxToInt((Object)heightOverride.getOrElse(this::$anonfun$2)), 2, baos.size(), PPrinter.BlackWhite$.MODULE$.tokenize$default$6(), PPrinter.BlackWhite$.MODULE$.tokenize$default$7());
                lines.foreach((Function1)(JProcedure1 & Serializable)lineStr -> {
                    String line = lineStr.plainText();
                    this.appendMultiline(sb, line);
                });
            }
            string = baos.toString();
        }
        return string;
    }

    public void appendMultiline(PrintStream sb, String string) {
        this.appendMultiline(sb, string, string.length());
    }

    public void appendMultiline(PrintStream sb, String string, int N) {
        for (int i = 0; i < N; ++i) {
            PrintStream printStream;
            char c = string.charAt(i);
            if ('\n' == c) {
                printStream = sb.append("\n// ");
                continue;
            }
            char ch = c;
            printStream = sb.append(ch);
        }
    }

    private final int $anonfun$1() {
        return this.width;
    }

    private final int $anonfun$2() {
        return this.height;
    }
}

