/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.interfaces.SourcePosition;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import mdoc.Reporter;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.Settings;
import mdoc.internal.markdown.FileImport;
import mdoc.internal.markdown.Gensym;
import mdoc.internal.markdown.Instrumented;
import mdoc.internal.markdown.Instrumented$;
import mdoc.internal.markdown.Instrumenter$;
import mdoc.internal.markdown.Instrumenter$Binders$;
import mdoc.internal.markdown.MagicImports;
import mdoc.internal.markdown.Modifier;
import mdoc.internal.markdown.Nesting;
import mdoc.internal.markdown.SectionInput;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.meta.Name;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class Instrumenter {
    private final List<SectionInput> sections;
    private final Reporter reporter;
    private final String innerClassIdent;
    private final MagicImports magic;
    private final ByteArrayOutputStream out;
    private final PrintStream sb;
    private final Gensym gensym;
    private final Nesting nest;

    public static Set magicImports() {
        return Instrumenter$.MODULE$.magicImports();
    }

    public static String position(SourcePosition sourcePosition) {
        return Instrumenter$.MODULE$.position(sourcePosition);
    }

    public static String wrapBody(String string) {
        return Instrumenter$.MODULE$.wrapBody(string);
    }

    public Instrumenter(InputFile file, List<SectionInput> sections, Settings settings, Reporter reporter) {
        this.sections = sections;
        this.reporter = reporter;
        this.innerClassIdent = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 4);
        this.magic = new MagicImports(settings, reporter, file);
        this.out = new ByteArrayOutputStream();
        this.sb = new PrintStream(this.out);
        this.gensym = new Gensym();
        this.nest = new Nesting(this.sb);
    }

    public Instrumented instrument() {
        this.printAsScript();
        return Instrumented$.MODULE$.fromSource(this.out.toString(), (List<Name.Indeterminate>)this.magic().scalacOptions().toList(), (List<Name.Indeterminate>)this.magic().dependencies().toList(), (List<Name.Indeterminate>)this.magic().repositories().toList(), (List<FileImport>)package$.MODULE$.Nil(), this.reporter);
    }

    public MagicImports magic() {
        return this.magic;
    }

    public Gensym gensym() {
        return this.gensym;
    }

    public Nesting nest() {
        return this.nest;
    }

    private void printlnWithIndent(String out) {
        this.sb.println(this.innerClassIdent + out);
    }

    private void printWithIndent(String out) {
        this.sb.print(this.innerClassIdent + out);
    }

    private void printAsScript() {
        ((List)this.sections.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SectionInput section = (SectionInput)tuple2._1();
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            this.printlnWithIndent("");
            this.printlnWithIndent("$doc.startSection();");
            section.stats().foreach((Function1)(JProcedure1 & Serializable)stat -> {
                this.printlnWithIndent("$doc.startStatement(" + Instrumenter$.MODULE$.position((SourcePosition)stat.sourcePos(section.ctx())) + ");");
                this.printStatement((Trees.Tree)stat, section.mod(), this.sb, section, section.ctx());
                this.printlnWithIndent("");
                this.printlnWithIndent("$doc.endStatement();");
            });
            this.printlnWithIndent("$doc.endSection();");
        });
        this.nest().unnest();
    }

    private void printBinder(String name, SourcePosition pos) {
        this.printlnWithIndent("");
        this.printlnWithIndent("$doc.binder(" + name + ", " + Instrumenter$.MODULE$.position(pos) + ")");
    }

    private void printStatement(Trees.Tree stat, Modifier m, PrintStream sb, SectionInput section, Contexts.Context ctx) {
        List list;
        Option<List<Tuple2<String, SourcePosition>>> option;
        Trees.Tree tree = stat;
        if (tree != null && !(option = Instrumenter$Binders$.MODULE$.unapply((Trees.Tree<Null$>)tree, ctx)).isEmpty()) {
            List list2;
            List names;
            list = names = (list2 = (List)option.get());
        } else {
            String fresh = this.gensym().fresh("res", this.gensym().fresh$default$2());
            this.printWithIndent("val " + fresh + " = ");
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)fresh);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)stat.sourcePos(ctx));
            list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        List binders = list;
        Trees.Tree tree2 = stat;
        if (!(tree2 instanceof Trees.Import) || !this.magic().NonPrintable().unapply((Trees.Import)tree2)) {
            this.printWithIndent(section.show(stat, StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(this.innerClassIdent))));
        }
        binders.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            SourcePosition pos = (SourcePosition)tuple2._2();
            this.printBinder(name, pos);
        });
    }
}

