/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Run;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interfaces.SourcePosition;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourceFile$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.VirtualDirectory;
import dotty.tools.repl.AbstractFileClassLoader;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import mdoc.Reporter;
import mdoc.internal.markdown.CodeBuilder;
import mdoc.internal.markdown.FileImport;
import mdoc.internal.markdown.MarkdownCompiler$;
import mdoc.internal.pos.EmptyResult;
import mdoc.internal.pos.PositionSyntax$;
import mdoc.internal.pos.TokenEditDistance;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.internal.inputs.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JFunction0;
import scala.runtime.function.JFunction1;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public class MarkdownCompiler {
    private final String classpath;
    private final String scalacOptions;
    private final AbstractFile target;
    private InteractiveDriver driver;
    private final URLClassLoader appClassLoader;

    public static VirtualDirectory $lessinit$greater$default$3() {
        return MarkdownCompiler$.MODULE$.$lessinit$greater$default$3();
    }

    public MarkdownCompiler(String classpath, String scalacOptions, AbstractFile target) {
        this.classpath = classpath;
        this.scalacOptions = scalacOptions;
        this.target = target;
        this.driver = this.newDriver();
        Object object = Predef$.MODULE$.refArrayOps((Object[])classpath.split(File.pathSeparator));
        URL[] appClasspath = (URL[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1 & Serializable)path -> new File((String)path).toURI().toURL(), ClassTag$.MODULE$.apply(URL.class));
        this.appClassLoader = new URLClassLoader(appClasspath, this.getClass().getClassLoader());
    }

    public String scalacOptions() {
        return this.scalacOptions;
    }

    private InteractiveDriver newDriver() {
        List defaultFlags = (List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-color:never", "-unchecked", "-deprecation", "-Ximport-suggestion-timeout", "0"}));
        List options = Predef$.MODULE$.wrapRefArray((Object[])this.scalacOptions().split("\\s+")).toList();
        List settings = scala.package$.MODULE$.Nil().$colon$colon((Object)this.classpath).$colon$colon((Object)"-classpath").$colon$colon$colon(defaultFlags).$colon$colon$colon(options);
        return new InteractiveDriver(settings);
    }

    public void shutdown() {
    }

    public Seq<Path> classpathEntries() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])((String)Settings.Setting$.MODULE$.value(this.driver.currentCtx().settings().classpath(), this.driver.currentCtx())).split(File.pathSeparator));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1 & Serializable)url -> Paths.get(url, new String[0]), ClassTag$.MODULE$.apply(Path.class)));
    }

    private void reset() {
        this.driver = this.newDriver();
    }

    private void clearTarget() {
        block0: {
            AbstractFile abstractFile = this.target;
            if (!(abstractFile instanceof VirtualDirectory)) break block0;
            VirtualDirectory vdir = (VirtualDirectory)abstractFile;
            vdir.clear();
        }
    }

    private SourceFile toSource(Input input) {
        String filename = Paths.get(package$.MODULE$.XtensionInputSyntaxStructure(input).syntax(), new String[0]).getFileName().toString();
        return SourceFile$.MODULE$.virtual(filename, new String(input.chars()), SourceFile$.MODULE$.virtual$default$3());
    }

    private Input toInput(dotty.tools.dotc.interfaces.SourceFile sourceFile) {
        return Input.String$.MODULE$.apply(new String(sourceFile.content()));
    }

    public boolean hasErrors() {
        return this.driver.currentCtx().reporter().hasErrors();
    }

    public boolean hasWarnings() {
        return this.driver.currentCtx().reporter().hasWarnings();
    }

    public void compileSources(Input input, Reporter vreporter, TokenEditDistance edit, List<FileImport> fileImports, Contexts.Context context) {
        this.clearTarget();
        Compiler compiler = new Compiler();
        Run run = compiler.newRun(context);
        List inputs = (List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Input[]{input}));
        Try$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> this.compileSources$$anonfun$1(run, inputs)));
        this.report(vreporter, input, fileImports, run.runContext(), edit);
    }

    public Option<Class<?>> compile(Input input, Reporter vreporter, TokenEditDistance edit, String className, List<FileImport> fileImports, int retry) {
        None$ none$;
        block5: {
            this.reset();
            Contexts.FreshContext context = this.driver.currentCtx().fresh().setSetting(this.driver.currentCtx().settings().outputDir(), (Object)this.target);
            this.compileSources(input, vreporter, edit, fileImports, (Contexts.Context)context);
            if (!context.reporter().hasErrors()) {
                AbstractFileClassLoader loader = new AbstractFileClassLoader(this.target, (ClassLoader)this.appClassLoader);
                try {
                    none$ = Some$.MODULE$.apply((Object)loader.loadClass(className));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (retry < 1) {
                        this.reset();
                        none$ = this.compile(input, vreporter, edit, className, fileImports, retry + 1);
                        break block5;
                    }
                    vreporter.error("" + package$.MODULE$.XtensionInputSyntaxStructure(input).syntax() + ": skipping file, the compiler produced no classfiles " + "and reported no errors to explain what went wrong during compilation. " + "Please report an issue to https://github.com/scalameta/mdoc/issues.");
                    none$ = None$.MODULE$;
                }
            } else {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public int compile$default$6() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Position toMetaPosition(TokenEditDistance edit, SourcePosition position) {
        Position position2;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(edit.toOriginal(position.start()), edit.toOriginal(position.end() - 1));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Either either = (Either)tuple2._1();
        Either either2 = (Either)tuple2._2();
        if (either instanceof Right) {
            Position start = (Position)((Right)either).value();
            if (either2 instanceof Right) {
                Position end = (Position)((Right)either2).value();
                position2 = PositionSyntax$.MODULE$.XtensionPositionMdoc((Position)Position.Range$.MODULE$.apply(start.input(), start.start(), end.end())).toUnslicedPosition();
                return position2;
            }
        }
        position2 = MarkdownCompiler.toOffsetPosition$1(edit, position.point() - 1);
        return position2;
    }

    private String nullableMessage(String msgOrNull) {
        return msgOrNull == null ? "" : msgOrNull;
    }

    private void report(Reporter vreporter, Input input, List<FileImport> fileImports, Contexts.Context context, TokenEditDistance edit) {
        List infos = (List)context.reporter().allErrors().toSeq().sortBy((Function1)(JFunction1 & Serializable)_$1 -> _$1.pos().source().path(), (Ordering)Ordering.String$.MODULE$);
        infos.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            block0: {
                String line;
                Position mpos;
                Diagnostic.Error error = x$1;
                Diagnostic.Error diagnostic = error;
                if (!diagnostic.position().isPresent()) break block0;
                SourcePosition pos = (SourcePosition)diagnostic.position().get();
                String msg = this.nullableMessage(diagnostic.message());
                Position position = mpos = this.toMetaPosition(edit, pos);
                Position.None$ none$ = Position.None$.MODULE$;
                String actualMessage = !(position != null ? !position.equals(none$) : none$ != null) ? (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line = pos.lineContent())) ? this.formatMessage(pos, msg) : msg) : msg;
                this.reportMessage(vreporter, (Diagnostic)diagnostic, mpos, actualMessage);
            }
        });
    }

    private void reportMessage(Reporter vreporter, Diagnostic diagnostic, Position mpos, String message) {
        block1: {
            Diagnostic diagnostic2;
            block2: {
                block0: {
                    diagnostic2 = diagnostic;
                    if (!(diagnostic2 instanceof Diagnostic.Error)) break block0;
                    vreporter.error(mpos, message);
                    break block1;
                }
                if (!(diagnostic2 instanceof Diagnostic.Info)) break block2;
                vreporter.info(mpos, message);
                break block1;
            }
            if (!(diagnostic2 instanceof Diagnostic.Warning)) break block1;
            vreporter.warning(mpos, message);
        }
    }

    private String formatMessage(SourcePosition pos, String message) {
        return new CodeBuilder().println("" + pos.source().path() + ":" + (pos.line() + 1) + " (mdoc generated code) " + message).println(pos.lineContent()).println(BoxesRunTime.boxToInteger((int)pos.point()).toString()).toString();
    }

    private final void compileSources$$anonfun$1(Run run$1, List inputs$1) {
        run$1.compileSources(inputs$1.map((Function1)(JFunction1 & Serializable)input -> this.toSource((Input)input)));
    }

    private static final Position toOffsetPosition$1(TokenEditDistance edit$1, int offset) {
        Position.None$ none$;
        Either<EmptyResult, Position> either = edit$1.toOriginal(offset);
        if (either instanceof Left) {
            none$ = Position.None$.MODULE$;
        } else if (either instanceof Right) {
            Position p = (Position)((Right)either).value();
            none$ = PositionSyntax$.MODULE$.XtensionPositionMdoc(p).toUnslicedPosition();
        } else {
            throw new MatchError(either);
        }
        return none$;
    }
}

