/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.pos;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import mdoc.document.RangePosition;
import mdoc.internal.cli.Settings;
import mdoc.internal.markdown.EvaluatedSection;
import mdoc.internal.pos.EmptyResult;
import mdoc.internal.pos.PositionSyntax$;
import mdoc.internal.pos.PositionSyntax$XtensionPositionsScalafix$;
import mdoc.internal.pos.TokenEditDistance;
import scala.MatchError;
import scala.Option;
import scala.collection.mutable.StringBuilder;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.internal.inputs.package$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.util.Either;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class PositionSyntax {
    public static XtensionAbsolutePathLink XtensionAbsolutePathLink(AbsolutePath absolutePath) {
        return PositionSyntax$.MODULE$.XtensionAbsolutePathLink(absolutePath);
    }

    public static XtensionInputMdoc XtensionInputMdoc(Input input) {
        return PositionSyntax$.MODULE$.XtensionInputMdoc(input);
    }

    public static XtensionPositionMdoc XtensionPositionMdoc(Position position) {
        return PositionSyntax$.MODULE$.XtensionPositionMdoc(position);
    }

    public static Position XtensionPositionsScalafix(Position position) {
        return PositionSyntax$.MODULE$.XtensionPositionsScalafix(position);
    }

    public static XtensionRangePositionMdoc XtensionRangePositionMdoc(RangePosition rangePosition) {
        return PositionSyntax$.MODULE$.XtensionRangePositionMdoc(rangePosition);
    }

    public static XtensionThrowable XtensionThrowable(Throwable throwable) {
        return PositionSyntax$.MODULE$.XtensionThrowable(throwable);
    }

    public static String formatMessage(Position position, String string, String string2, boolean bl) {
        return PositionSyntax$.MODULE$.formatMessage(position, string, string2, bl);
    }

    public static boolean formatMessage$default$4() {
        return PositionSyntax$.MODULE$.formatMessage$default$4();
    }

    public static class XtensionAbsolutePathLink {
        private final AbsolutePath path;

        public XtensionAbsolutePathLink(AbsolutePath path) {
            this.path = path;
        }

        public String filename() {
            return this.path.toNIO().getFileName().toString();
        }

        public String extension() {
            return PathIO$.MODULE$.extension(this.path.toNIO());
        }

        public String readText() {
            return FileIO$.MODULE$.slurp(this.path, StandardCharsets.UTF_8);
        }

        public void copyTo(AbsolutePath out) {
            Files.createDirectories(this.path.toNIO().getParent(), new FileAttribute[0]);
            Files.copy(this.path.toNIO(), out.toNIO(), StandardCopyOption.REPLACE_EXISTING);
        }

        public void write(String text) {
            Files.createDirectories(this.path.toNIO().getParent(), new FileAttribute[0]);
            Files.write(this.path.toNIO(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }

        public String toRelativeLinkFrom(AbsolutePath other, String prefix) {
            return prefix + this.path.toRelative(PositionSyntax$.MODULE$.XtensionAbsolutePathLink(other).parent()).toURI(false).toString();
        }

        public AbsolutePath parent() {
            return AbsolutePath$.MODULE$.apply(this.path.toNIO().getParent(), AbsolutePath$.MODULE$.workingDirectory());
        }
    }

    public static class XtensionInputMdoc {
        private final Input input;

        public XtensionInputMdoc(Input input) {
            this.input = input;
        }

        public String filename() {
            String string;
            Input input = this.input;
            if (input instanceof Input.Slice) {
                Input.Slice s = (Input.Slice)input;
                string = PositionSyntax$.MODULE$.XtensionInputMdoc(s.input()).filename();
            } else {
                string = package$.MODULE$.XtensionInputSyntaxStructure(this.input).syntax();
            }
            return string;
        }

        public RelativePath relativeFilename(AbsolutePath sourceroot) {
            RelativePath relativePath;
            Input input = this.input;
            if (input instanceof Input.Slice) {
                Input.Slice s = (Input.Slice)input;
                relativePath = PositionSyntax$.MODULE$.XtensionInputMdoc(s.input()).relativeFilename(sourceroot);
            } else {
                relativePath = AbsolutePath$.MODULE$.apply(package$.MODULE$.XtensionInputSyntaxStructure(this.input).syntax(), AbsolutePath$.MODULE$.workingDirectory()).toRelative(sourceroot);
            }
            return relativePath;
        }

        public String toFilename(Settings settings) {
            return settings.reportRelativePaths() ? Paths.get(PositionSyntax$.MODULE$.XtensionInputMdoc(this.input).filename(), new String[0]).getFileName().toString() : this.filename();
        }

        public Position.Range toPosition() {
            return scala.meta.package$.MODULE$.Position().Range().apply(this.input, 0, this.input.chars().length);
        }

        public Position toOffset(int line, int column) {
            return scala.meta.package$.MODULE$.Position().Range().apply(this.input, line, column, line, column);
        }
    }

    public static class XtensionPositionMdoc {
        private final Position pos;

        public XtensionPositionMdoc(Position pos) {
            this.pos = pos;
        }

        public Position addStart(int offset) {
            Position position;
            Position position2 = this.pos;
            if (position2 instanceof Position.Range) {
                Position.Range range = (Position.Range)position2;
                Input i = range.input();
                int start = range.start();
                int end = range.end();
                position = scala.meta.package$.MODULE$.Position().Range().apply(i, start + offset, end);
            } else {
                position = this.pos;
            }
            return position;
        }

        public Position toUnslicedPosition() {
            Position position;
            Input input = this.pos.input();
            if (input instanceof Input.Slice) {
                Input.Slice slice = (Input.Slice)input;
                Input underlying = slice.input();
                int a = slice.start();
                position = PositionSyntax$.MODULE$.XtensionPositionMdoc((Position)scala.meta.package$.MODULE$.Position().Range().apply(underlying, a + this.pos.start(), a + this.pos.end())).toUnslicedPosition();
            } else {
                position = this.pos;
            }
            return position;
        }

        public RangePosition toMdoc() {
            return new RangePosition(this.pos.startLine(), this.pos.startColumn(), this.pos.endLine(), this.pos.endColumn());
        }

        public boolean contains(int offset) {
            return this.pos.start() == this.pos.end() ? this.pos.end() == offset : this.pos.start() <= offset && this.pos.end() > offset;
        }
    }

    public static final class XtensionPositionsScalafix {
        private final Position pos;

        public static boolean contains$extension(Position position, Position position2) {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.contains$extension(position, position2);
        }

        public static boolean equals$extension(Position position, Object object) {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.equals$extension(position, object);
        }

        public static String formatMessage$extension(Position position, String string, String string2) {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.formatMessage$extension(position, string, string2);
        }

        public static int hashCode$extension(Position position) {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.hashCode$extension(position);
        }

        public static String lineInput$extension(Position position) {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.lineInput$extension(position);
        }

        public static String rangeNumber$extension(Position position) {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.rangeNumber$extension(position);
        }

        public XtensionPositionsScalafix(Position pos) {
            this.pos = pos;
        }

        public int hashCode() {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.hashCode$extension(this.mdoc$internal$pos$PositionSyntax$XtensionPositionsScalafix$$pos());
        }

        public boolean equals(Object x$0) {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.equals$extension(this.mdoc$internal$pos$PositionSyntax$XtensionPositionsScalafix$$pos(), x$0);
        }

        public Position mdoc$internal$pos$PositionSyntax$XtensionPositionsScalafix$$pos() {
            return this.pos;
        }

        public boolean contains(Position other) {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.contains$extension(this.mdoc$internal$pos$PositionSyntax$XtensionPositionsScalafix$$pos(), other);
        }

        public String formatMessage(String severity, String message) {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.formatMessage$extension(this.mdoc$internal$pos$PositionSyntax$XtensionPositionsScalafix$$pos(), severity, message);
        }

        public String lineInput() {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.lineInput$extension(this.mdoc$internal$pos$PositionSyntax$XtensionPositionsScalafix$$pos());
        }

        public String rangeNumber() {
            return PositionSyntax$XtensionPositionsScalafix$.MODULE$.rangeNumber$extension(this.mdoc$internal$pos$PositionSyntax$XtensionPositionsScalafix$$pos());
        }
    }

    public static class XtensionRangePositionMdoc {
        private final RangePosition pos;

        public XtensionRangePositionMdoc(RangePosition pos) {
            this.pos = pos;
        }

        public String formatMessage(EvaluatedSection section, String message) {
            String string;
            Position position = PositionSyntax$.MODULE$.XtensionRangePositionMdoc(this.pos).toMeta(section);
            Position.None$ none$ = scala.meta.package$.MODULE$.Position().None();
            Position position2 = position;
            if (!(none$ != null ? !none$.equals(position2) : position2 != null)) {
                string = message;
            } else {
                Position mpos = position;
                string = new StringBuilder().append(message).append("\n").append(package$.MODULE$.XtensionPositionFormatMessage(mpos).lineContent()).append("\n").append(package$.MODULE$.XtensionPositionFormatMessage(mpos).lineCaret()).append("\n").toString();
            }
            return string;
        }

        public Position toMeta(EvaluatedSection section) {
            Position position;
            try {
                position = this.toMetaUnsafe(section);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    position = scala.meta.package$.MODULE$.Position().None();
                }
                throw throwable;
            }
            return position;
        }

        public Position toMetaUnsafe(EvaluatedSection section) {
            Position.Range mpos = scala.meta.package$.MODULE$.Position().Range().apply(section.input(), this.pos.startLine(), this.pos.startColumn(), this.pos.endLine(), this.pos.endColumn());
            return PositionSyntax$.MODULE$.XtensionPositionMdoc((Position)mpos).toUnslicedPosition();
        }

        public Position toOriginal(TokenEditDistance edit) {
            Either<EmptyResult, Position> either = edit.toOriginal(this.pos.startLine(), this.pos.startColumn());
            if (!(either instanceof Right)) {
                throw new MatchError(either);
            }
            Position x = (Position)((Right)either).value();
            Position x2 = x;
            return PositionSyntax$.MODULE$.XtensionPositionMdoc(x2).toUnslicedPosition();
        }
    }

    public static class XtensionThrowable {
        private final Throwable e;

        public XtensionThrowable(Throwable e) {
            this.e = e;
        }

        public String message() {
            return this.e.getMessage() != null ? this.e.getMessage() : (this.e.getCause() != null ? PositionSyntax$.MODULE$.XtensionThrowable(this.e.getCause()).message() : "null");
        }
    }
}

