/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.difflib;

import java.util.ArrayList;
import java.util.List;
import munit.internal.difflib.Delta;
import munit.internal.difflib.MyersDiff;
import munit.internal.difflib.Patch;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class DiffUtils$ {
    public static final DiffUtils$ MODULE$;

    static {
        new DiffUtils$();
    }

    public List<String> generateUnifiedDiff(String original, String revised, List<String> originalLines, Patch<String> patch, int contextSize) {
        ArrayList<String> arrayList;
        if (patch.getDeltas().isEmpty()) {
            arrayList = new ArrayList<String>();
        } else {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(new StringBuilder().append((Object)"--- ").append((Object)original).toString());
            ret.add(new StringBuilder().append((Object)"+++ ").append((Object)revised).toString());
            ArrayList<Delta<String>> patchDeltas = new ArrayList<Delta<String>>(patch.getDeltas());
            ArrayList<Delta<String>> deltas = new ArrayList<Delta<String>>();
            ObjectRef delta = ObjectRef.create((Object)((Delta)patchDeltas.get(0)));
            deltas.add((Delta)delta.elem);
            if (patchDeltas.size() > 1) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), patchDeltas.size()).foreach$mVc$sp((Function1)new Serializable(originalLines, contextSize, ret, patchDeltas, deltas, delta){
                    public static final long serialVersionUID = 0L;
                    private final List originalLines$1;
                    private final int contextSize$1;
                    private final List ret$1;
                    private final List patchDeltas$1;
                    private final List deltas$1;
                    private final ObjectRef delta$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        boolean bl;
                        int position = ((Delta)this.delta$1.elem).getOriginal().getPosition();
                        Delta nextDelta = (Delta)this.patchDeltas$1.get(i);
                        if (position + ((Delta)this.delta$1.elem).getOriginal().size() + this.contextSize$1 >= nextDelta.getOriginal().getPosition() - this.contextSize$1) {
                            bl = this.deltas$1.add(nextDelta);
                        } else {
                            ArrayList<String> curBlock = DiffUtils$.MODULE$.munit$internal$difflib$DiffUtils$$processDeltas(this.originalLines$1, this.deltas$1, this.contextSize$1);
                            this.ret$1.addAll(curBlock);
                            this.deltas$1.clear();
                            bl = this.deltas$1.add(nextDelta);
                        }
                        this.delta$1.elem = nextDelta;
                    }
                    {
                        this.originalLines$1 = originalLines$1;
                        this.contextSize$1 = contextSize$1;
                        this.ret$1 = ret$1;
                        this.patchDeltas$1 = patchDeltas$1;
                        this.deltas$1 = deltas$1;
                        this.delta$1 = delta$1;
                    }
                });
            }
            ArrayList<String> curBlock = this.munit$internal$difflib$DiffUtils$$processDeltas(originalLines, deltas, contextSize);
            ret.addAll(curBlock);
            arrayList = ret;
        }
        return arrayList;
    }

    public Patch<String> diff(List<String> original, List<String> revised) {
        return new MyersDiff<String>().diff(original, revised);
    }

    public ArrayList<String> munit$internal$difflib$DiffUtils$$processDeltas(List<String> origLines, List<Delta<String>> deltas, int contextSize) {
        int contextStart;
        int revStart;
        ArrayList<String> buffer = new ArrayList<String>();
        int origTotal = 0;
        int revTotal = 0;
        int line = 0;
        Delta<String> curDelta = deltas.get(0);
        int origStart = curDelta.getOriginal().getPosition() + 1 - contextSize;
        if (origStart < 1) {
            origStart = 1;
        }
        if ((revStart = curDelta.getRevised().getPosition() + 1 - contextSize) < 1) {
            revStart = 1;
        }
        if ((contextStart = curDelta.getOriginal().getPosition() - contextSize) < 0) {
            contextStart = 0;
        }
        for (line = contextStart; line < curDelta.getOriginal().getPosition(); ++line) {
            buffer.add(new StringBuilder().append((Object)" ").append((Object)origLines.get(line)).toString());
            ++origTotal;
            ++revTotal;
        }
        buffer.addAll(this.getDeltaText(curDelta));
        origTotal += curDelta.getOriginal().getLines().size();
        revTotal += curDelta.getRevised().getLines().size();
        for (int deltaIndex = 1; deltaIndex < deltas.size(); ++deltaIndex) {
            int intermediateStart;
            Delta<String> nextDelta = deltas.get(deltaIndex);
            for (line = intermediateStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size(); line < nextDelta.getOriginal().getPosition(); ++line) {
                buffer.add(new StringBuilder().append((Object)" ").append((Object)origLines.get(line)).toString());
                ++origTotal;
                ++revTotal;
            }
            buffer.addAll(this.getDeltaText(nextDelta));
            origTotal += nextDelta.getOriginal().getLines().size();
            revTotal += nextDelta.getRevised().getLines().size();
            curDelta = nextDelta;
        }
        for (line = contextStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size(); line < contextStart + contextSize && line < origLines.size(); ++line) {
            buffer.add(new StringBuilder().append((Object)" ").append((Object)origLines.get(line)).toString());
            ++origTotal;
            ++revTotal;
        }
        StringBuffer header = new StringBuffer();
        header.append("@@ -");
        header.append(origStart);
        header.append(",");
        header.append(origTotal);
        header.append(" +");
        header.append(revStart);
        header.append(",");
        header.append(revTotal);
        header.append(" @@");
        buffer.add(0, header.toString());
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<String> getDeltaText(Delta<String> delta) {
        void var2_2;
        ArrayList buffer = new ArrayList();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delta.getOriginal().getLines()).asScala()).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ArrayList buffer$1;

            public final boolean apply(String line) {
                return this.buffer$1.add(new StringBuilder().append((Object)"-").append((Object)line).toString());
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delta.getRevised().getLines()).asScala()).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ArrayList buffer$1;

            public final boolean apply(String line) {
                return this.buffer$1.add(new StringBuilder().append((Object)"+").append((Object)line).toString());
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
        return var2_2;
    }

    private DiffUtils$() {
        MODULE$ = this;
    }
}

