/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.File;
import java.nio.file.Path;
import java.util.Date;
import org.scalafmt.Versions$;
import org.scalafmt.cli.CliArgParser;
import org.scalafmt.cli.CliArgParser$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.CommonOptions;
import org.scalafmt.cli.DiffFiles;
import org.scalafmt.cli.FileFetchMode;
import org.scalafmt.cli.FileFetchMode$;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.cli.WriteMode$List$;
import org.scalafmt.cli.WriteMode$Override$;
import org.scalafmt.cli.WriteMode$Stdout$;
import org.scalafmt.cli.WriteMode$Test$;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.AbsoluteFile$;
import org.scalafmt.util.GitOps;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scopt.OptionParser;
import scopt.Read$;

public final class CliArgParser$ {
    public static final CliArgParser$ MODULE$;
    private final String usageExamples;
    private final OptionParser<CliOptions> scoptParser;

    static {
        new CliArgParser$();
    }

    public String usageExamples() {
        return this.usageExamples;
    }

    public OptionParser<CliOptions> scoptParser() {
        return this.scoptParser;
    }

    public String buildInfo() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"build commit: ", "\n      |build time: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Versions$.MODULE$.commit(), new Date(new StringOps(Predef$.MODULE$.augmentString(Versions$.MODULE$.timestamp())).toLong())})))).stripMargin();
    }

    public CliOptions org$scalafmt$cli$CliArgParser$$writeMode(CliOptions c, WriteMode writeMode2) {
        return (CliOptions)c.writeModeOpt().fold((Function0)new Serializable(c, writeMode2){
            public static final long serialVersionUID = 0L;
            private final CliOptions c$1;
            private final WriteMode writeMode$1;

            public final CliOptions apply() {
                Some x$436 = new Some((Object)this.writeMode$1);
                Option<Path> x$437 = this.c$1.copy$default$1();
                Option<String> x$438 = this.c$1.copy$default$2();
                Set<Range> x$439 = this.c$1.copy$default$3();
                Seq<AbsoluteFile> x$440 = this.c$1.copy$default$4();
                Seq<String> x$441 = this.c$1.copy$default$5();
                boolean x$442 = this.c$1.copy$default$6();
                Option<Object> x$443 = this.c$1.copy$default$7();
                boolean x$444 = this.c$1.copy$default$8();
                Option<FileFetchMode> x$445 = this.c$1.copy$default$9();
                String x$446 = this.c$1.copy$default$10();
                Option<AbsoluteFile> x$447 = this.c$1.copy$default$11();
                CommonOptions x$448 = this.c$1.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$449 = this.c$1.copy$default$13();
                boolean x$450 = this.c$1.copy$default$15();
                boolean x$451 = this.c$1.copy$default$16();
                boolean x$452 = this.c$1.copy$default$17();
                boolean x$453 = this.c$1.copy$default$18();
                boolean x$454 = this.c$1.copy$default$19();
                boolean x$455 = this.c$1.copy$default$20();
                return this.c$1.copy(x$437, x$438, x$439, x$440, x$441, x$442, x$443, x$444, x$445, x$446, x$447, x$448, x$449, (Option<WriteMode>)x$436, x$450, x$451, x$452, x$453, x$454, x$455);
            }
            {
                this.c$1 = c$1;
                this.writeMode$1 = writeMode$1;
            }
        }, (Function1)new Serializable(c, writeMode2){
            public static final long serialVersionUID = 0L;
            private final CliOptions c$1;
            private final WriteMode writeMode$1;

            public final CliOptions apply(WriteMode x) {
                WriteMode writeMode2 = x;
                WriteMode writeMode3 = this.writeMode$1;
                if (!(writeMode2 != null ? !writeMode2.equals(writeMode3) : writeMode3 != null)) {
                    return this.c$1;
                }
                throw new CliArgParser.Conflict(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeMode changing from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x, this.writeMode$1})));
            }
            {
                this.c$1 = c$1;
                this.writeMode$1 = writeMode$1;
            }
        });
    }

    private CliArgParser$() {
        MODULE$ = this;
        this.usageExamples = new StringOps(Predef$.MODULE$.augmentString("|scalafmt # Format all files in the current project, configuration is determined in this order:\n      |         # 1. .scalafmt.conf file in current directory\n      |         # 2. .scalafmt.conf inside root directory of current git repo\n      |         # 3. no configuration, default style\n      |scalafmt --test # throw exception on mis-formatted files, won't write to files.\n      |scalafmt --mode diff # Format all files that were edited in git diff against master branch.\n      |scalafmt --mode changed # Format files listed in `git status` (latest changes against previous commit.\n      |scalafmt --diff-branch 2.x # same as --diff, except against branch 2.x\n      |scalafmt --stdin # read from stdin and print to stdout\n      |scalafmt --stdin --assume-filename foo.sbt < foo.sbt # required when using --stdin to format .sbt files.\n      |scalafmt Code1.scala A.scala       # write formatted contents to file.\n      |scalafmt --stdout Code.scala       # print formatted contents to stdout.\n      |scalafmt --exclude target          # format all files in directory excluding target\n      |scalafmt --config .scalafmt.conf   # read custom style from file.\n      |scalafmt --config-str \"style=IntelliJ\" # define custom style as a flag, must be quoted.")).stripMargin();
        this.scoptParser = new OptionParser<CliOptions>(){

            public boolean showUsageOnError() {
                return false;
            }

            public CliOptions org$scalafmt$cli$CliArgParser$$anon$$printAndExit(boolean inludeUsage, BoxedUnit ignore, CliOptions c) {
                if (inludeUsage) {
                    this.showUsage();
                } else {
                    this.showHeader();
                }
                throw scala.sys.package$.MODULE$.exit();
            }

            public CliOptions org$scalafmt$cli$CliArgParser$$anon$$readConfig(String contents, CliOptions c) {
                Some x$16 = new Some((Object)contents);
                Option<Path> x$17 = c.copy$default$1();
                Set<Range> x$18 = c.copy$default$3();
                Seq<AbsoluteFile> x$19 = c.copy$default$4();
                Seq<String> x$20 = c.copy$default$5();
                boolean x$21 = c.copy$default$6();
                Option<Object> x$22 = c.copy$default$7();
                boolean x$23 = c.copy$default$8();
                Option<FileFetchMode> x$24 = c.copy$default$9();
                String x$25 = c.copy$default$10();
                Option<AbsoluteFile> x$26 = c.copy$default$11();
                CommonOptions x$27 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$28 = c.copy$default$13();
                Option<WriteMode> x$29 = c.copy$default$14();
                boolean x$30 = c.copy$default$15();
                boolean x$31 = c.copy$default$16();
                boolean x$32 = c.copy$default$17();
                boolean x$33 = c.copy$default$18();
                boolean x$34 = c.copy$default$19();
                boolean x$35 = c.copy$default$20();
                return c.copy(x$17, (Option<String>)x$16, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35);
            }

            public CliOptions org$scalafmt$cli$CliArgParser$$anon$$readConfigFromFile(String file, CliOptions c) {
                AbsoluteFile configFile = AbsoluteFile$.MODULE$.fromFile(new File(file), c.common().workingDirectory());
                return c.copy((Option<Path>)new Some((Object)configFile.jfile().toPath()), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14(), c.copy$default$15(), c.copy$default$16(), c.copy$default$17(), c.copy$default$18(), c.copy$default$19(), c.copy$default$20());
            }

            public CliOptions org$scalafmt$cli$CliArgParser$$anon$$addFile(File file, CliOptions c) {
                AbsoluteFile absFile = AbsoluteFile$.MODULE$.fromFile(file, c.common().workingDirectory());
                Seq x$36 = (Seq)c.customFiles().$colon$plus((Object)absFile, Seq$.MODULE$.canBuildFrom());
                Option<Path> x$37 = c.copy$default$1();
                Option<String> x$38 = c.copy$default$2();
                Set<Range> x$39 = c.copy$default$3();
                Seq<String> x$40 = c.copy$default$5();
                boolean x$41 = c.copy$default$6();
                Option<Object> x$42 = c.copy$default$7();
                boolean x$43 = c.copy$default$8();
                Option<FileFetchMode> x$44 = c.copy$default$9();
                String x$45 = c.copy$default$10();
                Option<AbsoluteFile> x$46 = c.copy$default$11();
                CommonOptions x$47 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$48 = c.copy$default$13();
                Option<WriteMode> x$49 = c.copy$default$14();
                boolean x$50 = c.copy$default$15();
                boolean x$51 = c.copy$default$16();
                boolean x$52 = c.copy$default$17();
                boolean x$53 = c.copy$default$18();
                boolean x$54 = c.copy$default$19();
                boolean x$55 = c.copy$default$20();
                return c.copy(x$37, x$38, x$39, (Seq<AbsoluteFile>)x$36, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scalafmt", Versions$.MODULE$.nightly()}));
                this.opt('h', "help", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final CliOptions apply(BoxedUnit ignore, CliOptions c) {
                        return this.$outer.org$scalafmt$cli$CliArgParser$$anon$$printAndExit(true, ignore, c);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).text("prints this usage text");
                this.opt('v', "version", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final CliOptions apply(BoxedUnit ignore, CliOptions c) {
                        return this.$outer.org$scalafmt$cli$CliArgParser$$anon$$printAndExit(false, ignore, c);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).text("print version ");
                this.arg("<file>...", Read$.MODULE$.fileRead()).optional().unbounded().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final CliOptions apply(File file, CliOptions c) {
                        return this.$outer.org$scalafmt$cli$CliArgParser$$anon$$addFile(file, c);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).text(new StringOps(Predef$.MODULE$.augmentString("file, or directory (in which all *.scala files are to be formatted);\n            |if starts with '@', refers to path listing files to be formatted\n            |(with \"@-\" referring to standard input as a special case)")).stripMargin());
                this.opt('f', "files", Read$.MODULE$.seqRead(Read$.MODULE$.fileRead())).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(Seq<File> files, CliOptions c) {
                        Seq x$56 = AbsoluteFile$.MODULE$.fromFiles(files, c.common().workingDirectory());
                        Option<Path> x$57 = c.copy$default$1();
                        Option<String> x$58 = c.copy$default$2();
                        Set<Range> x$59 = c.copy$default$3();
                        Seq<String> x$60 = c.copy$default$5();
                        boolean x$61 = c.copy$default$6();
                        Option<Object> x$62 = c.copy$default$7();
                        boolean x$63 = c.copy$default$8();
                        Option<FileFetchMode> x$64 = c.copy$default$9();
                        String x$65 = c.copy$default$10();
                        Option<AbsoluteFile> x$66 = c.copy$default$11();
                        CommonOptions x$67 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$68 = c.copy$default$13();
                        Option<WriteMode> x$69 = c.copy$default$14();
                        boolean x$70 = c.copy$default$15();
                        boolean x$71 = c.copy$default$16();
                        boolean x$72 = c.copy$default$17();
                        boolean x$73 = c.copy$default$18();
                        boolean x$74 = c.copy$default$19();
                        boolean x$75 = c.copy$default$20();
                        return c.copy(x$57, x$58, x$59, (Seq<AbsoluteFile>)x$56, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75);
                    }
                }).hidden().text("file or directory, in which case all *.scala files are formatted. Deprecated: pass files as arguments");
                this.opt('i', "in-place", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$1, CliOptions c) {
                        return CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode(c, WriteMode$Override$.MODULE$);
                    }
                }).hidden().text("format files in-place (default)");
                this.opt("stdout", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$2, CliOptions c) {
                        return CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode(c, WriteMode$Stdout$.MODULE$);
                    }
                }).text("write formatted files to stdout");
                this.opt("git", Read$.MODULE$.booleanRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(boolean opt, CliOptions c) {
                        Some x$76 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)opt));
                        Option<Path> x$77 = c.copy$default$1();
                        Option<String> x$78 = c.copy$default$2();
                        Set<Range> x$79 = c.copy$default$3();
                        Seq<AbsoluteFile> x$80 = c.copy$default$4();
                        Seq<String> x$81 = c.copy$default$5();
                        boolean x$82 = c.copy$default$6();
                        boolean x$83 = c.copy$default$8();
                        Option<FileFetchMode> x$84 = c.copy$default$9();
                        String x$85 = c.copy$default$10();
                        Option<AbsoluteFile> x$86 = c.copy$default$11();
                        CommonOptions x$87 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$88 = c.copy$default$13();
                        Option<WriteMode> x$89 = c.copy$default$14();
                        boolean x$90 = c.copy$default$15();
                        boolean x$91 = c.copy$default$16();
                        boolean x$92 = c.copy$default$17();
                        boolean x$93 = c.copy$default$18();
                        boolean x$94 = c.copy$default$19();
                        boolean x$95 = c.copy$default$20();
                        return c.copy(x$77, x$78, x$79, x$80, x$81, x$82, (Option<Object>)x$76, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95);
                    }
                }).text("if true, ignore files in .gitignore (default false)");
                this.opt("exclude", Read$.MODULE$.seqRead(Read$.MODULE$.stringRead())).unbounded().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(Seq<String> excludes, CliOptions c) {
                        Seq<String> x$96 = excludes;
                        Option<Path> x$97 = c.copy$default$1();
                        Option<String> x$98 = c.copy$default$2();
                        Set<Range> x$99 = c.copy$default$3();
                        Seq<AbsoluteFile> x$100 = c.copy$default$4();
                        boolean x$101 = c.copy$default$6();
                        Option<Object> x$102 = c.copy$default$7();
                        boolean x$103 = c.copy$default$8();
                        Option<FileFetchMode> x$104 = c.copy$default$9();
                        String x$105 = c.copy$default$10();
                        Option<AbsoluteFile> x$106 = c.copy$default$11();
                        CommonOptions x$107 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$108 = c.copy$default$13();
                        Option<WriteMode> x$109 = c.copy$default$14();
                        boolean x$110 = c.copy$default$15();
                        boolean x$111 = c.copy$default$16();
                        boolean x$112 = c.copy$default$17();
                        boolean x$113 = c.copy$default$18();
                        boolean x$114 = c.copy$default$19();
                        boolean x$115 = c.copy$default$20();
                        return c.copy(x$97, x$98, x$99, x$100, x$96, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115);
                    }
                }).text("file or directory, when missing all *.scala files are formatted.");
                this.opt("respect-project-filters", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$3, CliOptions c) {
                        boolean x$116 = true;
                        Option<Path> x$117 = c.copy$default$1();
                        Option<String> x$118 = c.copy$default$2();
                        Set<Range> x$119 = c.copy$default$3();
                        Seq<AbsoluteFile> x$120 = c.copy$default$4();
                        Seq<String> x$121 = c.copy$default$5();
                        Option<Object> x$122 = c.copy$default$7();
                        boolean x$123 = c.copy$default$8();
                        Option<FileFetchMode> x$124 = c.copy$default$9();
                        String x$125 = c.copy$default$10();
                        Option<AbsoluteFile> x$126 = c.copy$default$11();
                        CommonOptions x$127 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$128 = c.copy$default$13();
                        Option<WriteMode> x$129 = c.copy$default$14();
                        boolean x$130 = c.copy$default$15();
                        boolean x$131 = c.copy$default$16();
                        boolean x$132 = c.copy$default$17();
                        boolean x$133 = c.copy$default$18();
                        boolean x$134 = c.copy$default$19();
                        boolean x$135 = c.copy$default$20();
                        return c.copy(x$117, x$118, x$119, x$120, x$121, x$116, x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135);
                    }
                }).text("use project filters even when specific files to format are provided");
                this.opt('c', "config", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final CliOptions apply(String file, CliOptions c) {
                        return this.$outer.org$scalafmt$cli$CliArgParser$$anon$$readConfigFromFile(file, c);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).text("a file path to .scalafmt.conf.");
                this.opt("config-str", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final CliOptions apply(String contents, CliOptions c) {
                        return this.$outer.org$scalafmt$cli$CliArgParser$$anon$$readConfig(contents, c);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).text("configuration defined as a string");
                this.opt("stdin", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$4, CliOptions c) {
                        boolean x$136 = true;
                        Option<Path> x$137 = c.copy$default$1();
                        Option<String> x$138 = c.copy$default$2();
                        Set<Range> x$139 = c.copy$default$3();
                        Seq<AbsoluteFile> x$140 = c.copy$default$4();
                        Seq<String> x$141 = c.copy$default$5();
                        boolean x$142 = c.copy$default$6();
                        Option<Object> x$143 = c.copy$default$7();
                        boolean x$144 = c.copy$default$8();
                        Option<FileFetchMode> x$145 = c.copy$default$9();
                        String x$146 = c.copy$default$10();
                        Option<AbsoluteFile> x$147 = c.copy$default$11();
                        CommonOptions x$148 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$149 = c.copy$default$13();
                        Option<WriteMode> x$150 = c.copy$default$14();
                        boolean x$151 = c.copy$default$15();
                        boolean x$152 = c.copy$default$16();
                        boolean x$153 = c.copy$default$18();
                        boolean x$154 = c.copy$default$19();
                        boolean x$155 = c.copy$default$20();
                        return c.copy(x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$136, x$153, x$154, x$155);
                    }
                }).text("read from stdin and print to stdout");
                this.opt("no-stderr", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$5, CliOptions c) {
                        boolean x$156 = true;
                        Option<Path> x$157 = c.copy$default$1();
                        Option<String> x$158 = c.copy$default$2();
                        Set<Range> x$159 = c.copy$default$3();
                        Seq<AbsoluteFile> x$160 = c.copy$default$4();
                        Seq<String> x$161 = c.copy$default$5();
                        boolean x$162 = c.copy$default$6();
                        Option<Object> x$163 = c.copy$default$7();
                        boolean x$164 = c.copy$default$8();
                        Option<FileFetchMode> x$165 = c.copy$default$9();
                        String x$166 = c.copy$default$10();
                        Option<AbsoluteFile> x$167 = c.copy$default$11();
                        CommonOptions x$168 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$169 = c.copy$default$13();
                        Option<WriteMode> x$170 = c.copy$default$14();
                        boolean x$171 = c.copy$default$15();
                        boolean x$172 = c.copy$default$16();
                        boolean x$173 = c.copy$default$17();
                        boolean x$174 = c.copy$default$19();
                        boolean x$175 = c.copy$default$20();
                        return c.copy(x$157, x$158, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$166, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$156, x$174, x$175);
                    }
                }).text("don't use strerr for messages, output to stdout");
                this.opt("assume-filename", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(String filename, CliOptions c) {
                        String x$176 = filename;
                        Option<Path> x$177 = c.copy$default$1();
                        Option<String> x$178 = c.copy$default$2();
                        Set<Range> x$179 = c.copy$default$3();
                        Seq<AbsoluteFile> x$180 = c.copy$default$4();
                        Seq<String> x$181 = c.copy$default$5();
                        boolean x$182 = c.copy$default$6();
                        Option<Object> x$183 = c.copy$default$7();
                        boolean x$184 = c.copy$default$8();
                        Option<FileFetchMode> x$185 = c.copy$default$9();
                        Option<AbsoluteFile> x$186 = c.copy$default$11();
                        CommonOptions x$187 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$188 = c.copy$default$13();
                        Option<WriteMode> x$189 = c.copy$default$14();
                        boolean x$190 = c.copy$default$15();
                        boolean x$191 = c.copy$default$16();
                        boolean x$192 = c.copy$default$17();
                        boolean x$193 = c.copy$default$18();
                        boolean x$194 = c.copy$default$19();
                        boolean x$195 = c.copy$default$20();
                        return c.copy(x$177, x$178, x$179, x$180, x$181, x$182, x$183, x$184, x$185, x$176, x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$193, x$194, x$195);
                    }
                }).text("when using --stdin, use --assume-filename to hint to scalafmt that the input is an .sbt file.");
                this.opt("reportError", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$6, CliOptions c) {
                        boolean x$196 = true;
                        Option<Path> x$197 = c.copy$default$1();
                        Option<String> x$198 = c.copy$default$2();
                        Set<Range> x$199 = c.copy$default$3();
                        Seq<AbsoluteFile> x$200 = c.copy$default$4();
                        Seq<String> x$201 = c.copy$default$5();
                        boolean x$202 = c.copy$default$6();
                        Option<Object> x$203 = c.copy$default$7();
                        boolean x$204 = c.copy$default$8();
                        Option<FileFetchMode> x$205 = c.copy$default$9();
                        String x$206 = c.copy$default$10();
                        Option<AbsoluteFile> x$207 = c.copy$default$11();
                        CommonOptions x$208 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$209 = c.copy$default$13();
                        Option<WriteMode> x$210 = c.copy$default$14();
                        boolean x$211 = c.copy$default$15();
                        boolean x$212 = c.copy$default$16();
                        boolean x$213 = c.copy$default$17();
                        boolean x$214 = c.copy$default$18();
                        boolean x$215 = c.copy$default$20();
                        return c.copy(x$197, x$198, x$199, x$200, x$201, x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210, x$211, x$212, x$213, x$214, x$196, x$215);
                    }
                }).text("exit with status 1 if any mis-formatted code found.");
                this.opt("test", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$7, CliOptions c) {
                        CliOptions qual$1 = CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode(c, WriteMode$Test$.MODULE$);
                        boolean x$216 = true;
                        Option<Path> x$217 = qual$1.copy$default$1();
                        Option<String> x$218 = qual$1.copy$default$2();
                        Set<Range> x$219 = qual$1.copy$default$3();
                        Seq<AbsoluteFile> x$220 = qual$1.copy$default$4();
                        Seq<String> x$221 = qual$1.copy$default$5();
                        boolean x$222 = qual$1.copy$default$6();
                        Option<Object> x$223 = qual$1.copy$default$7();
                        boolean x$224 = qual$1.copy$default$8();
                        Option<FileFetchMode> x$225 = qual$1.copy$default$9();
                        String x$226 = qual$1.copy$default$10();
                        Option<AbsoluteFile> x$227 = qual$1.copy$default$11();
                        CommonOptions x$228 = qual$1.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$229 = qual$1.copy$default$13();
                        Option<WriteMode> x$230 = qual$1.copy$default$14();
                        boolean x$231 = qual$1.copy$default$15();
                        boolean x$232 = qual$1.copy$default$16();
                        boolean x$233 = qual$1.copy$default$17();
                        boolean x$234 = qual$1.copy$default$18();
                        boolean x$235 = qual$1.copy$default$20();
                        return qual$1.copy(x$217, x$218, x$219, x$220, x$221, x$222, x$223, x$224, x$225, x$226, x$227, x$228, x$229, x$230, x$231, x$232, x$233, x$234, x$216, x$235);
                    }
                }).text("test for mis-formatted code only, exits with status 1 on failure.");
                this.opt("check", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$8, CliOptions c) {
                        CliOptions qual$2 = CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode(c, WriteMode$Test$.MODULE$);
                        boolean x$236 = true;
                        boolean x$237 = true;
                        Option<Path> x$238 = qual$2.copy$default$1();
                        Option<String> x$239 = qual$2.copy$default$2();
                        Set<Range> x$240 = qual$2.copy$default$3();
                        Seq<AbsoluteFile> x$241 = qual$2.copy$default$4();
                        Seq<String> x$242 = qual$2.copy$default$5();
                        boolean x$243 = qual$2.copy$default$6();
                        Option<Object> x$244 = qual$2.copy$default$7();
                        boolean x$245 = qual$2.copy$default$8();
                        Option<FileFetchMode> x$246 = qual$2.copy$default$9();
                        String x$247 = qual$2.copy$default$10();
                        Option<AbsoluteFile> x$248 = qual$2.copy$default$11();
                        CommonOptions x$249 = qual$2.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$250 = qual$2.copy$default$13();
                        Option<WriteMode> x$251 = qual$2.copy$default$14();
                        boolean x$252 = qual$2.copy$default$15();
                        boolean x$253 = qual$2.copy$default$16();
                        boolean x$254 = qual$2.copy$default$17();
                        boolean x$255 = qual$2.copy$default$18();
                        return qual$2.copy(x$238, x$239, x$240, x$241, x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, x$250, x$251, x$252, x$253, x$254, x$255, x$236, x$237);
                    }
                }).text("test for mis-formatted code only, exits with status 1 on first failure.");
                this.opt("migrate2hocon", Read$.MODULE$.fileRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(File file, CliOptions c) {
                        Some x$256 = new Some((Object)AbsoluteFile$.MODULE$.fromFile(file, c.common().workingDirectory()));
                        Option<Path> x$257 = c.copy$default$1();
                        Option<String> x$258 = c.copy$default$2();
                        Set<Range> x$259 = c.copy$default$3();
                        Seq<AbsoluteFile> x$260 = c.copy$default$4();
                        Seq<String> x$261 = c.copy$default$5();
                        boolean x$262 = c.copy$default$6();
                        Option<Object> x$263 = c.copy$default$7();
                        boolean x$264 = c.copy$default$8();
                        Option<FileFetchMode> x$265 = c.copy$default$9();
                        String x$266 = c.copy$default$10();
                        CommonOptions x$267 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$268 = c.copy$default$13();
                        Option<WriteMode> x$269 = c.copy$default$14();
                        boolean x$270 = c.copy$default$15();
                        boolean x$271 = c.copy$default$16();
                        boolean x$272 = c.copy$default$17();
                        boolean x$273 = c.copy$default$18();
                        boolean x$274 = c.copy$default$19();
                        boolean x$275 = c.copy$default$20();
                        return c.copy(x$257, x$258, x$259, x$260, x$261, x$262, x$263, x$264, x$265, x$266, (Option<AbsoluteFile>)x$256, x$267, x$268, x$269, x$270, x$271, x$272, x$273, x$274, x$275);
                    }
                }).text("migrate .scalafmt CLI style configuration to hocon style configuration in .scalafmt.conf");
                this.opt("diff", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$9, CliOptions c) {
                        Option x$276 = Option$.MODULE$.apply((Object)new DiffFiles("master"));
                        Option<Path> x$277 = c.copy$default$1();
                        Option<String> x$278 = c.copy$default$2();
                        Set<Range> x$279 = c.copy$default$3();
                        Seq<AbsoluteFile> x$280 = c.copy$default$4();
                        Seq<String> x$281 = c.copy$default$5();
                        boolean x$282 = c.copy$default$6();
                        Option<Object> x$283 = c.copy$default$7();
                        boolean x$284 = c.copy$default$8();
                        String x$285 = c.copy$default$10();
                        Option<AbsoluteFile> x$286 = c.copy$default$11();
                        CommonOptions x$287 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$288 = c.copy$default$13();
                        Option<WriteMode> x$289 = c.copy$default$14();
                        boolean x$290 = c.copy$default$15();
                        boolean x$291 = c.copy$default$16();
                        boolean x$292 = c.copy$default$17();
                        boolean x$293 = c.copy$default$18();
                        boolean x$294 = c.copy$default$19();
                        boolean x$295 = c.copy$default$20();
                        return c.copy(x$277, x$278, x$279, x$280, x$281, x$282, x$283, x$284, (Option<FileFetchMode>)x$276, x$285, x$286, x$287, x$288, x$289, x$290, x$291, x$292, x$293, x$294, x$295);
                    }
                }).text(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Format files listed in `git diff` against master.\n            |Deprecated: use --mode diff instead"})).s((Seq)Nil$.MODULE$))).stripMargin());
                this.opt("mode", FileFetchMode$.MODULE$.read()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(FileFetchMode m, CliOptions c) {
                        Option x$296 = Option$.MODULE$.apply((Object)m);
                        Option<Path> x$297 = c.copy$default$1();
                        Option<String> x$298 = c.copy$default$2();
                        Set<Range> x$299 = c.copy$default$3();
                        Seq<AbsoluteFile> x$300 = c.copy$default$4();
                        Seq<String> x$301 = c.copy$default$5();
                        boolean x$302 = c.copy$default$6();
                        Option<Object> x$303 = c.copy$default$7();
                        boolean x$304 = c.copy$default$8();
                        String x$305 = c.copy$default$10();
                        Option<AbsoluteFile> x$306 = c.copy$default$11();
                        CommonOptions x$307 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$308 = c.copy$default$13();
                        Option<WriteMode> x$309 = c.copy$default$14();
                        boolean x$310 = c.copy$default$15();
                        boolean x$311 = c.copy$default$16();
                        boolean x$312 = c.copy$default$17();
                        boolean x$313 = c.copy$default$18();
                        boolean x$314 = c.copy$default$19();
                        boolean x$315 = c.copy$default$20();
                        return c.copy(x$297, x$298, x$299, x$300, x$301, x$302, x$303, x$304, (Option<FileFetchMode>)x$296, x$305, x$306, x$307, x$308, x$309, x$310, x$311, x$312, x$313, x$314, x$315);
                    }
                }).text(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sets the files to be formatted fetching mode.\n            |Options:\n            |        diff - format files listed in `git diff` against master\n            |        changed - format files listed in `git status` (latest changes against previous commit)"})).s((Seq)Nil$.MODULE$))).stripMargin());
                this.opt("diff-branch", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(String branch, CliOptions c) {
                        Option x$316 = Option$.MODULE$.apply((Object)new DiffFiles(branch));
                        Option<Path> x$317 = c.copy$default$1();
                        Option<String> x$318 = c.copy$default$2();
                        Set<Range> x$319 = c.copy$default$3();
                        Seq<AbsoluteFile> x$320 = c.copy$default$4();
                        Seq<String> x$321 = c.copy$default$5();
                        boolean x$322 = c.copy$default$6();
                        Option<Object> x$323 = c.copy$default$7();
                        boolean x$324 = c.copy$default$8();
                        String x$325 = c.copy$default$10();
                        Option<AbsoluteFile> x$326 = c.copy$default$11();
                        CommonOptions x$327 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$328 = c.copy$default$13();
                        Option<WriteMode> x$329 = c.copy$default$14();
                        boolean x$330 = c.copy$default$15();
                        boolean x$331 = c.copy$default$16();
                        boolean x$332 = c.copy$default$17();
                        boolean x$333 = c.copy$default$18();
                        boolean x$334 = c.copy$default$19();
                        boolean x$335 = c.copy$default$20();
                        return c.copy(x$317, x$318, x$319, x$320, x$321, x$322, x$323, x$324, (Option<FileFetchMode>)x$316, x$325, x$326, x$327, x$328, x$329, x$330, x$331, x$332, x$333, x$334, x$335);
                    }
                }).text("If set, only format edited files in git diff against provided branch. Has no effect if mode set to `changed`.");
                this.opt("build-info", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply(BoxedUnit x$10, CliOptions x$11) {
                        Predef$.MODULE$.println((Object)CliArgParser$.MODULE$.buildInfo());
                        return scala.sys.package$.MODULE$.exit();
                    }
                }).text("prints build information");
                this.opt("quiet", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$12, CliOptions c) {
                        boolean x$336 = true;
                        Option<Path> x$337 = c.copy$default$1();
                        Option<String> x$338 = c.copy$default$2();
                        Set<Range> x$339 = c.copy$default$3();
                        Seq<AbsoluteFile> x$340 = c.copy$default$4();
                        Seq<String> x$341 = c.copy$default$5();
                        boolean x$342 = c.copy$default$6();
                        Option<Object> x$343 = c.copy$default$7();
                        boolean x$344 = c.copy$default$8();
                        Option<FileFetchMode> x$345 = c.copy$default$9();
                        String x$346 = c.copy$default$10();
                        Option<AbsoluteFile> x$347 = c.copy$default$11();
                        CommonOptions x$348 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$349 = c.copy$default$13();
                        Option<WriteMode> x$350 = c.copy$default$14();
                        boolean x$351 = c.copy$default$15();
                        boolean x$352 = c.copy$default$17();
                        boolean x$353 = c.copy$default$18();
                        boolean x$354 = c.copy$default$19();
                        boolean x$355 = c.copy$default$20();
                        return c.copy(x$337, x$338, x$339, x$340, x$341, x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349, x$350, x$351, x$336, x$352, x$353, x$354, x$355);
                    }
                }).text("don't print out stuff to console.");
                this.opt("debug", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$13, CliOptions c) {
                        boolean x$356 = true;
                        Option<Path> x$357 = c.copy$default$1();
                        Option<String> x$358 = c.copy$default$2();
                        Set<Range> x$359 = c.copy$default$3();
                        Seq<AbsoluteFile> x$360 = c.copy$default$4();
                        Seq<String> x$361 = c.copy$default$5();
                        boolean x$362 = c.copy$default$6();
                        Option<Object> x$363 = c.copy$default$7();
                        boolean x$364 = c.copy$default$8();
                        Option<FileFetchMode> x$365 = c.copy$default$9();
                        String x$366 = c.copy$default$10();
                        Option<AbsoluteFile> x$367 = c.copy$default$11();
                        CommonOptions x$368 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$369 = c.copy$default$13();
                        Option<WriteMode> x$370 = c.copy$default$14();
                        boolean x$371 = c.copy$default$16();
                        boolean x$372 = c.copy$default$17();
                        boolean x$373 = c.copy$default$18();
                        boolean x$374 = c.copy$default$19();
                        boolean x$375 = c.copy$default$20();
                        return c.copy(x$357, x$358, x$359, x$360, x$361, x$362, x$363, x$364, x$365, x$366, x$367, x$368, x$369, x$370, x$356, x$371, x$372, x$373, x$374, x$375);
                    }
                }).text("print out diagnostics to console.");
                this.opt("non-interactive", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$14, CliOptions c) {
                        boolean x$376 = true;
                        Option<Path> x$377 = c.copy$default$1();
                        Option<String> x$378 = c.copy$default$2();
                        Set<Range> x$379 = c.copy$default$3();
                        Seq<AbsoluteFile> x$380 = c.copy$default$4();
                        Seq<String> x$381 = c.copy$default$5();
                        boolean x$382 = c.copy$default$6();
                        Option<Object> x$383 = c.copy$default$7();
                        Option<FileFetchMode> x$384 = c.copy$default$9();
                        String x$385 = c.copy$default$10();
                        Option<AbsoluteFile> x$386 = c.copy$default$11();
                        CommonOptions x$387 = c.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$388 = c.copy$default$13();
                        Option<WriteMode> x$389 = c.copy$default$14();
                        boolean x$390 = c.copy$default$15();
                        boolean x$391 = c.copy$default$16();
                        boolean x$392 = c.copy$default$17();
                        boolean x$393 = c.copy$default$18();
                        boolean x$394 = c.copy$default$19();
                        boolean x$395 = c.copy$default$20();
                        return c.copy(x$377, x$378, x$379, x$380, x$381, x$382, x$383, x$376, x$384, x$385, x$386, x$387, x$388, x$389, x$390, x$391, x$392, x$393, x$394, x$395);
                    }
                }).text("disable fancy progress bar, useful in ci or sbt plugin.");
                this.opt("list", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(BoxedUnit x$15, CliOptions c) {
                        CliOptions qual$3 = CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode(c, WriteMode$List$.MODULE$);
                        boolean x$396 = true;
                        Option<Path> x$397 = qual$3.copy$default$1();
                        Option<String> x$398 = qual$3.copy$default$2();
                        Set<Range> x$399 = qual$3.copy$default$3();
                        Seq<AbsoluteFile> x$400 = qual$3.copy$default$4();
                        Seq<String> x$401 = qual$3.copy$default$5();
                        boolean x$402 = qual$3.copy$default$6();
                        Option<Object> x$403 = qual$3.copy$default$7();
                        boolean x$404 = qual$3.copy$default$8();
                        Option<FileFetchMode> x$405 = qual$3.copy$default$9();
                        String x$406 = qual$3.copy$default$10();
                        Option<AbsoluteFile> x$407 = qual$3.copy$default$11();
                        CommonOptions x$408 = qual$3.copy$default$12();
                        Function1<AbsoluteFile, GitOps> x$409 = qual$3.copy$default$13();
                        Option<WriteMode> x$410 = qual$3.copy$default$14();
                        boolean x$411 = qual$3.copy$default$15();
                        boolean x$412 = qual$3.copy$default$16();
                        boolean x$413 = qual$3.copy$default$17();
                        boolean x$414 = qual$3.copy$default$18();
                        boolean x$415 = qual$3.copy$default$20();
                        return qual$3.copy(x$397, x$398, x$399, x$400, x$401, x$402, x$403, x$404, x$405, x$406, x$407, x$408, x$409, x$410, x$411, x$412, x$413, x$414, x$396, x$415);
                    }
                }).text("list files that are different from scalafmt formatting");
                this.opt("range", Read$.MODULE$.tupleRead(Read$.MODULE$.intRead(), Read$.MODULE$.intRead())).hidden().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CliOptions apply(Tuple2<Object, Object> x0$1, CliOptions x1$1) {
                        Tuple2 tuple2 = new Tuple2(x0$1, (Object)x1$1);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            CliOptions c = (CliOptions)tuple2._2();
                            if (tuple22 != null) {
                                int to;
                                int from = tuple22._1$mcI$sp();
                                int offset = from == (to = tuple22._2$mcI$sp()) ? 0 : -1;
                                Set x$416 = (Set)c.range().$plus((Object)package$.MODULE$.Range().apply(from - 1, to + offset));
                                Option<Path> x$417 = c.copy$default$1();
                                Option<String> x$418 = c.copy$default$2();
                                Seq<AbsoluteFile> x$419 = c.copy$default$4();
                                Seq<String> x$420 = c.copy$default$5();
                                boolean x$421 = c.copy$default$6();
                                Option<Object> x$422 = c.copy$default$7();
                                boolean x$423 = c.copy$default$8();
                                Option<FileFetchMode> x$424 = c.copy$default$9();
                                String x$425 = c.copy$default$10();
                                Option<AbsoluteFile> x$426 = c.copy$default$11();
                                CommonOptions x$427 = c.copy$default$12();
                                Function1<AbsoluteFile, GitOps> x$428 = c.copy$default$13();
                                Option<WriteMode> x$429 = c.copy$default$14();
                                boolean x$430 = c.copy$default$15();
                                boolean x$431 = c.copy$default$16();
                                boolean x$432 = c.copy$default$17();
                                boolean x$433 = c.copy$default$18();
                                boolean x$434 = c.copy$default$19();
                                boolean x$435 = c.copy$default$20();
                                CliOptions cliOptions = c.copy(x$417, x$418, (Set<Range>)x$416, x$419, x$420, x$421, x$422, x$423, x$424, x$425, x$426, x$427, x$428, x$429, x$430, x$431, x$432, x$433, x$434, x$435);
                                return cliOptions;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }).text("(experimental) only format line range from=to");
                this.note(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|Examples:\n        |", "\n        |Please file bugs to https://github.com/scalameta/scalafmt/issues\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CliArgParser$.MODULE$.usageExamples()})))).stripMargin());
            }
        };
    }
}

