/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.scalafmt.Error;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.ExitCode$;
import org.scalafmt.cli.FailedToFormat;
import org.scalafmt.dynamic.exceptions.ScalafmtException;
import org.scalafmt.interfaces.PositionException;
import org.scalafmt.interfaces.ScalafmtReporter;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u0013\t\u00192kY1mC\u001alGo\u00117j%\u0016\u0004xN\u001d;fe*\u00111\u0001B\u0001\u0004G2L'BA\u0003\u0007\u0003!\u00198-\u00197bM6$(\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q!\u0003\u0005\u0002\f!5\tAB\u0003\u0002\u000e\u001d\u0005!A.\u00198h\u0015\u0005y\u0011\u0001\u00026bm\u0006L!!\u0005\u0007\u0003\r=\u0013'.Z2u!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0006j]R,'OZ1dKNL!a\u0006\u000b\u0003!M\u001b\u0017\r\\1g[R\u0014V\r]8si\u0016\u0014\b\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u000f=\u0004H/[8ogB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u000b\u00072Lw\n\u001d;j_:\u001c\b\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\b\u0006\u0002\"EA\u00111\u0004\u0001\u0005\u00063y\u0001\rA\u0007\u0005\bI\u0001\u0011\r\u0011\"\u0003&\u0003!)\u00070\u001b;D_\u0012,W#\u0001\u0014\u0011\u0007\u001dr\u0003'D\u0001)\u0015\tI#&\u0001\u0004bi>l\u0017n\u0019\u0006\u0003W1\n!bY8oGV\u0014(/\u001a8u\u0015\tic\"\u0001\u0003vi&d\u0017BA\u0018)\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA\u000e2\u0013\t\u0011$A\u0001\u0005Fq&$8i\u001c3f\u0011\u0019!\u0004\u0001)A\u0005M\u0005IQ\r_5u\u0007>$W\r\t\u0005\u0006m\u0001!\taN\u0001\fO\u0016$X\t_5u\u0007>$W-F\u00011\u0011\u0015I\u0004\u0001\"\u0011;\u0003\u0015)'O]8s)\rY\u0014I\u0013\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0005+:LG\u000fC\u0003Cq\u0001\u00071)\u0001\u0003gS2,\u0007C\u0001#I\u001b\u0005)%B\u0001\"G\u0015\t9e\"A\u0002oS>L!!S#\u0003\tA\u000bG\u000f\u001b\u0005\u0006\u0017b\u0002\r\u0001T\u0001\b[\u0016\u001c8/Y4f!\ti\u0005K\u0004\u0002=\u001d&\u0011q*P\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002P{!)\u0011\b\u0001C!)R\u00191(\u0016,\t\u000b\t\u001b\u0006\u0019A\"\t\u000b]\u001b\u0006\u0019\u0001-\u0002\u0003\u0015\u0004\"!W1\u000f\u0005i{fBA._\u001b\u0005a&BA/\t\u0003\u0019a$o\\8u}%\ta(\u0003\u0002a{\u00059\u0001/Y2lC\u001e,\u0017B\u00012d\u0005%!\u0006N]8xC\ndWM\u0003\u0002a{!)Q\r\u0001C!M\u0006AQ\r_2mk\u0012,G\r\u0006\u0002<O\")!\t\u001aa\u0001\u0007\")\u0011\u000e\u0001C!U\u0006a\u0001/\u0019:tK\u0012\u001cuN\u001c4jOR\u00191h[7\t\u000b1D\u0007\u0019A\"\u0002\r\r|gNZ5h\u0011\u0015q\u0007\u000e1\u0001M\u0003=\u00198-\u00197bM6$h+\u001a:tS>t\u0007\"\u00029\u0001\t\u0003\n\u0018A\u00043po:dw.\u00193Xe&$XM\u001d\u000b\u0002eB\u00111O^\u0007\u0002i*\u0011QOD\u0001\u0003S>L!a\u001e;\u0003\u0017A\u0013\u0018N\u001c;Xe&$XM\u001d\u0005\u0006s\u0002!\tE_\u0001\u001bI><h\u000e\\8bI>+H\u000f];u'R\u0014X-Y7Xe&$XM\u001d\u000b\u0002wB\u00111\u000f`\u0005\u0003{R\u0014!cT;uaV$8\u000b\u001e:fC6<&/\u001b;fe\u0002")
public class ScalafmtCliReporter
implements ScalafmtReporter {
    private final CliOptions options;
    private final AtomicReference<ExitCode> exitCode;

    private AtomicReference<ExitCode> exitCode() {
        return this.exitCode;
    }

    public ExitCode getExitCode() {
        return this.exitCode().get();
    }

    public void error(Path file, String message) {
        if (!this.options.ignoreWarnings()) {
            this.options.common().err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, file})));
            this.exitCode().getAndUpdate(new UnaryOperator<ExitCode>(this){

                public ExitCode apply(ExitCode t) {
                    return ExitCode$.MODULE$.merge(ExitCode$.MODULE$.UnexpectedError(), t);
                }
            });
        }
    }

    public void error(Path file, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof PositionException && !this.options.ignoreWarnings()) {
            this.options.common().err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.toString(), file})));
            this.exitCode().getAndUpdate(new UnaryOperator<ExitCode>(this){

                public ExitCode apply(ExitCode t) {
                    return ExitCode$.MODULE$.merge(ExitCode$.MODULE$.ParseError(), t);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof Error.MisformattedFile) {
            Error.MisformattedFile misformattedFile = (Error.MisformattedFile)throwable;
            String diff = misformattedFile.customMessage();
            this.options.common().err().println(diff);
            this.exitCode().getAndUpdate(new UnaryOperator<ExitCode>(this){

                public ExitCode apply(ExitCode t) {
                    return ExitCode$.MODULE$.merge(ExitCode$.MODULE$.TestError(), t);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof ScalafmtException) {
            ScalafmtException scalafmtException = (ScalafmtException)throwable;
            Throwable cause = scalafmtException.cause();
            this.error(file, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (this.options.ignoreWarnings()) {
                throw new MatchError((Object)throwable);
            }
            new FailedToFormat(((Object)file).toString(), e).printStackTrace(this.options.common().err());
            this.exitCode().getAndUpdate(new UnaryOperator<ExitCode>(this){

                public ExitCode apply(ExitCode t) {
                    return ExitCode$.MODULE$.merge(ExitCode$.MODULE$.UnexpectedError(), t);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void excluded(Path file) {
        this.options.common().debug().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file excluded: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
    }

    public void parsedConfig(Path config, String scalafmtVersion) {
        this.options.common().debug().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parsed config (v", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scalafmtVersion, config})));
    }

    public PrintWriter downloadWriter() {
        return new PrintWriter(this.options.common().out());
    }

    public OutputStreamWriter downloadOutputStreamWriter() {
        return new OutputStreamWriter(this.options.common().out());
    }

    public ScalafmtCliReporter(CliOptions options) {
        this.options = options;
        this.exitCode = new AtomicReference<ExitCode>(ExitCode$.MODULE$.Ok());
    }
}

