/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import metaconfig.ConfError;
import metaconfig.Configured;
import org.scalafmt.Error;
import org.scalafmt.Formatted;
import org.scalafmt.Scalafmt$;
import org.scalafmt.Versions$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.ExitCode$;
import org.scalafmt.cli.FailedToFormat;
import org.scalafmt.cli.InputMethod;
import org.scalafmt.cli.ScalafmtCoreRunner$;
import org.scalafmt.cli.ScalafmtRunner;
import org.scalafmt.cli.ScalafmtRunner$class;
import org.scalafmt.cli.TermDisplay;
import org.scalafmt.config.FilterMatcher;
import org.scalafmt.config.FilterMatcher$;
import org.scalafmt.config.ScalafmtConfig;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.OsSpecific$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.parallel.ParIterableLike;
import scala.meta.internal.tokenizers.PlatformTokenizerCache$;
import scala.meta.parsers.ParseException;
import scala.meta.tokenizers.TokenizeException;
import scala.util.control.Breaks$;

public final class ScalafmtCoreRunner$
implements ScalafmtRunner {
    public static final ScalafmtCoreRunner$ MODULE$;

    static {
        new ScalafmtCoreRunner$();
    }

    @Override
    public TermDisplay newTermDisplay(CliOptions options, Seq<InputMethod> inputMethods, String msg) {
        return ScalafmtRunner$class.newTermDisplay(this, options, inputMethods, msg);
    }

    @Override
    public Seq<InputMethod> getInputMethods(CliOptions options, Function1<AbsoluteFile, Object> filter) {
        return ScalafmtRunner$class.getInputMethods(this, options, filter);
    }

    @Override
    public ExitCode run(CliOptions options, String termDisplayMessage) {
        Configured<ScalafmtConfig> configured;
        block6: {
            ExitCode exitCode;
            block5: {
                block4: {
                    configured = options.scalafmtConfig();
                    if (!(configured instanceof Configured.NotOk)) break block4;
                    Configured.NotOk notOk = (Configured.NotOk)configured;
                    ConfError e = notOk.error();
                    options.common().err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.msg()})));
                    exitCode = ExitCode$.MODULE$.UnexpectedError();
                    break block5;
                }
                if (!(configured instanceof Configured.Ok)) break block6;
                Configured.Ok ok = (Configured.Ok)configured;
                ScalafmtConfig scalafmtConf = (ScalafmtConfig)ok.value();
                options.common().debug().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parsed config (v", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Versions$.MODULE$.version()})));
                FilterMatcher filterMatcher = FilterMatcher$.MODULE$.apply((Seq)scalafmtConf.project().includeFilters().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String unixSpecificPattern) {
                        return OsSpecific$.MODULE$.fixSeparatorsInPathPattern(unixSpecificPattern);
                    }
                }, Seq$.MODULE$.canBuildFrom()), (Seq)((TraversableLike)scalafmtConf.project().excludeFilters().$plus$plus(options.customExcludes(), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String unixSpecificPattern) {
                        return OsSpecific$.MODULE$.fixSeparatorsInPathPattern(unixSpecificPattern);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
                Seq<InputMethod> inputMethods = this.getInputMethods(options, (Function1<AbsoluteFile, Object>)new Serializable(filterMatcher){
                    public static final long serialVersionUID = 0L;
                    private final FilterMatcher filterMatcher$1;

                    public final boolean apply(AbsoluteFile file) {
                        return this.filterMatcher$1.matchesFile(file);
                    }
                    {
                        this.filterMatcher$1 = filterMatcher$1;
                    }
                });
                if (inputMethods.isEmpty() && options.mode().isEmpty() && !options.stdIn()) {
                    throw Error.NoMatchingFiles$.MODULE$;
                }
                AtomicInteger counter = new AtomicInteger();
                TermDisplay termDisplay = this.newTermDisplay(options, inputMethods, termDisplayMessage);
                AtomicReference<ExitCode> exitCode2 = new AtomicReference<ExitCode>(ExitCode$.MODULE$.Ok());
                Breaks$.MODULE$.breakable((Function0)new Serializable(options, termDisplayMessage, scalafmtConf, inputMethods, counter, termDisplay, exitCode2){
                    public static final long serialVersionUID = 0L;
                    public final CliOptions options$1;
                    public final String termDisplayMessage$1;
                    public final ScalafmtConfig scalafmtConf$1;
                    private final Seq inputMethods$1;
                    public final AtomicInteger counter$1;
                    public final TermDisplay termDisplay$1;
                    public final AtomicReference exitCode$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ((ParIterableLike)this.inputMethods$1.par()).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.run.1 $outer;

                            public final void apply(InputMethod inputMethod) {
                                ExitCode code = ScalafmtCoreRunner$.MODULE$.org$scalafmt$cli$ScalafmtCoreRunner$$handleFile(inputMethod, this.$outer.options$1, this.$outer.scalafmtConf$1);
                                this.$outer.exitCode$1.getAndUpdate(new UnaryOperator<ExitCode>(this, code){
                                    private final ExitCode code$1;

                                    public ExitCode apply(ExitCode t) {
                                        return ExitCode$.MODULE$.merge(this.code$1, t);
                                    }
                                    {
                                        this.code$1 = code$1;
                                    }
                                });
                                if (this.$outer.options$1.check() && !code.isOk()) {
                                    throw Breaks$.MODULE$.break();
                                }
                                PlatformTokenizerCache$.MODULE$.megaCache().clear();
                                this.$outer.termDisplay$1.taskProgress(this.$outer.termDisplayMessage$1, this.$outer.counter$1.incrementAndGet());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.options$1 = options$1;
                        this.termDisplayMessage$1 = termDisplayMessage$1;
                        this.scalafmtConf$1 = scalafmtConf$1;
                        this.inputMethods$1 = inputMethods$1;
                        this.counter$1 = counter$1;
                        this.termDisplay$1 = termDisplay$1;
                        this.exitCode$1 = exitCode$1;
                    }
                });
                termDisplay.completedTask(termDisplayMessage, exitCode2.get().isOk());
                termDisplay.stop();
                exitCode = exitCode2.get();
            }
            return exitCode;
        }
        throw new MatchError(configured);
    }

    public ExitCode org$scalafmt$cli$ScalafmtCoreRunner$$handleFile(InputMethod inputMethod, CliOptions options, ScalafmtConfig config) {
        Throwable throwable2;
        block2: {
            ExitCode exitCode;
            try {
                exitCode = this.unsafeHandleFile(inputMethod, options, config);
            }
            catch (Throwable throwable2) {
                ExitCode exitCode2;
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof Error.MisformattedFile)) break block2;
                Error.MisformattedFile misformattedFile = (Error.MisformattedFile)throwable3;
                String diff = misformattedFile.customMessage();
                options.common().err().println(diff);
                exitCode = exitCode2 = ExitCode$.MODULE$.TestError();
            }
            return exitCode;
        }
        throw throwable2;
    }

    private ExitCode unsafeHandleFile(InputMethod inputMethod, CliOptions options, ScalafmtConfig scalafmtConfig2) {
        Formatted formatted;
        block9: {
            ExitCode exitCode;
            block8: {
                ExitCode exitCode2;
                block7: {
                    String input = inputMethod.readInput(options);
                    Formatted.Result formatResult = Scalafmt$.MODULE$.formatCode(input, scalafmtConfig2, options.range(), inputMethod.filename());
                    formatted = formatResult.formatted();
                    if (!(formatted instanceof Formatted.Success)) break block7;
                    Formatted.Success success = (Formatted.Success)formatted;
                    String formatted2 = success.formattedCode();
                    exitCode = inputMethod.write(formatted2, input, options);
                    break block8;
                }
                if (!(formatted instanceof Formatted.Failure)) break block9;
                Formatted.Failure failure = (Formatted.Failure)formatted;
                Throwable e = failure.e();
                if (scalafmtConfig2.runner().ignoreWarnings()) {
                    exitCode2 = ExitCode$.MODULE$.Ok();
                } else {
                    ExitCode exitCode3;
                    Throwable throwable = e;
                    boolean bl = throwable instanceof ParseException ? true : throwable instanceof TokenizeException;
                    if (bl) {
                        options.common().err().println(throwable.toString());
                        exitCode3 = ExitCode$.MODULE$.ParseError();
                    } else {
                        new FailedToFormat(inputMethod.filename(), e).printStackTrace(options.common().out());
                        exitCode3 = ExitCode$.MODULE$.UnexpectedError();
                    }
                    exitCode2 = exitCode3;
                }
                exitCode = exitCode2;
            }
            return exitCode;
        }
        throw new MatchError((Object)formatted);
    }

    private ScalafmtCoreRunner$() {
        MODULE$ = this;
        ScalafmtRunner$class.$init$(this);
    }
}

